
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <cpl.h>

const char  *test_global_path_test_data;
int kmo_test_file_exists(const char*);
void kmo_test_create_pipeline_data_core(const char*, const char*);

char *pipeline_test_path = "pipeline/";

/**
  @brief	Do init for recipe-tests
  @param	argc   the number of parameters
  @param    argv   the parameter list
 */
int main(int argc, char *argv[])
{
    char path[1024];
    if (kmo_test_file_exists(test_global_path_test_data) == FALSE) {
        mkdir(test_global_path_test_data, 0777);
    }

    strcpy(path, test_global_path_test_data);
    strcat(path, pipeline_test_path);

    if (kmo_test_file_exists(path) == FALSE) {
        mkdir(path, 0777);
        kmo_test_create_pipeline_data_core(pipeline_test_path,
                                           "log_generate_pipeline_data.txt");
    }

    cpl_test_init("<kmos-spark@mpe.mpg.de>", CPL_MSG_WARNING);

    if ((argc == 5) && (strcmp(argv[1], "xxx") != 0)) { }

    return cpl_test_end(0);
}
