/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Err;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private int modeNameCode = -1;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;
    private String modeAttribute;
    private boolean implicitSelect = false;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "mode") {
                this.modeAttribute = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "select") {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.modeAttribute != null) {
            if (this.modeAttribute.equals("#current")) {
                this.useCurrentMode = true;
            } else if (!this.modeAttribute.equals("#default")) {
                try {
                    this.modeNameCode = this.makeNameCode(this.modeAttribute.trim());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage(), "XTSE0280");
                    this.modeNameCode = -1;
                }
                catch (XPathException xPathException) {
                    this.compileError("Mode name " + Err.wrap(this.modeAttribute) + " is not a valid QName", "XTSE0280");
                    this.modeNameCode = -1;
                }
            }
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws XPathException {
        Object object;
        this.checkWithinTemplate();
        if (!this.useCurrentMode) {
            this.mode = this.getPrincipalStylesheet().getRuleManager().getMode(this.modeNameCode);
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = (NodeInfo)axisIterator.next()) != null) {
            if (object instanceof XSLSort || object instanceof XSLWithParam) continue;
            if (object.getNodeKind() == 3) {
                if (Whitespace.isWhite(object.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-templates", "XTSE0010");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates", "XTSE0010");
        }
        if (this.select == null) {
            this.select = new AxisExpression(3, null);
            this.implicitSelect = true;
        }
        this.select = this.typeCheck("select", this.select);
        try {
            object = new RoleLocator(4, "xsl:apply-templates/select", 0, null);
            ((RoleLocator)object).setSourceLocator(new ExpressionLocation(this));
            ((RoleLocator)object).setErrorCode("XTTE0520");
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, (RoleLocator)object, this.getStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public void markTailCalls() {
        this.useTailRecursion = true;
    }

    public Expression compile(Executable executable) throws XPathException {
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        if (sortKeyDefinitionArray != null) {
            this.useTailRecursion = false;
        }
        Expression expression = this.select;
        if (sortKeyDefinitionArray != null) {
            expression = new SortExpression(this.select, sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(expression);
        }
        this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        ApplyTemplates applyTemplates = new ApplyTemplates(expression, this.useCurrentMode, this.useTailRecursion, this.mode, this.backwardsCompatibleModeIsEnabled(), this.implicitSelect);
        applyTemplates.setActualParameters(this.getWithParamInstructions(executable, false, applyTemplates), this.getWithParamInstructions(executable, true, applyTemplates));
        ExpressionTool.makeParentReferences(applyTemplates);
        return applyTemplates;
    }
}

