/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class Bindery {
    private ValueRepresentation[] globals;
    private boolean[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;

    public void allocateGlobals(SlotManager slotManager) {
        this.globalVariableMap = slotManager;
        int n = slotManager.getNumberOfVariables() + 1;
        this.globals = new ValueRepresentation[n];
        this.busy = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = false;
        }
    }

    public void defineGlobalParameters(GlobalParameterSet globalParameterSet) {
        this.globalParameters = globalParameterSet;
    }

    public boolean useGlobalParameter(int n, GlobalParam globalParam, XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        int n2 = globalParam.getSlotNumber();
        if (this.globals[n2] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Object object3 = this.globalParameters.get(n);
        if (object3 == null) {
            return false;
        }
        if (object3 instanceof DocumentInfo) {
            object2 = ((DocumentInfo)object3).getSystemId();
            try {
                if (object2 != null && new URI((String)object2).isAbsolute() && ((DocumentPool)(object = xPathContext.getController().getDocumentPool())).find((String)object2) == null) {
                    ((DocumentPool)object).add((DocumentInfo)object3, (String)object2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        object = xPathContext.getConfiguration();
        try {
            object2 = Value.convertJavaObjectToXPath(object3, globalParam.getRequiredType(), (Configuration)object);
            if (object2 == null) {
                object2 = EmptySequence.getInstance();
            }
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(globalParam);
            throw xPathException;
        }
        ItemType itemType = globalParam.getRequiredType().getPrimaryType();
        if (object2 instanceof AtomicValue && itemType.isAtomicType()) {
            if ((object2 = ((AtomicValue)object2).convert((AtomicType)itemType, xPathContext, true)) instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)object2).getException();
            }
        } else {
            DynamicError dynamicError = TypeChecker.testConformance((Value)object2, globalParam.getRequiredType(), (Configuration)object);
            if (dynamicError != null) {
                throw dynamicError;
            }
        }
        this.globals[n2] = object2;
        return true;
    }

    public void defineGlobalVariable(GlobalVariable globalVariable, ValueRepresentation valueRepresentation) {
        this.globals[globalVariable.getSlotNumber()] = valueRepresentation;
    }

    public void setExecuting(GlobalVariable globalVariable, boolean bl) throws XPathException {
        int n = globalVariable.getSlotNumber();
        if (bl) {
            if (this.busy[n]) {
                throw new XPathException.Circularity("Circular definition");
            }
            this.busy[n] = true;
        } else {
            this.busy[n] = false;
        }
    }

    public ValueRepresentation getGlobalVariableValue(GlobalVariable globalVariable) {
        return this.globals[globalVariable.getSlotNumber()];
    }

    public ValueRepresentation getGlobalVariable(int n) {
        return this.globals[n];
    }

    public void assignGlobalVariable(GlobalVariable globalVariable, ValueRepresentation valueRepresentation) {
        this.defineGlobalVariable(globalVariable, valueRepresentation);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public ValueRepresentation[] getGlobalVariables() {
        return this.globals;
    }
}

