/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.functions.Adjust;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.BaseURI;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.CodepointEqual;
import net.sf.saxon.functions.Collection;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.functions.Component;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentDateTime;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.Data;
import net.sf.saxon.functions.DateTimeConstructor;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.DefaultCollation;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Existence;
import net.sf.saxon.functions.ForceCase;
import net.sf.saxon.functions.FormatDate;
import net.sf.saxon.functions.FormatNumber2;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.Idref;
import net.sf.saxon.functions.InScopePrefixes;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.Insert;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.Lang;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.NamespaceForPrefix;
import net.sf.saxon.functions.Nilled;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.functions.NormalizeUnicode;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root;
import net.sf.saxon.functions.Rounding;
import net.sf.saxon.functions.StaticBaseURI;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.Unicode;
import net.sf.saxon.functions.Unordered;
import net.sf.saxon.functions.UnparsedEntity;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public abstract class StandardFunction {
    private static HashMap functionTable = new HashMap(200);
    protected static ItemType SAME_AS_FIRST_ARGUMENT = NodeKindTest.NAMESPACE;

    private StandardFunction() {
    }

    private static Entry register(String string, Class clazz, int n, int n2, int n3, ItemType itemType, int n4) {
        Entry entry = StandardFunction.makeEntry(string, clazz, n, n2, n3, itemType, n4);
        functionTable.put(string, entry);
        return entry;
    }

    public static Entry makeEntry(String string, Class clazz, int n, int n2, int n3, ItemType itemType, int n4) {
        Entry entry = new Entry();
        int n5 = string.indexOf(35);
        entry.name = n5 < 0 ? string : string.substring(0, n5);
        entry.implementationClass = clazz;
        entry.opcode = n;
        entry.minArguments = n2;
        entry.maxArguments = n3;
        entry.itemType = itemType;
        entry.cardinality = n4;
        entry.argumentTypes = n3 > 100 ? new SequenceType[1] : new SequenceType[n3];
        return entry;
    }

    public static void arg(Entry entry, int n, ItemType itemType, int n2) {
        try {
            entry.argumentTypes[n] = SequenceType.makeSequenceType(itemType, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Internal Saxon error: Can't set argument " + n + " of " + entry.name);
        }
    }

    public static Entry getFunction(String string, int n) {
        Entry entry = (Entry)functionTable.get(string + '#' + n);
        if (entry != null) {
            return entry;
        }
        return (Entry)functionTable.get(string);
    }

    static {
        Entry entry = StandardFunction.register("abs", Rounding.class, 4, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.NUMBER_TYPE, 24576);
        entry = StandardFunction.register("adjust-date-to-timezone", Adjust.class, 0, 1, 2, Type.DATE_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.DAY_TIME_DURATION_TYPE, 24576);
        entry = StandardFunction.register("adjust-dateTime-to-timezone", Adjust.class, 0, 1, 2, Type.DATE_TIME_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.DAY_TIME_DURATION_TYPE, 24576);
        entry = StandardFunction.register("adjust-time-to-timezone", Adjust.class, 0, 1, 2, Type.TIME_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.TIME_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.DAY_TIME_DURATION_TYPE, 24576);
        entry = StandardFunction.register("avg", Aggregate.class, 1, 1, 1, Type.ANY_ATOMIC_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 57344);
        entry = StandardFunction.register("base-uri", BaseURI.class, 0, 0, 1, Type.ANY_URI_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("boolean", BooleanFn.class, 0, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("ceiling", Rounding.class, 1, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.NUMBER_TYPE, 24576);
        entry = StandardFunction.register("codepoint-equal", CodepointEqual.class, 0, 2, 2, Type.BOOLEAN_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("codepoints-to-string", Unicode.class, 1, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.INTEGER_TYPE, 57344);
        entry = StandardFunction.register("collection", Collection.class, 0, 0, 1, Type.NODE_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("compare", Compare.class, 0, 2, 3, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("concat", Concat.class, 0, 2, Integer.MAX_VALUE, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 24576);
        entry = StandardFunction.register("contains", Contains.class, 0, 2, 3, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("count", Aggregate.class, 4, 1, 1, Type.INTEGER_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.register("current", Current.class, 0, 0, 0, Type.ITEM_TYPE, 16384);
        StandardFunction.register("current-date", CurrentDateTime.class, 0, 0, 0, Type.DATE_TYPE, 16384);
        StandardFunction.register("current-dateTime", CurrentDateTime.class, 0, 0, 0, Type.DATE_TIME_TYPE, 16384);
        StandardFunction.register("current-time", CurrentDateTime.class, 0, 0, 0, Type.TIME_TYPE, 16384);
        StandardFunction.register("current-group", CurrentGroup.class, 0, 0, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.register("current-grouping-key", CurrentGroup.class, 1, 0, 0, Type.ANY_ATOMIC_TYPE, 24576);
        entry = StandardFunction.register("data", Data.class, 0, 1, 1, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("dateTime", DateTimeConstructor.class, 0, 2, 2, Type.DATE_TIME_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 16384);
        StandardFunction.arg(entry, 1, Type.TIME_TYPE, 16384);
        entry = StandardFunction.register("day-from-date", Component.class, 197129, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 24576);
        entry = StandardFunction.register("day-from-dateTime", Component.class, 197127, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("days-from-duration", Component.class, 197126, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DURATION_TYPE, 24576);
        entry = StandardFunction.register("deep-equal", DeepEqual.class, 0, 2, 3, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        StandardFunction.register("default-collation", DefaultCollation.class, 0, 0, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("distinct-values", DistinctValues.class, 0, 1, 2, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("doc", Doc.class, 0, 1, 1, NodeKindTest.DOCUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("doc-available", Doc.class, 1, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("document", Document.class, 0, 1, 2, Type.NODE_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.NODE_TYPE, 16384);
        entry = StandardFunction.register("document-uri", NamePart.class, 4, 1, 1, Type.ANY_URI_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 57344);
        entry = StandardFunction.register("empty", Existence.class, 1, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("ends-with", Contains.class, 2, 2, 3, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("element-available", Available.class, 0, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("encode-for-uri", EscapeURI.class, 1, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("escape-html-uri", EscapeURI.class, 3, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("error", Error.class, 0, 0, 3, Type.ITEM_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.QNAME_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("exactly-one", TreatFn.class, 16384, 1, 1, SAME_AS_FIRST_ARGUMENT, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 16384);
        entry = StandardFunction.register("exists", Existence.class, 0, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.register("false", BooleanFn.class, 3, 0, 0, Type.BOOLEAN_TYPE, 16384);
        entry = StandardFunction.register("floor", Rounding.class, 0, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.NUMBER_TYPE, 24576);
        entry = StandardFunction.register("format-date", FormatDate.class, 521, 2, 5, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 3, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 4, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("format-dateTime", FormatDate.class, 519, 2, 5, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 3, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 4, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("format-number", FormatNumber2.class, 0, 2, 3, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NUMBER_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("format-time", FormatDate.class, 520, 2, 5, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.TIME_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 3, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 4, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("function-available", Available.class, 1, 1, 2, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 1, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("generate-id", NamePart.class, 3, 0, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("hours-from-dateTime", Component.class, 262663, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("hours-from-duration", Component.class, 262662, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DURATION_TYPE, 24576);
        entry = StandardFunction.register("hours-from-time", Component.class, 262664, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.TIME_TYPE, 24576);
        entry = StandardFunction.register("id", Id.class, 0, 1, 2, NodeKindTest.ELEMENT, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.NODE_TYPE, 16384);
        entry = StandardFunction.register("idref", Idref.class, 0, 1, 2, Type.NODE_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.NODE_TYPE, 16384);
        StandardFunction.register("implicit-timezone", CurrentDateTime.class, 0, 0, 0, Type.DAY_TIME_DURATION_TYPE, 16384);
        entry = StandardFunction.register("in-scope-prefixes", InScopePrefixes.class, 0, 1, 1, Type.STRING_TYPE, 57344);
        StandardFunction.arg(entry, 0, NodeKindTest.ELEMENT, 16384);
        entry = StandardFunction.register("index-of", IndexOf.class, 0, 2, 3, Type.INTEGER_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.ANY_ATOMIC_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("insert-before", Insert.class, 0, 3, 3, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.INTEGER_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("iri-to-uri", EscapeURI.class, 2, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("key", KeyFn.class, 0, 2, 3, Type.NODE_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 1, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 2, Type.NODE_TYPE, 16384);
        entry = StandardFunction.register("lang", Lang.class, 0, 1, 2, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.NODE_TYPE, 16384);
        StandardFunction.register("last", Last.class, 0, 0, 0, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("local-name", NamePart.class, 1, 0, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("local-name-from-QName", Component.class, 524818, 1, 1, Type.NCNAME_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.QNAME_TYPE, 24576);
        entry = StandardFunction.register("lower-case", ForceCase.class, 1, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("matches", Matches.class, 0, 2, 3, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("max", Minimax.class, 3, 1, 2, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("min", Minimax.class, 2, 1, 2, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("minutes-from-dateTime", Component.class, 328199, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("minutes-from-duration", Component.class, 328198, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DURATION_TYPE, 24576);
        entry = StandardFunction.register("minutes-from-time", Component.class, 328200, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.TIME_TYPE, 24576);
        entry = StandardFunction.register("month-from-date", Component.class, 131593, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 24576);
        entry = StandardFunction.register("month-from-dateTime", Component.class, 131591, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("months-from-duration", Component.class, 131590, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DURATION_TYPE, 24576);
        entry = StandardFunction.register("name", NamePart.class, 0, 0, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("namespace-uri", NamePart.class, 2, 0, 1, Type.ANY_URI_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("namespace-uri-for-prefix", NamespaceForPrefix.class, 0, 2, 2, Type.ANY_URI_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, NodeKindTest.ELEMENT, 16384);
        entry = StandardFunction.register("namespace-uri-from-QName", Component.class, 590354, 1, 1, Type.ANY_URI_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.QNAME_TYPE, 24576);
        entry = StandardFunction.register("nilled", Nilled.class, 0, 1, 1, Type.BOOLEAN_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("node-name", NamePart.class, 6, 1, 1, Type.QNAME_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("not", BooleanFn.class, 1, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.register("normalize-space", NormalizeSpace.class, 0, 0, 1, Type.STRING_TYPE, 16384);
        StandardFunction.register("normalize-space#0", NormalizeSpace.class, 0, 0, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("normalize-space#1", NormalizeSpace.class, 0, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("normalize-unicode", NormalizeUnicode.class, 0, 1, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("number", NumberFn.class, 0, 0, 1, Type.DOUBLE_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 24576);
        entry = StandardFunction.register("one-or-more", TreatFn.class, 49152, 1, 1, SAME_AS_FIRST_ARGUMENT, 49152);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 49152);
        StandardFunction.register("position", Position.class, 0, 0, 0, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("prefix-from-QName", Component.class, 655890, 1, 1, Type.NCNAME_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.QNAME_TYPE, 24576);
        entry = StandardFunction.register("QName", QNameFn.class, 0, 2, 2, Type.QNAME_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("regex-group", RegexGroup.class, 0, 1, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("remove", Remove.class, 0, 2, 2, SAME_AS_FIRST_ARGUMENT, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("replace", Replace.class, 0, 3, 4, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 3, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("resolve-QName", ResolveQName.class, 0, 2, 2, Type.QNAME_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, NodeKindTest.ELEMENT, 16384);
        entry = StandardFunction.register("resolve-uri", ResolveURI.class, 0, 1, 2, Type.ANY_URI_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("reverse", Reverse.class, 0, 1, 1, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("root", Root.class, 0, 0, 1, Type.NODE_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        entry = StandardFunction.register("round", Rounding.class, 2, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.NUMBER_TYPE, 24576);
        entry = StandardFunction.register("round-half-to-even", Rounding.class, 3, 1, 2, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.NUMBER_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("seconds-from-dateTime", Component.class, 393735, 1, 1, Type.DECIMAL_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("seconds-from-duration", Component.class, 393734, 1, 1, Type.DECIMAL_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DURATION_TYPE, 24576);
        entry = StandardFunction.register("seconds-from-time", Component.class, 393736, 1, 1, Type.DECIMAL_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.TIME_TYPE, 24576);
        entry = StandardFunction.register("starts-with", Contains.class, 1, 2, 3, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        StandardFunction.register("static-base-uri", StaticBaseURI.class, 0, 0, 0, Type.ANY_URI_TYPE, 24576);
        entry = StandardFunction.register("string", StringFn.class, 0, 0, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 24576);
        StandardFunction.register("string-length", StringLength.class, 0, 0, 1, Type.INTEGER_TYPE, 16384);
        StandardFunction.register("string-length#0", StringLength.class, 0, 0, 0, Type.INTEGER_TYPE, 16384);
        entry = StandardFunction.register("string-length#1", StringLength.class, 0, 1, 1, Type.INTEGER_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("string-join", StringJoin.class, 0, 2, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("string-to-codepoints", Unicode.class, 0, 1, 1, Type.INTEGER_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("subsequence", Subsequence.class, 0, 2, 3, SAME_AS_FIRST_ARGUMENT, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.NUMBER_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.NUMBER_TYPE, 16384);
        entry = StandardFunction.register("substring", Substring.class, 0, 2, 3, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.NUMBER_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.NUMBER_TYPE, 16384);
        entry = StandardFunction.register("substring-after", Contains.class, 3, 2, 3, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("substring-before", Contains.class, 4, 2, 3, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("sum", Aggregate.class, 0, 1, 2, Type.ANY_ATOMIC_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.ANY_ATOMIC_TYPE, 24576);
        entry = StandardFunction.register("system-property", SystemProperty.class, 0, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("timezone-from-date", Component.class, 459273, 1, 1, Type.DAY_TIME_DURATION_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 24576);
        entry = StandardFunction.register("timezone-from-dateTime", Component.class, 459271, 1, 1, Type.DAY_TIME_DURATION_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("timezone-from-time", Component.class, 459272, 1, 1, Type.DAY_TIME_DURATION_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.TIME_TYPE, 24576);
        entry = StandardFunction.register("trace", Trace.class, 0, 2, 2, SAME_AS_FIRST_ARGUMENT, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.register("true", BooleanFn.class, 2, 0, 0, Type.BOOLEAN_TYPE, 16384);
        entry = StandardFunction.register("translate", Translate.class, 0, 3, 3, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("tokenize", Tokenize.class, 0, 2, 3, Type.STRING_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 2, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("type-available", Available.class, 2, 1, 1, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("unordered", Unordered.class, 0, 1, 1, SAME_AS_FIRST_ARGUMENT, 57344);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 57344);
        entry = StandardFunction.register("upper-case", ForceCase.class, 0, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        entry = StandardFunction.register("unparsed-entity-uri", UnparsedEntity.class, UnparsedEntity.URI, 1, 1, Type.ANY_URI_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("unparsed-entity-uri_9999_", UnparsedEntity.class, UnparsedEntity.URI, 2, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 1, Type.NODE_TYPE, 16384);
        entry = StandardFunction.register("unparsed-entity-public-id", UnparsedEntity.class, UnparsedEntity.PUBLIC_ID, 1, 1, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("unparsed-entity-public-id_9999_", UnparsedEntity.class, UnparsedEntity.PUBLIC_ID, 2, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 1, Type.NODE_TYPE, 16384);
        entry = StandardFunction.register("unparsed-text", UnparsedText.class, 0, 1, 2, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("unparsed-text-available", UnparsedText.class, 1, 1, 2, Type.BOOLEAN_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
        entry = StandardFunction.register("year-from-date", Component.class, 66057, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TYPE, 24576);
        entry = StandardFunction.register("year-from-dateTime", Component.class, 66055, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DATE_TIME_TYPE, 24576);
        entry = StandardFunction.register("years-from-duration", Component.class, 66054, 1, 1, Type.INTEGER_TYPE, 24576);
        StandardFunction.arg(entry, 0, Type.DURATION_TYPE, 24576);
        entry = StandardFunction.register("zero-or-one", TreatFn.class, 24576, 1, 1, SAME_AS_FIRST_ARGUMENT, 24576);
        StandardFunction.arg(entry, 0, Type.ITEM_TYPE, 24576);
    }

    public static class Entry
    implements Serializable {
        public String name;
        public Class implementationClass;
        public int opcode;
        public int minArguments;
        public int maxArguments;
        public ItemType itemType;
        public int cardinality;
        public SequenceType[] argumentTypes;
    }
}

