/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public final class ContextMappingIterator
implements SequenceIterator,
AtomizableIterator {
    private SequenceIterator base;
    private ContextMappingFunction action;
    private XPathContext context;
    private SequenceIterator results = null;
    private boolean atomizing = false;
    private Item current = null;
    private int position = 0;

    public ContextMappingIterator(ContextMappingFunction contextMappingFunction, XPathContext xPathContext) {
        this.base = xPathContext.getCurrentIterator();
        this.action = contextMappingFunction;
        this.context = xPathContext;
    }

    public Item next() throws XPathException {
        Item item;
        block4: {
            while (true) {
                if (this.results != null) {
                    item = this.results.next();
                    if (item != null) break block4;
                    this.results = null;
                }
                if (this.base.next() == null) break;
                this.results = this.action.map(this.context);
                if (this.atomizing && this.results instanceof AtomizableIterator) {
                    ((AtomizableIterator)this.results).setIsAtomizing(this.atomizing);
                }
                if ((item = this.results.next()) == null) {
                    this.results = null;
                    continue;
                }
                break block4;
                break;
            }
            this.results = null;
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = item;
        ++this.position;
        return item;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator sequenceIterator = this.base.getAnother();
        XPathContext xPathContext = this.context;
        if (xPathContext != null) {
            xPathContext = xPathContext.newMinorContext();
            xPathContext.setCurrentIterator(sequenceIterator);
            xPathContext.setOrigin(this.context.getOrigin());
        }
        ContextMappingIterator contextMappingIterator = new ContextMappingIterator(this.action, xPathContext);
        contextMappingIterator.setIsAtomizing(this.atomizing);
        return contextMappingIterator;
    }

    public int getProperties() {
        return 8;
    }

    public void setIsAtomizing(boolean bl) {
        this.atomizing = bl;
    }
}

