/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.util.BitSet;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;

public class NormalizerData {
    static final String copyright = "Copyright \ufffd 1998-1999 Unicode, Inc.";
    public static final int NOT_COMPOSITE = 65535;
    private IntToIntHashMap canonicalClass;
    private IntHashMap decompose;
    private IntToIntHashMap compose;
    private BitSet isCompatibility = new BitSet();
    private BitSet isExcluded = new BitSet();

    public int getCanonicalClass(int n) {
        return this.canonicalClass.get(n);
    }

    public char getPairwiseComposition(int n, int n2) {
        if (n < 0 || n > 0x10FFFF || n2 < 0 || n2 > 0x10FFFF) {
            return '\uffff';
        }
        return (char)this.compose.get(n << 16 | n2);
    }

    public void getRecursiveDecomposition(boolean bl, int n, StringBuffer stringBuffer) {
        String string = (String)this.decompose.get(n);
        if (!(string == null || bl && this.isCompatibility.get(n))) {
            for (int i = 0; i < string.length(); ++i) {
                this.getRecursiveDecomposition(bl, string.charAt(i), stringBuffer);
            }
        } else if (n < 65536) {
            stringBuffer.append((char)n);
        } else {
            stringBuffer.append(XMLChar.highSurrogate(n));
            stringBuffer.append(XMLChar.lowSurrogate(n));
        }
    }

    NormalizerData(IntToIntHashMap intToIntHashMap, IntHashMap intHashMap, IntToIntHashMap intToIntHashMap2, BitSet bitSet, BitSet bitSet2) {
        this.canonicalClass = intToIntHashMap;
        this.decompose = intHashMap;
        this.compose = intToIntHashMap2;
        this.isCompatibility = bitSet;
        this.isExcluded = bitSet2;
    }

    boolean getExcluded(char c) {
        return this.isExcluded.get(c);
    }

    String getRawDecompositionMapping(char c) {
        return (String)this.decompose.get(c);
    }
}

