/*
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.asm.AsmClassTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer;
import org.apache.commons.javaflow.utils.RewritingUtils;

import java.io.IOException;

/**
 * A small test utility for performing a transformation on a single class file.
 *
 * <p>
 * Reads a class file image from stdin, write to stdout.
 * 
 * @author Kohsuke Kawaguchi
 */
public class RewriteTool {
    public static void main(String[] args) throws IOException {
        ResourceTransformer trans = new BcelClassTransformer();
        if(args.length>0 && args[0].equals("asm"))
            trans = new AsmClassTransformer();

        byte[] out = trans.transform(RewritingUtils.toByteArray(System.in));
        System.out.write(out);
    }
}
