/****************************************************************************
 *    lib/c/Constraint.h - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef CONSTRAINT_H
#define CONSTRAINT_H

#include <string>
#include <vector>
#include "Variable.h"
#include "Constant.h"

namespace C {


class Constraint
{
public:
	Constraint(Variable* left_var, Variable* right_var, string* text, string* type=NULL);
	Constraint(Variable* var, string* text, string* type=NULL);
	Constraint(string* text, string* type=NULL);

	virtual ~Constraint ( );

	string print(Printer* p);

	/**
	 * @return vector<Variable*>
	 */
	set<Variable*>* getVariables ( );

	string getText();
	string getType();

	void merge(Constraint* constraint, string* type=NULL);
	void merge(string* text, Variable*, string* type=NULL);
	void merge(string* text, string* type=NULL);
	void mergeLeft(string* text, Variable* var, string* type=NULL);
	void mergeLeft(string* text, string* type=NULL);
	
private:
	void init(string*, string*);

	vector<Variable*> vars_;
	string text_;
	string type_;

};
}; // end of package namespace

#endif // CONSTRAINT_H
