/* minimol.cpp: atomic model data */
//C Copyright (C) 2000-2006 Kevin Cowtan and University of York
//L
//L  This library is free software and is distributed under the terms
//L  and conditions of version 2.1 of the GNU Lesser General Public
//L  Licence (LGPL) with the following additional clause:
//L
//L     `You may also combine or link a "work that uses the Library" to
//L     produce a work containing portions of the Library, and distribute
//L     that work under terms of your choice, provided that you give
//L     prominent notice with each copy of the work that the specified
//L     version of the Library is used in it, and that you include or
//L     provide public access to the complete corresponding
//L     machine-readable source code for the Library including whatever
//L     changes were used in the work. (i.e. If you make changes to the
//L     Library you must distribute those, but you do not need to
//L     distribute source or object code to those portions of the work
//L     not covered by this licence.)'
//L
//L  Note that this clause grants an additional right and does not impose
//L  any additional restriction, and so does not affect compatibility
//L  with the GNU General Public Licence (GPL). If you wish to negotiate
//L  other terms, please contact the maintainer.
//L
//L  You can redistribute it and/or modify the library under the terms of
//L  the GNU Lesser General Public License as published by the Free Software
//L  Foundation; either version 2.1 of the License, or (at your option) any
//L  later version.
//L
//L  This library is distributed in the hope that it will be useful, but
//L  WITHOUT ANY WARRANTY; without even the implied warranty of
//L  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//L  Lesser General Public License for more details.
//L
//L  You should have received a copy of the CCP4 licence and/or GNU
//L  Lesser General Public License along with this library; if not, write
//L  to the CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
//L  The GNU Lesser General Public can also be obtained by writing to the
//L  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//L  MA 02111-1307 USA


#include "minimol_data.h"


namespace clipper {


namespace data {


Rotamer_data rotamer_data_dunbrack[] = { 
  {"ALA", 1, 0, 1.0000, 1," CB ",-0.940,-1.196, 0.000},
  {"ARG",16, 0, 0.1099, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 0, 0.1099, 7," CG ",-2.017,-1.162,-1.063},
  {"ARG",16, 0, 0.1099, 7," CD ",-2.937,-2.372,-1.071},
  {"ARG",16, 0, 0.1099, 7," NE ",-3.939,-2.292,-2.130},
  {"ARG",16, 0, 0.1099, 7," CZ ",-4.817,-3.248,-2.399},
  {"ARG",16, 0, 0.1099, 7," NH1",-4.823,-4.365,-1.684},
  {"ARG",16, 0, 0.1099, 7," NH2",-5.693,-3.090,-3.382},
  {"ARG",16, 1, 0.0666, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 1, 0.0666, 7," CG ",-2.007,-1.170,-1.074},
  {"ARG",16, 1, 0.0666, 7," CD ",-2.932,-2.375,-1.075},
  {"ARG",16, 1, 0.0666, 7," NE ",-2.238,-3.599,-1.465},
  {"ARG",16, 1, 0.0666, 7," CZ ",-2.778,-4.809,-1.423},
  {"ARG",16, 1, 0.0666, 7," NH1",-4.029,-4.965,-1.009},
  {"ARG",16, 1, 0.0666, 7," NH2",-2.072,-5.867,-1.796},
  {"ARG",16, 2, 0.0611, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 2, 0.0611, 7," CG ",-2.002,-1.174,-1.079},
  {"ARG",16, 2, 0.0611, 7," CD ",-2.913,-2.390,-1.095},
  {"ARG",16, 2, 0.0611, 7," NE ",-3.735,-2.475, 0.109},
  {"ARG",16, 2, 0.0611, 7," CZ ",-4.472,-3.527, 0.436},
  {"ARG",16, 2, 0.0611, 7," NH1",-4.492,-4.595,-0.351},
  {"ARG",16, 2, 0.0611, 7," NH2",-5.190,-3.517, 1.550},
  {"ARG",16, 3, 0.0602, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",16, 3, 0.0602, 7," CG ",-2.023,-1.158,-1.057},
  {"ARG",16, 3, 0.0602, 7," CD ",-2.960,-2.353,-1.046},
  {"ARG",16, 3, 0.0602, 7," NE ",-3.928,-2.302,-2.138},
  {"ARG",16, 3, 0.0602, 7," CZ ",-5.057,-1.608,-2.102},
  {"ARG",16, 3, 0.0602, 7," NH1",-5.367,-0.899,-1.025},
  {"ARG",16, 3, 0.0602, 7," NH2",-5.879,-1.619,-3.142},
  {"ARG",16, 4, 0.0546, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 4, 0.0546, 7," CG ",-1.888,-1.249, 1.194},
  {"ARG",16, 4, 0.0546, 7," CD ",-2.880,-2.399, 1.157},
  {"ARG",16, 4, 0.0546, 7," NE ",-3.750,-2.411, 2.330},
  {"ARG",16, 4, 0.0546, 7," CZ ",-4.694,-3.315, 2.549},
  {"ARG",16, 4, 0.0546, 7," NH1",-4.895,-4.292, 1.673},
  {"ARG",16, 4, 0.0546, 7," NH2",-5.439,-3.249, 3.644},
  {"ARG",16, 5, 0.0534, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 5, 0.0534, 7," CG ",-2.028,-1.154,-1.052},
  {"ARG",16, 5, 0.0534, 7," CD ",-3.091,-2.230,-0.905},
  {"ARG",16, 5, 0.0534, 7," NE ",-2.543,-3.570,-1.094},
  {"ARG",16, 5, 0.0534, 7," CZ ",-2.396,-4.156,-2.274},
  {"ARG",16, 5, 0.0534, 7," NH1",-2.754,-3.520,-3.382},
  {"ARG",16, 5, 0.0534, 7," NH2",-1.890,-5.380,-2.352},
  {"ARG",16, 6, 0.0480, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 6, 0.0480, 7," CG ",-2.006,-1.171,-1.075},
  {"ARG",16, 6, 0.0480, 7," CD ",-2.934,-2.374,-1.073},
  {"ARG",16, 6, 0.0480, 7," NE ",-3.958,-2.278,-2.109},
  {"ARG",16, 6, 0.0480, 7," CZ ",-3.794,-2.687,-3.359},
  {"ARG",16, 6, 0.0480, 7," NH1",-2.642,-3.227,-3.737},
  {"ARG",16, 6, 0.0480, 7," NH2",-4.780,-2.560,-4.237},
  {"ARG",16, 7, 0.0392, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 7, 0.0392, 7," CG ",-1.995,-1.180,-1.086},
  {"ARG",16, 7, 0.0392, 7," CD ",-2.920,-2.385,-1.086},
  {"ARG",16, 7, 0.0392, 7," NE ",-3.759,-2.432, 0.108},
  {"ARG",16, 7, 0.0392, 7," CZ ",-4.905,-1.779, 0.241},
  {"ARG",16, 7, 0.0392, 7," NH1",-5.358,-1.023,-0.751},
  {"ARG",16, 7, 0.0392, 7," NH2",-5.603,-1.879, 1.364},
  {"ARG",16, 8, 0.0367, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 8, 0.0367, 7," CG ",-1.933,-1.214, 1.158},
  {"ARG",16, 8, 0.0367, 7," CD ",-2.916,-2.372, 1.123},
  {"ARG",16, 8, 0.0367, 7," NE ",-2.260,-3.655, 1.362},
  {"ARG",16, 8, 0.0367, 7," CZ ",-2.830,-4.833, 1.158},
  {"ARG",16, 8, 0.0367, 7," NH1",-4.075,-4.900, 0.704},
  {"ARG",16, 8, 0.0367, 7," NH2",-2.158,-5.950, 1.404},
  {"ARG",16, 9, 0.0321, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16, 9, 0.0321, 7," CG ",-1.913,-1.230, 1.175},
  {"ARG",16, 9, 0.0321, 7," CD ",-2.850,-2.425, 1.179},
  {"ARG",16, 9, 0.0321, 7," NE ",-3.754,-2.417, 0.032},
  {"ARG",16, 9, 0.0321, 7," CZ ",-4.468,-3.462,-0.361},
  {"ARG",16, 9, 0.0321, 7," NH1",-4.391,-4.608, 0.301},
  {"ARG",16, 9, 0.0321, 7," NH2",-5.265,-3.364,-1.417},
  {"ARG",16,10, 0.0319, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,10, 0.0319, 7," CG ",-1.878,-1.256, 1.202},
  {"ARG",16,10, 0.0319, 7," CD ",-2.868,-2.409, 1.168},
  {"ARG",16,10, 0.0319, 7," NE ",-3.780,-2.383, 2.307},
  {"ARG",16,10, 0.0319, 7," CZ ",-3.507,-2.909, 3.493},
  {"ARG",16,10, 0.0319, 7," NH1",-2.341,-3.505, 3.703},
  {"ARG",16,10, 0.0319, 7," NH2",-4.397,-2.839, 4.473},
  {"ARG",16,11, 0.0308, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,11, 0.0308, 7," CG ",-1.882,-1.254, 1.199},
  {"ARG",16,11, 0.0308, 7," CD ",-2.837,-2.435, 1.190},
  {"ARG",16,11, 0.0308, 7," NE ",-2.135,-3.709, 1.314},
  {"ARG",16,11, 0.0308, 7," CZ ",-1.706,-4.216, 2.461},
  {"ARG",16,11, 0.0308, 7," NH1",-1.909,-3.558, 3.596},
  {"ARG",16,11, 0.0308, 7," NH2",-1.075,-5.382, 2.480},
  {"ARG",16,12, 0.0292, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,12, 0.0292, 7," CG ",-1.909,-1.232, 1.178},
  {"ARG",16,12, 0.0292, 7," CD ",-2.849,-2.427, 1.181},
  {"ARG",16,12, 0.0292, 7," NE ",-3.759,-2.411, 0.039},
  {"ARG",16,12, 0.0292, 7," CZ ",-4.885,-1.715,-0.007},
  {"ARG",16,12, 0.0292, 7," NH1",-5.248,-0.968, 1.027},
  {"ARG",16,12, 0.0292, 7," NH2",-5.653,-1.760,-1.087},
  {"ARG",16,13, 0.0283, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,13, 0.0283, 7," CG ",-1.941,-1.222,-1.135},
  {"ARG",16,13, 0.0283, 7," CD ",-3.052,-0.194,-1.000},
  {"ARG",16,13, 0.0283, 7," NE ",-4.014,-0.279,-2.095},
  {"ARG",16,13, 0.0283, 7," CZ ",-5.054, 0.530,-2.238},
  {"ARG",16,13, 0.0283, 7," NH1",-5.272, 1.496,-1.355},
  {"ARG",16,13, 0.0283, 7," NH2",-5.879, 0.379,-3.265},
  {"ARG",16,14, 0.0252, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,14, 0.0252, 7," CG ",-1.890,-1.247, 1.193},
  {"ARG",16,14, 0.0252, 7," CD ",-2.861,-2.415, 1.171},
  {"ARG",16,14, 0.0252, 7," NE ",-3.733,-2.425, 2.343},
  {"ARG",16,14, 0.0252, 7," CZ ",-4.864,-1.740, 2.436},
  {"ARG",16,14, 0.0252, 7," NH1",-5.270,-0.985, 1.424},
  {"ARG",16,14, 0.0252, 7," NH2",-5.594,-1.808, 3.541},
  {"ARG",16,15, 0.0237, 7," CB ",-0.939,-1.208, 0.008},
  {"ARG",16,15, 0.0237, 7," CG ",-1.949,-1.216,-1.129},
  {"ARG",16,15, 0.0237, 7," CD ",-3.023,-0.147,-1.012},
  {"ARG",16,15, 0.0237, 7," NE ",-4.031,-0.266,-2.062},
  {"ARG",16,15, 0.0237, 7," CZ ",-3.928, 0.291,-3.260},
  {"ARG",16,15, 0.0237, 7," NH1",-2.856, 1.009,-3.570},
  {"ARG",16,15, 0.0237, 7," NH2",-4.894, 0.131,-4.154},
  {"ASN",12, 0, 0.2820, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 0, 0.2820, 4," CG ",-2.060,-1.067,-1.020},
  {"ASN",12, 0, 0.2820, 4," OD1",-2.402, 0.037,-1.445},
  {"ASN",12, 0, 0.2820, 4," ND2",-2.628,-2.197,-1.425},
  {"ASN",12, 1, 0.1860, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 1, 0.1860, 4," CG ",-1.992,-1.122,-1.095},
  {"ASN",12, 1, 0.1860, 4," OD1",-2.829,-0.219,-1.113},
  {"ASN",12, 1, 0.1860, 4," ND2",-1.944,-2.073,-2.020},
  {"ASN",12, 2, 0.0984, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 2, 0.0984, 4," CG ",-1.993,-1.108, 1.105},
  {"ASN",12, 2, 0.0984, 4," OD1",-2.320,-0.019, 1.579},
  {"ASN",12, 2, 0.0984, 4," ND2",-2.519,-2.255, 1.516},
  {"ASN",12, 3, 0.0714, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 3, 0.0714, 4," CG ",-1.970,-1.126, 1.128},
  {"ASN",12, 3, 0.0714, 4," OD1",-1.774,-0.416, 2.115},
  {"ASN",12, 3, 0.0714, 4," ND2",-3.065,-1.862, 0.980},
  {"ASN",12, 4, 0.0705, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 4, 0.0705, 4," CG ",-0.220,-2.524, 0.066},
  {"ASN",12, 4, 0.0705, 4," OD1", 1.008,-2.565, 0.131},
  {"ASN",12, 4, 0.0705, 4," ND2",-0.974,-3.616, 0.045},
  {"ASN",12, 5, 0.0549, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 5, 0.0549, 4," CG ",-1.953,-1.139, 1.143},
  {"ASN",12, 5, 0.0549, 4," OD1",-2.749,-0.204, 1.238},
  {"ASN",12, 5, 0.0549, 4," ND2",-1.918,-2.141, 2.014},
  {"ASN",12, 6, 0.0432, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 6, 0.0432, 4," CG ",-1.928,-1.159, 1.166},
  {"ASN",12, 6, 0.0432, 4," OD1",-1.534,-1.274, 2.327},
  {"ASN",12, 6, 0.0432, 4," ND2",-3.209,-0.996, 0.857},
  {"ASN",12, 7, 0.0416, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 7, 0.0416, 4," CG ",-1.985,-1.128,-1.102},
  {"ASN",12, 7, 0.0416, 4," OD1",-1.811,-1.724,-2.165},
  {"ASN",12, 7, 0.0416, 4," ND2",-3.067,-0.398,-0.857},
  {"ASN",12, 8, 0.0359, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 8, 0.0359, 4," CG ",-0.221,-2.524,-0.046},
  {"ASN",12, 8, 0.0359, 4," OD1", 0.618,-2.818, 0.806},
  {"ASN",12, 8, 0.0359, 4," ND2",-0.536,-3.334,-1.049},
  {"ASN",12, 9, 0.0309, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12, 9, 0.0309, 4," CG ",-1.888,-1.191, 1.200},
  {"ASN",12, 9, 0.0309, 4," OD1",-1.820,-2.068, 2.060},
  {"ASN",12, 9, 0.0309, 4," ND2",-2.767,-0.198, 1.257},
  {"ASN",12,10, 0.0304, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12,10, 0.0304, 4," CG ",-1.977,-1.134,-1.109},
  {"ASN",12,10, 0.0304, 4," OD1",-2.296,-2.147,-1.732},
  {"ASN",12,10, 0.0304, 4," ND2",-2.499, 0.059,-1.366},
  {"ASN",12,11, 0.0260, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN",12,11, 0.0260, 4," CG ",-0.220,-2.524, 0.064},
  {"ASN",12,11, 0.0260, 4," OD1", 0.653,-2.800,-0.759},
  {"ASN",12,11, 0.0260, 4," ND2",-0.574,-3.353, 1.039},
  {"ASP", 8, 0, 0.3087, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 0, 0.3087, 4," CG ",-2.062,-1.078,-1.004},
  {"ASP", 8, 0, 0.3087, 4," OD1",-2.259, 0.034,-1.536},
  {"ASP", 8, 0, 0.3087, 4," OD2",-2.798,-2.034,-1.328},
  {"ASP", 8, 1, 0.1945, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 1, 0.1945, 4," CG ",-1.964,-1.155,-1.109},
  {"ASP", 8, 1, 0.1945, 4," OD1",-2.622,-0.105,-1.264},
  {"ASP", 8, 1, 0.1945, 4," OD2",-2.178,-2.113,-1.882},
  {"ASP", 8, 2, 0.1761, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 2, 0.1761, 4," CG ",-1.945,-1.157, 1.139},
  {"ASP", 8, 2, 0.1761, 4," OD1",-1.903,-0.190, 1.929},
  {"ASP", 8, 2, 0.1761, 4," OD2",-2.814,-2.036, 1.318},
  {"ASP", 8, 3, 0.1097, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 3, 0.1097, 4," CG ",-0.191,-2.526, 0.032},
  {"ASP", 8, 3, 0.1097, 4," OD1", 1.057,-2.502, 0.069},
  {"ASP", 8, 3, 0.1097, 4," OD2",-0.767,-3.635, 0.019},
  {"ASP", 8, 4, 0.0872, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 4, 0.0872, 4," CG ",-1.924,-1.173, 1.158},
  {"ASP", 8, 4, 0.0872, 4," OD1",-2.693,-0.193, 1.254},
  {"ASP", 8, 4, 0.0872, 4," OD2",-2.003,-2.079, 2.014},
  {"ASP", 8, 5, 0.0493, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 5, 0.0493, 4," CG ",-2.011,-1.105, 1.073},
  {"ASP", 8, 5, 0.0493, 4," OD1",-1.657,-0.939, 2.259},
  {"ASP", 8, 5, 0.0493, 4," OD2",-3.232,-1.177, 0.819},
  {"ASP", 8, 6, 0.0347, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 6, 0.0347, 4," CG ",-0.191,-2.526, 0.029},
  {"ASP", 8, 6, 0.0347, 4," OD1", 0.647,-2.751,-0.869},
  {"ASP", 8, 6, 0.0347, 4," OD2",-0.374,-3.397, 0.907},
  {"ASP", 8, 7, 0.0208, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 8, 7, 0.0208, 4," CG ",-0.195,-2.524,-0.100},
  {"ASP", 8, 7, 0.0208, 4," OD1", 0.712,-2.764, 0.725},
  {"ASP", 8, 7, 0.0208, 4," OD2",-0.448,-3.380,-0.974},
  {"CYS", 3, 0, 0.5664, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 0, 0.5664, 2," SG ",-2.165,-1.207,-1.322},
  {"CYS", 3, 1, 0.2742, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 1, 0.2742, 2," SG ",-2.064,-1.270, 1.421},
  {"CYS", 3, 2, 0.1594, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 2, 0.1594, 2," SG ",-0.101,-2.807, 0.069},
  {"GLN",13, 0, 0.1853, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 0, 0.1853, 5," CG ",-2.016,-1.163,-1.066},
  {"GLN",13, 0, 0.1853, 5," CD ",-2.891,-2.400,-1.067},
  {"GLN",13, 0, 0.1853, 5," OE1",-2.682,-3.315,-0.270},
  {"GLN",13, 0, 0.1853, 5," NE2",-3.874,-2.431,-1.962},
  {"GLN",13, 1, 0.1466, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 1, 0.1466, 5," CG ",-1.953,-1.212,-1.126},
  {"GLN",13, 1, 0.1466, 5," CD ",-2.911,-0.039,-1.058},
  {"GLN",13, 1, 0.1466, 5," OE1",-3.449, 0.268, 0.006},
  {"GLN",13, 1, 0.1466, 5," NE2",-3.125, 0.619,-2.193},
  {"GLN",13, 2, 0.0949, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 2, 0.0949, 5," CG ",-1.888,-1.251, 1.193},
  {"GLN",13, 2, 0.0949, 5," CD ",-2.846,-2.423, 1.132},
  {"GLN",13, 2, 0.0949, 5," OE1",-2.794,-3.227, 0.202},
  {"GLN",13, 2, 0.0949, 5," NE2",-3.725,-2.523, 2.125},
  {"GLN",13, 3, 0.0906, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 3, 0.0906, 5," CG ",-2.005,-1.171,-1.077},
  {"GLN",13, 3, 0.0906, 5," CD ",-2.921,-2.377,-1.035},
  {"GLN",13, 3, 0.0906, 5," OE1",-2.543,-3.466,-1.469},
  {"GLN",13, 3, 0.0906, 5," NE2",-4.129,-2.188,-0.513},
  {"GLN",13, 4, 0.0788, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 4, 0.0788, 5," CG ",-1.990,-1.183,-1.092},
  {"GLN",13, 4, 0.0788, 5," CD ",-2.919,-2.379,-1.038},
  {"GLN",13, 4, 0.0788, 5," OE1",-3.803,-2.448,-0.185},
  {"GLN",13, 4, 0.0788, 5," NE2",-2.721,-3.325,-1.952},
  {"GLN",13, 5, 0.0776, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 5, 0.0776, 5," CG ",-1.902,-1.239, 1.182},
  {"GLN",13, 5, 0.0776, 5," CD ",-2.901,-0.100, 1.151},
  {"GLN",13, 5, 0.0776, 5," OE1",-3.472, 0.205, 0.104},
  {"GLN",13, 5, 0.0776, 5," NE2",-3.114, 0.533, 2.300},
  {"GLN",13, 6, 0.0448, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 6, 0.0448, 5," CG ",-1.894,-1.246, 1.189},
  {"GLN",13, 6, 0.0448, 5," CD ",-2.799,-2.461, 1.169},
  {"GLN",13, 6, 0.0448, 5," OE1",-2.361,-3.572, 1.467},
  {"GLN",13, 6, 0.0448, 5," NE2",-4.065,-2.253, 0.820},
  {"GLN",13, 7, 0.0393, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 7, 0.0393, 5," CG ",-1.871,-1.263, 1.206},
  {"GLN",13, 7, 0.0393, 5," CD ",-2.850,-2.418, 1.132},
  {"GLN",13, 7, 0.0393, 5," OE1",-3.841,-2.352, 0.405},
  {"GLN",13, 7, 0.0393, 5," NE2",-2.574,-3.479, 1.883},
  {"GLN",13, 8, 0.0251, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 8, 0.0251, 5," CG ",-0.230,-2.548, 0.092},
  {"GLN",13, 8, 0.0251, 5," CD ",-1.187,-3.720, 0.035},
  {"GLN",13, 8, 0.0251, 5," OE1",-2.404,-3.535, 0.006},
  {"GLN",13, 8, 0.0251, 5," NE2",-0.641,-4.933, 0.018},
  {"GLN",13, 9, 0.0248, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13, 9, 0.0248, 5," CG ",-2.031,-1.151,-1.050},
  {"GLN",13, 9, 0.0248, 5," CD ",-2.949, 0.041,-0.879},
  {"GLN",13, 9, 0.0248, 5," OE1",-3.057, 0.882,-1.772},
  {"GLN",13, 9, 0.0248, 5," NE2",-3.615, 0.117, 0.269},
  {"GLN",13,10, 0.0245, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13,10, 0.0245, 5," CG ",-2.008,-1.169,-1.073},
  {"GLN",13,10, 0.0245, 5," CD ",-3.137,-0.213,-0.744},
  {"GLN",13,10, 0.0245, 5," OE1",-2.898, 0.909,-0.298},
  {"GLN",13,10, 0.0245, 5," NE2",-4.372,-0.655,-0.965},
  {"GLN",13,11, 0.0223, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13,11, 0.0223, 5," CG ",-2.029,-1.153,-1.052},
  {"GLN",13,11, 0.0223, 5," CD ",-1.506,-1.446,-2.443},
  {"GLN",13,11, 0.0223, 5," OE1",-0.632,-2.295,-2.618},
  {"GLN",13,11, 0.0223, 5," NE2",-2.041,-0.745,-3.438},
  {"GLN",13,12, 0.0208, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN",13,12, 0.0208, 5," CG ",-2.007,-1.170,-1.075},
  {"GLN",13,12, 0.0208, 5," CD ",-2.903,-2.391,-1.053},
  {"GLN",13,12, 0.0208, 5," OE1",-3.794,-2.530,-1.892},
  {"GLN",13,12, 0.0208, 5," NE2",-2.670,-3.282,-0.094},
  {"GLU",13, 0, 0.1884, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 0, 0.1884, 5," CG ",-2.018,-1.162,-1.064},
  {"GLU",13, 0, 0.1884, 5," CD ",-2.894,-2.400,-1.060},
  {"GLU",13, 0, 0.1884, 5," OE1",-2.632,-3.312,-0.249},
  {"GLU",13, 0, 0.1884, 5," OE2",-3.843,-2.461,-1.870},
  {"GLU",13, 1, 0.1200, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 1, 0.1200, 5," CG ",-1.882,-1.255, 1.198},
  {"GLU",13, 1, 0.1200, 5," CD ",-2.831,-2.438, 1.142},
  {"GLU",13, 1, 0.1200, 5," OE1",-2.752,-3.218, 0.170},
  {"GLU",13, 1, 0.1200, 5," OE2",-3.655,-2.586, 2.069},
  {"GLU",13, 2, 0.0900, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 2, 0.0900, 5," CG ",-1.982,-1.190,-1.100},
  {"GLU",13, 2, 0.0900, 5," CD ",-2.920,-2.380,-1.035},
  {"GLU",13, 2, 0.0900, 5," OE1",-2.426,-3.527,-1.027},
  {"GLU",13, 2, 0.0900, 5," OE2",-4.150,-2.168,-0.993},
  {"GLU",13, 3, 0.0830, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 3, 0.0830, 5," CG ",-2.018,-1.162,-1.064},
  {"GLU",13, 3, 0.0830, 5," CD ",-2.931, 0.041,-0.918},
  {"GLU",13, 3, 0.0830, 5," OE1",-3.470, 0.247, 0.189},
  {"GLU",13, 3, 0.0830, 5," OE2",-3.111, 0.777,-1.911},
  {"GLU",13, 4, 0.0750, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 4, 0.0750, 5," CG ",-2.026,-1.155,-1.055},
  {"GLU",13, 4, 0.0750, 5," CD ",-2.926,-2.377,-1.028},
  {"GLU",13, 4, 0.0750, 5," OE1",-3.507,-2.664, 0.039},
  {"GLU",13, 4, 0.0750, 5," OE2",-3.048,-3.050,-2.073},
  {"GLU",13, 5, 0.0685, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 5, 0.0685, 5," CG ",-1.965,-1.203,-1.116},
  {"GLU",13, 5, 0.0685, 5," CD ",-3.037,-0.148,-0.920},
  {"GLU",13, 5, 0.0685, 5," OE1",-3.088, 0.452, 0.175},
  {"GLU",13, 5, 0.0685, 5," OE2",-3.828, 0.080,-1.859},
  {"GLU",13, 6, 0.0600, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 6, 0.0600, 5," CG ",-1.877,-1.259, 1.201},
  {"GLU",13, 6, 0.0600, 5," CD ",-2.860,-2.413, 1.121},
  {"GLU",13, 6, 0.0600, 5," OE1",-2.408,-3.572, 1.019},
  {"GLU",13, 6, 0.0600, 5," OE2",-4.082,-2.158, 1.157},
  {"GLU",13, 7, 0.0572, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 7, 0.0572, 5," CG ",-1.916,-1.229, 1.171},
  {"GLU",13, 7, 0.0572, 5," CD ",-2.842,-2.430, 1.131},
  {"GLU",13, 7, 0.0572, 5," OE1",-3.551,-2.602, 0.118},
  {"GLU",13, 7, 0.0572, 5," OE2",-2.862,-3.200, 2.115},
  {"GLU",13, 8, 0.0409, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 8, 0.0409, 5," CG ",-1.864,-1.269, 1.212},
  {"GLU",13, 8, 0.0409, 5," CD ",-2.895,-0.157, 1.211},
  {"GLU",13, 8, 0.0409, 5," OE1",-3.009, 0.548, 0.186},
  {"GLU",13, 8, 0.0409, 5," OE2",-3.590, 0.013, 2.235},
  {"GLU",13, 9, 0.0392, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13, 9, 0.0392, 5," CG ",-1.995,-1.179,-1.086},
  {"GLU",13, 9, 0.0392, 5," CD ",-1.468,-1.678,-2.419},
  {"GLU",13, 9, 0.0392, 5," OE1",-0.287,-2.079,-2.478},
  {"GLU",13, 9, 0.0392, 5," OE2",-2.234,-1.666,-3.405},
  {"GLU",13,10, 0.0300, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13,10, 0.0300, 5," CG ",-1.954,-1.200, 1.138},
  {"GLU",13,10, 0.0300, 5," CD ",-2.895,-0.012, 1.067},
  {"GLU",13,10, 0.0300, 5," OE1",-3.497, 0.207,-0.005},
  {"GLU",13,10, 0.0300, 5," OE2",-3.030, 0.704, 2.082},
  {"GLU",13,11, 0.0256, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13,11, 0.0256, 5," CG ",-0.226,-2.549, 0.080},
  {"GLU",13,11, 0.0256, 5," CD ",-1.186,-3.722, 0.021},
  {"GLU",13,11, 0.0256, 5," OE1",-2.405,-3.487,-0.110},
  {"GLU",13,11, 0.0256, 5," OE2",-0.720,-4.878, 0.108},
  {"GLU",13,12, 0.0210, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU",13,12, 0.0210, 5," CG ",-1.997,-1.178,-1.085},
  {"GLU",13,12, 0.0210, 5," CD ",-1.415,-1.414,-2.466},
  {"GLU",13,12, 0.0210, 5," OE1",-0.696,-2.419,-2.645},
  {"GLU",13,12, 0.0210, 5," OE2",-1.675,-0.594,-3.371},
  {"HIS", 8, 0, 0.2964, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 0, 0.2964, 6," CG ",-1.939,-1.201,-1.105},
  {"HIS", 8, 0, 0.2964, 6," ND1",-3.021,-0.346,-1.133},
  {"HIS", 8, 0, 0.2964, 6," CD2",-2.024,-1.947,-2.233},
  {"HIS", 8, 0, 0.2964, 6," CE1",-3.726,-0.565,-2.227},
  {"HIS", 8, 0, 0.2964, 6," NE2",-3.144,-1.531,-2.913},
  {"HIS", 8, 1, 0.1533, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 1, 0.1533, 6," CG ",-1.846,-1.260, 1.196},
  {"HIS", 8, 1, 0.1533, 6," ND1",-2.904,-0.390, 1.368},
  {"HIS", 8, 1, 0.1533, 6," CD2",-1.855,-2.077, 2.275},
  {"HIS", 8, 1, 0.1533, 6," CE1",-3.523,-0.670, 2.499},
  {"HIS", 8, 1, 0.1533, 6," NE2",-2.909,-1.690, 3.070},
  {"HIS", 8, 2, 0.1451, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 2, 0.1451, 6," CG ",-1.974,-1.174,-1.073},
  {"HIS", 8, 2, 0.1451, 6," ND1",-1.737,-1.645,-2.348},
  {"HIS", 8, 2, 0.1451, 6," CD2",-3.252,-0.726,-1.071},
  {"HIS", 8, 2, 0.1451, 6," CE1",-2.823,-1.489,-3.082},
  {"HIS", 8, 2, 0.1451, 6," NE2",-3.758,-0.934,-2.333},
  {"HIS", 8, 3, 0.1213, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 3, 0.1213, 6," CG ",-1.938,-1.188, 1.121},
  {"HIS", 8, 3, 0.1213, 6," ND1",-1.649,-1.643, 2.391},
  {"HIS", 8, 3, 0.1213, 6," CD2",-3.226,-0.770, 1.158},
  {"HIS", 8, 3, 0.1213, 6," CE1",-2.713,-1.506, 3.159},
  {"HIS", 8, 3, 0.1213, 6," NE2",-3.684,-0.978, 2.438},
  {"HIS", 8, 4, 0.1077, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 4, 0.1077, 6," CG ",-2.005,-1.150,-1.041},
  {"HIS", 8, 4, 0.1077, 6," ND1",-2.805,-2.230,-1.352},
  {"HIS", 8, 4, 0.1077, 6," CD2",-2.403,-0.143,-1.854},
  {"HIS", 8, 4, 0.1077, 6," CE1",-3.649,-1.890,-2.309},
  {"HIS", 8, 4, 0.1077, 6," NE2",-3.428,-0.629,-2.632},
  {"HIS", 8, 5, 0.0705, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 5, 0.0705, 6," CG ",-0.234,-2.522, 0.099},
  {"HIS", 8, 5, 0.0705, 6," ND1", 0.360,-3.128,-0.988},
  {"HIS", 8, 5, 0.0705, 6," CD2",-0.025,-3.351, 1.150},
  {"HIS", 8, 5, 0.0705, 6," CE1", 0.903,-4.271,-0.612},
  {"HIS", 8, 5, 0.0705, 6," NE2", 0.685,-4.431, 0.680},
  {"HIS", 8, 6, 0.0528, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 6, 0.0528, 6," CG ",-1.935,-1.191, 1.124},
  {"HIS", 8, 6, 0.0528, 6," ND1",-2.738,-2.272, 1.424},
  {"HIS", 8, 6, 0.0528, 6," CD2",-2.260,-0.225, 2.015},
  {"HIS", 8, 6, 0.0528, 6," CE1",-3.513,-1.972, 2.450},
  {"HIS", 8, 6, 0.0528, 6," NE2",-3.243,-0.736, 2.829},
  {"HIS", 8, 7, 0.0474, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 7, 0.0474, 6," CG ",-0.232,-2.524, 0.042},
  {"HIS", 8, 7, 0.0474, 6," ND1", 0.182,-3.118, 1.216},
  {"HIS", 8, 7, 0.0474, 6," CD2", 0.137,-3.365,-0.953},
  {"HIS", 8, 7, 0.0474, 6," CE1", 0.775,-4.265, 0.942},
  {"HIS", 8, 7, 0.0474, 6," NE2", 0.761,-4.441,-0.366},
  {"ILE", 5, 0, 0.6158, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 0, 0.6158, 4," CG1",-1.934,-1.131,-1.157},
  {"ILE", 5, 0, 0.6158, 4," CG2",-1.685,-1.306, 1.334},
  {"ILE", 5, 0, 0.6158, 4," CD1",-2.741,-2.393,-1.366},
  {"ILE", 5, 1, 0.1557, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 1, 0.1557, 4," CG1",-1.858,-1.191,-1.220},
  {"ILE", 5, 1, 0.1557, 4," CG2",-1.768,-1.243, 1.287},
  {"ILE", 5, 1, 0.1557, 4," CD1",-2.749, 0.029,-1.294},
  {"ILE", 5, 2, 0.1202, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 2, 0.1202, 4," CG1",-0.142,-2.518,-0.003},
  {"ILE", 5, 2, 0.1202, 4," CG2",-1.895,-1.160,-1.179},
  {"ILE", 5, 2, 0.1202, 4," CD1",-0.981,-3.756, 0.221},
  {"ILE", 5, 3, 0.0615, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 3, 0.0615, 4," CG1",-1.950,-1.103, 1.157},
  {"ILE", 5, 3, 0.0615, 4," CG2",-0.151,-2.508, 0.114},
  {"ILE", 5, 3, 0.0615, 4," CD1",-3.097,-2.085, 1.064},
  {"ILE", 5, 4, 0.0267, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 4, 0.0267, 4," CG1",-2.004,-1.061, 1.103},
  {"ILE", 5, 4, 0.0267, 4," CG2",-0.158,-2.502, 0.201},
  {"ILE", 5, 4, 0.0267, 4," CD1",-2.976, 0.071, 0.856},
  {"LEU", 4, 0, 0.6252, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 0, 0.6252, 4," CG ",-2.001,-1.247,-1.094},
  {"LEU", 4, 0, 0.6252, 4," CD1",-2.772,-2.557,-1.051},
  {"LEU", 4, 0, 0.6252, 4," CD2",-2.946,-0.060,-0.975},
  {"LEU", 4, 1, 0.2891, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 1, 0.2891, 4," CG ",-1.880,-1.328, 1.209},
  {"LEU", 4, 1, 0.2891, 4," CD1",-2.838,-0.149, 1.260},
  {"LEU", 4, 1, 0.2891, 4," CD2",-2.643,-2.643, 1.167},
  {"LEU", 4, 2, 0.0365, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 2, 0.0365, 4," CG ",-2.274,-1.032,-0.721},
  {"LEU", 4, 2, 0.0365, 4," CD1",-2.048,-0.582,-2.155},
  {"LEU", 4, 2, 0.0365, 4," CD2",-3.084,-2.320,-0.680},
  {"LEU", 4, 3, 0.0256, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 3, 0.0256, 4," CG ",-2.097,-1.160, 1.008},
  {"LEU", 4, 3, 0.0256, 4," CD1",-3.073,-2.299, 0.755},
  {"LEU", 4, 3, 0.0256, 4," CD2",-1.577,-1.201, 2.436},
  {"LYS",14, 0, 0.2279, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 0, 0.2279, 5," CG ",-2.008,-1.171,-1.073},
  {"LYS",14, 0, 0.2279, 5," CD ",-2.911,-2.390,-1.000},
  {"LYS",14, 0, 0.2279, 5," CE ",-3.970,-2.360,-2.088},
  {"LYS",14, 0, 0.2279, 5," NZ ",-4.856,-3.556,-2.035},
  {"LYS",14, 1, 0.1345, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 1, 0.1345, 5," CG ",-1.884,-1.253, 1.197},
  {"LYS",14, 1, 0.1345, 5," CD ",-2.833,-2.437, 1.105},
  {"LYS",14, 1, 0.1345, 5," CE ",-3.769,-2.489, 2.300},
  {"LYS",14, 1, 0.1345, 5," NZ ",-4.706,-3.643, 2.221},
  {"LYS",14, 2, 0.0696, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 2, 0.0696, 5," CG ",-1.932,-1.230,-1.143},
  {"LYS",14, 2, 0.0696, 5," CD ",-2.924,-0.083,-1.040},
  {"LYS",14, 2, 0.0696, 5," CE ",-3.957,-0.143,-2.152},
  {"LYS",14, 2, 0.0696, 5," NZ ",-4.905, 1.003,-2.092},
  {"LYS",14, 3, 0.0544, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 3, 0.0544, 5," CG ",-2.003,-1.174,-1.078},
  {"LYS",14, 3, 0.0544, 5," CD ",-2.928,-2.376,-0.983},
  {"LYS",14, 3, 0.0544, 5," CE ",-3.954,-2.375,-2.103},
  {"LYS",14, 3, 0.0544, 5," NZ ",-4.899,-1.230,-1.989},
  {"LYS",14, 4, 0.0529, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 4, 0.0529, 5," CG ",-2.008,-1.171,-1.073},
  {"LYS",14, 4, 0.0529, 5," CD ",-2.926,-2.378,-0.984},
  {"LYS",14, 4, 0.0529, 5," CE ",-4.028,-2.312,-2.028},
  {"LYS",14, 4, 0.0529, 5," NZ ",-3.491,-2.432,-3.411},
  {"LYS",14, 5, 0.0383, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 5, 0.0383, 5," CG ",-2.015,-1.165,-1.065},
  {"LYS",14, 5, 0.0383, 5," CD ",-2.983,-2.328,-0.925},
  {"LYS",14, 5, 0.0383, 5," CE ",-2.339,-3.637,-1.350},
  {"LYS",14, 5, 0.0383, 5," NZ ",-3.301,-4.772,-1.297},
  {"LYS",14, 6, 0.0353, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 6, 0.0353, 5," CG ",-1.892,-1.247, 1.191},
  {"LYS",14, 6, 0.0353, 5," CD ",-2.857,-2.415, 1.086},
  {"LYS",14, 6, 0.0353, 5," CE ",-3.735,-2.521, 2.321},
  {"LYS",14, 6, 0.0353, 5," NZ ",-4.638,-1.346, 2.463},
  {"LYS",14, 7, 0.0348, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 7, 0.0348, 5," CG ",-2.028,-1.155,-1.051},
  {"LYS",14, 7, 0.0348, 5," CD ",-2.864,-2.424,-1.049},
  {"LYS",14, 7, 0.0348, 5," CE ",-3.719,-2.521, 0.203},
  {"LYS",14, 7, 0.0348, 5," NZ ",-4.591,-3.727, 0.188},
  {"LYS",14, 8, 0.0347, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 8, 0.0347, 5," CG ",-1.885,-1.252, 1.196},
  {"LYS",14, 8, 0.0347, 5," CD ",-2.835,-2.434, 1.103},
  {"LYS",14, 8, 0.0347, 5," CE ",-3.835,-2.431, 2.247},
  {"LYS",14, 8, 0.0347, 5," NZ ",-3.180,-2.686, 3.559},
  {"LYS",14, 9, 0.0314, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14, 9, 0.0314, 5," CG ",-0.226,-2.547, 0.117},
  {"LYS",14, 9, 0.0314, 5," CD ",-1.213,-3.702, 0.104},
  {"LYS",14, 9, 0.0314, 5," CE ",-0.503,-5.039, 0.226},
  {"LYS",14, 9, 0.0314, 5," NZ ",-1.460,-6.179, 0.217},
  {"LYS",14,10, 0.0299, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,10, 0.0299, 5," CG ",-1.875,-1.260, 1.204},
  {"LYS",14,10, 0.0299, 5," CD ",-2.934,-0.173, 1.124},
  {"LYS",14,10, 0.0299, 5," CE ",-3.932,-0.288, 2.265},
  {"LYS",14,10, 0.0299, 5," NZ ",-4.966, 0.781, 2.208},
  {"LYS",14,11, 0.0238, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,11, 0.0238, 5," CG ",-1.919,-1.226, 1.169},
  {"LYS",14,11, 0.0238, 5," CD ",-2.774,-2.482, 1.153},
  {"LYS",14,11, 0.0238, 5," CE ",-3.761,-2.464,-0.002},
  {"LYS",14,11, 0.0238, 5," NZ ",-4.656,-3.654, 0.014},
  {"LYS",14,12, 0.0232, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,12, 0.0232, 5," CG ",-1.879,-1.257, 1.201},
  {"LYS",14,12, 0.0232, 5," CD ",-2.882,-2.390, 1.069},
  {"LYS",14,12, 0.0232, 5," CE ",-2.217,-3.743, 1.261},
  {"LYS",14,12, 0.0232, 5," NZ ",-3.198,-4.860, 1.186},
  {"LYS",14,13, 0.0212, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",14,13, 0.0212, 5," CG ",-1.899,-1.256,-1.170},
  {"LYS",14,13, 0.0212, 5," CD ",-2.906,-0.121,-1.109},
  {"LYS",14,13, 0.0212, 5," CE ",-3.950,-0.248,-2.206},
  {"LYS",14,13, 0.0212, 5," NZ ",-3.372, 0.002,-3.555},
  {"MET",12, 0, 0.1853, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 0, 0.1853, 4," CG ",-1.991,-1.182,-1.091},
  {"MET",12, 0, 0.1853, 4," SD ",-3.101, 0.232,-0.960},
  {"MET",12, 0, 0.1853, 4," CE ",-4.019,-0.193, 0.518},
  {"MET",12, 1, 0.1634, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 1, 0.1634, 4," CG ",-2.015,-1.163,-1.067},
  {"MET",12, 1, 0.1634, 4," SD ",-3.064,-2.629,-1.060},
  {"MET",12, 1, 0.1634, 4," CE ",-3.984,-2.380, 0.457},
  {"MET",12, 2, 0.1181, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 2, 0.1181, 4," CG ",-2.020,-1.160,-1.062},
  {"MET",12, 2, 0.1181, 4," SD ",-3.168,-2.544,-0.951},
  {"MET",12, 2, 0.1181, 4," CE ",-2.150,-3.880,-1.575},
  {"MET",12, 3, 0.0931, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 3, 0.0931, 4," CG ",-2.014,-1.165,-1.068},
  {"MET",12, 3, 0.0931, 4," SD ",-3.084,-2.614,-1.039},
  {"MET",12, 3, 0.0931, 4," CE ",-4.149,-2.278,-2.440},
  {"MET",12, 4, 0.0722, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 4, 0.0722, 4," CG ",-1.927,-1.219, 1.164},
  {"MET",12, 4, 0.0722, 4," SD ",-3.020,-2.651, 1.129},
  {"MET",12, 4, 0.0722, 4," CE ",-4.070,-2.243,-0.263},
  {"MET",12, 5, 0.0702, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 5, 0.0702, 4," CG ",-1.875,-1.259, 1.205},
  {"MET",12, 5, 0.0702, 4," SD ",-2.980,-2.682, 1.162},
  {"MET",12, 5, 0.0702, 4," CE ",-1.836,-4.011, 1.529},
  {"MET",12, 6, 0.0690, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 6, 0.0690, 4," CG ",-1.904,-1.236, 1.182},
  {"MET",12, 6, 0.0690, 4," SD ",-3.060, 0.146, 1.170},
  {"MET",12, 6, 0.0690, 4," CE ",-4.134,-0.322,-0.186},
  {"MET",12, 7, 0.0373, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 7, 0.0373, 4," CG ",-1.881,-1.254, 1.200},
  {"MET",12, 7, 0.0373, 4," SD ",-3.073,-2.601, 1.092},
  {"MET",12, 7, 0.0373, 4," CE ",-3.937,-2.415, 2.650},
  {"MET",12, 8, 0.0332, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 8, 0.0332, 4," CG ",-1.944,-1.220,-1.134},
  {"MET",12, 8, 0.0332, 4," SD ",-3.098, 0.162,-1.062},
  {"MET",12, 8, 0.0332, 4," CE ",-3.940,-0.017,-2.633},
  {"MET",12, 9, 0.0311, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 9, 0.0311, 4," CG ",-1.991,-1.182,-1.090},
  {"MET",12, 9, 0.0311, 4," SD ",-3.156, 0.181,-0.909},
  {"MET",12, 9, 0.0311, 4," CE ",-2.486, 1.358,-2.081},
  {"MET",12,10, 0.0253, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12,10, 0.0253, 4," CG ",-0.230,-2.548, 0.076},
  {"MET",12,10, 0.0253, 4," SD ",-1.371,-3.942, 0.034},
  {"MET",12,10, 0.0253, 4," CE ",-1.808,-3.970,-1.703},
  {"MET",12,11, 0.0244, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12,11, 0.0244, 4," CG ",-0.229,-2.549, 0.052},
  {"MET",12,11, 0.0244, 4," SD ",-1.373,-3.941, 0.086},
  {"MET",12,11, 0.0244, 4," CE ",-2.024,-3.805, 1.749},
  {"MSE",12, 0, 0.1853, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 0, 0.1853, 4," CG ",-1.991,-1.182,-1.091},
  {"MSE",12, 0, 0.1853, 4,"SE  ",-3.101, 0.232,-0.960},
  {"MSE",12, 0, 0.1853, 4," CE ",-4.019,-0.193, 0.518},
  {"MSE",12, 1, 0.1634, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 1, 0.1634, 4," CG ",-2.015,-1.163,-1.067},
  {"MSE",12, 1, 0.1634, 4,"SE  ",-3.064,-2.629,-1.060},
  {"MSE",12, 1, 0.1634, 4," CE ",-3.984,-2.380, 0.457},
  {"MSE",12, 2, 0.1181, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 2, 0.1181, 4," CG ",-2.020,-1.160,-1.062},
  {"MSE",12, 2, 0.1181, 4,"SE  ",-3.168,-2.544,-0.951},
  {"MSE",12, 2, 0.1181, 4," CE ",-2.150,-3.880,-1.575},
  {"MSE",12, 3, 0.0931, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 3, 0.0931, 4," CG ",-2.014,-1.165,-1.068},
  {"MSE",12, 3, 0.0931, 4,"SE  ",-3.084,-2.614,-1.039},
  {"MSE",12, 3, 0.0931, 4," CE ",-4.149,-2.278,-2.440},
  {"MSE",12, 4, 0.0722, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 4, 0.0722, 4," CG ",-1.927,-1.219, 1.164},
  {"MSE",12, 4, 0.0722, 4,"SE  ",-3.020,-2.651, 1.129},
  {"MSE",12, 4, 0.0722, 4," CE ",-4.070,-2.243,-0.263},
  {"MSE",12, 5, 0.0702, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 5, 0.0702, 4," CG ",-1.875,-1.259, 1.205},
  {"MSE",12, 5, 0.0702, 4,"SE  ",-2.980,-2.682, 1.162},
  {"MSE",12, 5, 0.0702, 4," CE ",-1.836,-4.011, 1.529},
  {"MSE",12, 6, 0.0690, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 6, 0.0690, 4," CG ",-1.904,-1.236, 1.182},
  {"MSE",12, 6, 0.0690, 4,"SE  ",-3.060, 0.146, 1.170},
  {"MSE",12, 6, 0.0690, 4," CE ",-4.134,-0.322,-0.186},
  {"MSE",12, 7, 0.0373, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 7, 0.0373, 4," CG ",-1.881,-1.254, 1.200},
  {"MSE",12, 7, 0.0373, 4,"SE  ",-3.073,-2.601, 1.092},
  {"MSE",12, 7, 0.0373, 4," CE ",-3.937,-2.415, 2.650},
  {"MSE",12, 8, 0.0332, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 8, 0.0332, 4," CG ",-1.944,-1.220,-1.134},
  {"MSE",12, 8, 0.0332, 4,"SE  ",-3.098, 0.162,-1.062},
  {"MSE",12, 8, 0.0332, 4," CE ",-3.940,-0.017,-2.633},
  {"MSE",12, 9, 0.0311, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 9, 0.0311, 4," CG ",-1.991,-1.182,-1.090},
  {"MSE",12, 9, 0.0311, 4,"SE  ",-3.156, 0.181,-0.909},
  {"MSE",12, 9, 0.0311, 4," CE ",-2.486, 1.358,-2.081},
  {"MSE",12,10, 0.0253, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12,10, 0.0253, 4," CG ",-0.230,-2.548, 0.076},
  {"MSE",12,10, 0.0253, 4,"SE  ",-1.371,-3.942, 0.034},
  {"MSE",12,10, 0.0253, 4," CE ",-1.808,-3.970,-1.703},
  {"MSE",12,11, 0.0244, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12,11, 0.0244, 4," CG ",-0.229,-2.549, 0.052},
  {"MSE",12,11, 0.0244, 4,"SE  ",-1.373,-3.941, 0.086},
  {"MSE",12,11, 0.0244, 4," CE ",-2.024,-3.805, 1.749},
  {"PHE", 4, 0, 0.4708, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 0, 0.4708, 7," CG ",-1.956,-1.198,-1.072},
  {"PHE", 4, 0, 0.4708, 7," CD1",-3.131,-0.489,-0.893},
  {"PHE", 4, 0, 0.4708, 7," CD2",-1.766,-1.879,-2.263},
  {"PHE", 4, 0, 0.4708, 7," CE1",-4.096,-0.458,-1.880},
  {"PHE", 4, 0, 0.4708, 7," CE2",-2.728,-1.853,-3.253},
  {"PHE", 4, 0, 0.4708, 7," CZ ",-3.895,-1.141,-3.063},
  {"PHE", 4, 1, 0.3171, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 1, 0.3171, 7," CG ",-1.813,-1.306, 1.199},
  {"PHE", 4, 1, 0.3171, 7," CD1",-2.953,-0.524, 1.274},
  {"PHE", 4, 1, 0.3171, 7," CD2",-1.525,-2.163, 2.248},
  {"PHE", 4, 1, 0.3171, 7," CE1",-3.788,-0.595, 2.372},
  {"PHE", 4, 1, 0.3171, 7," CE2",-2.355,-2.237, 3.350},
  {"PHE", 4, 1, 0.3171, 7," CZ ",-3.490,-1.452, 3.412},
  {"PHE", 4, 2, 0.1106, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 2, 0.1106, 7," CG ",-0.174,-2.540, 0.036},
  {"PHE", 4, 2, 0.1106, 7," CD1", 0.201,-3.170,-1.139},
  {"PHE", 4, 2, 0.1106, 7," CD2", 0.143,-3.141, 1.242},
  {"PHE", 4, 2, 0.1106, 7," CE1", 0.876,-4.374,-1.111},
  {"PHE", 4, 2, 0.1106, 7," CE2", 0.817,-4.347, 1.276},
  {"PHE", 4, 2, 0.1106, 7," CZ ", 1.185,-4.965, 0.098},
  {"PHE", 4, 3, 0.0817, 7," CB ",-0.907,-1.229, 0.003},
  {"PHE", 4, 3, 0.0817, 7," CG ",-1.976,-1.184,-1.052},
  {"PHE", 4, 3, 0.0817, 7," CD1",-2.277,-0.000,-1.703},
  {"PHE", 4, 3, 0.0817, 7," CD2",-2.678,-2.328,-1.393},
  {"PHE", 4, 3, 0.0817, 7," CE1",-3.258, 0.042,-2.674},
  {"PHE", 4, 3, 0.0817, 7," CE2",-3.661,-2.291,-2.363},
  {"PHE", 4, 3, 0.0817, 7," CZ ",-3.952,-1.104,-3.006},
  {"PRO", 2, 0, 0.5072, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 2, 0, 0.5072, 3," CG ", 0.081,-2.204,-0.926},
  {"PRO", 2, 0, 0.5072, 3," CD ", 0.755,-1.306,-1.916},
  {"PRO", 2, 1, 0.4928, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 2, 1, 0.4928, 3," CG ",-0.832,-1.606,-1.565},
  {"PRO", 2, 1, 0.4928, 3," CD ",-0.930,-0.272,-2.238},
  {"SER", 3, 0, 0.4707, 2," CB ",-0.941,-1.207, 0.008},
  {"SER", 3, 0, 0.4707, 2," OG ",-0.212,-2.419, 0.096},
  {"SER", 3, 1, 0.2938, 2," CB ",-0.941,-1.207, 0.008},
  {"SER", 3, 1, 0.2938, 2," OG ",-1.863,-1.139,-1.066},
  {"SER", 3, 2, 0.2354, 2," CB ",-0.941,-1.207, 0.008},
  {"SER", 3, 2, 0.2354, 2," OG ",-1.729,-1.229, 1.186},
  {"THR", 3, 0, 0.4886, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 0, 0.4886, 3," OG1",-0.177,-2.423,-0.002},
  {"THR", 3, 0, 0.4886, 3," CG2",-1.731,-1.289,-1.292},
  {"THR", 3, 1, 0.4364, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 1, 0.4364, 3," OG1",-1.810,-1.160,-1.133},
  {"THR", 3, 1, 0.4364, 3," CG2",-1.910,-1.133, 1.182},
  {"THR", 3, 2, 0.0751, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 2, 0.0751, 3," OG1",-1.849,-1.114, 1.115},
  {"THR", 3, 2, 0.0751, 3," CG2",-0.173,-2.491, 0.303},
  {"TRP", 8, 0, 0.3081,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 0, 0.3081,10," CG ",-1.992,-1.157,-1.056},
  {"TRP", 8, 0, 0.3081,10," CD1",-1.984,-1.813,-2.254},
  {"TRP", 8, 0, 0.3081,10," CD2",-3.212,-0.408,-1.020},
  {"TRP", 8, 0, 0.3081,10," NE1",-3.121,-1.516,-2.964},
  {"TRP", 8, 0, 0.3081,10," CE2",-3.893,-0.656,-2.229},
  {"TRP", 8, 0, 0.3081,10," CE3",-3.801, 0.453,-0.088},
  {"TRP", 8, 0, 0.3081,10," CZ2",-5.126,-0.079,-2.526},
  {"TRP", 8, 0, 0.3081,10," CZ3",-5.025, 1.025,-0.385},
  {"TRP", 8, 0, 0.3081,10," CH2",-5.673, 0.756,-1.594},
  {"TRP", 8, 1, 0.1621,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 1, 0.1621,10," CG ",-1.862,-1.242, 1.188},
  {"TRP", 8, 1, 0.1621,10," CD1",-1.767,-2.050, 2.285},
  {"TRP", 8, 1, 0.1621,10," CD2",-3.024,-0.430, 1.390},
  {"TRP", 8, 1, 0.1621,10," NE1",-2.798,-1.792, 3.154},
  {"TRP", 8, 1, 0.1621,10," CE2",-3.584,-0.800, 2.630},
  {"TRP", 8, 1, 0.1621,10," CE3",-3.654, 0.576, 0.648},
  {"TRP", 8, 1, 0.1621,10," CZ2",-4.736,-0.203, 3.140},
  {"TRP", 8, 1, 0.1621,10," CZ3",-4.796, 1.167, 1.157},
  {"TRP", 8, 1, 0.1621,10," CH2",-5.324, 0.775, 2.390},
  {"TRP", 8, 2, 0.1302,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 2, 0.1302,10," CG ",-1.821,-1.274, 1.217},
  {"TRP", 8, 2, 0.1302,10," CD1",-3.018,-0.643, 1.396},
  {"TRP", 8, 2, 0.1302,10," CD2",-1.577,-2.014, 2.420},
  {"TRP", 8, 2, 0.1302,10," NE1",-3.532,-0.942, 2.634},
  {"TRP", 8, 2, 0.1302,10," CE2",-2.667,-1.783, 3.283},
  {"TRP", 8, 2, 0.1302,10," CE3",-0.544,-2.849, 2.859},
  {"TRP", 8, 2, 0.1302,10," CZ2",-2.752,-2.355, 4.551},
  {"TRP", 8, 2, 0.1302,10," CZ3",-0.631,-3.416, 4.117},
  {"TRP", 8, 2, 0.1302,10," CH2",-1.727,-3.166, 4.948},
  {"TRP", 8, 3, 0.1302,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 3, 0.1302,10," CG ",-2.009,-1.143,-1.038},
  {"TRP", 8, 3, 0.1302,10," CD1",-2.256,-0.112,-1.898},
  {"TRP", 8, 3, 0.1302,10," CD2",-2.979,-2.153,-1.337},
  {"TRP", 8, 3, 0.1302,10," NE1",-3.321,-0.417,-2.710},
  {"TRP", 8, 3, 0.1302,10," CE2",-3.783,-1.665,-2.388},
  {"TRP", 8, 3, 0.1302,10," CE3",-3.255,-3.425,-0.822},
  {"TRP", 8, 3, 0.1302,10," CZ2",-4.836,-2.401,-2.929},
  {"TRP", 8, 3, 0.1302,10," CZ3",-4.301,-4.152,-1.362},
  {"TRP", 8, 3, 0.1302,10," CH2",-5.077,-3.638,-2.404},
  {"TRP", 8, 4, 0.0992,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 4, 0.0992,10," CG ",-0.220,-2.524, 0.002},
  {"TRP", 8, 4, 0.0992,10," CD1", 0.167,-3.245,-1.091},
  {"TRP", 8, 4, 0.0992,10," CD2", 0.201,-3.278, 1.145},
  {"TRP", 8, 4, 0.0992,10," NE1", 0.798,-4.400,-0.699},
  {"TRP", 8, 4, 0.0992,10," CE2", 0.834,-4.445, 0.670},
  {"TRP", 8, 4, 0.0992,10," CE3", 0.106,-3.088, 2.528},
  {"TRP", 8, 4, 0.0992,10," CZ2", 1.366,-5.409, 1.523},
  {"TRP", 8, 4, 0.0992,10," CZ3", 0.635,-4.047, 3.373},
  {"TRP", 8, 4, 0.0992,10," CH2", 1.257,-5.192, 2.868},
  {"TRP", 8, 5, 0.0581,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 5, 0.0581,10," CG ",-1.897,-1.215, 1.159},
  {"TRP", 8, 5, 0.0581,10," CD1",-2.233,-0.158, 1.956},
  {"TRP", 8, 5, 0.0581,10," CD2",-2.649,-2.334, 1.645},
  {"TRP", 8, 5, 0.0581,10," NE1",-3.143,-0.550, 2.906},
  {"TRP", 8, 5, 0.0581,10," CE2",-3.417,-1.882, 2.738},
  {"TRP", 8, 5, 0.0581,10," CE3",-2.751,-3.678, 1.269},
  {"TRP", 8, 5, 0.0581,10," CZ2",-4.270,-2.721, 3.452},
  {"TRP", 8, 5, 0.0581,10," CZ3",-3.598,-4.508, 1.980},
  {"TRP", 8, 5, 0.0581,10," CH2",-4.346,-4.027, 3.058},
  {"TRP", 8, 6, 0.0532,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 6, 0.0532,10," CG ",-0.220,-2.524, 0.009},
  {"TRP", 8, 6, 0.0532,10," CD1", 0.193,-3.235, 1.100},
  {"TRP", 8, 6, 0.0532,10," CD2", 0.171,-3.290,-1.137},
  {"TRP", 8, 6, 0.0532,10," NE1", 0.817,-4.392, 0.703},
  {"TRP", 8, 6, 0.0532,10," CE2", 0.817,-4.451,-0.666},
  {"TRP", 8, 6, 0.0532,10," CE3", 0.044,-3.112,-2.519},
  {"TRP", 8, 6, 0.0532,10," CZ2", 1.329,-5.423,-1.523},
  {"TRP", 8, 6, 0.0532,10," CZ3", 0.553,-4.078,-3.367},
  {"TRP", 8, 6, 0.0532,10," CH2", 1.187,-5.218,-2.866},
  {"TRP", 8, 7, 0.0532,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 8, 7, 0.0532,10," CG ",-2.030,-1.126,-1.014},
  {"TRP", 8, 7, 0.0532,10," CD1",-3.285,-0.617,-0.838},
  {"TRP", 8, 7, 0.0532,10," CD2",-1.966,-1.567,-2.376},
  {"TRP", 8, 7, 0.0532,10," NE1",-4.004,-0.715,-2.004},
  {"TRP", 8, 7, 0.0532,10," CE2",-3.218,-1.294,-2.965},
  {"TRP", 8, 7, 0.0532,10," CE3",-0.977,-2.168,-3.162},
  {"TRP", 8, 7, 0.0532,10," CZ2",-3.503,-1.599,-4.294},
  {"TRP", 8, 7, 0.0532,10," CZ3",-1.263,-2.470,-4.481},
  {"TRP", 8, 7, 0.0532,10," CH2",-2.515,-2.185,-5.033},
  {"TYR", 4, 0, 0.4735, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 0, 0.4735, 8," CG ",-1.983,-1.178,-1.087},
  {"TYR", 4, 0, 0.4735, 8," CD1",-3.154,-0.444,-0.938},
  {"TYR", 4, 0, 0.4735, 8," CD2",-1.797,-1.885,-2.266},
  {"TYR", 4, 0, 0.4735, 8," CE1",-4.110,-0.416,-1.935},
  {"TYR", 4, 0, 0.4735, 8," CE2",-2.749,-1.863,-3.269},
  {"TYR", 4, 0, 0.4735, 8," CZ ",-3.901,-1.126,-3.099},
  {"TYR", 4, 0, 0.4735, 8," OH ",-4.852,-1.102,-4.093},
  {"TYR", 4, 1, 0.3248, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 1, 0.3248, 8," CG ",-1.838,-1.275, 1.223},
  {"TYR", 4, 1, 0.3248, 8," CD1",-2.963,-0.466, 1.326},
  {"TYR", 4, 1, 0.3248, 8," CD2",-1.561,-2.149, 2.265},
  {"TYR", 4, 1, 0.3248, 8," CE1",-3.786,-0.525, 2.434},
  {"TYR", 4, 1, 0.3248, 8," CE2",-2.380,-2.215, 3.378},
  {"TYR", 4, 1, 0.3248, 8," CZ ",-3.490,-1.403, 3.456},
  {"TYR", 4, 1, 0.3248, 8," OH ",-4.307,-1.463, 4.562},
  {"TYR", 4, 2, 0.1159, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 2, 0.1159, 8," CG ",-0.227,-2.539, 0.059},
  {"TYR", 4, 2, 0.1159, 8," CD1", 0.141,-3.196,-1.108},
  {"TYR", 4, 2, 0.1159, 8," CD2", 0.076,-3.138, 1.274},
  {"TYR", 4, 2, 0.1159, 8," CE1", 0.792,-4.414,-1.066},
  {"TYR", 4, 2, 0.1159, 8," CE2", 0.727,-4.358, 1.325},
  {"TYR", 4, 2, 0.1159, 8," CZ ", 1.083,-4.989, 0.153},
  {"TYR", 4, 2, 0.1159, 8," OH ", 1.730,-6.203, 0.198},
  {"TYR", 4, 3, 0.0653, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 3, 0.0653, 8," CG ",-2.004,-1.162,-1.066},
  {"TYR", 4, 3, 0.0653, 8," CD1",-2.304, 0.025,-1.724},
  {"TYR", 4, 3, 0.0653, 8," CD2",-2.707,-2.305,-1.420},
  {"TYR", 4, 3, 0.0653, 8," CE1",-3.276, 0.070,-2.705},
  {"TYR", 4, 3, 0.0653, 8," CE2",-3.681,-2.268,-2.401},
  {"TYR", 4, 3, 0.0653, 8," CZ ",-3.960,-1.080,-3.040},
  {"TYR", 4, 3, 0.0653, 8," OH ",-4.929,-1.037,-4.016},
  {"VAL", 3, 0, 0.7390, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 0, 0.7390, 3," CG1",-1.718,-1.247, 1.347},
  {"VAL", 3, 0, 0.7390, 3," CG2",-1.895,-1.189,-1.149},
  {"VAL", 3, 1, 0.1870, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 1, 0.1870, 3," CG1",-1.904,-1.181,-1.141},
  {"VAL", 3, 1, 0.1870, 3," CG2",-0.147,-2.510, 0.049},
  {"VAL", 3, 2, 0.0740, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 2, 0.0740, 3," CG1",-0.149,-2.505, 0.153},
  {"VAL", 3, 2, 0.0740, 3," CG2",-1.933,-1.086, 1.188}};
int rotamer_data_dunbrack_size = sizeof( rotamer_data_dunbrack ) / sizeof( rotamer_data_dunbrack[0] );


Rotamer_data rotamer_data_richardson[] = {
  {"ALA", 1, 0, 1.0000, 1," CB ",-0.940,-1.196, 0.000},
  {"ARG",19, 0, 0.1157, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 0, 0.1157, 7," CG ",-2.007,-1.170,-1.074},
  {"ARG",19, 0, 0.1157, 7," CD ",-2.970,-2.346,-1.037},
  {"ARG",19, 0, 0.1157, 7," NE ",-3.931,-2.301,-2.135},
  {"ARG",19, 0, 0.1157, 7," CZ ",-4.804,-3.262,-2.400},
  {"ARG",19, 0, 0.1157, 7," NH1",-4.845,-4.351,-1.643},
  {"ARG",19, 0, 0.1157, 7," NH2",-5.642,-3.137,-3.421},
  {"ARG",19, 1, 0.0702, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 1, 0.0702, 7," CG ",-2.036,-1.147,-1.043},
  {"ARG",19, 1, 0.0702, 7," CD ",-3.144,-2.169,-0.844},
  {"ARG",19, 1, 0.0702, 7," NE ",-2.651,-3.539,-0.951},
  {"ARG",19, 1, 0.0702, 7," CZ ",-2.531,-4.201,-2.093},
  {"ARG",19, 1, 0.0702, 7," NH1",-2.866,-3.619,-3.238},
  {"ARG",19, 1, 0.0702, 7," NH2",-2.074,-5.446,-2.097},
  {"ARG",19, 2, 0.0689, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 2, 0.0689, 7," CG ",-1.992,-1.182,-1.089},
  {"ARG",19, 2, 0.0689, 7," CD ",-2.970,-2.345,-1.038},
  {"ARG",19, 2, 0.0689, 7," NE ",-3.945,-2.288,-2.123},
  {"ARG",19, 2, 0.0689, 7," CZ ",-5.052,-1.559,-2.092},
  {"ARG",19, 2, 0.0689, 7," NH1",-5.330,-0.815,-1.029},
  {"ARG",19, 2, 0.0689, 7," NH2",-5.884,-1.568,-3.126},
  {"ARG",19, 3, 0.0624, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 3, 0.0624, 7," CG ",-2.022,-1.158,-1.058},
  {"ARG",19, 3, 0.0624, 7," CD ",-2.849,-2.430,-1.163},
  {"ARG",19, 3, 0.0624, 7," NE ",-2.044,-3.574,-1.580},
  {"ARG",19, 3, 0.0624, 7," CZ ",-2.522,-4.799,-1.748},
  {"ARG",19, 3, 0.0624, 7," NH1",-3.809,-5.046,-1.538},
  {"ARG",19, 3, 0.0624, 7," NH2",-1.716,-5.781,-2.129},
  {"ARG",19, 4, 0.0585, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 4, 0.0585, 7," CG ",-1.977,-1.194,-1.103},
  {"ARG",19, 4, 0.0585, 7," CD ",-2.848,-2.439,-1.156},
  {"ARG",19, 4, 0.0585, 7," NE ",-3.668,-2.584, 0.043},
  {"ARG",19, 4, 0.0585, 7," CZ ",-4.429,-3.638, 0.302},
  {"ARG",19, 4, 0.0585, 7," NH1",-4.476,-4.651,-0.554},
  {"ARG",19, 4, 0.0585, 7," NH2",-5.143,-3.685, 1.419},
  {"ARG",19, 5, 0.0442, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 5, 0.0442, 7," CG ",-1.853,-1.275, 1.220},
  {"ARG",19, 5, 0.0442, 7," CD ",-2.836,-2.435, 1.193},
  {"ARG",19, 5, 0.0442, 7," NE ",-2.160,-3.727, 1.258},
  {"ARG",19, 5, 0.0442, 7," CZ ",-1.755,-4.301, 2.381},
  {"ARG",19, 5, 0.0442, 7," NH1",-1.959,-3.700, 3.547},
  {"ARG",19, 5, 0.0442, 7," NH2",-1.147,-5.480, 2.346},
  {"ARG",19, 6, 0.0429, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 6, 0.0429, 7," CG ",-1.853,-1.275, 1.220},
  {"ARG",19, 6, 0.0429, 7," CD ",-2.836,-2.435, 1.193},
  {"ARG",19, 6, 0.0429, 7," NE ",-3.706,-2.443, 2.366},
  {"ARG",19, 6, 0.0429, 7," CZ ",-4.768,-3.224, 2.500},
  {"ARG",19, 6, 0.0429, 7," NH1",-5.097,-4.072, 1.533},
  {"ARG",19, 6, 0.0429, 7," NH2",-5.504,-3.164, 3.602},
  {"ARG",19, 7, 0.0429, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 7, 0.0429, 7," CG ",-2.007,-1.170,-1.074},
  {"ARG",19, 7, 0.0429, 7," CD ",-2.910,-2.393,-1.098},
  {"ARG",19, 7, 0.0429, 7," NE ",-3.932,-2.299,-2.136},
  {"ARG",19, 7, 0.0429, 7," CZ ",-3.733,-2.614,-3.407},
  {"ARG",19, 7, 0.0429, 7," NH1",-2.546,-3.052,-3.807},
  {"ARG",19, 7, 0.0429, 7," NH2",-4.721,-2.497,-4.285},
  {"ARG",19, 8, 0.0364, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 8, 0.0364, 7," CG ",-1.870,-1.262, 1.208},
  {"ARG",19, 8, 0.0364, 7," CD ",-2.770,-2.487, 1.241},
  {"ARG",19, 8, 0.0364, 7," NE ",-2.008,-3.723, 1.398},
  {"ARG",19, 8, 0.0364, 7," CZ ",-2.481,-4.929, 1.121},
  {"ARG",19, 8, 0.0364, 7," NH1",-3.719,-5.071, 0.665},
  {"ARG",19, 8, 0.0364, 7," NH2",-1.716,-6.000, 1.295},
  {"ARG",19, 9, 0.0338, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19, 9, 0.0338, 7," CG ",-1.853,-1.275, 1.220},
  {"ARG",19, 9, 0.0338, 7," CD ",-2.803,-2.462, 1.216},
  {"ARG",19, 9, 0.0338, 7," NE ",-3.659,-2.482, 2.399},
  {"ARG",19, 9, 0.0338, 7," CZ ",-3.316,-3.027, 3.557},
  {"ARG",19, 9, 0.0338, 7," NH1",-2.127,-3.599, 3.698},
  {"ARG",19, 9, 0.0338, 7," NH2",-4.159,-3.001, 4.581},
  {"ARG",19,10, 0.0325, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,10, 0.0325, 7," CG ",-1.919,-1.224, 1.170},
  {"ARG",19,10, 0.0325, 7," CD ",-2.820,-2.448, 1.205},
  {"ARG",19,10, 0.0325, 7," NE ",-3.719,-2.500, 0.056},
  {"ARG",19,10, 0.0325, 7," CZ ",-4.879,-1.863,-0.011},
  {"ARG",19,10, 0.0325, 7," NH1",-5.288,-1.116, 1.006},
  {"ARG",19,10, 0.0325, 7," NH2",-5.634,-1.968,-1.097},
  {"ARG",19,11, 0.0286, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,11, 0.0286, 7," CG ",-1.785,-1.328, 1.265},
  {"ARG",19,11, 0.0286, 7," CD ",-2.765,-0.182, 1.465},
  {"ARG",19,11, 0.0286, 7," NE ",-3.553,-0.342, 2.683},
  {"ARG",19,11, 0.0286, 7," CZ ",-3.160, 0.061, 3.883},
  {"ARG",19,11, 0.0286, 7," NH1",-1.984, 0.656, 4.033},
  {"ARG",19,11, 0.0286, 7," NH2",-3.943,-0.127, 4.938},
  {"ARG",19,12, 0.0286, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,12, 0.0286, 7," CG ",-1.820,-1.301, 1.243},
  {"ARG",19,12, 0.0286, 7," CD ",-2.737,-0.105, 1.443},
  {"ARG",19,12, 0.0286, 7," NE ",-3.594,-0.262, 2.615},
  {"ARG",19,12, 0.0286, 7," CZ ",-4.241, 0.733, 3.203},
  {"ARG",19,12, 0.0286, 7," NH1",-4.136, 1.968, 2.729},
  {"ARG",19,12, 0.0286, 7," NH2",-5.000, 0.498, 4.266},
  {"ARG",19,13, 0.0286, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,13, 0.0286, 7," CG ",-1.919,-1.224, 1.170},
  {"ARG",19,13, 0.0286, 7," CD ",-2.915,-2.372, 1.126},
  {"ARG",19,13, 0.0286, 7," NE ",-3.818,-2.358, 2.273},
  {"ARG",19,13, 0.0286, 7," CZ ",-4.913,-1.617, 2.350},
  {"ARG",19,13, 0.0286, 7," NH1",-5.253,-0.824, 1.341},
  {"ARG",19,13, 0.0286, 7," NH2",-5.677,-1.667, 3.434},
  {"ARG",19,14, 0.0260, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,14, 0.0260, 7," CG ",-0.227,-2.546, 0.116},
  {"ARG",19,14, 0.0260, 7," CD ",-1.150,-3.751, 0.027},
  {"ARG",19,14, 0.0260, 7," NE ",-0.427,-5.009, 0.184},
  {"ARG",19,14, 0.0260, 7," CZ ", 0.215,-5.626,-0.797},
  {"ARG",19,14, 0.0260, 7," NH1", 0.232,-5.100,-2.016},
  {"ARG",19,14, 0.0260, 7," NH2", 0.847,-6.769,-0.565},
  {"ARG",19,15, 0.0247, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,15, 0.0247, 7," CG ",-2.036,-1.147,-1.043},
  {"ARG",19,15, 0.0247, 7," CD ",-2.926,-2.379,-1.084},
  {"ARG",19,15, 0.0247, 7," NE ",-3.680,-2.552, 0.154},
  {"ARG",19,15, 0.0247, 7," CZ ",-4.828,-1.946, 0.417},
  {"ARG",19,15, 0.0247, 7," NH1",-5.367,-1.123,-0.475},
  {"ARG",19,15, 0.0247, 7," NH2",-5.447,-2.162, 1.571},
  {"ARG",19,16, 0.0234, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,16, 0.0234, 7," CG ",-0.225,-2.549,-0.053},
  {"ARG",19,16, 0.0234, 7," CD ",-1.151,-3.750, 0.051},
  {"ARG",19,16, 0.0234, 7," NE ",-0.415,-5.011, 0.035},
  {"ARG",19,16, 0.0234, 7," CZ ",-0.986,-6.207, 0.055},
  {"ARG",19,16, 0.0234, 7," NH1",-2.308,-6.313, 0.088},
  {"ARG",19,16, 0.0234, 7," NH2",-0.238,-7.303, 0.039},
  {"ARG",19,17, 0.0208, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,17, 0.0208, 7," CG ",-2.022,-1.158,-1.058},
  {"ARG",19,17, 0.0208, 7," CD ",-2.970,-2.347,-1.036},
  {"ARG",19,17, 0.0208, 7," NE ",-2.289,-3.597,-1.361},
  {"ARG",19,17, 0.0208, 7," CZ ",-1.940,-4.509,-0.465},
  {"ARG",19,17, 0.0208, 7," NH1",-2.210,-4.317, 0.820},
  {"ARG",19,17, 0.0208, 7," NH2",-1.322,-5.618,-0.850},
  {"ARG",19,18, 0.0208, 7," CB ",-0.939,-1.208, 0.007},
  {"ARG",19,18, 0.0208, 7," CG ",-0.225,-2.547, 0.092},
  {"ARG",19,18, 0.0208, 7," CD ",-1.155,-3.750, 0.051},
  {"ARG",19,18, 0.0208, 7," NE ",-0.425,-5.010, 0.159},
  {"ARG",19,18, 0.0208, 7," CZ ",-0.117,-5.596, 1.306},
  {"ARG",19,18, 0.0208, 7," NH1",-0.477,-5.040, 2.456},
  {"ARG",19,18, 0.0208, 7," NH2", 0.551,-6.743, 1.310},
  {"ASN", 7, 0, 0.4154, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 0, 0.4154, 4," CG ",-2.069,-1.060,-1.010},
  {"ASN", 7, 0, 0.4154, 4," OD1",-2.411, 0.046,-1.427},
  {"ASN", 7, 0, 0.4154, 4," ND2",-2.643,-2.187,-1.414},
  {"ASN", 7, 1, 0.1633, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 1, 0.1633, 4," CG ",-2.012,-1.092, 1.086},
  {"ASN", 7, 1, 0.1633, 4," OD1",-2.435, 0.004, 1.451},
  {"ASN", 7, 1, 0.1633, 4," ND2",-2.446,-2.236, 1.602},
  {"ASN", 7, 2, 0.1267, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 2, 0.1267, 4," CG ",-1.920,-1.165, 1.173},
  {"ASN", 7, 2, 0.1267, 4," OD1",-1.682,-0.488, 2.173},
  {"ASN", 7, 2, 0.1267, 4," ND2",-3.019,-1.900, 1.051},
  {"ASN", 7, 3, 0.0945, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 3, 0.0945, 4," CG ",-0.220,-2.524, 0.052},
  {"ASN", 7, 3, 0.0945, 4," OD1", 0.840,-2.640, 0.667},
  {"ASN", 7, 3, 0.0945, 4," ND2",-0.783,-3.533,-0.602},
  {"ASN", 7, 4, 0.0845, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 4, 0.0845, 4," CG ",-2.069,-1.060,-1.010},
  {"ASN", 7, 4, 0.0845, 4," OD1",-3.022,-0.310,-0.804},
  {"ASN", 7, 4, 0.0845, 4," ND2",-1.956,-1.787,-2.115},
  {"ASN", 7, 5, 0.0737, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 5, 0.0737, 4," CG ",-0.219,-2.524, 0.027},
  {"ASN", 7, 5, 0.0737, 4," OD1", 0.989,-2.583,-0.201},
  {"ASN", 7, 5, 0.0737, 4," ND2",-0.949,-3.599, 0.302},
  {"ASN", 7, 6, 0.0415, 4," CB ",-0.952,-1.197, 0.006},
  {"ASN", 7, 6, 0.0415, 4," CG ",-1.966,-1.142,-1.119},
  {"ASN", 7, 6, 0.0415, 4," OD1",-2.175,-2.125,-1.830},
  {"ASN", 7, 6, 0.0415, 4," ND2",-2.603, 0.011,-1.286},
  {"ASP", 5, 0, 0.5330, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 5, 0, 0.5330, 4," CG ",-2.047,-1.090,-1.022},
  {"ASP", 5, 0, 0.5330, 4," OD1",-2.264, 0.026,-1.538},
  {"ASP", 5, 0, 0.5330, 4," OD2",-2.752,-2.059,-1.376},
  {"ASP", 5, 1, 0.2146, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 5, 1, 0.2146, 4," CG ",-1.885,-1.202, 1.191},
  {"ASP", 5, 1, 0.2146, 4," OD1",-1.825,-0.250, 1.997},
  {"ASP", 5, 1, 0.2146, 4," OD2",-2.722,-2.106, 1.397},
  {"ASP", 5, 2, 0.0994, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 5, 2, 0.0994, 4," CG ",-0.191,-2.526,-0.005},
  {"ASP", 5, 2, 0.0994, 4," OD1", 1.054,-2.504,-0.095},
  {"ASP", 5, 2, 0.0994, 4," OD2",-0.764,-3.634, 0.072},
  {"ASP", 5, 3, 0.0950, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 5, 3, 0.0950, 4," CG ",-0.192,-2.524, 0.093},
  {"ASP", 5, 3, 0.0950, 4," OD1", 1.035,-2.499, 0.318},
  {"ASP", 5, 3, 0.0950, 4," OD2",-0.750,-3.633,-0.051},
  {"ASP", 5, 4, 0.0578, 4," CB ",-0.939,-1.208, 0.006},
  {"ASP", 5, 4, 0.0578, 4," CG ",-1.835,-1.240, 1.229},
  {"ASP", 5, 4, 0.0578, 4," OD1",-2.678,-0.331, 1.373},
  {"ASP", 5, 4, 0.0578, 4," OD2",-1.768,-2.136, 2.098},
  {"CYS", 3, 0, 0.5071, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 0, 0.5071, 2," SG ",-2.178,-1.197,-1.309},
  {"CYS", 3, 1, 0.2642, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 1, 0.2642, 2," SG ",-2.069,-1.265, 1.417},
  {"CYS", 3, 2, 0.2285, 2," CB ",-0.940,-1.207, 0.007},
  {"CYS", 3, 2, 0.2285, 2," SG ",-0.110,-2.801,-0.180},
  {"GLN", 7, 0, 0.3994, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 0, 0.3994, 5," CG ",-2.009,-1.169,-1.073},
  {"GLN", 7, 0, 0.3994, 5," CD ",-2.874,-2.412,-1.082},
  {"GLN", 7, 0, 0.3994, 5," OE1",-2.446,-3.477,-0.636},
  {"GLN", 7, 0, 0.3994, 5," NE2",-4.096,-2.281,-1.590},
  {"GLN", 7, 1, 0.1839, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 1, 0.1839, 5," CG ",-1.936,-1.214, 1.154},
  {"GLN", 7, 1, 0.1839, 5," CD ",-2.956,-2.327, 1.036},
  {"GLN", 7, 1, 0.1839, 5," OE1",-2.981,-3.051, 0.040},
  {"GLN", 7, 1, 0.1839, 5," NE2",-3.801,-2.468, 2.053},
  {"GLN", 7, 2, 0.1668, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 2, 0.1668, 5," CG ",-1.994,-1.181,-1.088},
  {"GLN", 7, 2, 0.1668, 5," CD ",-2.899, 0.030,-0.998},
  {"GLN", 7, 2, 0.1668, 5," OE1",-3.293, 0.439, 0.095},
  {"GLN", 7, 2, 0.1668, 5," NE2",-3.232, 0.608,-2.148},
  {"GLN", 7, 3, 0.1024, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 3, 0.1024, 5," CG ",-1.920,-1.226, 1.167},
  {"GLN", 7, 3, 0.1024, 5," CD ",-2.891,-0.065, 1.131},
  {"GLN", 7, 3, 0.1024, 5," OE1",-3.648, 0.090, 0.172},
  {"GLN", 7, 3, 0.1024, 5," NE2",-2.875, 0.755, 2.178},
  {"GLN", 7, 4, 0.0486, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 4, 0.0486, 5," CG ",-0.229,-2.549, 0.065},
  {"GLN", 7, 4, 0.0486, 5," CD ",-1.190,-3.719, 0.070},
  {"GLN", 7, 4, 0.0486, 5," OE1",-2.347,-3.583,-0.331},
  {"GLN", 7, 4, 0.0486, 5," NE2",-0.715,-4.875, 0.523},
  {"GLN", 7, 5, 0.0315, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 5, 0.0315, 5," CG ",-1.978,-1.193,-1.103},
  {"GLN", 7, 5, 0.0315, 5," CD ",-1.454,-1.770,-2.401},
  {"GLN", 7, 5, 0.0315, 5," OE1",-0.299,-2.189,-2.480},
  {"GLN", 7, 5, 0.0315, 5," NE2",-2.303,-1.796,-3.424},
  {"GLN", 7, 6, 0.0289, 5," CB ",-0.940,-1.207, 0.006},
  {"GLN", 7, 6, 0.0289, 5," CG ",-1.978,-1.193,-1.103},
  {"GLN", 7, 6, 0.0289, 5," CD ",-2.960,-0.048,-0.969},
  {"GLN", 7, 6, 0.0289, 5," OE1",-2.828, 0.974,-1.644},
  {"GLN", 7, 6, 0.0289, 5," NE2",-3.951,-0.214,-0.098},
  {"GLU", 7, 0, 0.3614, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 0, 0.3614, 5," CG ",-2.008,-1.170,-1.075},
  {"GLU", 7, 0, 0.3614, 5," CD ",-2.872,-2.417,-1.082},
  {"GLU", 7, 0, 0.3614, 5," OE1",-2.524,-3.387,-0.377},
  {"GLU", 7, 0, 0.3614, 5," OE2",-3.898,-2.427,-1.794},
  {"GLU", 7, 1, 0.2613, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 1, 0.2613, 5," CG ",-1.887,-1.252, 1.195},
  {"GLU", 7, 1, 0.2613, 5," CD ",-2.833,-2.436, 1.140},
  {"GLU", 7, 1, 0.2613, 5," OE1",-2.723,-3.244, 0.194},
  {"GLU", 7, 1, 0.2613, 5," OE2",-3.689,-2.558, 2.042},
  {"GLU", 7, 2, 0.1471, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 2, 0.1471, 5," CG ",-1.978,-1.194,-1.104},
  {"GLU", 7, 2, 0.1471, 5," CD ",-2.853, 0.045,-1.065},
  {"GLU", 7, 2, 0.1471, 5," OE1",-3.232, 0.472, 0.045},
  {"GLU", 7, 2, 0.1471, 5," OE2",-3.163, 0.589,-2.146},
  {"GLU", 7, 3, 0.0679, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 3, 0.0679, 5," CG ",-1.887,-1.252, 1.195},
  {"GLU", 7, 3, 0.0679, 5," CD ",-2.875,-0.100, 1.192},
  {"GLU", 7, 3, 0.0679, 5," OE1",-2.988, 0.586, 0.155},
  {"GLU", 7, 3, 0.0679, 5," OE2",-3.535, 0.121, 2.229},
  {"GLU", 7, 4, 0.0657, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 4, 0.0657, 5," CG ",-1.978,-1.194,-1.104},
  {"GLU", 7, 4, 0.0657, 5," CD ",-1.447,-1.772,-2.403},
  {"GLU", 7, 4, 0.0657, 5," OE1",-0.253,-2.131,-2.451},
  {"GLU", 7, 4, 0.0657, 5," OE2",-2.226,-1.865,-3.375},
  {"GLU", 7, 5, 0.0597, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 5, 0.0597, 5," CG ",-0.225,-2.550, 0.041},
  {"GLU", 7, 5, 0.0597, 5," CD ",-1.182,-3.721,-0.075},
  {"GLU", 7, 5, 0.0597, 5," OE1",-2.393,-3.526, 0.157},
  {"GLU", 7, 5, 0.0597, 5," OE2",-0.722,-4.837,-0.397},
  {"GLU", 7, 6, 0.0238, 5," CB ",-0.939,-1.208, 0.006},
  {"GLU", 7, 6, 0.0238, 5," CG ",-0.238,-2.538, 0.234},
  {"GLU", 7, 6, 0.0238, 5," CD ", 0.437,-3.061,-1.020},
  {"GLU", 7, 6, 0.0238, 5," OE1", 0.439,-2.342,-2.040},
  {"GLU", 7, 6, 0.0238, 5," OE2", 0.963,-4.194,-0.985},
  {"HIS", 8, 0, 0.3096, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 0, 0.3096, 6," CG ",-1.882,-1.247,-1.154},
  {"HIS", 8, 0, 0.3096, 6," ND1",-2.913,-0.344,-1.309},
  {"HIS", 8, 0, 0.3096, 6," CD2",-1.949,-2.080,-2.219},
  {"HIS", 8, 0, 0.3096, 6," CE1",-3.575,-0.621,-2.418},
  {"HIS", 8, 0, 0.3096, 6," NE2",-3.012,-1.669,-2.990},
  {"HIS", 8, 1, 0.1672, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 1, 0.1672, 6," CG ",-1.853,-1.255, 1.191},
  {"HIS", 8, 1, 0.1672, 6," ND1",-2.788,-0.275, 1.452},
  {"HIS", 8, 1, 0.1672, 6," CD2",-1.977,-2.165, 2.186},
  {"HIS", 8, 1, 0.1672, 6," CE1",-3.446,-0.580, 2.556},
  {"HIS", 8, 1, 0.1672, 6," NE2",-2.975,-1.721, 3.022},
  {"HIS", 8, 2, 0.1387, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 2, 0.1387, 6," CG ",-1.974,-1.174,-1.073},
  {"HIS", 8, 2, 0.1387, 6," ND1",-1.721,-1.598,-2.361},
  {"HIS", 8, 2, 0.1387, 6," CD2",-3.266,-0.770,-1.058},
  {"HIS", 8, 2, 0.1387, 6," CE1",-2.812,-1.454,-3.092},
  {"HIS", 8, 2, 0.1387, 6," NE2",-3.765,-0.954,-2.327},
  {"HIS", 8, 3, 0.1138, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 3, 0.1138, 6," CG ",-1.932,-1.194, 1.127},
  {"HIS", 8, 3, 0.1138, 6," ND1",-1.618,-1.602, 2.407},
  {"HIS", 8, 3, 0.1138, 6," CD2",-3.233,-0.820, 1.161},
  {"HIS", 8, 3, 0.1138, 6," CE1",-2.683,-1.481, 3.179},
  {"HIS", 8, 3, 0.1138, 6," NE2",-3.677,-1.009, 2.449},
  {"HIS", 8, 4, 0.0907, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 4, 0.0907, 6," CG ",-0.232,-2.525,-0.030},
  {"HIS", 8, 4, 0.0907, 6," ND1", 0.356,-3.023,-1.173},
  {"HIS", 8, 4, 0.0907, 6," CD2",-0.016,-3.448, 0.936},
  {"HIS", 8, 4, 0.0907, 6," CE1", 0.901,-4.197,-0.910},
  {"HIS", 8, 4, 0.0907, 6," NE2", 0.691,-4.479, 0.363},
  {"HIS", 8, 5, 0.0782, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 5, 0.0782, 6," CG ",-1.929,-1.210,-1.115},
  {"HIS", 8, 5, 0.0782, 6," ND1",-2.653,-2.330,-1.468},
  {"HIS", 8, 5, 0.0782, 6," CD2",-2.317,-0.230,-1.964},
  {"HIS", 8, 5, 0.0782, 6," CE1",-3.442,-2.039,-2.486},
  {"HIS", 8, 5, 0.0782, 6," NE2",-3.259,-0.772,-2.808},
  {"HIS", 8, 6, 0.0551, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 6, 0.0551, 6," CG ",-1.853,-1.255, 1.191},
  {"HIS", 8, 6, 0.0551, 6," ND1",-2.523,-2.400, 1.571},
  {"HIS", 8, 6, 0.0551, 6," CD2",-2.208,-0.300, 2.083},
  {"HIS", 8, 6, 0.0551, 6," CE1",-3.251,-2.146, 2.643},
  {"HIS", 8, 6, 0.0551, 6," NE2",-3.079,-0.881, 2.976},
  {"HIS", 8, 7, 0.0462, 6," CB ",-0.940,-1.207, 0.007},
  {"HIS", 8, 7, 0.0462, 6," CG ",-0.232,-2.525,-0.006},
  {"HIS", 8, 7, 0.0462, 6," ND1", 0.347,-3.071, 1.121},
  {"HIS", 8, 7, 0.0462, 6," CD2",-0.010,-3.408,-1.007},
  {"HIS", 8, 7, 0.0462, 6," CE1", 0.896,-4.232, 0.812},
  {"HIS", 8, 7, 0.0462, 6," NE2", 0.694,-4.461,-0.472},
  {"ILE", 5, 0, 0.6043, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 0, 0.6043, 4," CG1",-1.969,-1.104,-1.124},
  {"ILE", 5, 0, 0.6043, 4," CG2",-1.645,-1.338, 1.354},
  {"ILE", 5, 0, 0.6043, 4," CD1",-2.764,-2.369,-1.355},
  {"ILE", 5, 1, 0.1472, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 1, 0.1472, 4," CG1",-1.821,-1.220,-1.247},
  {"ILE", 5, 1, 0.1472, 4," CG2",-1.806,-1.213, 1.263},
  {"ILE", 5, 1, 0.1472, 4," CD1",-2.673, 0.019,-1.400},
  {"ILE", 5, 2, 0.1314, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 2, 0.1314, 4," CG1",-0.142,-2.518,-0.005},
  {"ILE", 5, 2, 0.1314, 4," CG2",-1.897,-1.160,-1.177},
  {"ILE", 5, 2, 0.1314, 4," CD1",-0.981,-3.755, 0.219},
  {"ILE", 5, 3, 0.0772, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 3, 0.0772, 4," CG1",-1.908,-1.135, 1.195},
  {"ILE", 5, 3, 0.0772, 4," CG2",-0.149,-2.511, 0.050},
  {"ILE", 5, 3, 0.0772, 4," CD1",-3.063,-2.108, 1.112},
  {"ILE", 5, 4, 0.0219, 4," CB ",-0.946,-1.216, 0.008},
  {"ILE", 5, 4, 0.0219, 4," CG1",-1.987,-1.074, 1.120},
  {"ILE", 5, 4, 0.0219, 4," CG2",-0.156,-2.505, 0.174},
  {"ILE", 5, 4, 0.0219, 4," CD1",-2.950, 0.073, 0.911},
  {"LEU", 4, 0, 0.6367, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 0, 0.6367, 4," CG ",-2.007,-1.243,-1.090},
  {"LEU", 4, 0, 0.6367, 4," CD1",-2.769,-2.559,-1.055},
  {"LEU", 4, 0, 0.6367, 4," CD2",-2.957,-0.064,-0.955},
  {"LEU", 4, 1, 0.3085, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 1, 0.3085, 4," CG ",-1.815,-1.377, 1.252},
  {"LEU", 4, 1, 0.3085, 4," CD1",-2.768,-0.201, 1.401},
  {"LEU", 4, 1, 0.3085, 4," CD2",-2.581,-2.690, 1.197},
  {"LEU", 4, 2, 0.0259, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 2, 0.0259, 4," CG ",-1.994,-1.239, 1.117},
  {"LEU", 4, 2, 0.0259, 4," CD1",-3.270,-1.907, 0.626},
  {"LEU", 4, 2, 0.0259, 4," CD2",-1.456,-1.944, 2.352},
  {"LEU", 4, 3, 0.0201, 4," CB ",-0.940,-1.208, 0.007},
  {"LEU", 4, 3, 0.0201, 4," CG ",-2.264,-1.041,-0.743},
  {"LEU", 4, 3, 0.0201, 4," CD1",-2.017,-0.885,-2.236},
  {"LEU", 4, 3, 0.0201, 4," CD2",-3.190,-2.215,-0.468},
  {"LYS",13, 0, 0.2479, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 0, 0.2479, 5," CG ",-2.006,-1.172,-1.074},
  {"LYS",13, 0, 0.2479, 5," CD ",-2.885,-2.410,-1.025},
  {"LYS",13, 0, 0.2479, 5," CE ",-3.968,-2.363,-2.090},
  {"LYS",13, 0, 0.2479, 5," NZ ",-4.822,-3.582,-2.068},
  {"LYS",13, 1, 0.1646, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 1, 0.1646, 5," CG ",-1.887,-1.251, 1.195},
  {"LYS",13, 1, 0.1646, 5," CD ",-2.820,-2.447, 1.114},
  {"LYS",13, 1, 0.1646, 5," CE ",-3.752,-2.503, 2.313},
  {"LYS",13, 1, 0.1646, 5," NZ ",-4.673,-3.671, 2.247},
  {"LYS",13, 2, 0.0782, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 2, 0.0782, 5," CG ",-1.913,-1.245,-1.159},
  {"LYS",13, 2, 0.0782, 5," CD ",-2.874,-0.069,-1.114},
  {"LYS",13, 2, 0.0782, 5," CE ",-3.895,-0.145,-2.237},
  {"LYS",13, 2, 0.0782, 5," NZ ",-4.828, 1.014,-2.220},
  {"LYS",13, 3, 0.0569, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 3, 0.0569, 5," CG ",-1.976,-1.196,-1.104},
  {"LYS",13, 3, 0.0569, 5," CD ",-2.872,-2.421,-1.037},
  {"LYS",13, 3, 0.0569, 5," CE ",-3.878,-2.434,-2.176},
  {"LYS",13, 3, 0.0569, 5," NZ ",-4.810,-1.275,-2.108},
  {"LYS",13, 4, 0.0497, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 4, 0.0497, 5," CG ",-1.887,-1.251, 1.195},
  {"LYS",13, 4, 0.0497, 5," CD ",-2.613,-2.583, 1.275},
  {"LYS",13, 4, 0.0497, 5," CE ",-3.615,-2.599, 2.418},
  {"LYS",13, 4, 0.0497, 5," NZ ",-4.766,-1.692, 2.161},
  {"LYS",13, 5, 0.0426, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 5, 0.0426, 5," CG ",-2.006,-1.172,-1.074},
  {"LYS",13, 5, 0.0426, 5," CD ",-2.960,-2.348,-0.949},
  {"LYS",13, 5, 0.0426, 5," CE ",-4.098,-2.247,-1.951},
  {"LYS",13, 5, 0.0426, 5," NZ ",-3.634,-2.492,-3.344},
  {"LYS",13, 6, 0.0406, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 6, 0.0406, 5," CG ",-2.036,-1.149,-1.043},
  {"LYS",13, 6, 0.0406, 5," CD ",-2.837,-2.439,-1.079},
  {"LYS",13, 6, 0.0406, 5," CE ",-3.598,-2.654, 0.219},
  {"LYS",13, 6, 0.0406, 5," NZ ",-4.481,-3.851, 0.154},
  {"LYS",13, 7, 0.0386, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 7, 0.0386, 5," CG ",-1.820,-1.303, 1.243},
  {"LYS",13, 7, 0.0386, 5," CD ",-2.745,-0.103, 1.355},
  {"LYS",13, 7, 0.0386, 5," CE ",-3.742,-0.277, 2.489},
  {"LYS",13, 7, 0.0386, 5," NZ ",-4.510, 0.971, 2.750},
  {"LYS",13, 8, 0.0376, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 8, 0.0376, 5," CG ",-2.021,-1.161,-1.059},
  {"LYS",13, 8, 0.0376, 5," CD ",-3.043,-2.267,-0.859},
  {"LYS",13, 8, 0.0376, 5," CE ",-2.435,-3.635,-1.121},
  {"LYS",13, 8, 0.0376, 5," NZ ",-3.453,-4.719,-1.046},
  {"LYS",13, 9, 0.0325, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13, 9, 0.0325, 5," CG ",-1.903,-1.238, 1.182},
  {"LYS",13, 9, 0.0325, 5," CD ",-2.718,-2.520, 1.196},
  {"LYS",13, 9, 0.0325, 5," CE ",-3.888,-2.422, 2.160},
  {"LYS",13, 9, 0.0325, 5," NZ ",-3.439,-2.148, 3.553},
  {"LYS",13,10, 0.0294, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13,10, 0.0294, 5," CG ",-1.935,-1.214, 1.156},
  {"LYS",13,10, 0.0294, 5," CD ",-2.485,-2.608, 1.404},
  {"LYS",13,10, 0.0294, 5," CE ",-3.068,-3.207, 0.135},
  {"LYS",13,10, 0.0294, 5," NZ ",-3.737,-4.512, 0.394},
  {"LYS",13,11, 0.0254, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13,11, 0.0254, 5," CG ",-1.887,-1.251, 1.195},
  {"LYS",13,11, 0.0254, 5," CD ",-2.960,-2.310, 1.008},
  {"LYS",13,11, 0.0254, 5," CE ",-2.382,-3.710, 1.128},
  {"LYS",13,11, 0.0254, 5," NZ ",-3.445,-4.752, 1.138},
  {"LYS",13,12, 0.0203, 5," CB ",-0.938,-1.208, 0.007},
  {"LYS",13,12, 0.0203, 5," CG ",-0.224,-2.549, 0.069},
  {"LYS",13,12, 0.0203, 5," CD ",-1.213,-3.702, 0.098},
  {"LYS",13,12, 0.0203, 5," CE ",-0.499,-5.042, 0.159},
  {"LYS",13,12, 0.0203, 5," NZ ",-1.457,-6.181, 0.188},
  {"MET",12, 0, 0.2224, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 0, 0.2224, 4," CG ",-1.995,-1.180,-1.087},
  {"MET",12, 0, 0.2224, 4," SD ",-3.072, 0.260,-0.981},
  {"MET",12, 0, 0.2224, 4," CE ",-3.942,-0.079, 0.548},
  {"MET",12, 1, 0.1949, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 1, 0.1949, 4," CG ",-2.024,-1.157,-1.057},
  {"MET",12, 1, 0.1949, 4," SD ",-3.055,-2.635,-1.069},
  {"MET",12, 1, 0.1949, 4," CE ",-4.000,-2.401, 0.435},
  {"MET",12, 2, 0.1228, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 2, 0.1228, 4," CG ",-2.010,-1.168,-1.072},
  {"MET",12, 2, 0.1228, 4," SD ",-3.147,-2.563,-0.974},
  {"MET",12, 2, 0.1228, 4," CE ",-2.134,-3.874,-1.654},
  {"MET",12, 3, 0.0911, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 3, 0.0911, 4," CG ",-2.010,-1.168,-1.072},
  {"MET",12, 3, 0.0911, 4," SD ",-3.040,-2.647,-1.082},
  {"MET",12, 3, 0.0911, 4," CE ",-4.115,-2.301,-2.473},
  {"MET",12, 4, 0.0762, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 4, 0.0762, 4," CG ",-1.888,-1.249, 1.195},
  {"MET",12, 4, 0.0762, 4," SD ",-3.053,-2.621, 1.106},
  {"MET",12, 4, 0.0762, 4," CE ",-4.236,-1.984,-0.079},
  {"MET",12, 5, 0.0635, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 5, 0.0635, 4," CG ",-1.888,-1.249, 1.195},
  {"MET",12, 5, 0.0635, 4," SD ",-3.081, 0.101, 1.183},
  {"MET",12, 5, 0.0635, 4," CE ",-4.202,-0.448,-0.102},
  {"MET",12, 6, 0.0593, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 6, 0.0593, 4," CG ",-1.769,-1.341, 1.274},
  {"MET",12, 6, 0.0593, 4," SD ",-2.903,-2.740, 1.218},
  {"MET",12, 6, 0.0593, 4," CE ",-1.763,-4.109, 1.406},
  {"MET",12, 7, 0.0360, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 7, 0.0360, 4," CG ",-0.233,-2.545, 0.139},
  {"MET",12, 7, 0.0360, 4," SD ",-1.381,-3.923, 0.317},
  {"MET",12, 7, 0.0360, 4," CE ",-1.840,-3.761, 2.041},
  {"MET",12, 8, 0.0360, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 8, 0.0360, 4," CG ",-1.838,-1.288, 1.231},
  {"MET",12, 8, 0.0360, 4," SD ",-3.101,-2.565, 1.084},
  {"MET",12, 8, 0.0360, 4," CE ",-3.831,-2.510, 2.718},
  {"MET",12, 9, 0.0317, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12, 9, 0.0317, 4," CG ",-1.964,-1.204,-1.116},
  {"MET",12, 9, 0.0317, 4," SD ",-3.099, 0.193,-1.021},
  {"MET",12, 9, 0.0317, 4," CE ",-2.432, 1.258,-2.297},
  {"MET",12,10, 0.0254, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12,10, 0.0254, 4," CG ",-0.235,-2.544, 0.163},
  {"MET",12,10, 0.0254, 4," SD ",-1.310,-3.943,-0.203},
  {"MET",12,10, 0.0254, 4," CE ",-1.066,-4.104,-1.970},
  {"MET",12,11, 0.0211, 4," CB ",-0.940,-1.206, 0.007},
  {"MET",12,11, 0.0211, 4," CG ",-1.821,-1.301, 1.243},
  {"MET",12,11, 0.0211, 4," SD ",-3.030, 0.032, 1.339},
  {"MET",12,11, 0.0211, 4," CE ",-3.848,-0.364, 2.883},
  {"MSE",12, 0, 0.2224, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 0, 0.2224, 4," CG ",-1.995,-1.180,-1.087},
  {"MSE",12, 0, 0.2224, 4,"SE  ",-3.072, 0.260,-0.981},
  {"MSE",12, 0, 0.2224, 4," CE ",-3.942,-0.079, 0.548},
  {"MSE",12, 1, 0.1949, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 1, 0.1949, 4," CG ",-2.024,-1.157,-1.057},
  {"MSE",12, 1, 0.1949, 4,"SE  ",-3.055,-2.635,-1.069},
  {"MSE",12, 1, 0.1949, 4," CE ",-4.000,-2.401, 0.435},
  {"MSE",12, 2, 0.1228, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 2, 0.1228, 4," CG ",-2.010,-1.168,-1.072},
  {"MSE",12, 2, 0.1228, 4,"SE  ",-3.147,-2.563,-0.974},
  {"MSE",12, 2, 0.1228, 4," CE ",-2.134,-3.874,-1.654},
  {"MSE",12, 3, 0.0911, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 3, 0.0911, 4," CG ",-2.010,-1.168,-1.072},
  {"MSE",12, 3, 0.0911, 4,"SE  ",-3.040,-2.647,-1.082},
  {"MSE",12, 3, 0.0911, 4," CE ",-4.115,-2.301,-2.473},
  {"MSE",12, 4, 0.0762, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 4, 0.0762, 4," CG ",-1.888,-1.249, 1.195},
  {"MSE",12, 4, 0.0762, 4,"SE  ",-3.053,-2.621, 1.106},
  {"MSE",12, 4, 0.0762, 4," CE ",-4.236,-1.984,-0.079},
  {"MSE",12, 5, 0.0635, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 5, 0.0635, 4," CG ",-1.888,-1.249, 1.195},
  {"MSE",12, 5, 0.0635, 4,"SE  ",-3.081, 0.101, 1.183},
  {"MSE",12, 5, 0.0635, 4," CE ",-4.202,-0.448,-0.102},
  {"MSE",12, 6, 0.0593, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 6, 0.0593, 4," CG ",-1.769,-1.341, 1.274},
  {"MSE",12, 6, 0.0593, 4,"SE  ",-2.903,-2.740, 1.218},
  {"MSE",12, 6, 0.0593, 4," CE ",-1.763,-4.109, 1.406},
  {"MSE",12, 7, 0.0360, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 7, 0.0360, 4," CG ",-0.233,-2.545, 0.139},
  {"MSE",12, 7, 0.0360, 4,"SE  ",-1.381,-3.923, 0.317},
  {"MSE",12, 7, 0.0360, 4," CE ",-1.840,-3.761, 2.041},
  {"MSE",12, 8, 0.0360, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 8, 0.0360, 4," CG ",-1.838,-1.288, 1.231},
  {"MSE",12, 8, 0.0360, 4,"SE  ",-3.101,-2.565, 1.084},
  {"MSE",12, 8, 0.0360, 4," CE ",-3.831,-2.510, 2.718},
  {"MSE",12, 9, 0.0317, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12, 9, 0.0317, 4," CG ",-1.964,-1.204,-1.116},
  {"MSE",12, 9, 0.0317, 4,"SE  ",-3.099, 0.193,-1.021},
  {"MSE",12, 9, 0.0317, 4," CE ",-2.432, 1.258,-2.297},
  {"MSE",12,10, 0.0254, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12,10, 0.0254, 4," CG ",-0.235,-2.544, 0.163},
  {"MSE",12,10, 0.0254, 4,"SE  ",-1.310,-3.943,-0.203},
  {"MSE",12,10, 0.0254, 4," CE ",-1.066,-4.104,-1.970},
  {"MSE",12,11, 0.0211, 4," CB ",-0.940,-1.206, 0.007},
  {"MSE",12,11, 0.0211, 4," CG ",-1.821,-1.301, 1.243},
  {"MSE",12,11, 0.0211, 4,"SE  ",-3.030, 0.032, 1.339},
  {"MSE",12,11, 0.0211, 4," CE ",-3.848,-0.364, 2.883},
  {"PHE", 4, 0, 0.4439, 7," CB ",-0.938,-1.208, 0.006},
  {"PHE", 4, 0, 0.4439, 7," CG ",-1.945,-1.200,-1.109},
  {"PHE", 4, 0, 0.4439, 7," CD1",-3.121,-0.479,-0.994},
  {"PHE", 4, 0, 0.4439, 7," CD2",-1.713,-1.914,-2.273},
  {"PHE", 4, 0, 0.4439, 7," CE1",-4.047,-0.469,-2.020},
  {"PHE", 4, 0, 0.4439, 7," CE2",-2.637,-1.909,-3.300},
  {"PHE", 4, 0, 0.4439, 7," CZ ",-3.805,-1.185,-3.175},
  {"PHE", 4, 1, 0.3324, 7," CB ",-0.938,-1.208, 0.006},
  {"PHE", 4, 1, 0.3324, 7," CG ",-1.773,-1.321, 1.251},
  {"PHE", 4, 1, 0.3324, 7," CD1",-2.915,-0.555, 1.408},
  {"PHE", 4, 1, 0.3324, 7," CD2",-1.414,-2.195, 2.263},
  {"PHE", 4, 1, 0.3324, 7," CE1",-3.684,-0.659, 2.551},
  {"PHE", 4, 1, 0.3324, 7," CE2",-2.179,-2.302, 3.409},
  {"PHE", 4, 1, 0.3324, 7," CZ ",-3.316,-1.534, 3.553},
  {"PHE", 4, 2, 0.1286, 7," CB ",-0.938,-1.208, 0.006},
  {"PHE", 4, 2, 0.1286, 7," CG ",-0.225,-2.529,-0.053},
  {"PHE", 4, 2, 0.1286, 7," CD1", 0.192,-3.161, 1.106},
  {"PHE", 4, 2, 0.1286, 7," CD2", 0.026,-3.141,-1.270},
  {"PHE", 4, 2, 0.1286, 7," CE1", 0.846,-4.377, 1.053},
  {"PHE", 4, 2, 0.1286, 7," CE2", 0.681,-4.356,-1.329},
  {"PHE", 4, 2, 0.1286, 7," CZ ", 1.091,-4.976,-0.166},
  {"PHE", 4, 3, 0.0949, 7," CB ",-0.938,-1.208, 0.006},
  {"PHE", 4, 3, 0.0949, 7," CG ",-1.945,-1.200,-1.109},
  {"PHE", 4, 3, 0.0949, 7," CD1",-2.245,-0.028,-1.782},
  {"PHE", 4, 3, 0.0949, 7," CD2",-2.590,-2.366,-1.484},
  {"PHE", 4, 3, 0.0949, 7," CE1",-3.169,-0.019,-2.809},
  {"PHE", 4, 3, 0.0949, 7," CE2",-3.517,-2.362,-2.509},
  {"PHE", 4, 3, 0.0949, 7," CZ ",-3.807,-1.188,-3.174},
  {"PRO", 3, 0, 0.4696, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 3, 0, 0.4696, 3," CG ", 0.113,-2.228,-0.862},
  {"PRO", 3, 0, 0.4696, 3," CD ", 1.345,-1.430,-1.153},
  {"PRO", 3, 1, 0.4609, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 3, 1, 0.4609, 3," CG ",-0.916,-1.555,-1.569},
  {"PRO", 3, 1, 0.4609, 3," CD ",-0.221,-0.406,-2.229},
  {"PRO", 3, 2, 0.0693, 3," CB ",-0.784,-1.311,-0.107},
  {"PRO", 3, 2, 0.0693, 3," CG ", 0.123,-2.236,-0.840},
  {"PRO", 3, 2, 0.0693, 3," CD ", 1.360,-1.442,-1.120},
  {"SER", 3, 0, 0.4890, 2," CB ",-0.939,-1.208, 0.010},
  {"SER", 3, 0, 0.4890, 2," OG ",-0.209,-2.421, 0.068},
  {"SER", 3, 1, 0.2907, 2," CB ",-0.939,-1.208, 0.010},
  {"SER", 3, 1, 0.2907, 2," OG ",-1.878,-1.128,-1.048},
  {"SER", 3, 2, 0.2202, 2," CB ",-0.939,-1.208, 0.010},
  {"SER", 3, 2, 0.2202, 2," OG ",-1.710,-1.242, 1.199},
  {"THR", 3, 0, 0.4936, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 0, 0.4936, 3," OG1",-0.178,-2.422,-0.051},
  {"THR", 3, 0, 0.4936, 3," CG2",-1.769,-1.260,-1.270},
  {"THR", 3, 1, 0.4368, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 1, 0.4368, 3," OG1",-1.819,-1.152,-1.125},
  {"THR", 3, 1, 0.4368, 3," CG2",-1.900,-1.141, 1.191},
  {"THR", 3, 2, 0.0695, 3," CB ",-0.946,-1.215, 0.008},
  {"THR", 3, 2, 0.0695, 3," OG1",-1.883,-1.087, 1.083},
  {"THR", 3, 2, 0.0695, 3," CG2",-0.183,-2.484, 0.359},
  {"TRP", 7, 0, 0.3339,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 0, 0.3339,10," CG ",-2.015,-1.139,-1.031},
  {"TRP", 7, 0, 0.3339,10," CD1",-1.991,-1.692,-2.279},
  {"TRP", 7, 0, 0.3339,10," CD2",-3.279,-0.475,-0.913},
  {"TRP", 7, 0, 0.3339,10," NE1",-3.160,-1.413,-2.944},
  {"TRP", 7, 0, 0.3339,10," CE2",-3.969,-0.668,-2.128},
  {"TRP", 7, 0, 0.3339,10," CE3",-3.902, 0.266, 0.097},
  {"TRP", 7, 0, 0.3339,10," CZ2",-5.243,-0.150,-2.357},
  {"TRP", 7, 0, 0.3339,10," CZ3",-5.165, 0.779,-0.133},
  {"TRP", 7, 0, 0.3339,10," CH2",-5.821, 0.569,-1.349},
  {"TRP", 7, 1, 0.1866,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 1, 0.1866,10," CG ",-1.850,-1.251, 1.196},
  {"TRP", 7, 1, 0.1866,10," CD1",-3.079,-0.669, 1.310},
  {"TRP", 7, 1, 0.1866,10," CD2",-1.605,-1.913, 2.443},
  {"TRP", 7, 1, 0.1866,10," NE1",-3.613,-0.925, 2.550},
  {"TRP", 7, 1, 0.1866,10," CE2",-2.729,-1.689, 3.265},
  {"TRP", 7, 1, 0.1866,10," CE3",-0.548,-2.674, 2.953},
  {"TRP", 7, 1, 0.1866,10," CZ2",-2.823,-2.196, 4.560},
  {"TRP", 7, 1, 0.1866,10," CZ3",-0.644,-3.176, 4.238},
  {"TRP", 7, 1, 0.1866,10," CH2",-1.773,-2.935, 5.026},
  {"TRP", 7, 2, 0.1712,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 2, 0.1712,10," CG ",-1.783,-1.303, 1.242},
  {"TRP", 7, 2, 0.1712,10," CD1",-1.620,-2.165, 2.287},
  {"TRP", 7, 2, 0.1712,10," CD2",-2.928,-0.502, 1.560},
  {"TRP", 7, 2, 0.1712,10," NE1",-2.592,-1.952, 3.234},
  {"TRP", 7, 2, 0.1712,10," CE2",-3.408,-0.935, 2.814},
  {"TRP", 7, 2, 0.1712,10," CE3",-3.601, 0.540, 0.913},
  {"TRP", 7, 2, 0.1712,10," CZ2",-4.522,-0.366, 3.427},
  {"TRP", 7, 2, 0.1712,10," CZ3",-4.706, 1.103, 1.525},
  {"TRP", 7, 2, 0.1712,10," CH2",-5.155, 0.650, 2.768},
  {"TRP", 7, 3, 0.1147,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 3, 0.1147,10," CG ",-0.223,-2.523,-0.075},
  {"TRP", 7, 3, 0.1147,10," CD1", 0.163,-3.180,-1.208},
  {"TRP", 7, 3, 0.1147,10," CD2", 0.195,-3.343, 1.023},
  {"TRP", 7, 3, 0.1147,10," NE1", 0.792,-4.357,-0.883},
  {"TRP", 7, 3, 0.1147,10," CE2", 0.827,-4.481, 0.480},
  {"TRP", 7, 3, 0.1147,10," CE3", 0.100,-3.234, 2.415},
  {"TRP", 7, 3, 0.1147,10," CZ2", 1.356,-5.496, 1.276},
  {"TRP", 7, 3, 0.1147,10," CZ3", 0.627,-4.242, 3.202},
  {"TRP", 7, 3, 0.1147,10," CH2", 1.246,-5.357, 2.631},
  {"TRP", 7, 4, 0.0821,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 4, 0.0821,10," CG ",-1.971,-1.173,-1.076},
  {"TRP", 7, 4, 0.0821,10," CD1",-2.185,-0.168,-1.975},
  {"TRP", 7, 4, 0.0821,10," CD2",-2.934,-2.191,-1.378},
  {"TRP", 7, 4, 0.0821,10," NE1",-3.222,-0.497,-2.815},
  {"TRP", 7, 4, 0.0821,10," CE2",-3.698,-1.734,-2.471},
  {"TRP", 7, 4, 0.0821,10," CE3",-3.231,-3.445,-0.834},
  {"TRP", 7, 4, 0.0821,10," CZ2",-4.734,-2.483,-3.027},
  {"TRP", 7, 4, 0.0821,10," CZ3",-4.259,-4.186,-1.388},
  {"TRP", 7, 4, 0.0821,10," CH2",-4.997,-3.703,-2.472},
  {"TRP", 7, 5, 0.0582,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 5, 0.0582,10," CG ",-0.221,-2.524,-0.027},
  {"TRP", 7, 5, 0.0582,10," CD1", 0.168,-3.278, 1.043},
  {"TRP", 7, 5, 0.0582,10," CD2", 0.196,-3.243,-1.194},
  {"TRP", 7, 5, 0.0582,10," NE1", 0.801,-4.419, 0.614},
  {"TRP", 7, 5, 0.0582,10," CE2", 0.830,-4.424,-0.755},
  {"TRP", 7, 5, 0.0582,10," CE3", 0.100,-3.010,-2.570},
  {"TRP", 7, 5, 0.0582,10," CZ2", 1.362,-5.362,-1.638},
  {"TRP", 7, 5, 0.0582,10," CZ3", 0.627,-3.943,-3.444},
  {"TRP", 7, 5, 0.0582,10," CH2", 1.250,-5.103,-2.975},
  {"TRP", 7, 6, 0.0530,10," CB ",-0.938,-1.209, 0.008},
  {"TRP", 7, 6, 0.0530,10," CG ",-2.029,-1.128,-1.015},
  {"TRP", 7, 6, 0.0530,10," CD1",-3.248,-0.531,-0.872},
  {"TRP", 7, 6, 0.0530,10," CD2",-2.000,-1.663,-2.344},
  {"TRP", 7, 6, 0.0530,10," NE1",-3.980,-0.663,-2.027},
  {"TRP", 7, 6, 0.0530,10," CE2",-3.237,-1.353,-2.948},
  {"TRP", 7, 6, 0.0530,10," CE3",-1.055,-2.377,-3.089},
  {"TRP", 7, 6, 0.0530,10," CZ2",-3.548,-1.729,-4.253},
  {"TRP", 7, 6, 0.0530,10," CZ3",-1.367,-2.748,-4.384},
  {"TRP", 7, 6, 0.0530,10," CH2",-2.602,-2.424,-4.952},
  {"TYR", 4, 0, 0.4382, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 0, 0.4382, 8," CG ",-1.972,-1.188,-1.098},
  {"TYR", 4, 0, 0.4382, 8," CD1",-3.187,-0.534,-0.929},
  {"TYR", 4, 0, 0.4382, 8," CD2",-1.730,-1.823,-2.307},
  {"TYR", 4, 0, 0.4382, 8," CE1",-4.131,-0.515,-1.936},
  {"TYR", 4, 0, 0.4382, 8," CE2",-2.670,-1.809,-3.322},
  {"TYR", 4, 0, 0.4382, 8," CZ ",-3.868,-1.154,-3.131},
  {"TYR", 4, 0, 0.4382, 8," OH ",-4.809,-1.138,-4.135},
  {"TYR", 4, 1, 0.3446, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 1, 0.3446, 8," CG ",-1.763,-1.334, 1.271},
  {"TYR", 4, 1, 0.3446, 8," CD1",-2.872,-0.524, 1.484},
  {"TYR", 4, 1, 0.3446, 8," CD2",-1.431,-2.263, 2.246},
  {"TYR", 4, 1, 0.3446, 8," CE1",-3.627,-0.637, 2.636},
  {"TYR", 4, 1, 0.3446, 8," CE2",-2.181,-2.384, 3.403},
  {"TYR", 4, 1, 0.3446, 8," CZ ",-3.277,-1.569, 3.592},
  {"TYR", 4, 1, 0.3446, 8," OH ",-4.026,-1.682, 4.741},
  {"TYR", 4, 2, 0.1290, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 2, 0.1290, 8," CG ",-0.227,-2.540, 0.045},
  {"TYR", 4, 2, 0.1290, 8," CD1", 0.109,-3.136, 1.255},
  {"TYR", 4, 2, 0.1290, 8," CD2", 0.108,-3.200,-1.128},
  {"TYR", 4, 2, 0.1290, 8," CE1", 0.759,-4.353, 1.293},
  {"TYR", 4, 2, 0.1290, 8," CE2", 0.760,-4.420,-1.099},
  {"TYR", 4, 2, 0.1290, 8," CZ ", 1.083,-4.991, 0.113},
  {"TYR", 4, 2, 0.1290, 8," OH ", 1.733,-6.204, 0.148},
  {"TYR", 4, 3, 0.0879, 8," CB ",-0.940,-1.206, 0.008},
  {"TYR", 4, 3, 0.0879, 8," CG ",-1.956,-1.200,-1.112},
  {"TYR", 4, 3, 0.0879, 8," CD1",-2.614,-0.029,-1.472},
  {"TYR", 4, 3, 0.0879, 8," CD2",-2.256,-2.362,-1.807},
  {"TYR", 4, 3, 0.0879, 8," CE1",-3.542,-0.019,-2.494},
  {"TYR", 4, 3, 0.0879, 8," CE2",-3.185,-2.361,-2.833},
  {"TYR", 4, 3, 0.0879, 8," CZ ",-3.824,-1.188,-3.172},
  {"TYR", 4, 3, 0.0879, 8," OH ",-4.750,-1.181,-4.189},
  {"VAL", 3, 0, 0.7353, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 0, 0.7353, 3," CG1",-1.702,-1.260, 1.357},
  {"VAL", 3, 0, 0.7353, 3," CG2",-1.910,-1.177,-1.137},
  {"VAL", 3, 1, 0.2003, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 1, 0.2003, 3," CG1",-1.941,-1.152,-1.108},
  {"VAL", 3, 1, 0.2003, 3," CG2",-0.149,-2.511,-0.009},
  {"VAL", 3, 2, 0.0643, 3," CB ",-0.945,-1.215, 0.038},
  {"VAL", 3, 2, 0.0643, 3," CG1",-0.148,-2.509, 0.091},
  {"VAL", 3, 2, 0.0643, 3," CG2",-1.892,-1.116, 1.225}};
int rotamer_data_richardson_size = sizeof( rotamer_data_richardson ) / sizeof( rotamer_data_richardson[0] );


} // namespace data


} // namespace clipper
