
from __future__ import division
# Phi/Psi corrections in Angstrom and Radials
mean_devs = {
  (-180, -180) : (0.035380, 0.662277), # 15
  (-180, 120) : (0.053514, 1.333874), # 10
  (-180, 140) : (0.065882, 1.394471), # 16
  (-180, 150) : (0.070142, 1.335410), # 23
  (-180, 160) : (0.042570, 1.598630), # 117
  (-180, 170) : (0.056479, 1.424566), # 141
  (-180, 180) : (0.047132, 1.055309), # 28
  (-170, -180) : (0.014683, 0.812329), # 159
  (-170, -170) : (0.012680, 0.666855), # 120
  (-170, -160) : (0.027296, -1.416677), # 25
  (-170, -150) : (0.064166, -0.703400), # 13
  (-170, 70) : (0.006514, 1.100750), # 15
  (-170, 80) : (0.037410, 0.869351), # 21
  (-170, 90) : (0.038212, 1.114734), # 45
  (-170, 100) : (0.035859, 1.046967), # 43
  (-170, 110) : (0.036030, 1.169316), # 65
  (-170, 120) : (0.044560, 1.283219), # 107
  (-170, 130) : (0.043804, 1.342144), # 165
  (-170, 140) : (0.055866, 1.246472), # 313
  (-170, 150) : (0.045856, 1.270181), # 568
  (-170, 160) : (0.031066, 1.589475), # 1391
  (-170, 170) : (0.033027, 1.437375), # 1462
  (-170, 180) : (0.023684, 1.079197), # 328
  (-160, -180) : (0.011008, -1.113808), # 430
  (-160, -170) : (0.027892, -1.218938), # 342
  (-160, -160) : (0.036602, -1.106130), # 86
  (-160, -150) : (0.063610, -0.357946), # 23
  (-160, -70) : (0.043214, -1.672802), # 14
  (-160, -60) : (0.023117, -1.055799), # 10
  (-160, -40) : (0.018249, -2.220518), # 13
  (-160, -30) : (0.082768, -2.190566), # 16
  (-160, 0) : (0.019883, -2.170500), # 10
  (-160, 10) : (0.002147, 2.580949), # 13
  (-160, 20) : (0.016715, -1.847864), # 19
  (-160, 30) : (0.021126, -1.322623), # 25
  (-160, 40) : (0.025713, -1.584550), # 17
  (-160, 50) : (0.022133, -0.563721), # 29
  (-160, 60) : (0.023022, -0.732167), # 65
  (-160, 70) : (0.030699, 0.454790), # 113
  (-160, 80) : (0.026247, 0.435118), # 148
  (-160, 90) : (0.017117, 0.677175), # 173
  (-160, 100) : (0.021666, 0.802728), # 240
  (-160, 110) : (0.033633, 0.903796), # 301
  (-160, 120) : (0.036951, 1.089095), # 524
  (-160, 130) : (0.043215, 1.125017), # 1030
  (-160, 140) : (0.048002, 1.118818), # 1969
  (-160, 150) : (0.018159, 1.320832), # 2486
  (-160, 160) : (0.008825, 2.329039), # 5108
  (-160, 170) : (0.009731, 1.438139), # 4000
  (-160, 180) : (0.009765, 0.284786), # 834
  (-150, -180) : (0.025976, -1.414715), # 413
  (-150, -170) : (0.040608, -1.465861), # 388
  (-150, -160) : (0.055387, -1.381442), # 106
  (-150, -150) : (0.053137, -0.998006), # 28
  (-150, -80) : (0.057485, -1.487359), # 11
  (-150, -70) : (0.045143, -1.238058), # 27
  (-150, -60) : (0.020970, -1.701431), # 26
  (-150, -50) : (0.036170, -2.343174), # 17
  (-150, -40) : (0.018862, 0.584221), # 13
  (-150, -30) : (0.097837, -2.093086), # 20
  (-150, -20) : (0.039108, -2.288352), # 45
  (-150, -10) : (0.047594, -2.107151), # 41
  (-150, 0) : (0.043824, -2.044125), # 63
  (-150, 10) : (0.027607, -1.778740), # 89
  (-150, 20) : (0.043970, -1.796062), # 102
  (-150, 30) : (0.025438, -1.704413), # 84
  (-150, 40) : (0.037674, -1.586154), # 97
  (-150, 50) : (0.028394, -1.140791), # 118
  (-150, 60) : (0.017017, -0.512805), # 193
  (-150, 70) : (0.024357, 0.022396), # 290
  (-150, 80) : (0.017283, 0.174238), # 343
  (-150, 90) : (0.018156, 0.488168), # 339
  (-150, 100) : (0.028121, 0.670690), # 476
  (-150, 110) : (0.036535, 0.781410), # 753
  (-150, 120) : (0.033526, 0.970868), # 1298
  (-150, 130) : (0.039852, 1.112267), # 2343
  (-150, 140) : (0.039142, 1.183404), # 3249
  (-150, 150) : (0.015276, 1.895597), # 4136
  (-150, 160) : (0.010561, -2.868389), # 6851
  (-150, 170) : (0.005168, -2.126847), # 3691
  (-150, 180) : (0.010933, -1.283351), # 715
  (-140, -180) : (0.024881, -1.442589), # 288
  (-140, -170) : (0.042737, -1.454059), # 286
  (-140, -160) : (0.060054, -1.485889), # 104
  (-140, -150) : (0.067927, -1.386088), # 28
  (-140, -140) : (0.078345, -1.112720), # 18
  (-140, -120) : (0.083897, -1.619159), # 10
  (-140, -110) : (0.096173, -1.391489), # 16
  (-140, -100) : (0.097110, -1.549858), # 16
  (-140, -90) : (0.084261, -1.580695), # 21
  (-140, -80) : (0.069431, -1.516320), # 40
  (-140, -70) : (0.042727, -1.527414), # 43
  (-140, -60) : (0.022900, -1.892213), # 60
  (-140, -50) : (0.016647, -2.223301), # 61
  (-140, -40) : (0.033453, -2.276075), # 31
  (-140, -30) : (0.033587, -2.580686), # 67
  (-140, -20) : (0.032163, -2.615596), # 114
  (-140, -10) : (0.050134, -2.180829), # 153
  (-140, 0) : (0.038032, -2.052152), # 239
  (-140, 10) : (0.045455, -1.991192), # 348
  (-140, 20) : (0.030876, -1.797775), # 303
  (-140, 30) : (0.025211, -1.735482), # 253
  (-140, 40) : (0.022233, -1.426948), # 239
  (-140, 50) : (0.007918, -0.485416), # 259
  (-140, 60) : (0.011121, 0.177915), # 404
  (-140, 70) : (0.020191, 0.126941), # 626
  (-140, 80) : (0.024561, 0.477359), # 544
  (-140, 90) : (0.023824, 0.546802), # 503
  (-140, 100) : (0.032034, 0.631404), # 726
  (-140, 110) : (0.033315, 0.775950), # 1193
  (-140, 120) : (0.037287, 1.060575), # 2323
  (-140, 130) : (0.043184, 1.228683), # 4145
  (-140, 140) : (0.047529, 1.422014), # 5288
  (-140, 150) : (0.041454, 1.679654), # 6681
  (-140, 160) : (0.019228, 1.960096), # 6496
  (-140, 170) : (0.007613, 1.456032), # 2488
  (-140, 180) : (0.008386, -0.729165), # 487
  (-130, -180) : (0.018634, -0.925330), # 219
  (-130, -170) : (0.037817, -1.408411), # 250
  (-130, -160) : (0.055600, -1.219199), # 126
  (-130, -150) : (0.057101, -1.035360), # 36
  (-130, -140) : (0.089842, -1.340588), # 43
  (-130, -130) : (0.097353, -1.443920), # 24
  (-130, -120) : (0.070038, -1.380726), # 16
  (-130, -110) : (0.071526, -1.439628), # 28
  (-130, -100) : (0.091998, -1.548586), # 22
  (-130, -90) : (0.078061, -1.706570), # 35
  (-130, -80) : (0.051600, -1.352740), # 54
  (-130, -70) : (0.036704, -1.430207), # 62
  (-130, -60) : (0.022884, -1.706452), # 127
  (-130, -50) : (0.022013, -2.031164), # 161
  (-130, -40) : (0.014996, -2.807639), # 204
  (-130, -30) : (0.020863, -2.653675), # 246
  (-130, -20) : (0.027800, -2.464141), # 367
  (-130, -10) : (0.022764, -2.588395), # 661
  (-130, 0) : (0.033104, -2.098936), # 760
  (-130, 10) : (0.028173, -1.937908), # 761
  (-130, 20) : (0.030243, -1.771149), # 822
  (-130, 30) : (0.028334, -1.583210), # 725
  (-130, 40) : (0.024384, -1.408040), # 510
  (-130, 50) : (0.015222, -1.172508), # 384
  (-130, 60) : (0.016071, 0.055900), # 827
  (-130, 70) : (0.018886, 0.155401), # 1374
  (-130, 80) : (0.026232, 0.403702), # 1059
  (-130, 90) : (0.026511, 0.580446), # 886
  (-130, 100) : (0.032558, 0.698718), # 1133
  (-130, 110) : (0.037224, 0.839515), # 2086
  (-130, 120) : (0.039146, 1.069236), # 4108
  (-130, 130) : (0.042723, 1.253922), # 6159
  (-130, 140) : (0.048414, 1.453668), # 7600
  (-130, 150) : (0.044270, 1.581483), # 8369
  (-130, 160) : (0.033256, 1.587780), # 5473
  (-130, 170) : (0.020659, 1.266869), # 1902
  (-130, 180) : (0.011336, 0.211699), # 380
  (-120, -180) : (0.014688, -0.117050), # 203
  (-120, -170) : (0.032007, -0.980437), # 205
  (-120, -160) : (0.065835, -1.294067), # 102
  (-120, -150) : (0.066744, -1.089809), # 28
  (-120, -140) : (0.072641, -1.198347), # 35
  (-120, -130) : (0.079687, -1.458753), # 31
  (-120, -120) : (0.092369, -1.484569), # 27
  (-120, -110) : (0.072662, -1.309212), # 40
  (-120, -100) : (0.076047, -1.333084), # 38
  (-120, -90) : (0.066899, -1.363375), # 44
  (-120, -80) : (0.059782, -1.486972), # 45
  (-120, -70) : (0.056654, -1.658986), # 84
  (-120, -60) : (0.035804, -1.746346), # 209
  (-120, -50) : (0.012660, -2.168792), # 299
  (-120, -40) : (0.011940, -3.012778), # 419
  (-120, -30) : (0.015548, 3.123561), # 723
  (-120, -20) : (0.021125, -2.603402), # 1049
  (-120, -10) : (0.026970, -2.266828), # 1454
  (-120, 0) : (0.027036, -1.960928), # 1596
  (-120, 10) : (0.029025, -1.845688), # 1768
  (-120, 20) : (0.029372, -1.613737), # 1824
  (-120, 30) : (0.031592, -1.568307), # 1171
  (-120, 40) : (0.029454, -1.381716), # 561
  (-120, 50) : (0.018795, -1.196771), # 226
  (-120, 60) : (0.012963, -0.674788), # 231
  (-120, 70) : (0.014620, 0.294422), # 418
  (-120, 80) : (0.026295, 0.557645), # 610
  (-120, 90) : (0.031373, 0.595787), # 962
  (-120, 100) : (0.034212, 0.689098), # 1581
  (-120, 110) : (0.040184, 0.820773), # 2909
  (-120, 120) : (0.042308, 1.083983), # 5369
  (-120, 130) : (0.046209, 1.269287), # 7639
  (-120, 140) : (0.050538, 1.433341), # 7855
  (-120, 150) : (0.045242, 1.523508), # 6781
  (-120, 160) : (0.036533, 1.504482), # 3962
  (-120, 170) : (0.022687, 1.159714), # 1329
  (-120, 180) : (0.013470, -0.466063), # 280
  (-110, -180) : (0.028009, -1.251149), # 209
  (-110, -170) : (0.035072, -1.215258), # 163
  (-110, -160) : (0.066352, -1.331753), # 73
  (-110, -150) : (0.069224, -1.300672), # 50
  (-110, -140) : (0.051110, -0.995940), # 32
  (-110, -130) : (0.081469, -1.173478), # 33
  (-110, -120) : (0.096092, -1.367514), # 32
  (-110, -110) : (0.096661, -1.441533), # 40
  (-110, -100) : (0.088920, -1.470877), # 38
  (-110, -90) : (0.064916, -1.474733), # 42
  (-110, -80) : (0.048555, -1.639574), # 49
  (-110, -70) : (0.044834, -1.481858), # 104
  (-110, -60) : (0.021457, -1.768428), # 230
  (-110, -50) : (0.010732, -2.216909), # 443
  (-110, -40) : (0.008537, 2.735087), # 752
  (-110, -30) : (0.013610, -2.916458), # 1243
  (-110, -20) : (0.016286, -2.662643), # 1849
  (-110, -10) : (0.019983, -2.247301), # 2321
  (-110, 0) : (0.020547, -2.041933), # 2953
  (-110, 10) : (0.028224, -1.717721), # 3935
  (-110, 20) : (0.034199, -1.664886), # 3097
  (-110, 30) : (0.042596, -1.622751), # 1197
  (-110, 40) : (0.035756, -1.570992), # 304
  (-110, 50) : (0.026204, -1.357511), # 125
  (-110, 60) : (0.029147, -0.544626), # 82
  (-110, 70) : (0.024058, 0.172375), # 91
  (-110, 80) : (0.033255, 0.409943), # 214
  (-110, 90) : (0.032085, 0.505992), # 669
  (-110, 100) : (0.035907, 0.658109), # 1878
  (-110, 110) : (0.040977, 0.804666), # 3850
  (-110, 120) : (0.042458, 1.049485), # 6236
  (-110, 130) : (0.047050, 1.251928), # 7925
  (-110, 140) : (0.049262, 1.418236), # 7098
  (-110, 150) : (0.043977, 1.510466), # 5268
  (-110, 160) : (0.034198, 1.389769), # 2820
  (-110, 170) : (0.023697, 1.006508), # 1199
  (-110, 180) : (0.015343, -0.099169), # 276
  (-100, -180) : (0.039428, -1.439405), # 222
  (-100, -170) : (0.044502, -1.337155), # 223
  (-100, -160) : (0.060472, -1.379317), # 84
  (-100, -150) : (0.096830, -1.468101), # 30
  (-100, -140) : (0.091867, -1.274536), # 40
  (-100, -130) : (0.159630, -1.424626), # 24
  (-100, -120) : (0.080430, -1.429158), # 20
  (-100, -110) : (0.080774, -1.335430), # 22
  (-100, -100) : (0.066029, -1.185783), # 21
  (-100, -90) : (0.071046, -1.481612), # 34
  (-100, -80) : (0.037801, -1.045407), # 43
  (-100, -70) : (0.047694, -1.638215), # 92
  (-100, -60) : (0.017665, -1.789385), # 230
  (-100, -50) : (0.007006, -2.361367), # 622
  (-100, -40) : (0.008486, 2.796787), # 1240
  (-100, -30) : (0.011247, -3.122182), # 1834
  (-100, -20) : (0.015137, -2.480596), # 2415
  (-100, -10) : (0.013135, -2.523902), # 3584
  (-100, 0) : (0.017867, -2.020602), # 5920
  (-100, 10) : (0.031631, -1.778965), # 6214
  (-100, 20) : (0.041184, -1.731363), # 2658
  (-100, 30) : (0.044714, -1.657374), # 639
  (-100, 40) : (0.040003, -1.527709), # 190
  (-100, 50) : (0.029201, -1.211142), # 111
  (-100, 60) : (0.035699, -1.078151), # 148
  (-100, 70) : (0.028841, -0.603070), # 228
  (-100, 80) : (0.029368, -0.415179), # 310
  (-100, 90) : (0.035763, 0.313650), # 700
  (-100, 100) : (0.035817, 0.537418), # 1961
  (-100, 110) : (0.039109, 0.742587), # 4046
  (-100, 120) : (0.039211, 1.042583), # 6094
  (-100, 130) : (0.044906, 1.238287), # 6913
  (-100, 140) : (0.045543, 1.403496), # 5600
  (-100, 150) : (0.038885, 1.460043), # 4056
  (-100, 160) : (0.026254, 1.289586), # 2421
  (-100, 170) : (0.017726, 0.849992), # 1224
  (-100, 180) : (0.018871, -1.079305), # 352
  (-90, -180) : (0.058703, -1.671233), # 352
  (-90, -170) : (0.054513, -1.588803), # 356
  (-90, -160) : (0.058859, -1.382145), # 88
  (-90, -150) : (0.097051, -1.322530), # 24
  (-90, -110) : (0.104757, -1.363381), # 16
  (-90, -100) : (0.101713, -1.567652), # 13
  (-90, -90) : (0.064950, -1.522757), # 28
  (-90, -80) : (0.052308, -1.073596), # 37
  (-90, -70) : (0.040100, -1.506099), # 68
  (-90, -60) : (0.022284, -1.603895), # 278
  (-90, -50) : (0.005066, -2.374916), # 972
  (-90, -40) : (0.006685, -2.930375), # 1935
  (-90, -30) : (0.009563, -2.965377), # 2775
  (-90, -20) : (0.013818, -2.623616), # 3525
  (-90, -10) : (0.012827, -2.581990), # 6363
  (-90, 0) : (0.024729, -2.025437), # 8130
  (-90, 10) : (0.041901, -1.848349), # 4117
  (-90, 20) : (0.053437, -1.808426), # 771
  (-90, 30) : (0.043674, -1.821181), # 143
  (-90, 40) : (0.047617, -1.640884), # 120
  (-90, 50) : (0.031032, -1.400273), # 232
  (-90, 60) : (0.040351, -1.342424), # 706
  (-90, 70) : (0.032105, -0.988480), # 1170
  (-90, 80) : (0.023840, -0.489149), # 1010
  (-90, 90) : (0.024235, 0.068699), # 1211
  (-90, 100) : (0.031499, 0.486048), # 2038
  (-90, 110) : (0.035938, 0.720800), # 3848
  (-90, 120) : (0.037204, 0.994821), # 5195
  (-90, 130) : (0.036835, 1.201917), # 5771
  (-90, 140) : (0.038268, 1.370060), # 4924
  (-90, 150) : (0.033866, 1.443588), # 3998
  (-90, 160) : (0.025352, 1.277386), # 2705
  (-90, 170) : (0.015392, 0.672880), # 1527
  (-90, 180) : (0.035080, -1.575063), # 426
  (-80, -180) : (0.070215, -1.705282), # 422
  (-80, -170) : (0.076237, -1.652820), # 311
  (-80, -160) : (0.066813, -1.166517), # 23
  (-80, -80) : (0.024269, -0.998138), # 10
  (-80, -70) : (0.049059, -1.380753), # 74
  (-80, -60) : (0.019123, -1.842720), # 352
  (-80, -50) : (0.006864, -1.933468), # 1841
  (-80, -40) : (0.013794, -2.003076), # 4895
  (-80, -30) : (0.025982, -2.015825), # 6075
  (-80, -20) : (0.020372, -2.402912), # 6653
  (-80, -10) : (0.022127, -2.264254), # 8619
  (-80, 0) : (0.045494, -1.974469), # 4950
  (-80, 10) : (0.066239, -1.897828), # 934
  (-80, 20) : (0.058096, -1.791180), # 85
  (-80, 30) : (0.039092, -1.844179), # 32
  (-80, 40) : (0.048675, -1.821511), # 39
  (-80, 50) : (0.036778, -1.502578), # 128
  (-80, 60) : (0.033623, -1.376710), # 453
  (-80, 70) : (0.026616, -1.037305), # 901
  (-80, 80) : (0.022668, -0.634339), # 981
  (-80, 90) : (0.019290, 0.070004), # 813
  (-80, 100) : (0.028683, 0.473588), # 1312
  (-80, 110) : (0.033472, 0.646422), # 2608
  (-80, 120) : (0.033973, 0.922777), # 4214
  (-80, 130) : (0.032829, 1.170479), # 5720
  (-80, 140) : (0.033765, 1.383574), # 5923
  (-80, 150) : (0.029554, 1.448714), # 5246
  (-80, 160) : (0.023256, 1.298858), # 3913
  (-80, 170) : (0.013634, 0.806682), # 2262
  (-80, 180) : (0.036830, -1.588003), # 563
  (-70, -180) : (0.050451, -1.457209), # 82
  (-70, -170) : (0.054482, -1.540685), # 29
  (-70, -70) : (0.048897, -1.460965), # 57
  (-70, -60) : (0.030832, -1.683153), # 573
  (-70, -50) : (0.005257, -1.698139), # 12661
  (-70, -40) : (0.019880, -1.951923), # 54346
  (-70, -30) : (0.040361, -1.962076), # 25310
  (-70, -20) : (0.034995, -2.136502), # 14319
  (-70, -10) : (0.045940, -2.061780), # 8112
  (-70, 0) : (0.077778, -1.952414), # 1215
  (-70, 10) : (0.088878, -1.883337), # 76
  (-70, 50) : (0.036843, -1.710986), # 11
  (-70, 60) : (0.012427, -2.932937), # 14
  (-70, 70) : (0.036763, -1.131792), # 40
  (-70, 80) : (0.018158, -0.836282), # 66
  (-70, 90) : (0.015816, -0.564259), # 82
  (-70, 100) : (0.025893, 0.302007), # 214
  (-70, 110) : (0.028115, 0.476840), # 943
  (-70, 120) : (0.028123, 0.778833), # 3190
  (-70, 130) : (0.025483, 1.167196), # 6701
  (-70, 140) : (0.028541, 1.371193), # 8156
  (-70, 150) : (0.026799, 1.538768), # 7177
  (-70, 160) : (0.023024, 1.364320), # 4799
  (-70, 170) : (0.016426, 1.008555), # 1759
  (-70, 180) : (0.014358, -1.101534), # 226
  (-60, -70) : (0.044954, -1.241402), # 31
  (-60, -60) : (0.018837, -1.877795), # 1386
  (-60, -50) : (0.000847, -1.663021), # 57909
  (-60, -40) : (0.012460, -2.254188), # 97643
  (-60, -30) : (0.027173, -2.196004), # 24040
  (-60, -20) : (0.034260, -2.222687), # 9448
  (-60, -10) : (0.048591, -2.070202), # 1020
  (-60, 0) : (0.068556, -1.934232), # 27
  (-60, 110) : (0.021673, 0.243486), # 210
  (-60, 120) : (0.023702, 0.645766), # 1944
  (-60, 130) : (0.025022, 1.124696), # 6722
  (-60, 140) : (0.030805, 1.363162), # 8159
  (-60, 150) : (0.028218, 1.530713), # 4555
  (-60, 160) : (0.025432, 1.343957), # 1595
  (-60, 170) : (0.017690, 1.092076), # 232
  (-60, 180) : (0.008251, 2.509253), # 10
  (-50, -60) : (0.025580, -1.949634), # 755
  (-50, -50) : (0.008402, -2.072406), # 11093
  (-50, -40) : (0.012596, -2.342089), # 8400
  (-50, -30) : (0.019770, -2.394853), # 2142
  (-50, -20) : (0.033287, -2.199995), # 186
  (-50, 110) : (0.031668, 0.350915), # 66
  (-50, 120) : (0.023657, 0.558038), # 770
  (-50, 130) : (0.025811, 1.006346), # 3195
  (-50, 140) : (0.032795, 1.215492), # 2282
  (-50, 150) : (0.035794, 1.512423), # 487
  (-50, 160) : (0.037347, 1.128178), # 67
  (-40, -60) : (0.031832, -2.117161), # 154
  (-40, -50) : (0.022585, -2.097524), # 428
  (-40, -40) : (0.011717, -2.293766), # 150
  (-40, 110) : (0.025919, -0.160097), # 25
  (-40, 120) : (0.042104, 0.488702), # 150
  (-40, 130) : (0.032171, 0.999491), # 311
  (-40, 140) : (0.052664, 1.320359), # 88
  (-30, -60) : (0.032135, -2.296674), # 23
  (-30, 120) : (0.035068, 0.539057), # 21
  (-30, 130) : (0.054616, 0.901047), # 13
  (30, 60) : (0.072607, -1.832323), # 33
  (30, 70) : (0.034337, -1.585456), # 22
  (40, -130) : (0.116007, -1.634873), # 29
  (40, -120) : (0.108968, -1.558834), # 31
  (40, -110) : (0.096649, -1.622488), # 13
  (40, 40) : (0.066143, -1.860469), # 88
  (40, 50) : (0.048835, -1.763838), # 380
  (40, 60) : (0.040186, -1.779217), # 362
  (40, 70) : (0.048039, -1.989197), # 59
  (50, -150) : (0.109743, -1.547969), # 32
  (50, -140) : (0.075935, -1.422907), # 95
  (50, -130) : (0.096203, -1.487093), # 239
  (50, -120) : (0.101169, -1.516319), # 175
  (50, -110) : (0.106881, -1.636900), # 41
  (50, -100) : (0.100677, -1.859417), # 10
  (50, 20) : (0.056028, -2.128278), # 70
  (50, 30) : (0.049681, -1.969021), # 742
  (50, 40) : (0.044823, -1.819312), # 2876
  (50, 50) : (0.044058, -1.743815), # 2711
  (50, 60) : (0.043105, -1.798318), # 872
  (50, 70) : (0.041541, -1.805274), # 95
  (60, -170) : (0.074767, -1.689534), # 19
  (60, -160) : (0.074479, -1.622709), # 35
  (60, -150) : (0.100118, -1.618585), # 52
  (60, -140) : (0.085065, -1.464307), # 79
  (60, -130) : (0.102385, -1.393663), # 120
  (60, -120) : (0.096917, -1.450551), # 92
  (60, -110) : (0.100767, -1.542336), # 55
  (60, -100) : (0.091068, -1.670842), # 23
  (60, -40) : (0.093689, -2.215011), # 13
  (60, 0) : (0.059879, -2.153670), # 25
  (60, 10) : (0.084165, -2.126972), # 284
  (60, 20) : (0.074210, -2.062337), # 1394
  (60, 30) : (0.063501, -1.994479), # 2706
  (60, 40) : (0.055604, -1.887973), # 2746
  (60, 50) : (0.053196, -1.843967), # 1235
  (60, 60) : (0.063469, -1.811230), # 416
  (60, 70) : (0.053382, -2.006615), # 118
  (60, 80) : (0.081720, -2.123401), # 27
  (60, 170) : (0.030872, -1.936611), # 11
  (70, -180) : (0.044577, -1.458756), # 16
  (70, -170) : (0.077082, -1.770507), # 29
  (70, -160) : (0.089496, -1.810629), # 13
  (70, -150) : (0.133719, -1.657575), # 11
  (70, -140) : (0.119755, -1.672934), # 11
  (70, -70) : (0.147067, -2.142418), # 26
  (70, -60) : (0.101518, -2.163974), # 64
  (70, -50) : (0.098038, -2.268177), # 85
  (70, -40) : (0.103219, -2.274119), # 60
  (70, -30) : (0.089309, -2.554478), # 29
  (70, -20) : (0.096679, -2.306757), # 30
  (70, -10) : (0.099835, -2.349063), # 82
  (70, 0) : (0.107001, -2.207153), # 426
  (70, 10) : (0.100233, -2.136523), # 1020
  (70, 20) : (0.093000, -2.068692), # 1010
  (70, 30) : (0.089295, -2.035659), # 594
  (70, 40) : (0.085628, -1.966428), # 238
  (70, 50) : (0.104310, -1.999237), # 70
  (70, 60) : (0.085614, -1.863681), # 30
  (70, 70) : (0.071485, -1.999119), # 43
  (70, 80) : (0.110997, -2.159237), # 32
  (70, 90) : (0.080609, -2.256173), # 12
  (70, 160) : (0.099517, -2.202135), # 28
  (70, 170) : (0.104469, -2.069903), # 38
  (70, 180) : (0.056735, -2.175485), # 19
  (80, -70) : (0.112877, -2.263793), # 11
  (80, -60) : (0.106791, -2.074358), # 29
  (80, -50) : (0.136957, -2.141120), # 41
  (80, -40) : (0.128737, -2.095763), # 24
  (80, -30) : (0.109287, -2.390230), # 15
  (80, -20) : (0.117640, -2.301341), # 40
  (80, -10) : (0.124131, -2.337896), # 162
  (80, 0) : (0.137295, -2.204819), # 227
  (80, 10) : (0.122574, -2.186306), # 170
  (80, 20) : (0.124705, -2.108139), # 75
  (80, 30) : (0.169779, -2.134279), # 30
  (80, 100) : (0.069279, -2.688228), # 11
  (80, 110) : (0.107938, -2.417924), # 14
  (80, 120) : (0.087318, -2.513343), # 11
  (80, 140) : (0.092550, -2.466506), # 15
  (80, 160) : (0.102778, -2.388696), # 25
  (80, 170) : (0.115985, -2.142115), # 21
  (90, -20) : (0.125725, -2.473357), # 19
  (90, -10) : (0.131658, -2.326943), # 26
  (90, 0) : (0.149122, -2.434733), # 17
  (180, 160) : (0.062122, 1.667069), # 25
  (180, 170) : (0.094775, 1.388222), # 23
}

if __name__ == '__main__':
  for phi_psi in [(0,0), (-60,-60)]:
    print(phi_psi, mean_devs.get(phi_psi, None))
