set(ANDROID_ROOT ${ROOT_DIR}/android-project/)
set(MIN_ANDROID_SDK 10)
set(TARGET_ANDROID_SDK 13)

set(ANDROID_NDK_ROOT ${ANDROID_NDK})
set(ANDROID_SDK_ROOT $ENV{ANDROID_SDK})
set(ANDROID_SDK_BUILD_TOOLS_VERSION "22.0.1")
set(ANDROID_BUILD_TOOLS_ROOT ${ANDROID_SDK_ROOT}/build-tools/${ANDROID_SDK_BUILD_TOOLS_VERSION})
set(ANDROID_API "android-13" CACHE STRING "Android platform version")

if (${CMAKE_HOST_SYSTEM_NAME} STREQUAL "Windows")
	set(ANDROID_NDK_EXE_EXT ".exe")
	set(ANDROID_SDK_TOOL_EXT ".bat")
endif()

if (VERBOSE)
	set(ANT_FLAGS -v)
	set(ZIPALIGN_FLAGS -v)
	set(KEYTOOL_FLAGS -v)
	set(ANDROID_TOOL_FLAGS "${ANDROID_TOOL_FLAGS} -v")
endif()
if (GRADLE)
	set(ANDROID_TOOL_FLAGS "${ANDROID_TOOL_FLAGS} -g")
endif()

set(ANDROID_SDK_TOOL "${ANDROID_SDK_ROOT}/tools/android${ANDROID_SDK_TOOL_EXT}")

if (NOT ANDROID_NDK_ROOT)
	message(FATAL_ERROR "ANDROID_NDK environment variable is not set")
endif()
if (NOT ANDROID_SDK_ROOT)
	message(FATAL_ERROR "ANDROID_SDK environment variable is not set")
endif()
message(STATUS "Android NDK root: ${ANDROID_NDK_ROOT}")
message(STATUS "Android SDK root: ${ANDROID_SDK_ROOT}")

if (RELEASE)
	set(ANT_TARGET release)
	set(ANT_INSTALL_TARGET installr)
	set(MANIFEST_DEBUGGABLE false)
else()
	set(ANT_TARGET debug)
	set(ANT_INSTALL_TARGET installd)
	set(MANIFEST_DEBUGGABLE true)
endif()

# find the ant tool
find_host_program(ANDROID_ANT ant)
if (ANDROID_ANT)
	message(STATUS "ant found")
else()
	message(FATAL_ERROR "ant not found in path!")
endif()

if (GRADLE)
	find_host_program(ANDROID_GRADLE gradle)
	if (ANDROID_GRADLE)
		message(STATUS "gradle found")
	else()
		message(FATAL_ERROR "gradle not found in path!")
	endif()
endif()

find_host_program(JARSIGNER "jarsigner")
find_host_program(ANDROID_NDK_STACK "ndk-stack" HINTS ${ANDROID_NDK_ROOT})
find_host_program(ANDROID_ZIPALIGN "zipalign" HINTS ${ANDROID_SDK_ROOT}/tools)
if (ANDROID_ZIPALIGN)
	message(STATUS "zipalign tool found")
else()
	set(ANDROID_ZIPALIGN ${ANDROID_BUILD_TOOLS_ROOT}/zipalign)
	message(STATUS "could not find zipalign in path - use ${ANDROID_ZIPALIGN}")
endif()

option(HD_VERSION "Build the HD versions of the games" OFF)
set(ANDROID_REFERENCED_LIBS android.library.reference.1=google-play-services_lib)
set(TOOLS OFF)
set(USE_BUILTIN ON)

find_host_program(ANDROID_ADB adb PATHS ${ANDROID_SDK_ROOT}/platform-tools/)
if (ANDROID_ADB)
	message(STATUS "adb tool found")
else()
	message(FATAL_ERROR "adb tool not found in path!")
endif()

set(PERMISSIONS)
list(APPEND PERMISSIONS "<uses-permission android:name=\"com.android.vending.BILLING\" />")

set(META_DATA)
if (NOT HD_VERSION)
	list(APPEND META_DATA "<meta-data android:value=\"true\" android:name=\"ADMOB_ALLOW_LOCATION_FOR_ADS\" />")
	message(STATUS "Don't build HD version")
else()
	message(STATUS "Build HD version")
endif()
list(APPEND META_DATA "<meta-data android:name=\"com.google.android.gms.games.APP_ID\" android:value=\"@string/app_id\" />")
list(APPEND META_DATA "<meta-data android:name=\"com.google.android.gms.appstate.APP_ID\" android:value=\"@string/app_id\" />")
list(APPEND META_DATA "<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />")

set(DEBUG_KEYSTORES "$ENV{HOME}/.android/debug.keystore" "$ENV{HOMEPATH}/.android/debug.keystore")
foreach(DEBUG_KEYSTORE ${DEBUG_KEYSTORES})
	if (EXISTS ${DEBUG_KEYSTORE})
		set(ANDROID_DEBUG_KEYSTORE ${DEBUG_KEYSTORE})
	endif()
endforeach()

set(ANDROID_DEBUG_ALIAS androiddebugkey)
set(ANDROID_DEBUG_STOREPASS android)
set(ANDROID_DEBUG_KEYPASS android)
if (NOT ANDROID_DEBUG_KEYSTORE)
	find_host_program(KEYTOOL keytool)
	if (KEYTOOL)
		message(STATUS "keytool found (${KEYTOOL})- generate debug keystore at $ENV{HOME}/.android with storepass ${ANDROID_DEBUG_STOREPASS}, alias ${ANDROID_DEBUG_ALIAS}, keypass ${ANDROID_DEBUG_KEYPASS}")
		file(MAKE_DIRECTORY $ENV{HOME}/.android)
		execute_process(COMMAND ${KEYTOOL} -genkeypair ${KEYTOOL_FLAGS} -keystore $ENV{HOME}/.android/debug.keystore -storepass ${ANDROID_DEBUG_STOREPASS} -alias ${ANDROID_DEBUG_ALIAS} -keypass ${ANDROID_DEBUG_KEYPASS} -dname "CN=Android Debug,O=Android,C=US" RESULT_VARIABLE exitcode)
		execute_process(COMMAND ${KEYTOOL} --help)
		message(STATUS "keytool exited with ${exitcode}")
	else()
		message(FATAL_ERROR "keytool not found in path! no debug keystore found")
	endif()
endif()

set(ANDROID_RELEASE_KEYSTORE $ENV{CAVEPRODUCTIONS_KEYSTORE_PATH})
set(ANDROID_RELEASE_ALIAS CaveProductions)
set(ANDROID_RELEASE_STOREPASS $ENV{CAVEPRODUCTIONS_KEYSTORE_PASSWD})
set(ANDROID_RELEASE_KEYPASS $ENV{CAVEPRODUCTIONS_ALIAS_PASSWD})

if (RELEASE)
	if (NOT DEFINED ENV{CAVEPRODUCTIONS_KEYSTORE_PASSWD})
		message(FATAL_ERROR "No keystore password set")
	endif()
	if (NOT DEFINED ENV{CAVEPRODUCTIONS_KEYSTORE_PATH})
		message(FATAL_ERROR "No keystore path set")
	endif()
	set(ANDROID_KEYSTORE ${ANDROID_RELEASE_KEYSTORE})
	set(ANDROID_ALIAS ${ANDROID_RELEASE_ALIAS})
	set(ANDROID_STOREPASS ${ANDROID_RELEASE_STOREPASS})
	set(ANDROID_KEYPASS ${ANDROID_RELEASE_KEYPASS})
else()
	set(ANDROID_KEYSTORE ${ANDROID_DEBUG_KEYSTORE})
	set(ANDROID_ALIAS ${ANDROID_DEBUG_ALIAS})
	set(ANDROID_STOREPASS ${ANDROID_DEBUG_STOREPASS})
	set(ANDROID_KEYPASS ${ANDROID_DEBUG_KEYPASS})
endif()

add_definitions(-DGL_GLEXT_PROTOTYPES)

set(CMAKE_C_STANDARD_LIBRARIES "-ldl -landroid -llog -lm -lz -lc -lgcc")
set(CMAKE_CXX_STANDARD_LIBRARIES "${CMAKE_C_STANDARD_LIBRARIES}")
