/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef AtomDCProperties_H
#define AtomDCProperties_H

#include <QObject>
#include <QMap>
#include <QVector3D>

class AtomDC;
/**
 *  @ingroup group_cepmodeling_components_physicalmodel
 *
 *  @brief
 *  The class AtomDCProperties defines an object that allows interaction
 *  of some properties of an atom.
 *
 *  The default atom properties are created thanks to Q_PROPERTY.
 *  The extra properties found in the PML document are also available thanks
 *  to the dynamic features of the Qt's Property System (see qt documentation).
 *
 **/
class AtomDCProperties : public QObject {
    Q_OBJECT

    /** the index property that will be managed in the property dialog */
    Q_PROPERTY(int index READ getIndex WRITE setIndex )

    /// the 3D position property
    Q_PROPERTY(QVector3D position READ getPosition WRITE setPosition)

public:

    /** Default construtor */
    AtomDCProperties(AtomDC *);

    /// destructor
    ~AtomDCProperties() {}

    /// change the currently managed AtomDC and update the value of the properties
    void updateProperties(AtomDC*);

    /// change the atom's index from the property editor
    void setIndex( int );
    /// get the atom's index in a form the property editor understands
    int getIndex() const;

    /// change the atom's position from the property editor
    void setPosition(QVector3D);

    /// get the atom's position in a form the property editor understands
    QVector3D getPosition() const;

    /** intercept signal for dynamic property changed.
     */
    virtual bool event(QEvent* e);

private:
    /// the currently selected atom's AtomDC
    AtomDC *myDC;

};


#endif
