# bzr-dbus: dbus support for bzr/bzrlib.
# Copyright (C) 2007,2009 Canonical Limited.
#   Author: Robert Collins
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
# 

"""System wide hooks to trigger dbus events from bzr activity."""


def get_activity():
    import activity
    import dbus
    try:
        return activity.Activity()
    except dbus.DBusException, e:
        from bzrlib import trace
        trace.mutter("Unable to connect to dbus, won't send events."
                     "Reason: '%s'" % e)
        return None


def on_post_change_branch_tip(params):
    """Announce the new head revision of the branch to dbus."""
    activity = get_activity()
    if activity is None:
        return
    activity.advertise_branch(params.branch)


def on_server_start(local_urls, public_url):
    """Add the servers local and public urls to the session Broadcaster."""
    activity = get_activity()
    if activity is None:
        return
    for local_url in local_urls:
        activity.add_url_map(local_url, public_url)


def on_server_stop(local_urls, public_url):
    """The server has shutdown, so remove the servers local and public urls."""
    activity = get_activity()
    if activity is None:
        return
    for local_url in local_urls:
        activity.remove_url_map(local_url, public_url)
