// ************************************************************************** //
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Wrap/Swig/libBornAgainDevice.i
//! @brief     SWIG interface file for libBornAgainDevice
//!
//!            Configuration is done in Device/CMakeLists.txt
//!
//! @homepage  http://apps.jcns.fz-juelich.de/BornAgain
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2013
//! @authors   Scientific Computing Group at MLZ Garching
//
// ************************************************************************** //

%module(directors="1", moduleimport="import $module") "libBornAgainDevice"

%include "commons.i"

%{
#include "Base/Axis/Frame.h"
#include "Base/Axis/Scale.h"
#include "Base/Spin/SpinMatrix.h"
#include "Device/Beam/Beam.h"
#include "Device/Beam/FootprintGauss.h"
#include "Device/Beam/FootprintSquare.h"
#include "Device/Data/DataUtil.h"
#include "Device/Histo/DiffUtil.h"
#include "Device/Histo/SimulationResult.h"
#include "Device/Detector/RectangularDetector.h"
#include "Device/Detector/OffspecDetector.h"
#include "Device/Detector/SphericalDetector.h"
#include "Device/IO/IOFactory.h"
#include "Device/Mask/DetectorMask.h"
#include "Device/Mask/Ellipse.h"
#include "Device/Mask/Line.h"
#include "Device/Mask/Polygon.h"
#include "Device/Mask/Rectangle.h"
#include "Device/Resolution/IDetectorResolution.h"
#include "Device/Resolution/ResolutionFunction2DGaussian.h"
#include "Param/Distrib/ParameterDistribution.h"
%}

%import(module="libBornAgainFit") "Fit/Param/AttLimits.h"
%import(module="libBornAgainFit") "Fit/Param/Attributes.h"
%import(module="libBornAgainFit") "Fit/Param/Parameters.h"
%import(module="libBornAgainFit") "Fit/Param/Parameter.h"

%include "fromBase.i"
%include "fromParam.i"

%include "Device/Data/Datafield.h"
%include "Device/Histo/DiffUtil.h"
%include "Device/Data/DataUtil.h"

%include "Device/Beam/Beam.h"
%include "Device/Beam/IFootprint.h"
%include "Device/Beam/FootprintGauss.h"
%include "Device/Beam/FootprintSquare.h"
%include "Device/Mask/IShape2D.h"
%include "Device/Mask/Ellipse.h"
%include "Device/Mask/Line.h"
%include "Device/Mask/Polygon.h"
%include "Device/Mask/Rectangle.h"
%include "Device/Resolution/IDetectorResolution.h"
%include "Device/Resolution/IResolutionFunction2D.h"
%include "Device/Resolution/ResolutionFunction2DGaussian.h"

%include "Device/Coord/Tags.h"

%include "Device/Mask/DetectorMask.h"
%include "Device/Detector/IDetector.h"
%include "Device/Detector/RectangularDetector.h"
%include "Device/Detector/OffspecDetector.h"
%include "Device/Detector/SphericalDetector.h"

%include "Device/Data/DataUtil.h"
%include "Device/IO/IOFactory.h"
%include "Device/Histo/SimulationResult.h"
