#include "Device/Data/ArrayUtil.h"
#include "Device/Data/Datafield.h"
#include "GUI/Model/Data/IntensityDataItem.h"
#include "GUI/Model/Data/SpecularDataItem.h"
#include "Tests/GTestWrapper/google_test.h"
#include <QTest>

class TestDataItems : public ::testing::Test {
public:
    template <typename T>
    void testItemClock()
    {
        DataItem* item = new T();

        QDateTime time = QDateTime::currentDateTime();
        item->setLastModified(time);
        EXPECT_EQ(time, item->lastModified());

        const int nap_time(20);
        QTest::qSleep(nap_time);

        // changing item (file name)
        item->setFileName("name.txt");
        QDateTime time2 = item->lastModified();
        EXPECT_TRUE(time.msecsTo(time2) > nap_time / 2);

        QTest::qSleep(nap_time);

        // changing item (Datafield)
        if (typeid(T) == typeid(SpecularDataItem)) {
            std::vector<double> data = {1, 2, 3};
            item->setDatafield(DataUtil::Array::createPField1D(data).release());
        } else {
            std::vector<std::vector<double>> data;
            data.push_back(std::vector<double>({1, 2, 3}));
            data.push_back(std::vector<double>({1, 2, 3}));
            data.push_back(std::vector<double>({1, 2, 3}));
            item->setDatafield(DataUtil::Array::createPField2D(data).release());
        }
        QDateTime time3 = item->lastModified();
        EXPECT_TRUE(time2.msecsTo(time3) > nap_time / 2);
    }
};

TEST_F(TestDataItems, testSpecularItemClock)
{
    testItemClock<SpecularDataItem>();
}

TEST_F(TestDataItems, testIntensityItemClock)
{
    testItemClock<IntensityDataItem>();
}
