//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Resample/Processed/Slicer.h
//! @brief     Defines function Compute::Slicing::sliceFormFactor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG

#ifndef BORNAGAIN_RESAMPLE_PROCESSED_SLICER_H
#define BORNAGAIN_RESAMPLE_PROCESSED_SLICER_H

#include "Base/Types/OwningVector.h"

class IParticle;
class Material;
class IReParticle;
class Span;
class ZLimits;

namespace Compute::Slicing {

OwningVector<IReParticle> particlesInSlice(const IParticle* particle, const ZLimits&,
                                           const Material& ambientMat);

} // namespace Compute::Slicing

#endif // BORNAGAIN_RESAMPLE_PROCESSED_SLICER_H
