//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/DetectorEditor.h
//! @brief     Defines class DetectorEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_DETECTOREDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_DETECTOREDITOR_H

#include <QGroupBox>

class InstrumentItem;
class GISASInstrumentItem;
class QFormLayout;

//! Contains stack of detector editors and the logic to show proper editor for certain type
//! of detector item (SphericalDetectorForm or RectangularDetectorForm).

class DetectorEditor : public QGroupBox {
    Q_OBJECT

public:
    DetectorEditor(QWidget* parent, GISASInstrumentItem* item);

signals:
    void dataChanged();

private:
    void createDetectorWidgets();

    GISASInstrumentItem* m_instrument;
    QFormLayout* m_formLayout;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_DETECTOREDITOR_H
