//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/Lattice2DItemCatalog.h
//! @brief     Defines class Lattice2DItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_LATTICE2DITEMCATALOG_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_LATTICE2DITEMCATALOG_H

#include "GUI/Support/Type/UiInfo.h"
#include <QVector>

class Lattice2DItem;

class Lattice2DItemCatalog {
public:
    // used in SelectionProperty<Catalog>
    using CatalogedType = Lattice2DItem;

    // Do not change the numbering! It is serialized!
    enum class Type : uint8_t { Basic = 1, Square = 2, Hexagonal };

    //! Creates the item of the given type.
    static CatalogedType* create(Type type);

    //! List of available types, sorted as expected in the UI.
    static QVector<Type> types();

    //! UiInfo on the given type.
    static UiInfo uiInfo(Type t);

    //! Returns the enum type of the given item.
    static Type type(const CatalogedType* item);
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_LATTICE2DITEMCATALOG_H
