//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Model/DataFilesCleaner.cpp
//! @brief     Implements class DataFilesCleaner
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2023
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Model/DataFilesCleaner.h"
#include "GUI/Model/Data/DataItem.h"
#include <QFile>

DataFilesCleaner::DataFilesCleaner() = default;

void DataFilesCleaner::recollectDataNames(const QVector<DataItem*>& dataItems)
{
    m_fileNames.clear();
    for (DataItem* item : dataItems)
        m_fileNames << item->fileName();
}

void DataFilesCleaner::cleanOldFiles(const QString& projectDir, const QVector<DataItem*>& dataItems)
{
    QStringList oldSaves = m_fileNames;
    recollectDataNames(dataItems);

    for (QString name : oldSaves)
        if (!m_fileNames.contains(name))
            QFile::remove(projectDir + "/" + name);
}
