//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Data/DataItemUtil.h
//! @brief     Defines namespace GUI::Model::DataItemUtil
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DATA_DATAITEMUTIL_H
#define BORNAGAIN_GUI_MODEL_DATA_DATAITEMUTIL_H

#include "Device/Detector/IDetector.h"
#include "GUI/Model/Data/ComboProperty.h"

class DataItem;
class ICoordSystem;
class SimulationResult;

//! Contains convenience methods to trasfer data from domain simulation to IntensityDataItem.
//! Used to modify Datafield's axes units as requested by IntensityDataItem.

namespace GUI::Model::DataItemUtil {

//! Updates axes' titles
void updateAxesTitle(DataItem* intensityItem, const ICoordSystem& converter, Coords units);

//! Updates axes of Datafield in IntensityData item
void updateDataAxes(DataItem* dataItem, const ICoordSystem& converter);

//! Available units for coordinate system
QStringList availableUnits(const ICoordSystem& converter);

//! Creates zero-value intensity map with given coordinate system
void createDefaultDetectorMap(DataItem* dataItem, const ICoordSystem& converter);

} // namespace GUI::Model::DataItemUtil

#endif // BORNAGAIN_GUI_MODEL_DATA_DATAITEMUTIL_H
