//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Beam/BeamWavelengthItem.h
//! @brief     Defines class BeamWavelengthItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_BEAM_BEAMWAVELENGTHITEM_H
#define BORNAGAIN_GUI_MODEL_BEAM_BEAMWAVELENGTHITEM_H

#include "GUI/Model/Beam/BeamDistributionItem.h"

class BeamWavelengthItem : public BeamDistributionItem {
public:
    BeamWavelengthItem(bool onlySymmetricDistributions = false);

    void readFrom(QXmlStreamReader* r) override;

    //! Returns wavelength. In the case of distribution applied, returns its mean.
    double wavelength() const;
};

#endif // BORNAGAIN_GUI_MODEL_BEAM_BEAMWAVELENGTHITEM_H
