//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Beam/BeamDistributionItem.h
//! @brief     Defines class BeamDistributionItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_BEAM_BEAMDISTRIBUTIONITEM_H
#define BORNAGAIN_GUI_MODEL_BEAM_BEAMDISTRIBUTIONITEM_H

#include "GUI/Model/Beam/DistributionItemCatalog.h"
#include "GUI/Model/Descriptor/SelectionProperty.h"
#include "Param/Distrib/ParameterDistribution.h"

class DistributionItem;

//! The BeamDistributionItem handles wavelength, inclination and azimuthal parameter
//! distribution for BeamItem

class BeamDistributionItem {
public:
    virtual ~BeamDistributionItem();

    virtual void writeTo(QXmlStreamWriter* w) const;
    virtual void readFrom(QXmlStreamReader* r);

    virtual double meanValue() const;
    void resetToValue(double value);

    virtual double scaleFactor() const;

    template <typename T>
    T* setDistributionItemType();
    DistributionItem* distributionItem() const { return m_distribution.currentItem(); }
    SelectionProperty<DistributionItemCatalog>& distributionSelection() { return m_distribution; }

    bool isExpandGroupBox() const { return m_expandGroupBox; }
    void setExpandGroupBox(bool b) { m_expandGroupBox = b; }

    virtual std::unique_ptr<IDistribution1D> createDistribution1D() const;

protected:
    SelectionProperty<DistributionItemCatalog> m_distribution;
    bool m_expandGroupBox = true;
};

template <typename T>
T* BeamDistributionItem::setDistributionItemType()
{
    m_distribution.setCurrentItem<T>();
    return dynamic_cast<T*>(m_distribution.currentItem());
}

#endif // BORNAGAIN_GUI_MODEL_BEAM_BEAMDISTRIBUTIONITEM_H
