#!/bin/bash
# -*- shell-script -*-

test_frame_adjust()
{
    _Dbg_errmsg() {
	errmsg+=("$1")
    }
    _Dbg_msg() {
	msg+=("$@")
    }
    _Dbg_print_location_and_command() {
	:
    }
    _Dbg_running=1
    _Dbg_stack_size=${#FUNCNAME[@]}
    typeset -a errmsg=()
    typeset -i i
    
    # Test frame_adjust parameter checking
    _Dbg_frame_adjust a
    assertNotEquals "Invalid frame_adjust 'a'" 0 "$?"

    _Dbg_frame_adjust
    assertNotEquals 'no adjust parameter' 0 "$?"

    _Dbg_stack_size=${#FUNCNAME[@]}
    _Dbg_running=1
    # Test absolute positioning - ok values (0..3)
    _Dbg_stack_pos=0
    for i in 0 1 -1 ; do
    	_Dbg_frame_adjust $i 0
    	assertEquals "_Dbg_frame_adjust $i should work - " 0 ${#errmsg[@]}
    done

    # Test invalid values
    for pair in '4 0' '5 -1' '3 +1' '-6 0'; do 
    	unset errmsg; errmsg=()
    	typeset _Dbg_stack_pos=2
    	_Dbg_frame_adjust $pair
    	assertNotEquals "Should get error for pair $pair -" 0 "$?"
    	assertNotEquals 0 ${#errmsg[@]}
    done
}

test_frame_adjusted_pos() 
{
    _Dbg_running=1
    _Dbg_stack_size=0
    typeset -li pos
    pos=$(_Dbg_frame_adjusted_pos -1)
    typeset -li pos2
    (( pos2 = _Dbg_stack_size - 1 ))
    pos2=$(_Dbg_frame_adjusted_pos $pos2)
    assertEquals "_Dbg_frame_adjusted_pos -1 should be _Dbg_stack_size-1" $pos $pos2
}

get_parms() 
{
    ## typeset -p BASH_ARGV
    ## typeset -p BASH_ARGC
    ## typeset -p FUNCNAME
    _Dbg_frame_fn_param_str
    if [[ "$1" == "test-two" ]] ; then 
	_Dbg_frame_fn_param_str
    fi
}

double_call()
{
    _Dbg_next_argc=0
    _Dbg_next_argv=0
    get_parms test-two a b 
    assertEquals 2 $_Dbg_next_argc
    assertEquals 6 $_Dbg_next_argv
    assertEquals '"d", "e", "f"' "$_Dbg_parm_str"
}

test_frame_fn_param_str()
{
    _Dbg_frame_fn_param_str 'a'
    assertNotEquals "Wrong number of params" 0 "$?"
    _Dbg_frame_next_argc='bogus'
    _Dbg_frame_fn_param_str
    assertNotEquals "Invalid _Dbg_next_argc" 0 "$?"
    _Dbg_next_argc=0
    _Dbg_next_argv='bogus'
    _Dbg_frame_fn_param_str
    assertNotEquals "Invalid _Dbg_next_argv" 0 "$?"

    _Dbg_next_argc=0
    _Dbg_next_argv=0
    get_parms first second
    assertEquals "valid _Dbg_frame_fn_param_str" 0 "$?"
    assertEquals '"first", "second"' "$_Dbg_parm_str"
    assertEquals 1 $_Dbg_next_argc
    assertEquals 2 $_Dbg_next_argv

    _Dbg_next_argc=0
    _Dbg_next_argv=0
    get_parms another-test
    assertEquals "valid _Dbg_frame_fn_param_str" 0 "$?"
    assertEquals '"another-test"' "$_Dbg_parm_str"

    _Dbg_next_argc=0
    _Dbg_next_argv=0
    get_parms three parameters now
    assertEquals "valid _Dbg_frame_fn_param_str" 0 "$?"
    assertEquals '"three", "parameters", "now"' "$_Dbg_parm_str"

    _Dbg_next_argc=0
    _Dbg_next_argv=0
    get_parms
    assertEquals "valid _Dbg_frame_fn_param_str" 0 "$?"
    assertEquals '' "$_Dbg_parm_str"

    _Dbg_next_argc=0
    _Dbg_next_argv=0
    get_parms
    assertEquals "valid _Dbg_frame_fn_param_str" 0 "$?"
    assertEquals '' "$_Dbg_parm_str"

    double_call d e f
}

test_frame_prefix()
{
    typeset -li _Dbg_stack_size=4
    typeset -li _Dbg_stack_pos=0
    typeset -li i
    typeset -l prefix
    for i in 0 1 2 3 ; do
	_Dbg_stack_pos=$i
	prefix=$(_Dbg_frame_prefix i)
	assertEquals 'Should give 0 return' 0 $?
	assertEquals "prefix $i should be ->" '->' $prefix
    done
    _Dbg_stack_pos=0
    for i in 1 2 3 ; do
	prefix=$(_Dbg_frame_prefix i)
	assertEquals 'Should give 0 return' 0 $?
	assertEquals "prefix $i should be ##" '##' $prefix
    done
    for i in -1 4 11 ; do
	prefix=$(_Dbg_frame_prefix i)
	assertEquals "prefix $i should be ??" '??' $prefix
    done
    prefix=$(_Dbg_frame_prefix 1 2 )
    assertNotEquals "invalid _Dbg_frame_prefix call ($?)" 0 '$?'
}

test_frame_print()
{
    typeset result='bogus'

    function _Dbg_msg {
	msg=$1
    }
    
    msg=''
    _Dbg_frame_print '->' 0 '' dbg-cmds.sh 2 ''

    assertEquals "->0 in file \`dbg-cmds.sh' at line 2" "$msg"
}

if [ '/src/external-vcs/bashdb' = '' ] ; then
  echo "Something is wrong: abs_top_srcdir is not set."
 exit 1
fi
abs_top_srcdir=/src/external-vcs/bashdb
# Make sure $abs_top_srcrdir has a trailing slash
abs_top_srcdir=${abs_top_srcdir%%/}/
. ${abs_top_srcdir}test/unit/helper.sh
. ${abs_top_srcdir}init/vars.sh
. ${abs_top_srcdir}init/pre.sh
. ${abs_top_srcdir}lib/file.sh
. ${abs_top_srcdir}lib/frame.sh
. ${abs_top_srcdir}lib/run.sh
. ${abs_top_srcdir}lib/validate.sh
set -- # reset $# so shunit2 doesn't get confused.

[[ $0 == ${BASH_SOURCE} ]] && . ${shunit_file}
