/* errno.c - error codes for libpiw
 *
 * author(s): Tom Lord
 ****************************************************************
 * Copyright (C) 1998 UUNET Technologies, Inc.
 *
 * See the file "COPYING.PIW" for further information
 * about the copyright status of this work.
 */


#include "hackerlab/piw-malloc/errno.h"


/************************************************************************
 *(h2 "PIW Allocation Function Error Codes")
 * 
 * The functions `piw_malloc', `piw_realloc', `piw_free',
 * `piw_allocation_size' return error codes when certain errors occur.
 * These codes are listed here and in `"hackerlab/piw-malloc/errno.h"'.
 *
 * 	piw_enoerror		no error
 * 	piw_espace		out of memory
 * 	piw_esize		absurd allocation size
 * 	piw_emalloc_header	corrupted malloc header or 
 *				not a malloced region
 */


t_uchar * piw_error_msg[] =
{
#undef PIW_ERRNO
#define PIW_ERRNO(A,B)	B,
  PIW_ERRNO_LIST
};


