/* This file is part of the 'atomes' software

'atomes' is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with 'atomes'.
If not, see <https://www.gnu.org/licenses/>

Copyright (C) 2022-2025 by CNRS and University of Strasbourg */

/*!
* @file cp2k_gth-basis.c
* @short CP2K GTH basis set, as delivered with CP2K v9.1
* @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>
*/

/*
* This file: 'cp2k_gth-basis.c'
*
* Contains:
*

  - CP2K GTH basis set, as delivered with CP2K v9.1

  This file contains 3 tables:

  gth_elem -> the list of chemical elements
  gth_keys -> the list of keywords
  cp2k_gth -> finally the complete GTH basis set

*/

#include "global.h"

char * gth_elem[156] = {"H",
"H",
"H",
"H",
"H",
"H",
"H",
"H",
"H",
"H",
"H",
"H",
"He",
"He",
"He",
"He",
"He",
"He",
"He",
"Li",
"Li",
"Li",
"Li",
"Li",
"Li",
"Be",
"Be",
"Be",
"Be",
"Be",
"Be",
"B",
"B",
"B",
"B",
"B",
"B",
"C",
"C",
"C",
"C",
"C",
"C",
"C",
"C",
"C",
"C",
"C",
"N",
"N",
"N",
"N",
"N",
"N",
"N",
"N",
"N",
"N",
"N",
"O",
"O",
"O",
"O",
"O",
"O",
"O",
"O",
"O",
"O",
"O",
"F",
"F",
"F",
"F",
"F",
"F",
"F",
"F",
"F",
"F",
"F",
"Ne",
"Ne",
"Ne",
"Ne",
"Ne",
"Ne",
"Na",
"Na",
"Na",
"Na",
"Na",
"Na",
"Mg",
"Mg",
"Mg",
"Mg",
"Mg",
"Mg",
"Al",
"Al",
"Al",
"Al",
"Al",
"Al",
"Si",
"Si",
"Si",
"Si",
"Si",
"Si",
"Si",
"Si",
"Si",
"Si",
"Si",
"P",
"P",
"P",
"P",
"P",
"P",
"P",
"P",
"P",
"P",
"P",
"S",
"S",
"S",
"S",
"S",
"S",
"S",
"S",
"S",
"S",
"S",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Cl",
"Ar",
"Ar",
"Ar",
"Ar",
"Ar",
"Ar",
"W"};

char * gth_keys[156] = {"SZV-GTH",
"DZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"aug-DZVP-GTH",
"aug-TZVP-GTH",
"aug-TZV2P-GTH",
"aug-QZV2P-GTH",
"aug-QZV3P-GTH",
"SZV-GTH",
"DZVP-GTH",
"TZVP-GTH",
"TZV2P-GTH",
"QZV2P-GTH",
"QZV3P-GTH",
"DZVP-GTH"};

char * cp2k_gth[156] = {"\n"
"H SZV-GTH-q1 SZV-GTH\n"
"  1\n"
"  1  0  0  4  1\n"
"        8.3744350009  -0.0283380461\n"
"        1.8058681460  -0.1333810052\n"
"        0.4852528328  -0.3995676063\n"
"        0.1658236932  -0.5531027541\n"
"#","\n"
"H DZV-GTH-q1 DZV-GTH\n"
"  1\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0283380461   0.0000000000\n"
"        1.8058681460  -0.1333810052   0.0000000000\n"
"        0.4852528328  -0.3995676063   0.0000000000\n"
"        0.1658236932  -0.5531027541   1.0000000000\n"
"#","\n"
"H DZVP-GTH-q1 DZVP-GTH\n"
"  2\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0283380461   0.0000000000\n"
"        1.8058681460  -0.1333810052   0.0000000000\n"
"        0.4852528328  -0.3995676063   0.0000000000\n"
"        0.1658236932  -0.5531027541   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7270000000   1.0000000000\n"
"#","\n"
"H TZVP-GTH-q1 TZVP-GTH\n"
"  2\n"
"  1  0  0  5  3\n"
"       10.8827241585  -0.0167058885   0.0000000000   0.0000000000\n"
"        3.0968750876  -0.0627538300   0.0000000000   0.0000000000\n"
"        0.9874518162  -0.1917521975   0.0000000000   0.0000000000\n"
"        0.3450687533  -0.4173635232   1.0000000000   0.0000000000\n"
"        0.1492693554  -0.4270508887   0.0000000000   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7270000000   1.0000000000\n"
"#","\n"
"H TZV2P-GTH-q1 TZV2P-GTH\n"
"  2\n"
"  1  0  0  5  3\n"
"       10.8827241585  -0.0167058885   0.0000000000   0.0000000000\n"
"        3.0968750876  -0.0627538300   0.0000000000   0.0000000000\n"
"        0.9874518162  -0.1917521975   0.0000000000   0.0000000000\n"
"        0.3450687533  -0.4173635232   1.0000000000   0.0000000000\n"
"        0.1492693554  -0.4270508887   0.0000000000   1.0000000000\n"
"  2  1  1  2  2\n"
"        1.4070000000   1.0000000000   0.0000000000\n"
"        0.3880000000   0.0000000000   1.0000000000\n"
"#","\n"
"H QZV2P-GTH-q1 QZV2P-GTH\n"
"  2\n"
"  1  0  0  6  4\n"
"       12.5350945530   0.0114321687   0.0000000000   0.0000000000   0.0000000000\n"
"        4.5491539489   0.0344048283   0.0000000000   0.0000000000   0.0000000000\n"
"        1.6685193606   0.1007746979   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6523849556   0.2302169182   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2733011244   0.4067637930   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1390608890   0.3322841300   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  2  2\n"
"        1.4070000000   1.0000000000   0.0000000000\n"
"        0.3880000000   0.0000000000   1.0000000000\n"
"#","\n"
"H QZV3P-GTH-q1 QZV3P-GTH\n"
"  2\n"
"  1  0  0  6  4\n"
"       12.5350945530   0.0114321687   0.0000000000   0.0000000000   0.0000000000\n"
"        4.5491539489   0.0344048283   0.0000000000   0.0000000000   0.0000000000\n"
"        1.6685193606   0.1007746979   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6523849556   0.2302169182   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2733011244   0.4067637930   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1390608890   0.3322841300   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  3  3\n"
"        2.2920000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.8380000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2920000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"H aug-DZVP-GTH-q1 aug-DZVP-GTH\n"
"  4\n"
"  1  0  0  4  2\n"
"        8.3744350009  -0.0283380461   0.0000000000\n"
"        1.8058681460  -0.1333810052   0.0000000000\n"
"        0.4852528328  -0.3995676063   0.0000000000\n"
"        0.1658236932  -0.5531027541   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7270000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.0297400000   1.0000000000\n"
"  3  1  1  1  1\n"
"        0.1410000000   1.0000000000\n"
"#","\n"
"H aug-TZVP-GTH-q1 aug-TZVP-GTH\n"
"  4\n"
"  1  0  0  5  3\n"
"       10.8827241585  -0.0167058885   0.0000000000   0.0000000000\n"
"        3.0968750876  -0.0627538300   0.0000000000   0.0000000000\n"
"        0.9874518162  -0.1917521975   0.0000000000   0.0000000000\n"
"        0.3450687533  -0.4173635232   1.0000000000   0.0000000000\n"
"        0.1492693554  -0.4270508887   0.0000000000   1.0000000000\n"
"  2  1  1  1  1\n"
"        0.7270000000   1.0000000000\n"
"  4  0  0  1  1\n"
"        0.0252600000   1.0000000000\n"
"  3  1  1  1  1\n"
"        0.1020000000   1.0000000000\n"
"#","\n"
"H aug-TZV2P-GTH-q1 aug-TZV2P-GTH\n"
"  4\n"
"  1  0  0  5  3\n"
"       10.8827241585  -0.0167058885   0.0000000000   0.0000000000\n"
"        3.0968750876  -0.0627538300   0.0000000000   0.0000000000\n"
"        0.9874518162  -0.1917521975   0.0000000000   0.0000000000\n"
"        0.3450687533  -0.4173635232   1.0000000000   0.0000000000\n"
"        0.1492693554  -0.4270508887   0.0000000000   1.0000000000\n"
"  2  1  1  2  2\n"
"        1.4070000000   1.0000000000   0.0000000000\n"
"        0.3880000000   0.0000000000   1.0000000000\n"
"  4  0  0  1  1\n"
"        0.0252600000   1.0000000000\n"
"  4  1  1  1  1\n"
"        0.1020000000   1.0000000000\n"
"#","\n"
"H aug-QZV2P-GTH-q1 aug-QZV2P-GTH\n"
"  4\n"
"  1  0  0  6  4\n"
"       12.5350945530   0.0114321687   0.0000000000   0.0000000000   0.0000000000\n"
"        4.5491539489   0.0344048283   0.0000000000   0.0000000000   0.0000000000\n"
"        1.6685193606   0.1007746979   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6523849556   0.2302169182   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2733011244   0.4067637930   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1390608890   0.3322841300   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  2  2\n"
"        1.4070000000   1.0000000000   0.0000000000\n"
"        0.3880000000   0.0000000000   1.0000000000\n"
"  5  0  0  1  1\n"
"        0.0236300000   1.0000000000\n"
"  4  1  1  1  1\n"
"        0.0848000000   1.0000000000\n"
"#","\n"
"H aug-QZV3P-GTH-q1 aug-QZV3P-GTH\n"
"  4\n"
"  1  0  0  6  4\n"
"       12.5350945530   0.0114321687   0.0000000000   0.0000000000   0.0000000000\n"
"        4.5491539489   0.0344048283   0.0000000000   0.0000000000   0.0000000000\n"
"        1.6685193606   0.1007746979   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6523849556   0.2302169182   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2733011244   0.4067637930   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1390608890   0.3322841300   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  3  3\n"
"        2.2920000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.8380000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2920000000   0.0000000000   0.0000000000   1.0000000000\n"
"  5  0  0  1  1\n"
"        0.0236300000   1.0000000000\n"
"  5  1  1  1  1\n"
"        0.0848000000   1.0000000000\n"
"#","\n"
"He SZV-GTH-q2 SZV-GTH\n"
"  1\n"
"  1  0  0  5  1\n"
"       13.1305278312  -0.0500802904\n"
"        4.1977275150  -0.1474339352\n"
"        1.3647725570  -0.3245281495\n"
"        0.4549715461  -0.4365284986\n"
"        0.1513197845  -0.2164629317\n"
"#","\n"
"He DZV-GTH-q2 DZV-GTH\n"
"  1\n"
"  1  0  0  5  2\n"
"       13.1305278312  -0.0500802904   0.0000000000\n"
"        4.1977275150  -0.1474339352   0.0000000000\n"
"        1.3647725570  -0.3245281495   0.0000000000\n"
"        0.4549715461  -0.4365284986   0.0000000000\n"
"        0.1513197845  -0.2164629317   1.0000000000\n"
"#","\n"
"He DZVP-GTH-q2 DZVP-GTH\n"
"  2\n"
"  1  0  0  5  2\n"
"       13.1305278312  -0.0500802904   0.0000000000\n"
"        4.1977275150  -0.1474339352   0.0000000000\n"
"        1.3647725570  -0.3245281495   0.0000000000\n"
"        0.4549715461  -0.4365284986   0.0000000000\n"
"        0.1513197845  -0.2164629317   1.0000000000\n"
"  2  1  1  1  1\n"
"        1.2750000000   1.0000000000\n"
"#","\n"
"He TZVP-GTH-q2 TZVP-GTH\n"
"  2\n"
"  1  0  0  6  3\n"
"       14.9231368362   0.0343142688   0.0000000000   0.0000000000\n"
"        5.9479610723   0.0933152472   0.0000000000   0.0000000000\n"
"        2.1932485067   0.2143451850   0.0000000000   0.0000000000\n"
"        0.8304881034   0.3500759421   0.0000000000   0.0000000000\n"
"        0.3182586587   0.3570840512   1.0000000000   0.0000000000\n"
"        0.1197839846   0.1270021790   0.0000000000   1.0000000000\n"
"  2  1  1  1  1\n"
"        1.2750000000   1.0000000000\n"
"#","\n"
"He TZV2P-GTH-q2 TZV2P-GTH\n"
"  2\n"
"  1  0  0  6  3\n"
"       14.9231368362   0.0343142688   0.0000000000   0.0000000000\n"
"        5.9479610723   0.0933152472   0.0000000000   0.0000000000\n"
"        2.1932485067   0.2143451850   0.0000000000   0.0000000000\n"
"        0.8304881034   0.3500759421   0.0000000000   0.0000000000\n"
"        0.3182586587   0.3570840512   1.0000000000   0.0000000000\n"
"        0.1197839846   0.1270021790   0.0000000000   1.0000000000\n"
"  2  1  1  2  2\n"
"        3.0440000000   1.0000000000   0.0000000000\n"
"        0.7580000000   0.0000000000   1.0000000000\n"
"#","\n"
"He QZV2P-GTH-q2 QZV2P-GTH\n"
"  2\n"
"  1  0  0  7  4\n"
"       16.7962354569  -0.0217345796   0.0000000000   0.0000000000   0.0000000000\n"
"        8.0784265748  -0.0637981790   0.0000000000   0.0000000000   0.0000000000\n"
"        3.2397448253  -0.1438730374   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3463173459  -0.2567923947   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5669193043  -0.3407783682   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2404041556  -0.2752209877   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0990547078  -0.0742573863   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  2  2\n"
"        3.0440000000   1.0000000000   0.0000000000\n"
"        0.7580000000   0.0000000000   1.0000000000\n"
"#","\n"
"He QZV3P-GTH-q2 QZV3P-GTH\n"
"  2\n"
"  1  0  0  7  4\n"
"       16.7962354569  -0.0217345796   0.0000000000   0.0000000000   0.0000000000\n"
"        8.0784265748  -0.0637981790   0.0000000000   0.0000000000   0.0000000000\n"
"        3.2397448253  -0.1438730374   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3463173459  -0.2567923947   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5669193043  -0.3407783682   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2404041556  -0.2752209877   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0990547078  -0.0742573863   0.0000000000   0.0000000000   1.0000000000\n"
"  2  1  1  3  3\n"
"        5.9940000000   1.0000000000   0.0000000000   0.0000000000\n"
"        1.7450000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.5600000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Li SZV-GTH-q3 SZV-GTH\n"
"  1\n"
"  1  0  0  5  2\n"
"        7.2610457926  -0.2798628497   0.0501840556\n"
"        2.1056583087  -0.4477420790   0.1084202571\n"
"        0.6439906571  -0.3912929157   0.1448363201\n"
"        0.0797152017  -0.0282408543  -0.4643021689\n"
"        0.0294029590   0.0106542324  -0.6220213304\n"
"#","\n"
"Li DZVP-GTH-q3 DZVP-GTH\n"
"  2\n"
"  1  0  1  5  3  2\n"
"        7.2610457926  -0.2798628497   0.0501840556   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1056583087  -0.4477420790   0.1084202571   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6439906571  -0.3912929157   0.1448363201   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0797152017  -0.0282408543  -0.4643021689   0.0000000000   0.0000000000   1.0000000000\n"
"        0.0294029590   0.0106542324  -0.6220213304   1.0000000000   0.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        0.1239000000   1.0000000000\n"
"#","\n"
"Li TZVP-GTH-q3 TZVP-GTH\n"
"  2\n"
"  1  0  1  6  4  3\n"
"        9.0670525492  -0.1411283591   0.0257097367   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        4.3499909489  -0.2767569948   0.0520569091   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4348215636  -0.4501634495   0.1264219750   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4970537951  -0.2617675690   0.1024067911   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0729943466  -0.0116685753  -0.5635707625   1.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0264328979   0.0038616721  -0.5290102979   0.0000000000   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1239000000   1.0000000000\n"
"#","\n"
"Li TZV2P-GTH-q3 TZV2P-GTH\n"
"  2\n"
"  1  0  1  6  4  3\n"
"        9.0670525492  -0.1411283591   0.0257097367   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        4.3499909489  -0.2767569948   0.0520569091   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4348215636  -0.4501634495   0.1264219750   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4970537951  -0.2617675690   0.1024067911   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0729943466  -0.0116685753  -0.5635707625   1.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0264328979   0.0038616721  -0.5290102979   0.0000000000   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.1874000000   1.0000000000   0.0000000000\n"
"        0.0801000000   0.0000000000   1.0000000000\n"
"#","\n"
"Li QZV2P-GTH-q3 QZV2P-GTH\n"
"  2\n"
"  1  0  1  7  5  4\n"
"       11.2399728913   0.0546031957   0.0121121394   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        5.9010009273   0.2707752256   0.0442943986   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1128841305   0.3250518116   0.0864603159   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9242200694   0.3360526690   0.0982556510   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.3843405136   0.1477938090   0.0724371635   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0745791133   0.0049656060  -0.5608077915   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0266127545  -0.0013302258  -0.5385875662   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.1874000000   1.0000000000   0.0000000000\n"
"        0.0801000000   0.0000000000   1.0000000000\n"
"#","\n"
"Li QZV3P-GTH-q3 QZV3P-GTH\n"
"  2\n"
"  1  0  1  7  5  4\n"
"       11.2399728913   0.0546031957   0.0121121394   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        5.9010009273   0.2707752256   0.0442943986   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1128841305   0.3250518116   0.0864603159   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9242200694   0.3360526690   0.0982556510   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.3843405136   0.1477938090   0.0724371635   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0745791133   0.0049656060  -0.5608077915   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0266127545  -0.0013302258  -0.5385875662   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        0.3440000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1530000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0680000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Be SZV-GTH-q4 SZV-GTH\n"
"  1\n"
"  1  0  0  5  2\n"
"       12.0759365620  -0.2957180545   0.0588372089\n"
"        3.8545761940  -0.4334460398   0.1288856096\n"
"        1.2504781570  -0.3784683226   0.1550415386\n"
"        0.1871714430  -0.0264606251  -0.5160084709\n"
"        0.0612757198   0.0081452640  -0.5935732462\n"
"#","\n"
"Be DZVP-GTH-q4 DZVP-GTH\n"
"  2\n"
"  1  0  1  5  3  2\n"
"       12.0759365620  -0.2957180545   0.0588372089   0.0000000000   0.0000000000   0.0000000000\n"
"        3.8545761940  -0.4334460398   0.1288856096   0.0000000000   0.0000000000   0.0000000000\n"
"        1.2504781570  -0.3784683226   0.1550415386   0.0000000000   0.0000000000   0.0000000000\n"
"        0.1871714430  -0.0264606251  -0.5160084709   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0612757198   0.0081452640  -0.5935732462   1.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2380000000   1.0000000000\n"
"#","\n"
"Be TZVP-GTH-q4 TZVP-GTH\n"
"  2\n"
"  1  0  1  6  4  3\n"
"       16.1633017560   0.1058505482   0.0252110810   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.2794656488   0.3142306535   0.0592234829   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.7431462702   0.4327355582   0.1590642952   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0051192904   0.2646375740   0.0970211162   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1765074807   0.0128485143  -0.5606394206   1.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0580432824  -0.0034494712  -0.5479256813   0.0000000000   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2380000000   1.0000000000\n"
"#","\n"
"Be TZV2P-GTH-q4 TZV2P-GTH\n"
"  2\n"
"  1  0  1  6  4  3\n"
"       16.1633017560   0.1058505482   0.0252110810   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.2794656488   0.3142306535   0.0592234829   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.7431462702   0.4327355582   0.1590642952   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0051192904   0.2646375740   0.0970211162   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1765074807   0.0128485143  -0.5606394206   1.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0580432824  -0.0034494712  -0.5479256813   0.0000000000   1.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.3480000000   1.0000000000   0.0000000000\n"
"        0.1803000000   0.0000000000   1.0000000000\n"
"#","\n"
"Be QZV2P-GTH-q4 QZV2P-GTH\n"
"  2\n"
"  1  0  1  7  5  4\n"
"       16.8878782250  -0.0871781047  -0.0213560020   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.7399964830  -0.3154557784  -0.0594803584   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.9043390390  -0.4227762231  -0.1487687019   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0791842760  -0.2848246813  -0.1164217493   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2337917550  -0.0252413708   0.2786030195   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1037025890   0.0110215162   0.5642008017   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0421510390  -0.0028677576   0.2754009863   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.3480000000   1.0000000000   0.0000000000\n"
"        0.1803000000   0.0000000000   1.0000000000\n"
"#","\n"
"Be QZV3P-GTH-q4 QZV3P-GTH\n"
"  2\n"
"  1  0  1  7  5  4\n"
"       16.8878782250  -0.0871781047  -0.0213560020   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        8.7399964830  -0.3154557784  -0.0594803584   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        2.9043390390  -0.4227762231  -0.1487687019   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0791842760  -0.2848246813  -0.1164217493   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2337917550  -0.0252413708   0.2786030195   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1037025890   0.0110215162   0.5642008017   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0421510390  -0.0028677576   0.2754009863   0.0000000000   0.0000000000   1.0000000000   0.0000000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.0720000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4410000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1811000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"B SZV-GTH-q3 SZV-GTH\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        2.8854084023   0.1420731829  -0.0759815770\n"
"        0.8566849689  -0.0083257749  -0.2508281584\n"
"        0.2712991753  -0.6707104603  -0.4610296144\n"
"        0.0826101984  -0.4241277148  -0.4419922734\n"
"#","\n"
"B DZVP-GTH-q3 DZVP-GTH\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        2.8854084023   0.1420731829   0.0000000000  -0.0759815770   0.0000000000\n"
"        0.8566849689  -0.0083257749   0.0000000000  -0.2508281584   0.0000000000\n"
"        0.2712991753  -0.6707104603   0.0000000000  -0.4610296144   0.0000000000\n"
"        0.0826101984  -0.4241277148   1.0000000000  -0.4419922734   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3430000000   1.0000000000\n"
"#","\n"
"B TZVP-GTH-q3 TZVP-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"        3.5725567849   0.0919963366   0.0000000000   0.0000000000  -0.0431808210   0.0000000000   0.0000000000\n"
"        1.3258097706   0.1075235422   0.0000000000   0.0000000000  -0.1511855730   0.0000000000   0.0000000000\n"
"        0.4583887751  -0.3415470752   0.0000000000   0.0000000000  -0.3429313866   0.0000000000   0.0000000000\n"
"        0.1620866416  -0.6439245174   1.0000000000   0.0000000000  -0.4414563660   1.0000000000   0.0000000000\n"
"        0.0559199264  -0.1753147308   0.0000000000   1.0000000000  -0.2681154092   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3430000000   1.0000000000\n"
"#","\n"
"B TZV2P-GTH-q3 TZV2P-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"        3.5725567849   0.0919963366   0.0000000000   0.0000000000  -0.0431808210   0.0000000000   0.0000000000\n"
"        1.3258097706   0.1075235422   0.0000000000   0.0000000000  -0.1511855730   0.0000000000   0.0000000000\n"
"        0.4583887751  -0.3415470752   0.0000000000   0.0000000000  -0.3429313866   0.0000000000   0.0000000000\n"
"        0.1620866416  -0.6439245174   1.0000000000   0.0000000000  -0.4414563660   1.0000000000   0.0000000000\n"
"        0.0559199264  -0.1753147308   0.0000000000   1.0000000000  -0.2681154092   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.6610000000   1.0000000000   0.0000000000\n"
"        0.1990000000   0.0000000000   1.0000000000\n"
"#","\n"
"B QZV2P-GTH-q3 QZV2P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"        4.1102306804  -0.0620335875   0.0000000000   0.0000000000   0.0000000000   0.0278217612   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7172984348  -0.1274529700   0.0000000000   0.0000000000   0.0000000000   0.1085525628   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6589800479   0.1200448703   0.0000000000   0.0000000000   0.0000000000   0.2367567166   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2700358860   0.5129734657   1.0000000000   0.0000000000   0.0000000000   0.3599759140   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1081818865   0.4555842541   0.0000000000   1.0000000000   0.0000000000   0.3683676413   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0406426579   0.0612204758   0.0000000000   0.0000000000   1.0000000000   0.1513382480   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.6610000000   1.0000000000   0.0000000000\n"
"        0.1990000000   0.0000000000   1.0000000000\n"
"#","\n"
"B QZV3P-GTH-q3 QZV3P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"        4.1102306804  -0.0620335875   0.0000000000   0.0000000000   0.0000000000   0.0278217612   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7172984348  -0.1274529700   0.0000000000   0.0000000000   0.0000000000   0.1085525628   0.0000000000   0.0000000000   0.0000000000\n"
"        0.6589800479   0.1200448703   0.0000000000   0.0000000000   0.0000000000   0.2367567166   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2700358860   0.5129734657   1.0000000000   0.0000000000   0.0000000000   0.3599759140   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1081818865   0.4555842541   0.0000000000   1.0000000000   0.0000000000   0.3683676413   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0406426579   0.0612204758   0.0000000000   0.0000000000   1.0000000000   0.1513382480   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.1100000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4020000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1450000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"C SZV-GTH-q4 SZV-GTH\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        4.3362376436   0.1490797872  -0.0878123619\n"
"        1.2881838513  -0.0292640031  -0.2775560300\n"
"        0.4037767149  -0.6882040510  -0.4712295093\n"
"        0.1187877657  -0.3964426906  -0.4058039291\n"
"#","\n"
"C DZVP-GTH-q4 DZVP-GTH\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        4.3362376436   0.1490797872   0.0000000000  -0.0878123619   0.0000000000\n"
"        1.2881838513  -0.0292640031   0.0000000000  -0.2775560300   0.0000000000\n"
"        0.4037767149  -0.6882040510   0.0000000000  -0.4712295093   0.0000000000\n"
"        0.1187877657  -0.3964426906   1.0000000000  -0.4058039291   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"C TZVP-GTH-q4 TZVP-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"        5.3685662937   0.0974901974   0.0000000000   0.0000000000  -0.0510969367   0.0000000000   0.0000000000\n"
"        1.9830691554   0.1041996677   0.0000000000   0.0000000000  -0.1693035193   0.0000000000   0.0000000000\n"
"        0.6978346167  -0.3645093878   0.0000000000   0.0000000000  -0.3579933930   0.0000000000   0.0000000000\n"
"        0.2430968816  -0.6336931464   1.0000000000   0.0000000000  -0.4327616531   1.0000000000   0.0000000000\n"
"        0.0812865018  -0.1676727564   0.0000000000   1.0000000000  -0.2457672757   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"#","\n"
"C TZV2P-GTH-q4 TZV2P-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"        5.3685662937   0.0974901974   0.0000000000   0.0000000000  -0.0510969367   0.0000000000   0.0000000000\n"
"        1.9830691554   0.1041996677   0.0000000000   0.0000000000  -0.1693035193   0.0000000000   0.0000000000\n"
"        0.6978346167  -0.3645093878   0.0000000000   0.0000000000  -0.3579933930   0.0000000000   0.0000000000\n"
"        0.2430968816  -0.6336931464   1.0000000000   0.0000000000  -0.4327616531   1.0000000000   0.0000000000\n"
"        0.0812865018  -0.1676727564   0.0000000000   1.0000000000  -0.2457672757   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0970000000   1.0000000000   0.0000000000\n"
"        0.3180000000   0.0000000000   1.0000000000\n"
"#","\n"
"C QZV2P-GTH-q4 QZV2P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"        6.2117903778  -0.0646967401   0.0000000000   0.0000000000   0.0000000000   0.0325569458   0.0000000000   0.0000000000   0.0000000000\n"
"        2.6063423906  -0.1297753357   0.0000000000   0.0000000000   0.0000000000   0.1202876489   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0110258071   0.1365330322   0.0000000000   0.0000000000   0.0000000000   0.2556810166   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4099767831   0.5183875877   1.0000000000   0.0000000000   0.0000000000   0.3643736556   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1615409293   0.4426674841   0.0000000000   1.0000000000   0.0000000000   0.3489621232   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0597349919   0.0598757918   0.0000000000   0.0000000000   1.0000000000   0.1399973180   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0970000000   1.0000000000   0.0000000000\n"
"        0.3180000000   0.0000000000   1.0000000000\n"
"#","\n"
"C QZV3P-GTH-q4 QZV3P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"        6.2117903778  -0.0646967401   0.0000000000   0.0000000000   0.0000000000   0.0325569458   0.0000000000   0.0000000000   0.0000000000\n"
"        2.6063423906  -0.1297753357   0.0000000000   0.0000000000   0.0000000000   0.1202876489   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0110258071   0.1365330322   0.0000000000   0.0000000000   0.0000000000   0.2556810166   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4099767831   0.5183875877   1.0000000000   0.0000000000   0.0000000000   0.3643736556   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1615409293   0.4426674841   0.0000000000   1.0000000000   0.0000000000   0.3489621232   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0597349919   0.0598757918   0.0000000000   0.0000000000   1.0000000000   0.1399973180   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.8480000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.6490000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2280000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"C aug-DZVP-GTH-q4 aug-DZVP-GTH\n"
"  4\n"
"  2  0  1  4  2  2\n"
"        4.3362376436   0.1490797872   0.0000000000  -0.0878123619   0.0000000000\n"
"        1.2881838513  -0.0292640031   0.0000000000  -0.2775560300   0.0000000000\n"
"        0.4037767149  -0.6882040510   0.0000000000  -0.4712295093   0.0000000000\n"
"        0.1187877657  -0.3964426906   1.0000000000  -0.4058039291   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.04690000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.04041000     1.0000000000\n"
"#","\n"
"C aug-TZVP-GTH-q4 aug-TZVP-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"        5.3685662937   0.0974901974   0.0000000000   0.0000000000  -0.0510969367   0.0000000000   0.0000000000\n"
"        1.9830691554   0.1041996677   0.0000000000   0.0000000000  -0.1693035193   0.0000000000   0.0000000000\n"
"        0.6978346167  -0.3645093878   0.0000000000   0.0000000000  -0.3579933930   0.0000000000   0.0000000000\n"
"        0.2430968816  -0.6336931464   1.0000000000   0.0000000000  -0.4327616531   1.0000000000   0.0000000000\n"
"        0.0812865018  -0.1676727564   0.0000000000   1.0000000000  -0.2457672757   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.5500000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.04402000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.03569000     1.0000000000\n"
"#","\n"
"C aug-TZV2P-GTH-q4 aug-TZV2P-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"        5.3685662937   0.0974901974   0.0000000000   0.0000000000  -0.0510969367   0.0000000000   0.0000000000\n"
"        1.9830691554   0.1041996677   0.0000000000   0.0000000000  -0.1693035193   0.0000000000   0.0000000000\n"
"        0.6978346167  -0.3645093878   0.0000000000   0.0000000000  -0.3579933930   0.0000000000   0.0000000000\n"
"        0.2430968816  -0.6336931464   1.0000000000   0.0000000000  -0.4327616531   1.0000000000   0.0000000000\n"
"        0.0812865018  -0.1676727564   0.0000000000   1.0000000000  -0.2457672757   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0970000000   1.0000000000   0.0000000000\n"
"        0.3180000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.04402000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.03569000     1.0000000000\n"
"#","\n"
"C aug-QZV2P-GTH-q4 aug-QZV2P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"        6.2117903778  -0.0646967401   0.0000000000   0.0000000000   0.0000000000   0.0325569458   0.0000000000   0.0000000000   0.0000000000\n"
"        2.6063423906  -0.1297753357   0.0000000000   0.0000000000   0.0000000000   0.1202876489   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0110258071   0.1365330322   0.0000000000   0.0000000000   0.0000000000   0.2556810166   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4099767831   0.5183875877   1.0000000000   0.0000000000   0.0000000000   0.3643736556   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1615409293   0.4426674841   0.0000000000   1.0000000000   0.0000000000   0.3489621232   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0597349919   0.0598757918   0.0000000000   0.0000000000   1.0000000000   0.1399973180   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0970000000   1.0000000000   0.0000000000\n"
"        0.3180000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.04145000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.03218000     1.0000000000\n"
"#","\n"
"C aug-QZV3P-GTH-q4 aug-QZV3P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"        6.2117903778  -0.0646967401   0.0000000000   0.0000000000   0.0000000000   0.0325569458   0.0000000000   0.0000000000   0.0000000000\n"
"        2.6063423906  -0.1297753357   0.0000000000   0.0000000000   0.0000000000   0.1202876489   0.0000000000   0.0000000000   0.0000000000\n"
"        1.0110258071   0.1365330322   0.0000000000   0.0000000000   0.0000000000   0.2556810166   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4099767831   0.5183875877   1.0000000000   0.0000000000   0.0000000000   0.3643736556   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1615409293   0.4426674841   0.0000000000   1.0000000000   0.0000000000   0.3489621232   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0597349919   0.0598757918   0.0000000000   0.0000000000   1.0000000000   0.1399973180   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.8480000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.6490000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2280000000   0.0000000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.04145000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.03218000     1.0000000000\n"
"#","\n"
"N SZV-GTH-q5 SZV-GTH\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        6.1526903413   0.1506300537  -0.0950603476\n"
"        1.8236332280  -0.0360100734  -0.2918864295\n"
"        0.5676628870  -0.6942023212  -0.4739050050\n"
"        0.1628222852  -0.3878929987  -0.3893418670\n"
"#","\n"
"N DZVP-GTH-q5 DZVP-GTH\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        6.1526903413   0.1506300537   0.0000000000  -0.0950603476   0.0000000000\n"
"        1.8236332280  -0.0360100734   0.0000000000  -0.2918864295   0.0000000000\n"
"        0.5676628870  -0.6942023212   0.0000000000  -0.4739050050   0.0000000000\n"
"        0.1628222852  -0.3878929987   1.0000000000  -0.3893418670   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8170000000   1.0000000000\n"
"#","\n"
"N TZVP-GTH-q5 TZVP-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"        7.6227447102   0.0983924689   0.0000000000   0.0000000000  -0.0561654555   0.0000000000   0.0000000000\n"
"        2.7970605447   0.1045217098   0.0000000000   0.0000000000  -0.1798165209   0.0000000000   0.0000000000\n"
"        0.9909765447  -0.3742661352   0.0000000000   0.0000000000  -0.3653986185   0.0000000000   0.0000000000\n"
"        0.3417314862  -0.6278094034   1.0000000000   0.0000000000  -0.4259126207   1.0000000000   0.0000000000\n"
"        0.1116822743  -0.1675236192   0.0000000000   1.0000000000  -0.2366040346   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8170000000   1.0000000000\n"
"#","\n"
"N TZV2P-GTH-q5 TZV2P-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"        7.6227447102   0.0983924689   0.0000000000   0.0000000000  -0.0561654555   0.0000000000   0.0000000000\n"
"        2.7970605447   0.1045217098   0.0000000000   0.0000000000  -0.1798165209   0.0000000000   0.0000000000\n"
"        0.9909765447  -0.3742661352   0.0000000000   0.0000000000  -0.3653986185   0.0000000000   0.0000000000\n"
"        0.3417314862  -0.6278094034   1.0000000000   0.0000000000  -0.4259126207   1.0000000000   0.0000000000\n"
"        0.1116822743  -0.1675236192   0.0000000000   1.0000000000  -0.2366040346   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.6540000000   1.0000000000   0.0000000000\n"
"        0.4690000000   0.0000000000   1.0000000000\n"
"#","\n"
"N QZV2P-GTH-q5 QZV2P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"        8.8030997240  -0.0653598725   0.0000000000   0.0000000000   0.0000000000   0.0363703004   0.0000000000   0.0000000000   0.0000000000\n"
"        3.6785202400  -0.1318019698   0.0000000000   0.0000000000   0.0000000000   0.1277243136   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4352947631   0.1465239013   0.0000000000   0.0000000000   0.0000000000   0.2667499496   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5774326402   0.5201300002   1.0000000000   0.0000000000   0.0000000000   0.3658846849   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2247320708   0.4360365020   0.0000000000   1.0000000000   0.0000000000   0.3370061673   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818920852   0.0597929754   0.0000000000   0.0000000000   1.0000000000   0.1349212947   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.6540000000   1.0000000000   0.0000000000\n"
"        0.4690000000   0.0000000000   1.0000000000\n"
"#","\n"
"N QZV3P-GTH-q5 QZV3P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"        8.8030997240  -0.0653598725   0.0000000000   0.0000000000   0.0000000000   0.0363703004   0.0000000000   0.0000000000   0.0000000000\n"
"        3.6785202400  -0.1318019698   0.0000000000   0.0000000000   0.0000000000   0.1277243136   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4352947631   0.1465239013   0.0000000000   0.0000000000   0.0000000000   0.2667499496   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5774326402   0.5201300002   1.0000000000   0.0000000000   0.0000000000   0.3658846849   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2247320708   0.4360365020   0.0000000000   1.0000000000   0.0000000000   0.3370061673   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818920852   0.0597929754   0.0000000000   0.0000000000   1.0000000000   0.1349212947   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        2.8370000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.9680000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.3350000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"N aug-DZVP-GTH-q5 aug-DZVP-GTH\n"
"  4\n"
"  2  0  1  4  2  2\n"
"        6.1526903413   0.1506300537   0.0000000000  -0.0950603476   0.0000000000\n"
"        1.8236332280  -0.0360100734   0.0000000000  -0.2918864295   0.0000000000\n"
"        0.5676628870  -0.6942023212   0.0000000000  -0.4739050050   0.0000000000\n"
"        0.1628222852  -0.3878929987   1.0000000000  -0.3893418670   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8170000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.06124000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.05611000     1.0000000000\n"
"#","\n"
"N aug-TZVP-GTH-q5 aug-TZVP-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"        7.6227447102   0.0983924689   0.0000000000   0.0000000000  -0.0561654555   0.0000000000   0.0000000000\n"
"        2.7970605447   0.1045217098   0.0000000000   0.0000000000  -0.1798165209   0.0000000000   0.0000000000\n"
"        0.9909765447  -0.3742661352   0.0000000000   0.0000000000  -0.3653986185   0.0000000000   0.0000000000\n"
"        0.3417314862  -0.6278094034   1.0000000000   0.0000000000  -0.4259126207   1.0000000000   0.0000000000\n"
"        0.1116822743  -0.1675236192   0.0000000000   1.0000000000  -0.2366040346   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.8170000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.05760000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.04910000     1.0000000000\n"
"#","\n"
"N aug-TZV2P-GTH-q5 aug-TZV2P-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"        7.6227447102   0.0983924689   0.0000000000   0.0000000000  -0.0561654555   0.0000000000   0.0000000000\n"
"        2.7970605447   0.1045217098   0.0000000000   0.0000000000  -0.1798165209   0.0000000000   0.0000000000\n"
"        0.9909765447  -0.3742661352   0.0000000000   0.0000000000  -0.3653986185   0.0000000000   0.0000000000\n"
"        0.3417314862  -0.6278094034   1.0000000000   0.0000000000  -0.4259126207   1.0000000000   0.0000000000\n"
"        0.1116822743  -0.1675236192   0.0000000000   1.0000000000  -0.2366040346   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.6540000000   1.0000000000   0.0000000000\n"
"        0.4690000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.05760000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.04910000     1.0000000000\n"
"#","\n"
"N aug-QZV2P-GTH-q5 aug-QZV2P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"        8.8030997240  -0.0653598725   0.0000000000   0.0000000000   0.0000000000   0.0363703004   0.0000000000   0.0000000000   0.0000000000\n"
"        3.6785202400  -0.1318019698   0.0000000000   0.0000000000   0.0000000000   0.1277243136   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4352947631   0.1465239013   0.0000000000   0.0000000000   0.0000000000   0.2667499496   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5774326402   0.5201300002   1.0000000000   0.0000000000   0.0000000000   0.3658846849   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2247320708   0.4360365020   0.0000000000   1.0000000000   0.0000000000   0.3370061673   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818920852   0.0597929754   0.0000000000   0.0000000000   1.0000000000   0.1349212947   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.6540000000   1.0000000000   0.0000000000\n"
"        0.4690000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.05464000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.04402000     1.0000000000\n"
"#","\n"
"N aug-QZV3P-GTH-q5 aug-QZV3P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"        8.8030997240  -0.0653598725   0.0000000000   0.0000000000   0.0000000000   0.0363703004   0.0000000000   0.0000000000   0.0000000000\n"
"        3.6785202400  -0.1318019698   0.0000000000   0.0000000000   0.0000000000   0.1277243136   0.0000000000   0.0000000000   0.0000000000\n"
"        1.4352947631   0.1465239013   0.0000000000   0.0000000000   0.0000000000   0.2667499496   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5774326402   0.5201300002   1.0000000000   0.0000000000   0.0000000000   0.3658846849   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2247320708   0.4360365020   0.0000000000   1.0000000000   0.0000000000   0.3370061673   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818920852   0.0597929754   0.0000000000   0.0000000000   1.0000000000   0.1349212947   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        2.8370000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.9680000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.3350000000   0.0000000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.05464000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.04402000     1.0000000000\n"
"#","\n"
"O SZV-GTH-q6 SZV-GTH\n"
"  1\n"
"  2  0  1  4  1  1\n"
"        8.3043855492   0.1510165999  -0.0995679273\n"
"        2.4579484191  -0.0393195364  -0.3011422449\n"
"        0.7597373434  -0.6971724029  -0.4750857083\n"
"        0.2136388632  -0.3841133622  -0.3798777957\n"
"#","\n"
"O DZVP-GTH-q6 DZVP-GTH\n"
"  2\n"
"  2  0  1  4  2  2\n"
"        8.3043855492   0.1510165999   0.0000000000  -0.0995679273   0.0000000000\n"
"        2.4579484191  -0.0393195364   0.0000000000  -0.3011422449   0.0000000000\n"
"        0.7597373434  -0.6971724029   0.0000000000  -0.4750857083   0.0000000000\n"
"        0.2136388632  -0.3841133622   1.0000000000  -0.3798777957   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.1850000000   1.0000000000\n"
"#","\n"
"O TZVP-GTH-q6 TZVP-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"       10.2674419938   0.0989598460   0.0000000000   0.0000000000  -0.0595856940   0.0000000000   0.0000000000\n"
"        3.7480495696   0.1041178339   0.0000000000   0.0000000000  -0.1875649045   0.0000000000   0.0000000000\n"
"        1.3308337704  -0.3808255700   0.0000000000   0.0000000000  -0.3700707718   0.0000000000   0.0000000000\n"
"        0.4556802254  -0.6232449802   1.0000000000   0.0000000000  -0.4204922615   1.0000000000   0.0000000000\n"
"        0.1462920596  -0.1677863491   0.0000000000   1.0000000000  -0.2313901687   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.1850000000   1.0000000000\n"
"#","\n"
"O TZV2P-GTH-q6 TZV2P-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"       10.2674419938   0.0989598460   0.0000000000   0.0000000000  -0.0595856940   0.0000000000   0.0000000000\n"
"        3.7480495696   0.1041178339   0.0000000000   0.0000000000  -0.1875649045   0.0000000000   0.0000000000\n"
"        1.3308337704  -0.3808255700   0.0000000000   0.0000000000  -0.3700707718   0.0000000000   0.0000000000\n"
"        0.4556802254  -0.6232449802   1.0000000000   0.0000000000  -0.4204922615   1.0000000000   0.0000000000\n"
"        0.1462920596  -0.1677863491   0.0000000000   1.0000000000  -0.2313901687   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        2.3140000000   1.0000000000   0.0000000000\n"
"        0.6450000000   0.0000000000   1.0000000000\n"
"#","\n"
"O QZV2P-GTH-q6 QZV2P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"       11.8298677444  -0.0658681959   0.0000000000   0.0000000000   0.0000000000   0.0389990698   0.0000000000   0.0000000000   0.0000000000\n"
"        4.9326307395  -0.1327117781   0.0000000000   0.0000000000   0.0000000000   0.1329824319   0.0000000000   0.0000000000   0.0000000000\n"
"        1.9312997298   0.1529660213   0.0000000000   0.0000000000   0.0000000000   0.2737974007   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7724003899   0.5206439978   1.0000000000   0.0000000000   0.0000000000   0.3663338041   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2976334392   0.4322622254   0.0000000000   1.0000000000   0.0000000000   0.3292638764   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1070061063   0.0599977177   0.0000000000   0.0000000000   1.0000000000   0.1324571183   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        2.3140000000   1.0000000000   0.0000000000\n"
"        0.6450000000   0.0000000000   1.0000000000\n"
"#","\n"
"O QZV3P-GTH-q6 QZV3P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"       11.8298677444  -0.0658681959   0.0000000000   0.0000000000   0.0000000000   0.0389990698   0.0000000000   0.0000000000   0.0000000000\n"
"        4.9326307395  -0.1327117781   0.0000000000   0.0000000000   0.0000000000   0.1329824319   0.0000000000   0.0000000000   0.0000000000\n"
"        1.9312997298   0.1529660213   0.0000000000   0.0000000000   0.0000000000   0.2737974007   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7724003899   0.5206439978   1.0000000000   0.0000000000   0.0000000000   0.3663338041   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2976334392   0.4322622254   0.0000000000   1.0000000000   0.0000000000   0.3292638764   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1070061063   0.0599977177   0.0000000000   0.0000000000   1.0000000000   0.1324571183   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        3.7750000000   1.0000000000   0.0000000000   0.0000000000\n"
"        1.3000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.4440000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"O aug-DZVP-GTH-q6 aug-DZVP-GTH\n"
"  4\n"
"  2  0  1  4  2  2\n"
"        8.3043855492   0.1510165999   0.0000000000  -0.0995679273   0.0000000000\n"
"        2.4579484191  -0.0393195364   0.0000000000  -0.3011422449   0.0000000000\n"
"        0.7597373434  -0.6971724029   0.0000000000  -0.4750857083   0.0000000000\n"
"        0.2136388632  -0.3841133622   1.0000000000  -0.3798777957   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.1850000000   1.0000000000\n"
"  4  0  0  1  1\n"
"        0.0789600000   1.0000000000\n"
"  4  1  1  1  1\n"
"        0.0685600000   1.0000000000\n"
"#","\n"
"O aug-TZVP-GTH-q6 aug-TZVP-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"       10.2674419938   0.0989598460   0.0000000000   0.0000000000  -0.0595856940   0.0000000000   0.0000000000   0.0000000000\n"
"        3.7480495696   0.1041178339   0.0000000000   0.0000000000  -0.1875649045   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3308337704  -0.3808255700   0.0000000000   0.0000000000  -0.3700707718   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4556802254  -0.6232449802   1.0000000000   0.0000000000  -0.4204922615   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1462920596  -0.1677863491   0.0000000000   1.0000000000  -0.2313901687   0.0000000000   1.0000000000   0.0000000000\n"
"  3  2  2  1  1\n"
"        1.1850000000   1.0000000000\n"
"  5  0  0  1  1\n"
"        0.0737600000   1.0000000000\n"
"  5  1  1  1  1\n"
"        0.0597400000   1.0000000000\n"
"#","\n"
"O aug-TZV2P-GTH-q6 aug-TZV2P-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"       10.2674419938   0.0989598460   0.0000000000   0.0000000000  -0.0595856940   0.0000000000   0.0000000000   0.0000000000\n"
"        3.7480495696   0.1041178339   0.0000000000   0.0000000000  -0.1875649045   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3308337704  -0.3808255700   0.0000000000   0.0000000000  -0.3700707718   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4556802254  -0.6232449802   1.0000000000   0.0000000000  -0.4204922615   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1462920596  -0.1677863491   0.0000000000   1.0000000000  -0.2313901687   0.0000000000   1.0000000000   0.0000000000\n"
"  3  2  2  2  2\n"
"        2.3140000000   1.0000000000   0.0000000000\n"
"        0.6450000000   0.0000000000   1.0000000000\n"
"  5  0  0  1  1\n"
"        0.0737600000   1.0000000000\n"
"  5  1  1  1  1\n"
"        0.0597400000   1.0000000000\n"
"#","\n"
"O aug-QZV2P-GTH-q6 aug-QZV2P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"       11.8298677444  -0.0658681959   0.0000000000   0.0000000000   0.0000000000   0.0389990698   0.0000000000   0.0000000000   0.0000000000\n"
"        4.9326307395  -0.1327117781   0.0000000000   0.0000000000   0.0000000000   0.1329824319   0.0000000000   0.0000000000   0.0000000000\n"
"        1.9312997298   0.1529660213   0.0000000000   0.0000000000   0.0000000000   0.2737974007   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7724003899   0.5206439978   1.0000000000   0.0000000000   0.0000000000   0.3663338041   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2976334392   0.4322622254   0.0000000000   1.0000000000   0.0000000000   0.3292638764   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1070061063   0.0599977177   0.0000000000   0.0000000000   1.0000000000   0.1324571183   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        2.3140000000   1.0000000000   0.0000000000\n"
"        0.6450000000   0.0000000000   1.0000000000\n"
"  6  0  0  1  1\n"
"        0.0695900000   1.0000000000\n"
"  6  1  1  1  1\n"
"        0.0534800000   1.0000000000\n"
"#","\n"
"O aug-QZV3P-GTH-q6 aug-QZV3P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"       11.8298677444  -0.0658681959   0.0000000000   0.0000000000   0.0000000000   0.0389990698   0.0000000000   0.0000000000   0.0000000000\n"
"        4.9326307395  -0.1327117781   0.0000000000   0.0000000000   0.0000000000   0.1329824319   0.0000000000   0.0000000000   0.0000000000\n"
"        1.9312997298   0.1529660213   0.0000000000   0.0000000000   0.0000000000   0.2737974007   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7724003899   0.5206439978   1.0000000000   0.0000000000   0.0000000000   0.3663338041   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2976334392   0.4322622254   0.0000000000   1.0000000000   0.0000000000   0.3292638764   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1070061063   0.0599977177   0.0000000000   0.0000000000   1.0000000000   0.1324571183   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        3.7750000000   1.0000000000   0.0000000000   0.0000000000\n"
"        1.3000000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.4440000000   0.0000000000   0.0000000000   1.0000000000\n"
"  6  0  0  1  1\n"
"        0.0695900000   1.0000000000\n"
"  6  1  1  1  1\n"
"        0.0534800000   1.0000000000\n"
"#","\n"
"F SZV-GTH-q7 SZV-GTH\n"
"  1\n"
"  2  0  1  4  1  1\n"
"       10.7079832847   0.1525178777  -0.1028649478\n"
"        3.1757210204  -0.0450363043  -0.3085265610\n"
"        0.9750975650  -0.6987425604  -0.4757649909\n"
"        0.2701246771  -0.3801470341  -0.3724954705\n"
"#","\n"
"F DZVP-GTH-q7 DZVP-GTH\n"
"  2\n"
"  2  0  1  4  2  2\n"
"       10.7079832847   0.1525178777   0.0000000000  -0.1028649478   0.0000000000\n"
"        3.1757210204  -0.0450363043   0.0000000000  -0.3085265610   0.0000000000\n"
"        0.9750975650  -0.6987425604   0.0000000000  -0.4757649909   0.0000000000\n"
"        0.2701246771  -0.3801470341   1.0000000000  -0.3724954705   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.6400000000   1.0000000000\n"
"#","\n"
"F TZVP-GTH-q7 TZVP-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"       13.1625129789   0.1014784435   0.0000000000   0.0000000000  -0.0624161251   0.0000000000   0.0000000000\n"
"        4.7972015127   0.1001604122   0.0000000000   0.0000000000  -0.1948710850   0.0000000000   0.0000000000\n"
"        1.7049975196  -0.3881644200   0.0000000000   0.0000000000  -0.3737338926   0.0000000000   0.0000000000\n"
"        0.5814471097  -0.6179394476   1.0000000000   0.0000000000  -0.4151939502   1.0000000000   0.0000000000\n"
"        0.1842582220  -0.1660215122   0.0000000000   1.0000000000  -0.2267411587   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.6400000000   1.0000000000\n"
"#","\n"
"F TZV2P-GTH-q7 TZV2P-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"       13.1625129789   0.1014784435   0.0000000000   0.0000000000  -0.0624161251   0.0000000000   0.0000000000\n"
"        4.7972015127   0.1001604122   0.0000000000   0.0000000000  -0.1948710850   0.0000000000   0.0000000000\n"
"        1.7049975196  -0.3881644200   0.0000000000   0.0000000000  -0.3737338926   0.0000000000   0.0000000000\n"
"        0.5814471097  -0.6179394476   1.0000000000   0.0000000000  -0.4151939502   1.0000000000   0.0000000000\n"
"        0.1842582220  -0.1660215122   0.0000000000   1.0000000000  -0.2267411587   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        3.1070000000   1.0000000000   0.0000000000\n"
"        0.8550000000   0.0000000000   1.0000000000\n"
"#","\n"
"F QZV2P-GTH-q7 QZV2P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"       15.1623003547  -0.0676084899   0.0000000000   0.0000000000   0.0000000000   0.0407647530   0.0000000000   0.0000000000   0.0000000000\n"
"        6.3418425141  -0.1317375108   0.0000000000   0.0000000000   0.0000000000   0.1374408584   0.0000000000   0.0000000000   0.0000000000\n"
"        2.4900230297   0.1587177173   0.0000000000   0.0000000000   0.0000000000   0.2789708771   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9919240308   0.5210056191   1.0000000000   0.0000000000   0.0000000000   0.3662011969   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3793151196   0.4286790556   0.0000000000   1.0000000000   0.0000000000   0.3234540792   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1348132586   0.0598520782   0.0000000000   0.0000000000   1.0000000000   0.1307942509   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        3.1070000000   1.0000000000   0.0000000000\n"
"        0.8550000000   0.0000000000   1.0000000000\n"
"#","\n"
"F QZV3P-GTH-q7 QZV3P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"       15.1623003547  -0.0676084899   0.0000000000   0.0000000000   0.0000000000   0.0407647530   0.0000000000   0.0000000000   0.0000000000\n"
"        6.3418425141  -0.1317375108   0.0000000000   0.0000000000   0.0000000000   0.1374408584   0.0000000000   0.0000000000   0.0000000000\n"
"        2.4900230297   0.1587177173   0.0000000000   0.0000000000   0.0000000000   0.2789708771   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9919240308   0.5210056191   1.0000000000   0.0000000000   0.0000000000   0.3662011969   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3793151196   0.4286790556   0.0000000000   1.0000000000   0.0000000000   0.3234540792   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1348132586   0.0598520782   0.0000000000   0.0000000000   1.0000000000   0.1307942509   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        5.0140000000   1.0000000000   0.0000000000   0.0000000000\n"
"        1.7250000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.5860000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"F aug-DZVP-GTH-q7 aug-DZVP-GTH\n"
"  4\n"
"  2  0  1  4  2  2\n"
"       10.7079832847   0.1525178777   0.0000000000  -0.1028649478   0.0000000000\n"
"        3.1757210204  -0.0450363043   0.0000000000  -0.3085265610   0.0000000000\n"
"        0.9750975650  -0.6987425604   0.0000000000  -0.4757649909   0.0000000000\n"
"        0.2701246771  -0.3801470341   1.0000000000  -0.3724954705   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.6400000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.09863000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.08502000     1.0000000000\n"
"#","\n"
"F aug-TZVP-GTH-q7 aug-TZVP-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"       13.1625129789   0.1014784435   0.0000000000   0.0000000000  -0.0624161251   0.0000000000   0.0000000000\n"
"        4.7972015127   0.1001604122   0.0000000000   0.0000000000  -0.1948710850   0.0000000000   0.0000000000\n"
"        1.7049975196  -0.3881644200   0.0000000000   0.0000000000  -0.3737338926   0.0000000000   0.0000000000\n"
"        0.5814471097  -0.6179394476   1.0000000000   0.0000000000  -0.4151939502   1.0000000000   0.0000000000\n"
"        0.1842582220  -0.1660215122   0.0000000000   1.0000000000  -0.2267411587   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        1.6400000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.09158000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.07361000     1.0000000000\n"
"#","\n"
"F aug-TZV2P-GTH-q7 aug-TZV2P-GTH\n"
"  4\n"
"  2  0  1  5  3  3\n"
"       13.1625129789   0.1014784435   0.0000000000   0.0000000000  -0.0624161251   0.0000000000   0.0000000000\n"
"        4.7972015127   0.1001604122   0.0000000000   0.0000000000  -0.1948710850   0.0000000000   0.0000000000\n"
"        1.7049975196  -0.3881644200   0.0000000000   0.0000000000  -0.3737338926   0.0000000000   0.0000000000\n"
"        0.5814471097  -0.6179394476   1.0000000000   0.0000000000  -0.4151939502   1.0000000000   0.0000000000\n"
"        0.1842582220  -0.1660215122   0.0000000000   1.0000000000  -0.2267411587   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        3.1070000000   1.0000000000   0.0000000000\n"
"        0.8550000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.09158000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.07361000     1.0000000000\n"
"#","\n"
"F aug-QZV2P-GTH-q7 aug-QZV2P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"       15.1623003547  -0.0676084899   0.0000000000   0.0000000000   0.0000000000   0.0407647530   0.0000000000   0.0000000000   0.0000000000\n"
"        6.3418425141  -0.1317375108   0.0000000000   0.0000000000   0.0000000000   0.1374408584   0.0000000000   0.0000000000   0.0000000000\n"
"        2.4900230297   0.1587177173   0.0000000000   0.0000000000   0.0000000000   0.2789708771   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9919240308   0.5210056191   1.0000000000   0.0000000000   0.0000000000   0.3662011969   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3793151196   0.4286790556   0.0000000000   1.0000000000   0.0000000000   0.3234540792   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1348132586   0.0598520782   0.0000000000   0.0000000000   1.0000000000   0.1307942509   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        3.1070000000   1.0000000000   0.0000000000\n"
"        0.8550000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.08594000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.06568000     1.0000000000\n"
"#","\n"
"F aug-QZV3P-GTH-q7 aug-QZV3P-GTH\n"
"  4\n"
"  2  0  1  6  4  4\n"
"       15.1623003547  -0.0676084899   0.0000000000   0.0000000000   0.0000000000   0.0407647530   0.0000000000   0.0000000000   0.0000000000\n"
"        6.3418425141  -0.1317375108   0.0000000000   0.0000000000   0.0000000000   0.1374408584   0.0000000000   0.0000000000   0.0000000000\n"
"        2.4900230297   0.1587177173   0.0000000000   0.0000000000   0.0000000000   0.2789708771   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9919240308   0.5210056191   1.0000000000   0.0000000000   0.0000000000   0.3662011969   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3793151196   0.4286790556   0.0000000000   1.0000000000   0.0000000000   0.3234540792   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1348132586   0.0598520782   0.0000000000   0.0000000000   1.0000000000   0.1307942509   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        5.0140000000   1.0000000000   0.0000000000   0.0000000000\n"
"        1.7250000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.5860000000   0.0000000000   0.0000000000   1.0000000000\n"
"  2  0  0  1  1\n"
"        0.08594000     1.0000000000\n"
"  2  1  1  1  1\n"
"        0.06568000     1.0000000000\n"
"#","\n"
"Ne SZV-GTH-q8 SZV-GTH\n"
"  1\n"
"  2  0  1  4  1  1\n"
"       13.7594449156   0.1483426747  -0.1044041225\n"
"        4.0425282819  -0.0356307196  -0.3108899020\n"
"        1.2355181615  -0.7010729520  -0.4760216511\n"
"        0.3367029925  -0.3841118307  -0.3721570391\n"
"#","\n"
"Ne DZVP-GTH-q8 DZVP-GTH\n"
"  2\n"
"  2  0  1  4  2  2\n"
"       13.7594449156   0.1483426747   0.0000000000  -0.1044041225   0.0000000000\n"
"        4.0425282819  -0.0356307196   0.0000000000  -0.3108899020   0.0000000000\n"
"        1.2355181615  -0.7010729520   0.0000000000  -0.4760216511   0.0000000000\n"
"        0.3367029925  -0.3841118307   1.0000000000  -0.3721570391   1.0000000000\n"
"  3  2  2  1  1\n"
"        2.2020000000   1.0000000000\n"
"#","\n"
"Ne TZVP-GTH-q8 TZVP-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"       17.0406976441   0.0956582854   0.0000000000   0.0000000000  -0.0631287607   0.0000000000   0.0000000000\n"
"        6.1494859942   0.1095546500   0.0000000000   0.0000000000  -0.1953504506   0.0000000000   0.0000000000\n"
"        2.1810891675  -0.3850952695   0.0000000000   0.0000000000  -0.3747245390   0.0000000000   0.0000000000\n"
"        0.7370336206  -0.6201458095   1.0000000000   0.0000000000  -0.4151315545   1.0000000000   0.0000000000\n"
"        0.2296296929  -0.1719183539   0.0000000000   1.0000000000  -0.2286539782   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        2.2020000000   1.0000000000\n"
"#","\n"
"Ne TZV2P-GTH-q8 TZV2P-GTH\n"
"  2\n"
"  2  0  1  5  3  3\n"
"       17.0406976441   0.0956582854   0.0000000000   0.0000000000  -0.0631287607   0.0000000000   0.0000000000\n"
"        6.1494859942   0.1095546500   0.0000000000   0.0000000000  -0.1953504506   0.0000000000   0.0000000000\n"
"        2.1810891675  -0.3850952695   0.0000000000   0.0000000000  -0.3747245390   0.0000000000   0.0000000000\n"
"        0.7370336206  -0.6201458095   1.0000000000   0.0000000000  -0.4151315545   1.0000000000   0.0000000000\n"
"        0.2296296929  -0.1719183539   0.0000000000   1.0000000000  -0.2286539782   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        4.0140000000   1.0000000000   0.0000000000\n"
"        1.0960000000   0.0000000000   1.0000000000\n"
"#","\n"
"Ne QZV2P-GTH-q8 QZV2P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"       19.5499411153  -0.0632766758   0.0000000000   0.0000000000   0.0000000000   0.0422167837   0.0000000000   0.0000000000   0.0000000000\n"
"        8.0769601838  -0.1370919085   0.0000000000   0.0000000000   0.0000000000   0.1383304483   0.0000000000   0.0000000000   0.0000000000\n"
"        3.1678758504   0.1578325934   0.0000000000   0.0000000000   0.0000000000   0.2813677061   0.0000000000   0.0000000000   0.0000000000\n"
"        1.2535625634   0.5200705489   1.0000000000   0.0000000000   0.0000000000   0.3669217463   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4749693396   0.4313985613   0.0000000000   1.0000000000   0.0000000000   0.3213403173   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1666682167   0.0613040256   0.0000000000   0.0000000000   1.0000000000   0.1317714527   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        4.0140000000   1.0000000000   0.0000000000\n"
"        1.0960000000   0.0000000000   1.0000000000\n"
"#","\n"
"Ne QZV3P-GTH-q8 QZV3P-GTH\n"
"  2\n"
"  2  0  1  6  4  4\n"
"       19.5499411153  -0.0632766758   0.0000000000   0.0000000000   0.0000000000   0.0422167837   0.0000000000   0.0000000000   0.0000000000\n"
"        8.0769601838  -0.1370919085   0.0000000000   0.0000000000   0.0000000000   0.1383304483   0.0000000000   0.0000000000   0.0000000000\n"
"        3.1678758504   0.1578325934   0.0000000000   0.0000000000   0.0000000000   0.2813677061   0.0000000000   0.0000000000   0.0000000000\n"
"        1.2535625634   0.5200705489   1.0000000000   0.0000000000   0.0000000000   0.3669217463   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4749693396   0.4313985613   0.0000000000   1.0000000000   0.0000000000   0.3213403173   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1666682167   0.0613040256   0.0000000000   0.0000000000   1.0000000000   0.1317714527   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        6.4710000000   1.0000000000   0.0000000000   0.0000000000\n"
"        2.2130000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.7470000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Na SZV-GTH-q9 SZV-GTH\n"
"  1\n"
"  2  0  1  6  2  1\n"
"       17.6698382207  -0.1362364777   0.0270957219   0.0791980974\n"
"        6.9070658063  -0.0645835666   0.0098734119   0.2184139257\n"
"        2.6098601451   0.3866153961  -0.0737170396   0.3764887364\n"
"        0.9649548796   0.5971358883  -0.2186742776   0.3922304007\n"
"        0.3400348369   0.1756697026  -0.0301066303   0.1808407220\n"
"        0.0432486046  -0.0017104621   1.0388865857   0.0057696324\n"
"#","\n"
"Na DZVP-GTH-q9 DZVP-GTH\n"
"  2\n"
"  2  0  1  6  3  2\n"
"       17.6698382207  -0.1362364777   0.0270957219   0.0000000000   0.0791980974   0.0000000000\n"
"        6.9070658063  -0.0645835666   0.0098734119   0.0000000000   0.2184139257   0.0000000000\n"
"        2.6098601451   0.3866153961  -0.0737170396   0.0000000000   0.3764887364   0.0000000000\n"
"        0.9649548796   0.5971358883  -0.2186742776   0.0000000000   0.3922304007   0.0000000000\n"
"        0.3400348369   0.1756697026  -0.0301066303   0.0000000000   0.1808407220   0.0000000000\n"
"        0.0432486046  -0.0017104621   1.0388865857   1.0000000000   0.0057696324   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0973000000   1.0000000000\n"
"#","\n"
"Na TZVP-GTH-q9 TZVP-GTH\n"
"  2\n"
"  2  0  1  7  4  3\n"
"       18.1210741090  -0.1275232222  -0.0248047945   0.0000000000   0.0000000000   0.0729874345   0.0000000000   0.0000000000\n"
"        7.3775066400  -0.0812376594  -0.0171596817   0.0000000000   0.0000000000   0.1996717590   0.0000000000   0.0000000000\n"
"        2.8817585986   0.3277442268   0.0724090847   0.0000000000   0.0000000000   0.3527504683   0.0000000000   0.0000000000\n"
"        1.0990235357   0.5946658147   0.1739886836   0.0000000000   0.0000000000   0.3936231447   0.0000000000   0.0000000000\n"
"        0.4007387720   0.2436047977   0.1404493622   0.0000000000   0.0000000000   0.2171401481   0.0000000000   0.0000000000\n"
"        0.0916859420  -0.0017574619  -0.3860533721   1.0000000000   0.0000000000   0.0205070521   1.0000000000   0.0000000000\n"
"        0.0309750158   0.0016745741  -0.7360619920   0.0000000000   1.0000000000  -0.0045593404   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.0973000000   1.0000000000\n"
"#","\n"
"Na TZV2P-GTH-q9 TZV2P-GTH\n"
"  2\n"
"  2  0  1  7  4  3\n"
"       18.1210741090  -0.1275232222  -0.0248047945   0.0000000000   0.0000000000   0.0729874345   0.0000000000   0.0000000000\n"
"        7.3775066400  -0.0812376594  -0.0171596817   0.0000000000   0.0000000000   0.1996717590   0.0000000000   0.0000000000\n"
"        2.8817585986   0.3277442268   0.0724090847   0.0000000000   0.0000000000   0.3527504683   0.0000000000   0.0000000000\n"
"        1.0990235357   0.5946658147   0.1739886836   0.0000000000   0.0000000000   0.3936231447   0.0000000000   0.0000000000\n"
"        0.4007387720   0.2436047977   0.1404493622   0.0000000000   0.0000000000   0.2171401481   0.0000000000   0.0000000000\n"
"        0.0916859420  -0.0017574619  -0.3860533721   1.0000000000   0.0000000000   0.0205070521   1.0000000000   0.0000000000\n"
"        0.0309750158   0.0016745741  -0.7360619920   0.0000000000   1.0000000000  -0.0045593404   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.1367000000   1.0000000000   0.0000000000\n"
"        0.0636000000   0.0000000000   1.0000000000\n"
"#","\n"
"Na QZV2P-GTH-q9 QZV2P-GTH\n"
"  2\n"
"  2  0  1  8  5  4\n"
"       19.7241294087   0.0964646065   0.0186968769   0.0000000000   0.0000000000   0.0000000000  -0.0533754431   0.0000000000   0.0000000000   0.0000000000\n"
"        9.3287912748   0.1166761476   0.0236192089   0.0000000000   0.0000000000   0.0000000000  -0.1400719948   0.0000000000   0.0000000000   0.0000000000\n"
"        4.1199901709  -0.1393562188  -0.0290484898   0.0000000000   0.0000000000   0.0000000000  -0.2641114390   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7720338111  -0.4584822127  -0.1108583114   0.0000000000   0.0000000000   0.0000000000  -0.3519032892   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7498415377  -0.4636596929  -0.1735322668   0.0000000000   0.0000000000   0.0000000000  -0.3064604543   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2996060606  -0.1092610807  -0.0565756124   1.0000000000   0.0000000000   0.0000000000  -0.1309377611   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0698044897   0.0012749633   0.5743314061   0.0000000000   1.0000000000   0.0000000000  -0.0074120120   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0255058383  -0.0006119521   0.5364207511   0.0000000000   0.0000000000   1.0000000000   0.0017424530   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.1367000000   1.0000000000   0.0000000000\n"
"        0.0636000000   0.0000000000   1.0000000000\n"
"#","\n"
"Na QZV3P-GTH-q9 QZV3P-GTH\n"
"  2\n"
"  2  0  1  8  5  4\n"
"       19.7241294087   0.0964646065   0.0186968769   0.0000000000   0.0000000000   0.0000000000  -0.0533754431   0.0000000000   0.0000000000   0.0000000000\n"
"        9.3287912748   0.1166761476   0.0236192089   0.0000000000   0.0000000000   0.0000000000  -0.1400719948   0.0000000000   0.0000000000   0.0000000000\n"
"        4.1199901709  -0.1393562188  -0.0290484898   0.0000000000   0.0000000000   0.0000000000  -0.2641114390   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7720338111  -0.4584822127  -0.1108583114   0.0000000000   0.0000000000   0.0000000000  -0.3519032892   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7498415377  -0.4636596929  -0.1735322668   0.0000000000   0.0000000000   0.0000000000  -0.3064604543   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2996060606  -0.1092610807  -0.0565756124   1.0000000000   0.0000000000   0.0000000000  -0.1309377611   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0698044897   0.0012749633   0.5743314061   0.0000000000   1.0000000000   0.0000000000  -0.0074120120   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0255058383  -0.0006119521   0.5364207511   0.0000000000   0.0000000000   1.0000000000   0.0017424530   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        0.1538000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0865000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0487000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Mg SZV-GTH-q10 SZV-GTH\n"
"  1\n"
"  2  0  1  6  2  1\n"
"       28.4894000448  -0.0662729183   0.0165018731   0.0464558886\n"
"       11.7278204570  -0.1706135571   0.0374283767   0.1664914738\n"
"        4.4443941842   0.2494781478  -0.0517347280   0.3580941241\n"
"        1.6070266284   0.6423214818  -0.2647624258   0.4356599896\n"
"        0.5690630460   0.2933234669  -0.0948461091   0.2229558550\n"
"        0.0763496459  -0.0002717019   1.0630071183   0.0085986529\n"
"#","\n"
"Mg DZVP-GTH-q10 DZVP-GTH\n"
"  2\n"
"  2  0  1  6  3  2\n"
"       28.4894000448  -0.0662729183   0.0165018731   0.0000000000   0.0464558886   0.0000000000\n"
"       11.7278204570  -0.1706135571   0.0374283767   0.0000000000   0.1664914738   0.0000000000\n"
"        4.4443941842   0.2494781478  -0.0517347280   0.0000000000   0.3580941241   0.0000000000\n"
"        1.6070266284   0.6423214818  -0.2647624258   0.0000000000   0.4356599896   0.0000000000\n"
"        0.5690630460   0.2933234669  -0.0948461091   0.0000000000   0.2229558550   0.0000000000\n"
"        0.0763496459  -0.0002717019   1.0630071183   1.0000000000   0.0085986529   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Mg TZVP-GTH-q10 TZVP-GTH\n"
"  2\n"
"  2  0  1  7  4  3\n"
"       32.6102127160  -0.0379330911  -0.0088936017   0.0000000000   0.0000000000   0.0307150457   0.0000000000   0.0000000000\n"
"       14.0525311690  -0.1824731301  -0.0446185212   0.0000000000   0.0000000000   0.1365611853   0.0000000000   0.0000000000\n"
"        5.3750565930   0.1414840059   0.0361139004   0.0000000000   0.0000000000   0.3216977104   0.0000000000   0.0000000000\n"
"        1.9603294652   0.6092794423   0.1991926589   0.0000000000   0.0000000000   0.4406864532   0.0000000000   0.0000000000\n"
"        0.6985451378   0.4085543085   0.2360727936   0.0000000000   0.0000000000   0.2830209201   0.0000000000   0.0000000000\n"
"        0.1599451430   0.0093835755  -0.4060439955   1.0000000000   0.0000000000   0.0314202293   1.0000000000   0.0000000000\n"
"        0.0539901438  -0.0000358721  -0.7421716821   0.0000000000   1.0000000000  -0.0070197374   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1870000000   1.0000000000\n"
"#","\n"
"Mg TZV2P-GTH-q10 TZV2P-GTH\n"
"  2\n"
"  2  0  1  7  4  3\n"
"       32.6102127160  -0.0379330911  -0.0088936017   0.0000000000   0.0000000000   0.0307150457   0.0000000000   0.0000000000\n"
"       14.0525311690  -0.1824731301  -0.0446185212   0.0000000000   0.0000000000   0.1365611853   0.0000000000   0.0000000000\n"
"        5.3750565930   0.1414840059   0.0361139004   0.0000000000   0.0000000000   0.3216977104   0.0000000000   0.0000000000\n"
"        1.9603294652   0.6092794423   0.1991926589   0.0000000000   0.0000000000   0.4406864532   0.0000000000   0.0000000000\n"
"        0.6985451378   0.4085543085   0.2360727936   0.0000000000   0.0000000000   0.2830209201   0.0000000000   0.0000000000\n"
"        0.1599451430   0.0093835755  -0.4060439955   1.0000000000   0.0000000000   0.0314202293   1.0000000000   0.0000000000\n"
"        0.0539901438  -0.0000358721  -0.7421716821   0.0000000000   1.0000000000  -0.0070197374   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.2940000000   1.0000000000   0.0000000000\n"
"        0.1260000000   0.0000000000   1.0000000000\n"
"#","\n"
"Mg QZV2P-GTH-q10 QZV2P-GTH\n"
"  2\n"
"  2  0  1  8  5  4\n"
"       38.2989934401   0.0104376055   0.0024542703   0.0000000000   0.0000000000   0.0000000000  -0.0169307005   0.0000000000   0.0000000000   0.0000000000\n"
"       18.2352594129   0.1600713964   0.0383890090   0.0000000000   0.0000000000   0.0000000000  -0.0880606004   0.0000000000   0.0000000000   0.0000000000\n"
"        7.8322039250   0.0236151231   0.0063757667   0.0000000000   0.0000000000   0.0000000000  -0.2233078530   0.0000000000   0.0000000000   0.0000000000\n"
"        3.2096669080  -0.3496886711  -0.0967311125   0.0000000000   0.0000000000   0.0000000000  -0.3590124156   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3215191150  -0.5744578292  -0.2302830710   0.0000000000   0.0000000000   0.0000000000  -0.3636484834   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5219034472  -0.2167187848  -0.1302378952   1.0000000000   0.0000000000   0.0000000000  -0.1772276014   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1263242017  -0.0012887617   0.5892536861   0.0000000000   1.0000000000   0.0000000000  -0.0121989604   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0449896165  -0.0003669674   0.5569471332   0.0000000000   0.0000000000   1.0000000000   0.0026934953   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.2940000000   1.0000000000   0.0000000000\n"
"        0.1260000000   0.0000000000   1.0000000000\n"
"#","\n"
"Mg QZV3P-GTH-q10 QZV3P-GTH\n"
"  2\n"
"  2  0  1  8  5  4\n"
"       38.2989934401   0.0104376055   0.0024542703   0.0000000000   0.0000000000   0.0000000000  -0.0169307005   0.0000000000   0.0000000000   0.0000000000\n"
"       18.2352594129   0.1600713964   0.0383890090   0.0000000000   0.0000000000   0.0000000000  -0.0880606004   0.0000000000   0.0000000000   0.0000000000\n"
"        7.8322039250   0.0236151231   0.0063757667   0.0000000000   0.0000000000   0.0000000000  -0.2233078530   0.0000000000   0.0000000000   0.0000000000\n"
"        3.2096669080  -0.3496886711  -0.0967311125   0.0000000000   0.0000000000   0.0000000000  -0.3590124156   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3215191150  -0.5744578292  -0.2302830710   0.0000000000   0.0000000000   0.0000000000  -0.3636484834   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5219034472  -0.2167187848  -0.1302378952   1.0000000000   0.0000000000   0.0000000000  -0.1772276014   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1263242017  -0.0012887617   0.5892536861   0.0000000000   1.0000000000   0.0000000000  -0.0121989604   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0449896165  -0.0003669674   0.5569471332   0.0000000000   0.0000000000   1.0000000000   0.0026934953   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        0.3570000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1944000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1060000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Al SZV-GTH-q3 SZV-GTH\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        0.9504275958   0.2820078575   0.0257257859\n"
"        0.2947366659  -0.2787607042  -0.2528156908\n"
"        0.1124426785  -0.7494973519  -0.5124696636\n"
"        0.0396003631  -0.1645895071  -0.3831165034\n"
"#","\n"
"Al DZVP-GTH-q3 DZVP-GTH\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        0.9504275958   0.2820078575   0.0000000000   0.0257257859   0.0000000000\n"
"        0.2947366659  -0.2787607042   0.0000000000  -0.2528156908   0.0000000000\n"
"        0.1124426785  -0.7494973519   0.0000000000  -0.5124696636   0.0000000000\n"
"        0.0396003631  -0.1645895071   1.0000000000  -0.3831165034   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1890000000   1.0000000000\n"
"#","\n"
"Al TZVP-GTH-q3 TZVP-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        0.9710403542   0.2731273083   0.0000000000   0.0000000000   0.0318495312   0.0000000000   0.0000000000\n"
"        0.3604758056  -0.1164353642   0.0000000000   0.0000000000  -0.1582365164   0.0000000000   0.0000000000\n"
"        0.1582849401  -0.6159606293   0.0000000000   0.0000000000  -0.3791239519   0.0000000000   0.0000000000\n"
"        0.0674736203  -0.4172871263   1.0000000000   0.0000000000  -0.4457455282   1.0000000000   0.0000000000\n"
"        0.0267010818  -0.0326661237   0.0000000000   1.0000000000  -0.1788784308   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.1890000000   1.0000000000\n"
"#","\n"
"Al TZV2P-GTH-q3 TZV2P-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        0.9710403542   0.2731273083   0.0000000000   0.0000000000   0.0318495312   0.0000000000   0.0000000000\n"
"        0.3604758056  -0.1164353642   0.0000000000   0.0000000000  -0.1582365164   0.0000000000   0.0000000000\n"
"        0.1582849401  -0.6159606293   0.0000000000   0.0000000000  -0.3791239519   0.0000000000   0.0000000000\n"
"        0.0674736203  -0.4172871263   1.0000000000   0.0000000000  -0.4457455282   1.0000000000   0.0000000000\n"
"        0.0267010818  -0.0326661237   0.0000000000   1.0000000000  -0.1788784308   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.3330000000   1.0000000000   0.0000000000\n"
"        0.1090000000   0.0000000000   1.0000000000\n"
"#","\n"
"Al QZV2P-GTH-q3 QZV2P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        3.0705249839   0.0027352701   0.0000000000   0.0000000000   0.0000000000   0.0044124453   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9962478983  -0.2668117634   0.0000000000   0.0000000000   0.0000000000  -0.0401883011   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4094779636   0.0618740192   0.0000000000   0.0000000000   0.0000000000   0.1289865679   0.0000000000   0.0000000000   0.0000000000\n"
"        0.1732890531   0.5987573069   1.0000000000   0.0000000000   0.0000000000   0.3723262575   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0723986239   0.4707960559   0.0000000000   1.0000000000   0.0000000000   0.4626980717   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0282432465   0.0425944411   0.0000000000   0.0000000000   1.0000000000   0.2032552207   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.3330000000   1.0000000000   0.0000000000\n"
"        0.1090000000   0.0000000000   1.0000000000\n"
"#","\n"
"Al QZV3P-GTH-q3 QZV3P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        3.0705249839   0.0027352701   0.0000000000   0.0000000000   0.0000000000   0.0044124453   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9962478983  -0.2668117634   0.0000000000   0.0000000000   0.0000000000  -0.0401883011   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4094779636   0.0618740192   0.0000000000   0.0000000000   0.0000000000   0.1289865679   0.0000000000   0.0000000000   0.0000000000\n"
"        0.1732890531   0.5987573069   1.0000000000   0.0000000000   0.0000000000   0.3723262575   1.0000000000   0.0000000000   0.0000000000\n"
"        0.0723986239   0.4707960559   0.0000000000   1.0000000000   0.0000000000   0.4626980717   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0282432465   0.0425944411   0.0000000000   0.0000000000   1.0000000000   0.2032552207   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        0.4940000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1990000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0804000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Si SZV-GTH-q4 SZV-GTH\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        1.2032403600   0.3290356759   0.0474536439\n"
"        0.4688385970  -0.2533162616  -0.2594495462\n"
"        0.1679853910  -0.7870936517  -0.5440932235\n"
"        0.0575616890  -0.1909870193  -0.3623984652\n"
"#","\n"
"Si DZVP-GTH-q4 DZVP-GTH\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.2032403600   0.3290356759   0.0000000000   0.0474536439   0.0000000000\n"
"        0.4688385970  -0.2533162616   0.0000000000  -0.2594495462   0.0000000000\n"
"        0.1679853910  -0.7870936517   0.0000000000  -0.5440932235   0.0000000000\n"
"        0.0575616890  -0.1909870193   1.0000000000  -0.3623984652   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2750000000   1.0000000000\n"
"#","\n"
"Si TZVP-GTH-q4 TZVP-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        1.2331731434   0.3150424674   0.0000000000   0.0000000000   0.0667574395   0.0000000000   0.0000000000\n"
"        0.6579957180  -0.0732928041   0.0000000000   0.0000000000  -0.1473516106   0.0000000000   0.0000000000\n"
"        0.2547041526  -0.5862322199   0.0000000000   0.0000000000  -0.4034178654   0.0000000000   0.0000000000\n"
"        0.1060089904  -0.5051712664   1.0000000000   0.0000000000  -0.4457008802   1.0000000000   0.0000000000\n"
"        0.0418790646  -0.0507253610   0.0000000000   1.0000000000  -0.1941498294   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2750000000   1.0000000000\n"
"#","\n"
"Si TZV2P-GTH-q4 TZV2P-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        1.2331731434   0.3150424674   0.0000000000   0.0000000000   0.0667574395   0.0000000000   0.0000000000\n"
"        0.6579957180  -0.0732928041   0.0000000000   0.0000000000  -0.1473516106   0.0000000000   0.0000000000\n"
"        0.2547041526  -0.5862322199   0.0000000000   0.0000000000  -0.4034178654   0.0000000000   0.0000000000\n"
"        0.1060089904  -0.5051712664   1.0000000000   0.0000000000  -0.4457008802   1.0000000000   0.0000000000\n"
"        0.0418790646  -0.0507253610   0.0000000000   1.0000000000  -0.1941498294   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.4810000000   1.0000000000   0.0000000000\n"
"        0.1590000000   0.0000000000   1.0000000000\n"
"#","\n"
"Si QZV2P-GTH-q4 QZV2P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        3.0914606934   0.0124908161   0.0000000000   0.0000000000   0.0000000000  -0.0027532026   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3362310368  -0.2927569134   0.0000000000   0.0000000000   0.0000000000  -0.0422856821   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5649726509   0.0456455175   0.0000000000   0.0000000000   0.0000000000   0.1468609670   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2466543506   0.6102734005   1.0000000000   0.0000000000   0.0000000000   0.3930678123   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1028862952   0.4799377663   0.0000000000   1.0000000000   0.0000000000   0.4491746304   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0403147900   0.0462217432   0.0000000000   0.0000000000   1.0000000000   0.1794865096   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.4810000000   1.0000000000   0.0000000000\n"
"        0.1590000000   0.0000000000   1.0000000000\n"
"#","\n"
"Si QZV3P-GTH-q4 QZV3P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        3.0914606934   0.0124908161   0.0000000000   0.0000000000   0.0000000000  -0.0027532026   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3362310368  -0.2927569134   0.0000000000   0.0000000000   0.0000000000  -0.0422856821   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5649726509   0.0456455175   0.0000000000   0.0000000000   0.0000000000   0.1468609670   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2466543506   0.6102734005   1.0000000000   0.0000000000   0.0000000000   0.3930678123   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1028862952   0.4799377663   0.0000000000   1.0000000000   0.0000000000   0.4491746304   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0403147900   0.0462217432   0.0000000000   0.0000000000   1.0000000000   0.1794865096   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        0.7600000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3020000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1200000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Si aug-DZVP-GTH-q4 aug-DZVP-GTH\n"
"  4\n"
"  3  0  1  4  2  2\n"
"        1.2032403600   0.3290356759   0.0000000000   0.0474536439   0.0000000000\n"
"        0.4688385970  -0.2533162616   0.0000000000  -0.2594495462   0.0000000000\n"
"        0.1679853910  -0.7870936517   0.0000000000  -0.5440932235   0.0000000000\n"
"        0.0575616890  -0.1909870193   1.0000000000  -0.3623984652   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2750000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.03320000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02500000     1.0000000000\n"
"#","\n"
"Si aug-TZVP-GTH-q4 aug-TZVP-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        1.2331731434   0.3150424674   0.0000000000   0.0000000000   0.0667574395   0.0000000000   0.0000000000\n"
"        0.6579957180  -0.0732928041   0.0000000000   0.0000000000  -0.1473516106   0.0000000000   0.0000000000\n"
"        0.2547041526  -0.5862322199   0.0000000000   0.0000000000  -0.4034178654   0.0000000000   0.0000000000\n"
"        0.1060089904  -0.5051712664   1.0000000000   0.0000000000  -0.4457008802   1.0000000000   0.0000000000\n"
"        0.0418790646  -0.0507253610   0.0000000000   1.0000000000  -0.1941498294   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.2750000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.03300000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02370000     1.0000000000\n"
"#","\n"
"Si aug-TZV2P-GTH-q4 aug-TZV2P-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        1.2331731434   0.3150424674   0.0000000000   0.0000000000   0.0667574395   0.0000000000   0.0000000000\n"
"        0.6579957180  -0.0732928041   0.0000000000   0.0000000000  -0.1473516106   0.0000000000   0.0000000000\n"
"        0.2547041526  -0.5862322199   0.0000000000   0.0000000000  -0.4034178654   0.0000000000   0.0000000000\n"
"        0.1060089904  -0.5051712664   1.0000000000   0.0000000000  -0.4457008802   1.0000000000   0.0000000000\n"
"        0.0418790646  -0.0507253610   0.0000000000   1.0000000000  -0.1941498294   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.4810000000   1.0000000000   0.0000000000\n"
"        0.1590000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.03300000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02370000     1.0000000000\n"
"#","\n"
"Si aug-QZV2P-GTH-q4 aug-QZV2P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        3.0914606934   0.0124908161   0.0000000000   0.0000000000   0.0000000000  -0.0027532026   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3362310368  -0.2927569134   0.0000000000   0.0000000000   0.0000000000  -0.0422856821   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5649726509   0.0456455175   0.0000000000   0.0000000000   0.0000000000   0.1468609670   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2466543506   0.6102734005   1.0000000000   0.0000000000   0.0000000000   0.3930678123   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1028862952   0.4799377663   0.0000000000   1.0000000000   0.0000000000   0.4491746304   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0403147900   0.0462217432   0.0000000000   0.0000000000   1.0000000000   0.1794865096   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.4810000000   1.0000000000   0.0000000000\n"
"        0.1590000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.02750000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02000000     1.0000000000\n"
"#","\n"
"Si aug-QZV3P-GTH-q4 aug-QZV3P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        3.0914606934   0.0124908161   0.0000000000   0.0000000000   0.0000000000  -0.0027532026   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3362310368  -0.2927569134   0.0000000000   0.0000000000   0.0000000000  -0.0422856821   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5649726509   0.0456455175   0.0000000000   0.0000000000   0.0000000000   0.1468609670   0.0000000000   0.0000000000   0.0000000000\n"
"        0.2466543506   0.6102734005   1.0000000000   0.0000000000   0.0000000000   0.3930678123   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1028862952   0.4799377663   0.0000000000   1.0000000000   0.0000000000   0.4491746304   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0403147900   0.0462217432   0.0000000000   0.0000000000   1.0000000000   0.1794865096   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        0.7600000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.3020000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1200000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.02750000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02000000     1.0000000000\n"
"#","\n"
"P SZV-GTH-q5 SZV-GTH\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        1.4960907993   0.3653124842   0.0816205767\n"
"        0.7169067467  -0.2125748699  -0.2627397053\n"
"        0.2411464781  -0.8136091436  -0.5627246555\n"
"        0.0803414677  -0.2362413556  -0.3691448735\n"
"#","\n"
"P DZVP-GTH-q5 DZVP-GTH\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.4960907993   0.3653124842   0.0000000000   0.0816205767   0.0000000000\n"
"        0.7169067467  -0.2125748699   0.0000000000  -0.2627397053   0.0000000000\n"
"        0.2411464781  -0.8136091436   0.0000000000  -0.5627246555   0.0000000000\n"
"        0.0803414677  -0.2362413556   1.0000000000  -0.3691448735   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3730000000   1.0000000000\n"
"#","\n"
"P TZVP-GTH-q5 TZVP-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        2.1996341190  -0.0704921557   0.0000000000   0.0000000000   0.0621639873   0.0000000000   0.0000000000\n"
"        1.6369289280   0.3969825114   0.0000000000   0.0000000000  -0.0400911635   0.0000000000   0.0000000000\n"
"        0.4970575820  -0.3512429748   0.0000000000   0.0000000000  -0.3338049853   0.0000000000   0.0000000000\n"
"        0.1944032900  -0.7297176188   1.0000000000   0.0000000000  -0.5118382938   1.0000000000   0.0000000000\n"
"        0.0699106580  -0.1421063788   0.0000000000   1.0000000000  -0.2909693679   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3730000000   1.0000000000\n"
"#","\n"
"P TZV2P-GTH-q5 TZV2P-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        2.1996341190  -0.0704921557   0.0000000000   0.0000000000   0.0621639873   0.0000000000   0.0000000000\n"
"        1.6369289280   0.3969825114   0.0000000000   0.0000000000  -0.0400911635   0.0000000000   0.0000000000\n"
"        0.4970575820  -0.3512429748   0.0000000000   0.0000000000  -0.3338049853   0.0000000000   0.0000000000\n"
"        0.1944032900  -0.7297176188   1.0000000000   0.0000000000  -0.5118382938   1.0000000000   0.0000000000\n"
"        0.0699106580  -0.1421063788   0.0000000000   1.0000000000  -0.2909693679   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.6520000000   1.0000000000   0.0000000000\n"
"        0.2160000000   0.0000000000   1.0000000000\n"
"#","\n"
"P QZV2P-GTH-q5 QZV2P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        3.7552135262   0.0219221916   0.0000000000   0.0000000000   0.0000000000  -0.0089770006   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7140316717  -0.3135634867   0.0000000000   0.0000000000   0.0000000000  -0.0448447247   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7438335270   0.0341312768   0.0000000000   0.0000000000   0.0000000000   0.1612574940   0.0000000000   0.0000000000   0.0000000000\n"
"        0.3280082762   0.6173246158   1.0000000000   0.0000000000   0.0000000000   0.4083320223   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1366188473   0.4868790477   0.0000000000   1.0000000000   0.0000000000   0.4366765007   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0534696687   0.0500106401   0.0000000000   0.0000000000   1.0000000000   0.1655268470   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.6520000000   1.0000000000   0.0000000000\n"
"        0.2160000000   0.0000000000   1.0000000000\n"
"#","\n"
"P QZV3P-GTH-q5 QZV3P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        3.7552135262   0.0219221916   0.0000000000   0.0000000000   0.0000000000  -0.0089770006   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7140316717  -0.3135634867   0.0000000000   0.0000000000   0.0000000000  -0.0448447247   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7438335270   0.0341312768   0.0000000000   0.0000000000   0.0000000000   0.1612574940   0.0000000000   0.0000000000   0.0000000000\n"
"        0.3280082762   0.6173246158   1.0000000000   0.0000000000   0.0000000000   0.4083320223   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1366188473   0.4868790477   0.0000000000   1.0000000000   0.0000000000   0.4366765007   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0534696687   0.0500106401   0.0000000000   0.0000000000   1.0000000000   0.1655268470   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.0360000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4130000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1650000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"P aug-DZVP-GTH-q5 aug-DZVP-GTH\n"
"  4\n"
"  3  0  1  4  2  2\n"
"        1.4960907993   0.3653124842   0.0000000000   0.0816205767   0.0000000000\n"
"        0.7169067467  -0.2125748699   0.0000000000  -0.2627397053   0.0000000000\n"
"        0.2411464781  -0.8136091436   0.0000000000  -0.5627246555   0.0000000000\n"
"        0.0803414677  -0.2362413556   1.0000000000  -0.3691448735   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3730000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04170000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03430000     1.0000000000\n"
"#","\n"
"P aug-TZVP-GTH-q5 aug-TZVP-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        2.1996341190  -0.0704921557   0.0000000000   0.0000000000   0.0621639873   0.0000000000   0.0000000000\n"
"        1.6369289280   0.3969825114   0.0000000000   0.0000000000  -0.0400911635   0.0000000000   0.0000000000\n"
"        0.4970575820  -0.3512429748   0.0000000000   0.0000000000  -0.3338049853   0.0000000000   0.0000000000\n"
"        0.1944032900  -0.7297176188   1.0000000000   0.0000000000  -0.5118382938   1.0000000000   0.0000000000\n"
"        0.0699106580  -0.1421063788   0.0000000000   1.0000000000  -0.2909693679   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.3730000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04090000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03070000     1.0000000000\n"
"#","\n"
"P aug-TZV2P-GTH-q5 aug-TZV2P-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        2.1996341190  -0.0704921557   0.0000000000   0.0000000000   0.0621639873   0.0000000000   0.0000000000\n"
"        1.6369289280   0.3969825114   0.0000000000   0.0000000000  -0.0400911635   0.0000000000   0.0000000000\n"
"        0.4970575820  -0.3512429748   0.0000000000   0.0000000000  -0.3338049853   0.0000000000   0.0000000000\n"
"        0.1944032900  -0.7297176188   1.0000000000   0.0000000000  -0.5118382938   1.0000000000   0.0000000000\n"
"        0.0699106580  -0.1421063788   0.0000000000   1.0000000000  -0.2909693679   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.6520000000   1.0000000000   0.0000000000\n"
"        0.2160000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04090000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03070000     1.0000000000\n"
"#","\n"
"P aug-QZV2P-GTH-q5 aug-QZV2P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        3.7552135262   0.0219221916   0.0000000000   0.0000000000   0.0000000000  -0.0089770006   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7140316717  -0.3135634867   0.0000000000   0.0000000000   0.0000000000  -0.0448447247   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7438335270   0.0341312768   0.0000000000   0.0000000000   0.0000000000   0.1612574940   0.0000000000   0.0000000000   0.0000000000\n"
"        0.3280082762   0.6173246158   1.0000000000   0.0000000000   0.0000000000   0.4083320223   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1366188473   0.4868790477   0.0000000000   1.0000000000   0.0000000000   0.4366765007   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0534696687   0.0500106401   0.0000000000   0.0000000000   1.0000000000   0.1655268470   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.6520000000   1.0000000000   0.0000000000\n"
"        0.2160000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.03540000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02720000     1.0000000000\n"
"#","\n"
"P aug-QZV3P-GTH-q5 aug-QZV3P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        3.7552135262   0.0219221916   0.0000000000   0.0000000000   0.0000000000  -0.0089770006   0.0000000000   0.0000000000   0.0000000000\n"
"        1.7140316717  -0.3135634867   0.0000000000   0.0000000000   0.0000000000  -0.0448447247   0.0000000000   0.0000000000   0.0000000000\n"
"        0.7438335270   0.0341312768   0.0000000000   0.0000000000   0.0000000000   0.1612574940   0.0000000000   0.0000000000   0.0000000000\n"
"        0.3280082762   0.6173246158   1.0000000000   0.0000000000   0.0000000000   0.4083320223   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1366188473   0.4868790477   0.0000000000   1.0000000000   0.0000000000   0.4366765007   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0534696687   0.0500106401   0.0000000000   0.0000000000   1.0000000000   0.1655268470   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.0360000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.4130000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.1650000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.03540000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.02720000     1.0000000000\n"
"#","\n"
"S SZV-GTH-q6 SZV-GTH\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        1.8379629578   0.3832142891   0.1221358296\n"
"        1.0357730084  -0.1682257315  -0.2752002461\n"
"        0.3297969875  -0.8258488166  -0.5729054592\n"
"        0.1073535471  -0.2832758052  -0.3825468137\n"
"#","\n"
"S DZVP-GTH-q6 DZVP-GTH\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        1.8379629578   0.3832142891   0.0000000000   0.1221358296   0.0000000000\n"
"        1.0357730084  -0.1682257315   0.0000000000  -0.2752002461   0.0000000000\n"
"        0.3297969875  -0.8258488166   0.0000000000  -0.5729054592   0.0000000000\n"
"        0.1073535471  -0.2832758052   1.0000000000  -0.3825468137   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4790000000   1.0000000000\n"
"#","\n"
"S TZVP-GTH-q6 TZVP-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        2.9775941238  -0.0684133054   0.0000000000   0.0000000000   0.0522484808   0.0000000000   0.0000000000\n"
"        2.0190866819   0.4095039721   0.0000000000   0.0000000000  -0.0232128642   0.0000000000   0.0000000000\n"
"        0.6439412840  -0.3403336830   0.0000000000   0.0000000000  -0.3459753011   0.0000000000   0.0000000000\n"
"        0.2501987605  -0.7425154227   1.0000000000   0.0000000000  -0.5141620418   1.0000000000   0.0000000000\n"
"        0.0891650206  -0.1520225390   0.0000000000   1.0000000000  -0.2803769713   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4790000000   1.0000000000\n"
"#","\n"
"S TZV2P-GTH-q6 TZV2P-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        2.9775941238  -0.0684133054   0.0000000000   0.0000000000   0.0522484808   0.0000000000   0.0000000000\n"
"        2.0190866819   0.4095039721   0.0000000000   0.0000000000  -0.0232128642   0.0000000000   0.0000000000\n"
"        0.6439412840  -0.3403336830   0.0000000000   0.0000000000  -0.3459753011   0.0000000000   0.0000000000\n"
"        0.2501987605  -0.7425154227   1.0000000000   0.0000000000  -0.5141620418   1.0000000000   0.0000000000\n"
"        0.0891650206  -0.1520225390   0.0000000000   1.0000000000  -0.2803769713   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.8190000000   1.0000000000   0.0000000000\n"
"        0.2690000000   0.0000000000   1.0000000000\n"
"#","\n"
"S QZV2P-GTH-q6 QZV2P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        4.2573596528   0.0340198790   0.0000000000   0.0000000000   0.0000000000  -0.0139384068   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1309107097  -0.3349229077   0.0000000000   0.0000000000   0.0000000000  -0.0449848970   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9293415064   0.0316794871   0.0000000000   0.0000000000   0.0000000000   0.1762303153   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4136351121   0.6234596988   1.0000000000   0.0000000000   0.0000000000   0.4188613693   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1723749938   0.4869763921   0.0000000000   1.0000000000   0.0000000000   0.4242144008   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0673747361   0.0524674807   0.0000000000   0.0000000000   1.0000000000   0.1544985250   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.8190000000   1.0000000000   0.0000000000\n"
"        0.2690000000   0.0000000000   1.0000000000\n"
"#","\n"
"S QZV3P-GTH-q6 QZV3P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        4.2573596528   0.0340198790   0.0000000000   0.0000000000   0.0000000000  -0.0139384068   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1309107097  -0.3349229077   0.0000000000   0.0000000000   0.0000000000  -0.0449848970   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9293415064   0.0316794871   0.0000000000   0.0000000000   0.0000000000   0.1762303153   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4136351121   0.6234596988   1.0000000000   0.0000000000   0.0000000000   0.4188613693   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1723749938   0.4869763921   0.0000000000   1.0000000000   0.0000000000   0.4242144008   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0673747361   0.0524674807   0.0000000000   0.0000000000   1.0000000000   0.1544985250   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.2500000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.5040000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2030000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"S aug-DZVP-GTH-q6 aug-DZVP-GTH\n"
"  4\n"
"  3  0  1  4  2  2\n"
"        1.8379629578   0.3832142891   0.0000000000   0.1221358296   0.0000000000\n"
"        1.0357730084  -0.1682257315   0.0000000000  -0.2752002461   0.0000000000\n"
"        0.3297969875  -0.8258488166   0.0000000000  -0.5729054592   0.0000000000\n"
"        0.1073535471  -0.2832758052   1.0000000000  -0.3825468137   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4790000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.05070000     1.0000000000\n"
"  3  1  1  1  1 \n"
"        0.03990000     1.0000000000\n"
"#","\n"
"S aug-TZVP-GTH-q6 aug-TZVP-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        2.9775941238  -0.0684133054   0.0000000000   0.0000000000   0.0522484808   0.0000000000   0.0000000000\n"
"        2.0190866819   0.4095039721   0.0000000000   0.0000000000  -0.0232128642   0.0000000000   0.0000000000\n"
"        0.6439412840  -0.3403336830   0.0000000000   0.0000000000  -0.3459753011   0.0000000000   0.0000000000\n"
"        0.2501987605  -0.7425154227   1.0000000000   0.0000000000  -0.5141620418   1.0000000000   0.0000000000\n"
"        0.0891650206  -0.1520225390   0.0000000000   1.0000000000  -0.2803769713   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.4790000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04970000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03510000     1.0000000000\n"
"#","\n"
"S aug-TZV2P-GTH-q6 aug-TZV2P-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        2.9775941238  -0.0684133054   0.0000000000   0.0000000000   0.0522484808   0.0000000000   0.0000000000\n"
"        2.0190866819   0.4095039721   0.0000000000   0.0000000000  -0.0232128642   0.0000000000   0.0000000000\n"
"        0.6439412840  -0.3403336830   0.0000000000   0.0000000000  -0.3459753011   0.0000000000   0.0000000000\n"
"        0.2501987605  -0.7425154227   1.0000000000   0.0000000000  -0.5141620418   1.0000000000   0.0000000000\n"
"        0.0891650206  -0.1520225390   0.0000000000   1.0000000000  -0.2803769713   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.8190000000   1.0000000000   0.0000000000\n"
"        0.2690000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04970000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03510000     1.0000000000\n"
"#","\n"
"S aug-QZV2P-GTH-q6 aug-QZV2P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        4.2573596528   0.0340198790   0.0000000000   0.0000000000   0.0000000000  -0.0139384068   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1309107097  -0.3349229077   0.0000000000   0.0000000000   0.0000000000  -0.0449848970   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9293415064   0.0316794871   0.0000000000   0.0000000000   0.0000000000   0.1762303153   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4136351121   0.6234596988   1.0000000000   0.0000000000   0.0000000000   0.4188613693   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1723749938   0.4869763921   0.0000000000   1.0000000000   0.0000000000   0.4242144008   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0673747361   0.0524674807   0.0000000000   0.0000000000   1.0000000000   0.1544985250   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        0.8190000000   1.0000000000   0.0000000000\n"
"        0.2690000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04280000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03170000     1.0000000000\n"
"#","\n"
"S aug-QZV3P-GTH-q6 aug-QZV3P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        4.2573596528   0.0340198790   0.0000000000   0.0000000000   0.0000000000  -0.0139384068   0.0000000000   0.0000000000   0.0000000000\n"
"        2.1309107097  -0.3349229077   0.0000000000   0.0000000000   0.0000000000  -0.0449848970   0.0000000000   0.0000000000   0.0000000000\n"
"        0.9293415064   0.0316794871   0.0000000000   0.0000000000   0.0000000000   0.1762303153   0.0000000000   0.0000000000   0.0000000000\n"
"        0.4136351121   0.6234596988   1.0000000000   0.0000000000   0.0000000000   0.4188613693   1.0000000000   0.0000000000   0.0000000000\n"
"        0.1723749938   0.4869763921   0.0000000000   1.0000000000   0.0000000000   0.4242144008   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0673747361   0.0524674807   0.0000000000   0.0000000000   1.0000000000   0.1544985250   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.2500000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.5040000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2030000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.04280000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03170000     1.0000000000\n"
"#","\n"
"Cl SZV-GTH-q7 SZV-GTH\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        2.2321759828   0.3787844947   0.1555385229\n"
"        1.3787736290  -0.1239714599  -0.2931741896\n"
"        0.4264904045  -0.8298226129  -0.5781097351\n"
"        0.1366670312  -0.3175023225  -0.3901110870\n"
"#","\n"
"Cl DZVP-GTH-q7 DZVP-GTH\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        2.2321759828   0.3787844947   0.0000000000   0.1555385229   0.0000000000\n"
"        1.3787736290  -0.1239714599   0.0000000000  -0.2931741896   0.0000000000\n"
"        0.4264904045  -0.8298226129   0.0000000000  -0.5781097351   0.0000000000\n"
"        0.1366670312  -0.3175023225   1.0000000000  -0.3901110870   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"Cl TZVP-GTH-q7 TZVP-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        3.4404677360  -0.0962885076   0.0000000000   0.0000000000   0.0674841325   0.0000000000   0.0000000000\n"
"        2.4424740830   0.4481503162   0.0000000000   0.0000000000  -0.0388856129   0.0000000000   0.0000000000\n"
"        0.7848604567  -0.3507929510   0.0000000000   0.0000000000  -0.3633699842   0.0000000000   0.0000000000\n"
"        0.3048755969  -0.7403677289   1.0000000000   0.0000000000  -0.5101595423   1.0000000000   0.0000000000\n"
"        0.1084717366  -0.1528159301   0.0000000000   1.0000000000  -0.2654035575   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"#","\n"
"Cl TZV2P-GTH-q7 TZV2P-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        3.4404677360  -0.0962885076   0.0000000000   0.0000000000   0.0674841325   0.0000000000   0.0000000000\n"
"        2.4424740830   0.4481503162   0.0000000000   0.0000000000  -0.0388856129   0.0000000000   0.0000000000\n"
"        0.7848604567  -0.3507929510   0.0000000000   0.0000000000  -0.3633699842   0.0000000000   0.0000000000\n"
"        0.3048755969  -0.7403677289   1.0000000000   0.0000000000  -0.5101595423   1.0000000000   0.0000000000\n"
"        0.1084717366  -0.1528159301   0.0000000000   1.0000000000  -0.2654035575   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0460000000   1.0000000000   0.0000000000\n"
"        0.3440000000   0.0000000000   1.0000000000\n"
"#","\n"
"Cl QZV2P-GTH-q7 QZV2P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        4.7390692540   0.0460145547   0.0000000000   0.0000000000   0.0000000000  -0.0184287984   0.0000000000   0.0000000000   0.0000000000\n"
"        2.5664506160  -0.3573237652   0.0000000000   0.0000000000   0.0000000000  -0.0428888823   0.0000000000   0.0000000000   0.0000000000\n"
"        1.1168239570   0.0404814650   0.0000000000   0.0000000000   0.0000000000   0.1933392026   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5007318360   0.6290842339   1.0000000000   0.0000000000   0.0000000000   0.4262968544   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2092217935   0.4804996350   0.0000000000   1.0000000000   0.0000000000   0.4107393400   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818080455   0.0532567628   0.0000000000   0.0000000000   1.0000000000   0.1444014999   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0460000000   1.0000000000   0.0000000000\n"
"        0.3440000000   0.0000000000   1.0000000000\n"
"#","\n"
"Cl QZV3P-GTH-q7 QZV3P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        4.7390692540   0.0460145547   0.0000000000   0.0000000000   0.0000000000  -0.0184287984   0.0000000000   0.0000000000   0.0000000000\n"
"        2.5664506160  -0.3573237652   0.0000000000   0.0000000000   0.0000000000  -0.0428888823   0.0000000000   0.0000000000   0.0000000000\n"
"        1.1168239570   0.0404814650   0.0000000000   0.0000000000   0.0000000000   0.1933392026   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5007318360   0.6290842339   1.0000000000   0.0000000000   0.0000000000   0.4262968544   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2092217935   0.4804996350   0.0000000000   1.0000000000   0.0000000000   0.4107393400   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818080455   0.0532567628   0.0000000000   0.0000000000   1.0000000000   0.1444014999   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.5510000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.6280000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2540000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"Cl aug-DZVP-GTH-q7 aug-DZVP-GTH\n"
"  4\n"
"  3  0  1  4  2  2\n"
"        2.2321759828   0.3787844947   0.0000000000   0.1555385229   0.0000000000\n"
"        1.3787736290  -0.1239714599   0.0000000000  -0.2931741896   0.0000000000\n"
"        0.4264904045  -0.8298226129   0.0000000000  -0.5781097351   0.0000000000\n"
"        0.1366670312  -0.3175023225   1.0000000000  -0.3901110870   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.06080000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.04660000     1.0000000000\n"
"#","\n"
"Cl aug-TZVP-GTH-q7 aug-TZVP-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        3.4404677360  -0.0962885076   0.0000000000   0.0000000000   0.0674841325   0.0000000000   0.0000000000\n"
"        2.4424740830   0.4481503162   0.0000000000   0.0000000000  -0.0388856129   0.0000000000   0.0000000000\n"
"        0.7848604567  -0.3507929510   0.0000000000   0.0000000000  -0.3633699842   0.0000000000   0.0000000000\n"
"        0.3048755969  -0.7403677289   1.0000000000   0.0000000000  -0.5101595423   1.0000000000   0.0000000000\n"
"        0.1084717366  -0.1528159301   0.0000000000   1.0000000000  -0.2654035575   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.6000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.05910000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.04190000     1.0000000000\n"
"#","\n"
"Cl aug-TZV2P-GTH-q7 aug-TZV2P-GTH\n"
"  4\n"
"  3  0  1  5  3  3\n"
"        3.4404677360  -0.0962885076   0.0000000000   0.0000000000   0.0674841325   0.0000000000   0.0000000000\n"
"        2.4424740830   0.4481503162   0.0000000000   0.0000000000  -0.0388856129   0.0000000000   0.0000000000\n"
"        0.7848604567  -0.3507929510   0.0000000000   0.0000000000  -0.3633699842   0.0000000000   0.0000000000\n"
"        0.3048755969  -0.7403677289   1.0000000000   0.0000000000  -0.5101595423   1.0000000000   0.0000000000\n"
"        0.1084717366  -0.1528159301   0.0000000000   1.0000000000  -0.2654035575   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0460000000   1.0000000000   0.0000000000\n"
"        0.3440000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.05910000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.04190000     1.0000000000\n"
"#","\n"
"Cl aug-QZV2P-GTH-q7 aug-QZV2P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        4.7390692540   0.0460145547   0.0000000000   0.0000000000   0.0000000000  -0.0184287984   0.0000000000   0.0000000000   0.0000000000\n"
"        2.5664506160  -0.3573237652   0.0000000000   0.0000000000   0.0000000000  -0.0428888823   0.0000000000   0.0000000000   0.0000000000\n"
"        1.1168239570   0.0404814650   0.0000000000   0.0000000000   0.0000000000   0.1933392026   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5007318360   0.6290842339   1.0000000000   0.0000000000   0.0000000000   0.4262968544   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2092217935   0.4804996350   0.0000000000   1.0000000000   0.0000000000   0.4107393400   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818080455   0.0532567628   0.0000000000   0.0000000000   1.0000000000   0.1444014999   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.0460000000   1.0000000000   0.0000000000\n"
"        0.3440000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.05190000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03760000     1.0000000000\n"
"#","\n"
"Cl aug-QZV3P-GTH-q7 aug-QZV3P-GTH\n"
"  4\n"
"  3  0  1  6  4  4\n"
"        4.7390692540   0.0460145547   0.0000000000   0.0000000000   0.0000000000  -0.0184287984   0.0000000000   0.0000000000   0.0000000000\n"
"        2.5664506160  -0.3573237652   0.0000000000   0.0000000000   0.0000000000  -0.0428888823   0.0000000000   0.0000000000   0.0000000000\n"
"        1.1168239570   0.0404814650   0.0000000000   0.0000000000   0.0000000000   0.1933392026   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5007318360   0.6290842339   1.0000000000   0.0000000000   0.0000000000   0.4262968544   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2092217935   0.4804996350   0.0000000000   1.0000000000   0.0000000000   0.4107393400   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0818080455   0.0532567628   0.0000000000   0.0000000000   1.0000000000   0.1444014999   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.5510000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.6280000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.2540000000   0.0000000000   0.0000000000   1.0000000000\n"
"  3  0  0  1  1\n"
"        0.05190000     1.0000000000\n"
"  3  1  1  1  1\n"
"        0.03760000     1.0000000000\n"
"#","\n"
"Ar SZV-GTH-q8 SZV-GTH\n"
"  1\n"
"  3  0  1  4  1  1\n"
"        2.6436341408   0.3737594656   0.1735190188\n"
"        1.6948954231  -0.0996534757  -0.3100915552\n"
"        0.5231109619  -0.8315200024  -0.5807564917\n"
"        0.1663306660  -0.3339930084  -0.3879330451\n"
"#","\n"
"Ar DZVP-GTH-q8 DZVP-GTH\n"
"  2\n"
"  3  0  1  4  2  2\n"
"        2.6436341408   0.3737594656   0.0000000000   0.1735190188   0.0000000000\n"
"        1.6948954231  -0.0996534757   0.0000000000  -0.3100915552   0.0000000000\n"
"        0.5231109619  -0.8315200024   0.0000000000  -0.5807564917   0.0000000000\n"
"        0.1663306660  -0.3339930084   1.0000000000  -0.3879330451   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7380000000   1.0000000000\n"
"#","\n"
"Ar TZVP-GTH-q8 TZVP-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        3.7933849461  -0.1618280953   0.0000000000   0.0000000000   0.0960404756   0.0000000000   0.0000000000\n"
"        2.9269187333   0.5221781637   0.0000000000   0.0000000000  -0.0704844503   0.0000000000   0.0000000000\n"
"        0.9316537640  -0.3632163241   0.0000000000   0.0000000000  -0.3787707182   0.0000000000   0.0000000000\n"
"        0.3621005146  -0.7358329756   1.0000000000   0.0000000000  -0.5047539917   1.0000000000   0.0000000000\n"
"        0.1287409102  -0.1523090856   0.0000000000   1.0000000000  -0.2525011145   0.0000000000   1.0000000000\n"
"  3  2  2  1  1\n"
"        0.7380000000   1.0000000000\n"
"#","\n"
"Ar TZV2P-GTH-q8 TZV2P-GTH\n"
"  2\n"
"  3  0  1  5  3  3\n"
"        3.7933849461  -0.1618280953   0.0000000000   0.0000000000   0.0960404756   0.0000000000   0.0000000000\n"
"        2.9269187333   0.5221781637   0.0000000000   0.0000000000  -0.0704844503   0.0000000000   0.0000000000\n"
"        0.9316537640  -0.3632163241   0.0000000000   0.0000000000  -0.3787707182   0.0000000000   0.0000000000\n"
"        0.3621005146  -0.7358329756   1.0000000000   0.0000000000  -0.5047539917   1.0000000000   0.0000000000\n"
"        0.1287409102  -0.1523090856   0.0000000000   1.0000000000  -0.2525011145   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.2540000000   1.0000000000   0.0000000000\n"
"        0.4100000000   0.0000000000   1.0000000000\n"
"#","\n"
"Ar QZV2P-GTH-q8 QZV2P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        5.2342384840   0.0594091942   0.0000000000   0.0000000000   0.0000000000  -0.0218235164   0.0000000000   0.0000000000   0.0000000000\n"
"        3.0293732626  -0.3808584814   0.0000000000   0.0000000000   0.0000000000  -0.0397609427   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3121914980   0.0527214554   0.0000000000   0.0000000000   0.0000000000   0.2096390562   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5914580696   0.6333744672   1.0000000000   0.0000000000   0.0000000000   0.4311838680   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2478147218   0.4727819382   0.0000000000   1.0000000000   0.0000000000   0.3981434659   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0969644987   0.0535029998   0.0000000000   0.0000000000   1.0000000000   0.1359825259   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  2  2\n"
"        1.2540000000   1.0000000000   0.0000000000\n"
"        0.4100000000   0.0000000000   1.0000000000\n"
"#","\n"
"Ar QZV3P-GTH-q8 QZV3P-GTH\n"
"  2\n"
"  3  0  1  6  4  4\n"
"        5.2342384840   0.0594091942   0.0000000000   0.0000000000   0.0000000000  -0.0218235164   0.0000000000   0.0000000000   0.0000000000\n"
"        3.0293732626  -0.3808584814   0.0000000000   0.0000000000   0.0000000000  -0.0397609427   0.0000000000   0.0000000000   0.0000000000\n"
"        1.3121914980   0.0527214554   0.0000000000   0.0000000000   0.0000000000   0.2096390562   0.0000000000   0.0000000000   0.0000000000\n"
"        0.5914580696   0.6333744672   1.0000000000   0.0000000000   0.0000000000   0.4311838680   1.0000000000   0.0000000000   0.0000000000\n"
"        0.2478147218   0.4727819382   0.0000000000   1.0000000000   0.0000000000   0.3981434659   0.0000000000   1.0000000000   0.0000000000\n"
"        0.0969644987   0.0535029998   0.0000000000   0.0000000000   1.0000000000   0.1359825259   0.0000000000   0.0000000000   1.0000000000\n"
"  3  2  2  3  3\n"
"        1.8730000000   1.0000000000   0.0000000000   0.0000000000\n"
"        0.7630000000   0.0000000000   1.0000000000   0.0000000000\n"
"        0.3110000000   0.0000000000   0.0000000000   1.0000000000\n"
"#","\n"
"W DZVP-GTH-q14 DZVP-GTH\n"
"  3\n"
"  5  0  0  4  3\n"
"          3.17833961    -0.59405642     0.16293727     0.00000000\n"
"          1.54892965     0.66388244    -0.20717075     0.00000000\n"
"          0.65507630     0.77725275    -0.51725023     0.00000000\n"
"          0.08615458     0.02093277     1.15557619     1.00000000\n"
"  5  1  1  4  2\n"
"          2.98630221     0.05620580     0.00000000\n"
"          1.21317676    -0.52492834     0.00000000\n"
"          0.58573989    -0.46305304     0.00000000\n"
"          0.26423237    -0.11761739     1.00000000\n"
"  5  2  2  4  2\n"
"          3.98958029     0.05242902     0.00000000\n"
"          1.11283726    -0.37652293     0.00000000\n"
"          0.39364968    -0.52218358     0.00000000\n"
"          0.12396511    -0.33923705     1.00000000\n"
"#"};
