subroutine te0085(option, nomte)
! ======================================================================
! COPYRIGHT (C) 1991 - 2013  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
    implicit none
#include "jeveux.h"
!
#include "asterfort/dfdm2d.h"
#include "asterfort/elref4.h"
#include "asterfort/jevech.h"
#include "asterfort/lteatt.h"
#include "asterfort/rccoma.h"
#include "asterfort/rcvalb.h"
    character(len=16) :: option, nomte, phenom
! ......................................................................
!    - FONCTION REALISEE:  CALCUL DES TERMES ELEMENTAIRES EN MECANIQUE
!                          OPTION : 'CHAR_MECA_PESA_R'
!                          2D PLAN ET AXISYMETRIQUE
!    - ARGUMENTS:
!        DONNEES:      OPTION       -->  OPTION DE CALCUL
!                      NOMTE        -->  NOM DU TYPE ELEMENT
! ......................................................................
!
    integer :: icodre
    real(kind=8) :: dfdx(9), dfdy(9), poids, rx
    integer :: nno, kp, k, npg, i, ivectu, ipesa
    integer :: ipoids, ivf, idfde, igeom, imate
!
!
!-----------------------------------------------------------------------
    integer :: jgano, ndim, nnos
    real(kind=8) :: r8b, rho
!-----------------------------------------------------------------------
    call elref4(' ', 'RIGI', ndim, nno, nnos,&
                npg, ipoids, ivf, idfde, jgano)
!
    call jevech('PGEOMER', 'L', igeom)
    call jevech('PMATERC', 'L', imate)
    call jevech('PPESANR', 'L', ipesa)
    call jevech('PVECTUR', 'E', ivectu)
!
    call rccoma(zi(imate), 'ELAS', 1, phenom, icodre)
    call rcvalb('FPG1', 1, 1, '+', zi(imate),&
                ' ', phenom, 0, ' ', r8b,&
                1, 'RHO', rho, icodre, 1)
!
    do 101 kp = 1, npg
        k = nno*(kp-1)
        call dfdm2d(nno, kp, ipoids, idfde, zr(igeom),&
                    dfdx, dfdy, poids)
        poids = poids * rho * zr(ipesa)
        if (lteatt(' ','AXIS','OUI')) then
            rx= 0.d0
            do 102 i = 1, nno
                rx= rx+ zr(igeom+2*i-2)*zr(ivf+k+i-1)
102          continue
            poids = poids*rx
            do 103 i = 1, nno
                zr(ivectu+2*i-1) = zr(ivectu+2*i-1) + poids*zr(ipesa+ 2)*zr(ivf+k+i-1)
103          continue
        else
            do 104 i = 1, nno
                zr(ivectu+2*i-2) = zr(ivectu+2*i-2) + poids*zr(ipesa+ 1)*zr(ivf+k+i-1)
                zr(ivectu+2*i-1) = zr(ivectu+2*i-1) + poids*zr(ipesa+ 2)*zr(ivf+k+i-1)
104          continue
        endif
101  end do
end subroutine
