subroutine shbbar(x, b, vol)
! ======================================================================
! COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
!--------------------------------------------------------
! ELEMENT SHB8-PS A.COMBESCURE, S.BAGUET INSA LYON 2003 /
!-------------------------------------------------------
    implicit none
    real(kind=8) :: uns12
    real(kind=8) :: x(24)
    real(kind=8) :: b(3, 8), vol
    integer :: i, j
    uns12=1.d0/12.d0
!****** CALCUL DES MATRICES B_BARRE
!
    b(1,1)= x(5)*(x(18)-x(9)+x(15)-x(12))+x(8)*(x(6)-x(12))+&
     & x(11)*(x(9)-x(24)+x(6)-x(15))+x(14)*(x(24)-x(18)+x(12)-x(6))+&
     & x(17)*(x(15)-x(6))+x(23)*(x(12)-x(15))
!
    b(1,2)= x(8)*(x(21)-x(12)+x(18)-x(3))+x(11)*(x(9)-x(3))+&
     & x(2)*(x(12)-x(15)+x(9)-x(18))+x(17)*(x(15)-x(21)+x(3)-x(9))+&
     & x(20)*(x(18)-x(9))+x(14)*(x(3)-x(18))
!
    b(1,3)= x(11)*(x(24)-x(3)+x(21)-x(6))+x(2)*(x(12)-x(6))+&
     & x(5)*(x(3)-x(18)+x(12)-x(21))+x(20)*(x(18)-x(24)+x(6)-x(12))+&
     & x(23)*(x(21)-x(12))+x(17)*(x(6)-x(21))
!
    b(1,4)= x(2)*(x(15)-x(6)+x(24)-x(9))+x(5)*(x(3)-x(9))+&
     & x(8)*(x(6)-x(21)+x(3)-x(24))+x(23)*(x(21)-x(15)+x(9)-x(3))+&
     & x(14)*(x(24)-x(3))+x(20)*(x(9)-x(24))
!
    b(1,5)= x(23)*(x(12)-x(21)+x(3)-x(18))+x(20)*(x(24)-x(18))+&
     & x(17)*(x(21)-x(6)+x(24)-x(3))+x(2)*(x(6)-x(12)+x(18)-x(24))+&
     & x(11)*(x(3)-x(24))+x(5)*(x(18)-x(3))
!
    b(1,6)= x(14)*(x(3)-x(24)+x(6)-x(21))+x(23)*(x(15)-x(21))+&
     & x(20)*(x(24)-x(9)+x(15)-x(6))+x(5)*(x(9)-x(3)+x(21)-x(15))+&
     & x(2)*(x(6)-x(15))+x(8)*(x(21)-x(6))
!
    b(1,7)= x(17)*(x(6)-x(15)+x(9)-x(24))+x(14)*(x(18)-x(24))+&
     & x(23)*(x(15)-x(12)+x(18)-x(9))+x(8)*(x(12)-x(6)+x(24)-x(18))+&
     & x(5)*(x(9)-x(18))+x(11)*(x(24)-x(9))
!
    b(1,8)= x(20)*(x(9)-x(18)+x(12)-x(15))+x(17)*(x(21)-x(15))+&
     & x(14)*(x(18)-x(3)+x(21)-x(12))+x(11)*(x(3)-x(9)+x(15)-x(21))+&
     & x(8)*(x(12)-x(21))+x(2)*(x(15)-x(12))
!
!
!
!
    b(2,1)= x(6)*(x(16)-x(7)+x(13)-x(10))+x(9)*(x(4)-x(10))+&
     & x(12)*(x(7)-x(22)+x(4)-x(13))+x(15)*(x(22)-x(16)+x(10)-x(4))+&
     & x(18)*(x(13)-x(4))+x(24)*(x(10)-x(13))
!
    b(2,2)= x(9)*(x(19)-x(10)+x(16)-x(1))+x(12)*(x(7)-x(1))+&
     & x(3)*(x(10)-x(13)+x(7)-x(16))+x(18)*(x(13)-x(19)+x(1)-x(7))+&
     & x(21)*(x(16)-x(7))+x(15)*(x(1)-x(16))
!
    b(2,3)= x(12)*(x(22)-x(1)+x(19)-x(4))+x(3)*(x(10)-x(4))+&
     & x(6)*(x(1)-x(16)+x(10)-x(19))+x(21)*(x(16)-x(22)+x(4)-x(10))+&
     & x(24)*(x(19)-x(10))+x(18)*(x(4)-x(19))
!
    b(2,4)= x(3)*(x(13)-x(4)+x(22)-x(7))+x(6)*(x(1)-x(7))+&
     & x(9)*(x(4)-x(19)+x(1)-x(22))+x(24)*(x(19)-x(13)+x(7)-x(1))+&
     & x(15)*(x(22)-x(1))+x(21)*(x(7)-x(22))
!
    b(2,5)= x(24)*(x(10)-x(19)+x(1)-x(16))+x(21)*(x(22)-x(16))+&
     & x(18)*(x(19)-x(4)+x(22)-x(1))+x(3)*(x(4)-x(10)+x(16)-x(22))+&
     & x(12)*(x(1)-x(22))+x(6)*(x(16)-x(1))
!
    b(2,6)= x(15)*(x(1)-x(22)+x(4)-x(19))+x(24)*(x(13)-x(19))+&
     & x(21)*(x(22)-x(7)+x(13)-x(4))+x(6)*(x(7)-x(1)+x(19)-x(13))+&
     & x(3)*(x(4)-x(13))+x(9)*(x(19)-x(4))
!
    b(2,7)= x(18)*(x(4)-x(13)+x(7)-x(22))+x(15)*(x(16)-x(22))+&
     & x(24)*(x(13)-x(10)+x(16)-x(7))+x(9)*(x(10)-x(4)+x(22)-x(16))+&
     & x(6)*(x(7)-x(16))+x(12)*(x(22)-x(7))
!
    b(2,8)= x(21)*(x(7)-x(16)+x(10)-x(13))+x(18)*(x(19)-x(13))+&
     & x(15)*(x(16)-x(1)+x(19)-x(10))+x(12)*(x(1)-x(7)+x(13)-x(19))+&
     & x(9)*(x(10)-x(19))+x(3)*(x(13)-x(10))
!
!
!
    b(3,1)= x(4)*(x(17)-x(8)+x(14)-x(11))+x(7)*(x(5)-x(11))+&
     & x(10)*(x(8)-x(23)+x(5)-x(14))+x(13)*(x(23)-x(17)+x(11)-x(5))+&
     & x(16)*(x(14)-x(5))+x(22)*(x(11)-x(14))
!
    b(3,2)= x(7)*(x(20)-x(11)+x(17)-x(2))+x(10)*(x(8)-x(2))+&
     & x(1)*(x(11)-x(14)+x(8)-x(17))+x(16)*(x(14)-x(20)+x(2)-x(8))+&
     & x(19)*(x(17)-x(8))+x(13)*(x(2)-x(17))
!
    b(3,3)= x(10)*(x(23)-x(2)+x(20)-x(5))+x(1)*(x(11)-x(5))+&
     & x(4)*(x(2)-x(17)+x(11)-x(20))+x(19)*(x(17)-x(23)+x(5)-x(11))+&
     & x(22)*(x(20)-x(11))+x(16)*(x(5)-x(20))
!
    b(3,4)= x(1)*(x(14)-x(5)+x(23)-x(8))+x(4)*(x(2)-x(8))+&
     & x(7)*(x(5)-x(20)+x(2)-x(23))+x(22)*(x(20)-x(14)+x(8)-x(2))+&
     & x(13)*(x(23)-x(2))+x(19)*(x(8)-x(23))
!
    b(3,5)= x(22)*(x(11)-x(20)+x(2)-x(17))+x(19)*(x(23)-x(17))+&
     & x(16)*(x(20)-x(5)+x(23)-x(2))+x(1)*(x(5)-x(11)+x(17)-x(23))+&
     & x(10)*(x(2)-x(23))+x(4)*(x(17)-x(2))
!
    b(3,6)= x(13)*(x(2)-x(23)+x(5)-x(20))+x(22)*(x(14)-x(20))+&
     & x(19)*(x(23)-x(8)+x(14)-x(5))+x(4)*(x(8)-x(2)+x(20)-x(14))+&
     & x(1)*(x(5)-x(14))+x(7)*(x(20)-x(5))
!
    b(3,7)= x(16)*(x(5)-x(14)+x(8)-x(23))+x(13)*(x(17)-x(23))+&
     & x(22)*(x(14)-x(11)+x(17)-x(8))+x(7)*(x(11)-x(5)+x(23)-x(17))+&
     & x(4)*(x(8)-x(17))+x(10)*(x(23)-x(8))
!
    b(3,8)= x(19)*(x(8)-x(17)+x(11)-x(14))+x(16)*(x(20)-x(14))+&
     & x(13)*(x(17)-x(2)+x(20)-x(11))+x(10)*(x(2)-x(8)+x(14)-x(20))+&
     & x(7)*(x(11)-x(20))+x(1)*(x(14)-x(11))
!
!
!****** CALCUL DU VOLUME DE L'ELEMENT
!
    vol= uns12*(b(1,1)*x(1)+b(1,2)*x(4)+b(1,3)*x(7)+b(1,4)*x(10)+&
     &  b(1,5)*x(13)+b(1,6)*x(16)+b(1,7)*x(19)+b(1,8)*x(22))
!
!****** CALCUL DES MATRICES B
!
    do 10 j = 1, 3
        do 20 i = 1, 8
            b(j,i)= uns12*b(j,i)/vol
20      continue
10  end do
!
end subroutine
