/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.aspectj.internal.tools.ant.taskdefs.AJInstaller;
import org.aspectj.internal.tools.ant.taskdefs.AntBuilder;
import org.aspectj.internal.tools.build.BuildSpec;
import org.aspectj.internal.tools.build.Builder;
import org.aspectj.internal.tools.build.Messager;
import org.aspectj.internal.tools.build.Util;

class ProductBuilder
extends AntBuilder {
    private static String getProductInstallResourcesSrc(BuildSpec buildSpec) {
        String resourcesName = "installer-resources";
        File dir = buildSpec.productDir.getParentFile();
        if (null == dir) {
            return Util.path(new String[]{"..", "..", "installer-resources"});
        }
        if (null == (dir = dir.getParentFile())) {
            return Util.path("..", "installer-resources");
        }
        dir = new File(dir, "installer-resources");
        return dir.getPath();
    }

    private static String getProductInstallerFileName(BuildSpec buildSpec) {
        return "aspectj-" + buildSpec.productDir.getName() + "-" + Util.shortVersion(buildSpec.version) + ".jar";
    }

    private static String getProductInstallerMainClass(BuildSpec buildSpec) {
        String productName = buildSpec.productDir.getName();
        String initial = productName.substring(0, 1).toUpperCase();
        productName = initial + productName.substring(1);
        return "$installer$.org.aspectj." + productName + "Installer";
    }

    ProductBuilder(Project project, File tempDir, boolean useEclipseCompiles, Messager handler) {
        super(project, tempDir, useEclipseCompiles, handler);
    }

    protected boolean copyBinaries(BuildSpec buildSpec, File distDir, File targDir, String excludes) {
        Copy copy = this.makeCopyTask(false);
        copy.setTodir(targDir);
        FileSet fileset = new FileSet();
        fileset.setDir(distDir);
        fileset.setIncludes(Builder.BINARY_SOURCE_PATTERN);
        if (null != excludes) {
            fileset.setExcludes(excludes);
        }
        copy.addFileset(fileset);
        return this.executeTask((Task)copy);
    }

    protected boolean copyNonBinaries(BuildSpec buildSpec, File distDir, File targDir) {
        Copy copy = this.makeCopyTask(true);
        copy.setTodir(targDir);
        Util.iaxIfNotCanReadDir(distDir, "product dist directory");
        FileSet fileset = new FileSet();
        fileset.setDir(distDir);
        fileset.setExcludes(Builder.BINARY_SOURCE_PATTERN);
        copy.addFileset(fileset);
        return this.executeTask((Task)copy);
    }

    protected boolean buildInstaller(BuildSpec buildSpec, String targDirPath) {
        if (buildSpec.verbose) {
            this.handler.log("creating installer for " + buildSpec);
        }
        AJInstaller installer2 = new AJInstaller();
        this.setupTask((Task)installer2, "installer");
        installer2.setBasedir(targDirPath);
        File installSrcDir = new File(buildSpec.productDir, "install");
        Util.iaxIfNotCanReadDir(installSrcDir, "installSrcDir");
        installer2.setHtmlSrc(installSrcDir.getPath());
        String resourcePath = ProductBuilder.getProductInstallResourcesSrc(buildSpec);
        File resourceSrcDir = new File(resourcePath);
        Util.iaxIfNotCanReadDir(resourceSrcDir, "resourceSrcDir");
        installer2.setResourcesSrc(resourcePath);
        String name = ProductBuilder.getProductInstallerFileName(buildSpec);
        File outFile = new File(buildSpec.jarDir, name);
        installer2.setZipfile(outFile.getPath());
        installer2.setMainclass(ProductBuilder.getProductInstallerMainClass(buildSpec));
        installer2.setInstallerclassjar(this.getBuildJar(buildSpec));
        return this.executeTask((Task)installer2);
    }

    private String getBuildJar(BuildSpec buildSpec) {
        return buildSpec.baseDir.getPath() + "/lib/build/build.jar";
    }
}

