// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_h__
#define __location_h__

#include "Puma/Filename.h"

namespace Puma {


class Location {
  Filename _filename;
  int _line;
  int _column;

public:
  Location () : _filename (), _line (0), _column (0) {}
  Location (Filename f, int l, int c = 0) { setup (f, l, c); }
  void setup (Filename f, int l, int c = 0) {
    _filename = f;
    _line     = l;
    _column   = c;
  }
  const Filename &filename () const { return _filename; }
  int line () const { return _line; }
  int column () const { return _column; }
  bool operator == (const Location &l) const {
    return filename () == l.filename () && line () == l.line () &&
      column () == l.column ();
  }
  bool operator != (const Location &l) const { return ! (*this == l); }
  bool operator < (const Location &l) const {
    // TODO: does it make sense to compare the filenames? better assert?
    if (filename () != l.filename ())
      return false;
    return line () < l.line () && column () < l.column ();
  }
};

inline std::ostream &operator << (std::ostream &os, const Location &loc) {
#ifdef VISUAL_STUDIO
  os << loc.filename () << "(" << loc.line () << ")";
#else
  os << loc.filename () << ":" << loc.line ();
#endif
  return os;  
}
} // namespace Puma

#endif /* __location_h__ */
