/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jiapi.Configuration;
import net.sf.jiapi.file.ParseException;

public class ConstantPool
implements Iterable<Entry> {
    private static Configuration config = new Configuration();
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_InvokeDynamic = 18;
    private ArrayList<Entry> cp;

    ConstantPool(int size) {
        this.cp = new ArrayList(size);
    }

    public ConstantPool() {
        this.cp = new ArrayList();
    }

    public short add(Entry entry) {
        if (entry instanceof ClassInfo) {
            return this.addClassInfo(((ClassInfo)entry).getName()).getEntryIndex();
        }
        if (entry instanceof FieldRefInfo) {
            FieldRefInfo fri = (FieldRefInfo)entry;
            short ciIdx = this.add(fri.getClassInfo());
            return this.addFieldRefInfo((ClassInfo)this.get(ciIdx), fri.getNameAndTypeInfo().getName(), fri.getNameAndTypeInfo().getDescriptor()).getEntryIndex();
        }
        if (entry instanceof MethodRefInfo) {
            MethodRefInfo mri = (MethodRefInfo)entry;
            short ciIdx = this.add(mri.getClassInfo());
            return this.addMethodRefInfo((ClassInfo)this.get(ciIdx), mri.getNameAndTypeInfo().getName(), mri.getNameAndTypeInfo().getDescriptor()).getEntryIndex();
        }
        if (entry instanceof InterfaceMethodRefInfo) {
            InterfaceMethodRefInfo imri = (InterfaceMethodRefInfo)entry;
            short ciIdx = this.add(imri.getClassInfo());
            return this.addInterfaceMethodRefInfo((ClassInfo)this.get(ciIdx), imri.getNameAndTypeInfo().getName(), imri.getNameAndTypeInfo().getDescriptor()).getEntryIndex();
        }
        if (entry instanceof StringInfo) {
            StringInfo si = (StringInfo)entry;
            return this.addStringInfo(si.stringValue()).getEntryIndex();
        }
        if (entry instanceof IntegerInfo || entry instanceof FloatInfo) {
            this.cp.add(entry);
            return (short)this.cp.size();
        }
        if (entry instanceof LongInfo || entry instanceof DoubleInfo) {
            this.cp.add(entry);
            this.cp.add(new NullEntry());
            return (short)(this.cp.size() - 1);
        }
        if (entry instanceof NameAndTypeInfo) {
            NameAndTypeInfo nti = (NameAndTypeInfo)entry;
            return this.addNameAndTypeInfo(nti.getName(), nti.getDescriptor()).getEntryIndex();
        }
        if (entry instanceof Utf8Info) {
            Utf8Info utf8 = (Utf8Info)entry;
            return this.addUtf8Info(utf8.stringValue()).getEntryIndex();
        }
        throw new RuntimeException("ConstantPool.Entry not handled: " + entry);
    }

    short addClassInfo(short nameIndex) {
        Entry e;
        if (nameIndex <= 0) {
            throw new ParseException("Adding class_info, but name_index does not points to 0", this);
        }
        if (nameIndex <= this.cp.size() && !((e = this.get(nameIndex)) instanceof Utf8Info)) {
            throw new ParseException("Adding class_info, but name_index does not point to Utf8Info; index=" + nameIndex + ", " + e, this);
        }
        ClassInfo ci = new ClassInfo(nameIndex);
        this.cp.add(ci);
        return (short)this.cp.size();
    }

    public ClassInfo addClassInfo(String className) {
        String internalName = className.replace('.', '/');
        short idx = this.findClassInfo(0, internalName);
        if (idx != -1) {
            return (ClassInfo)this.cp.get(idx);
        }
        Utf8Info u8 = this.addUtf8Info(internalName);
        ClassInfo ci = new ClassInfo(u8.getEntryIndex());
        this.cp.add(ci);
        return ci;
    }

    public FieldRefInfo addFieldRefInfo(ClassInfo ci, String name, String desc) {
        FieldRefInfo __fi = this.findFieldRefInfo(0, ci, name, desc);
        if (__fi != null) {
            return __fi;
        }
        short classIndex = ci.getEntryIndex();
        short nameAndTypeIndex = this.addNameAndTypeInfo(name, desc).getEntryIndex();
        FieldRefInfo fi = new FieldRefInfo(classIndex, nameAndTypeIndex);
        this.cp.add(fi);
        return fi;
    }

    short addFieldRefInfo(short classIndex, short nameAndTypeIndex) {
        Entry e;
        if (classIndex <= 0 || nameAndTypeIndex <= 0) {
            throw new ParseException("Adding fieldRef_info, but class_index or nameAndType_index is 0", this);
        }
        if (classIndex <= this.cp.size() && !((e = this.get(classIndex)) instanceof ClassInfo)) {
            throw new ParseException("Adding fieldRef_info, but class_index does not point to classInfo; index=" + classIndex + ", " + e, this);
        }
        FieldRefInfo fi = new FieldRefInfo(classIndex, nameAndTypeIndex);
        this.cp.add(fi);
        return (short)this.cp.size();
    }

    public MethodRefInfo addMethodRefInfo(ClassInfo ci, String name, String desc) {
        MethodRefInfo __mi = this.findMethodRefInfo(0, ci, name, desc);
        if (__mi != null) {
            return __mi;
        }
        short classIndex = ci.getEntryIndex();
        short nameAndTypeIndex = this.addNameAndTypeInfo(name, desc).getEntryIndex();
        MethodRefInfo mi = new MethodRefInfo(classIndex, nameAndTypeIndex);
        this.cp.add(mi);
        return mi;
    }

    short addMethodRefInfo(short classIndex, short nameAndTypeIndex) {
        Entry e;
        if (classIndex <= 0 || nameAndTypeIndex <= 0) {
            throw new ParseException("Adding methodRef_info, but class_index or nameAndType_index is 0", this);
        }
        if (classIndex <= this.cp.size() && !((e = this.get(classIndex)) instanceof ClassInfo)) {
            throw new ParseException("Adding methodRef_info, but class_index does not point to classInfo; index=" + classIndex + ", " + e, this);
        }
        MethodRefInfo mi = new MethodRefInfo(classIndex, nameAndTypeIndex);
        this.cp.add(mi);
        return (short)this.cp.size();
    }

    public InterfaceMethodRefInfo addInterfaceMethodRefInfo(ClassInfo ci, String name, String desc) {
        short classIndex = ci.getEntryIndex();
        short nameAndTypeIndex = this.addNameAndTypeInfo(name, desc).getEntryIndex();
        InterfaceMethodRefInfo imi = new InterfaceMethodRefInfo(classIndex, nameAndTypeIndex);
        this.cp.add(imi);
        return imi;
    }

    short addInterfaceMethodRefInfo(short classIndex, short nameAndTypeIndex) {
        Entry e;
        if (classIndex <= 0 || nameAndTypeIndex <= 0) {
            throw new ParseException("Adding interfaceMethodRef_info, but class_index or nameAndType_index is 0", this);
        }
        if (classIndex <= this.cp.size() && !((e = this.get(classIndex)) instanceof ClassInfo)) {
            throw new ParseException("Adding interfaceMethodRef_info, but class_index does not point to classInfo; index=" + classIndex + ", " + e, this);
        }
        InterfaceMethodRefInfo imi = new InterfaceMethodRefInfo(classIndex, nameAndTypeIndex);
        this.cp.add(imi);
        return (short)this.cp.size();
    }

    public StringInfo addStringInfo(String s) {
        StringInfo __si = this.findStringInfo(0, s);
        if (__si != null) {
            return __si;
        }
        Utf8Info u8 = this.addUtf8Info(s);
        StringInfo si = new StringInfo(u8.getEntryIndex());
        this.cp.add(si);
        return si;
    }

    short addString_info(short stringIndex) {
        Entry e;
        if (stringIndex <= 0) {
            throw new ParseException("Adding string_info, but string_index is 0", this);
        }
        if (stringIndex <= this.cp.size() && !((e = this.get(stringIndex)) instanceof Utf8Info)) {
            throw new ParseException("Adding string_info, but string_index does not point to Utf8Info; index=" + stringIndex + ", " + e, this);
        }
        StringInfo si = new StringInfo(stringIndex);
        this.cp.add(si);
        return (short)this.cp.size();
    }

    public IntegerInfo addIntegerInfo(int bytes) {
        IntegerInfo ii = new IntegerInfo(bytes);
        this.cp.add(ii);
        return ii;
    }

    short addInteger_info(int bytes) {
        IntegerInfo ii = new IntegerInfo(bytes);
        this.cp.add(ii);
        return (short)this.cp.size();
    }

    public FloatInfo addFloatInfo(int bytes) {
        FloatInfo fi = new FloatInfo(bytes);
        this.cp.add(fi);
        return fi;
    }

    short addFloat_info(int bytes) {
        FloatInfo fi = new FloatInfo(bytes);
        this.cp.add(fi);
        return (short)this.cp.size();
    }

    public LongInfo addLongInfo(int highBytes, int lowBytes) {
        LongInfo li = new LongInfo(highBytes, lowBytes);
        this.cp.add(li);
        return li;
    }

    public LongInfo addLongInfo(long l) {
        LongInfo li = new LongInfo(l);
        this.cp.add(li);
        return li;
    }

    short addLong_info(int highBytes, int lowBytes) {
        LongInfo fi = new LongInfo(highBytes, lowBytes);
        this.cp.add(fi);
        this.cp.add(new NullEntry());
        return (short)(this.cp.size() - 1);
    }

    public DoubleInfo addDoubleInfo(int highBytes, int lowBytes) {
        DoubleInfo di = new DoubleInfo(highBytes, lowBytes);
        this.cp.add(di);
        return di;
    }

    public DoubleInfo addDoubleInfo(long bits) {
        DoubleInfo di = new DoubleInfo(bits);
        this.cp.add(di);
        return di;
    }

    short addDouble_info(int highBytes, int lowBytes) {
        DoubleInfo fi = new DoubleInfo(highBytes, lowBytes);
        this.cp.add(fi);
        this.cp.add(new NullEntry());
        return (short)(this.cp.size() - 1);
    }

    public NameAndTypeInfo addNameAndTypeInfo(String name, String descriptor) {
        NameAndTypeInfo ni = this.findNameAndTypeInfo(0, name, descriptor);
        if (ni != null) {
            return ni;
        }
        short nameIndex = this.addUtf8Info(name).getEntryIndex();
        short descriptorIndex = this.addUtf8Info(descriptor).getEntryIndex();
        NameAndTypeInfo fi = new NameAndTypeInfo(nameIndex, descriptorIndex);
        this.cp.add(fi);
        return fi;
    }

    short addNameAndTypeInfo(short nameIndex, short descriptorIndex) {
        Entry e;
        if (nameIndex <= 0 || descriptorIndex <= 0) {
            throw new ParseException("Adding nameAndType_info, but name_index or descriptor_index is 0", this);
        }
        if (nameIndex <= this.cp.size() && !((e = this.get(nameIndex)) instanceof Utf8Info)) {
            throw new ParseException("Adding nameAndType_info, but name_index does not point to Utf8Info; index=" + nameIndex + ", " + e, this);
        }
        if (descriptorIndex <= this.cp.size() && !((e = this.get(descriptorIndex)) instanceof Utf8Info)) {
            throw new ParseException("Adding nameAndType_info, but descriptor_index does not point to Utf8Info; name_index=" + nameIndex + ", descriptor_index=" + descriptorIndex + ", " + e, this);
        }
        NameAndTypeInfo fi = new NameAndTypeInfo(nameIndex, descriptorIndex);
        this.cp.add(fi);
        return (short)this.cp.size();
    }

    public Utf8Info addUtf8Info(String s) {
        Utf8Info u8 = this.findUtf8Info(0, s);
        if (u8 != null) {
            return u8;
        }
        return (Utf8Info)this.cp.get(this.addUtf8_info(s.getBytes()) - 1);
    }

    short addUtf8_info(byte[] bytes) {
        Utf8Info ui = new Utf8Info(bytes);
        this.cp.add(ui);
        return (short)this.cp.size();
    }

    short addMethodHandle_info(byte reference_kind, short reference_index) {
        this.cp.add(new MethodHandleInfo(reference_kind, reference_index));
        return (short)this.cp.size();
    }

    short addMethodType_info(short descriptor_index) {
        this.cp.add(new MethodTypeInfo(descriptor_index));
        return (short)this.cp.size();
    }

    short addInvokeDynamic_info(short bootstrap_method_attr_index, short name_and_type_index) {
        this.cp.add(new InvokeDynamicInfo(bootstrap_method_attr_index, name_and_type_index));
        return (short)this.cp.size();
    }

    public Entry get(int index) {
        return this.cp.get(index - 1);
    }

    public String getUtf8(short index) {
        Entry utf8 = this.get(index);
        if (utf8 instanceof Utf8Info) {
            byte[] bytes = ((Utf8Info)utf8).getBytes();
            return new String(bytes);
        }
        throw new IllegalArgumentException("index does not point to utf8_info structure: index " + index + " -> " + utf8);
    }

    public String getStringValue(short index) {
        Entry str = this.get(index);
        if (str instanceof StringInfo) {
            String s = ((StringInfo)str).stringValue();
            return s;
        }
        if (str instanceof Utf8Info) {
            byte[] bytes = ((Utf8Info)str).getBytes();
            return new String(bytes);
        }
        throw new IllegalArgumentException("index does not point to string_info structure: index " + index + " -> " + str);
    }

    public String getClassName(short index) {
        Entry ci = this.get(index);
        if (ci instanceof ClassInfo) {
            short nameIndex = ((ClassInfo)ci).getNameIndex();
            return this.getUtf8(nameIndex).replace('/', '.');
        }
        throw new IllegalArgumentException("index does not point to Class_info structure: index " + index + " -> " + ci);
    }

    public int size() {
        return this.cp.size();
    }

    List<Entry> getList() {
        this.cp.trimToSize();
        return this.cp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int idx = 1;
        Iterator<Entry> i = this.cp.iterator();
        while (i.hasNext()) {
            sb.append(idx);
            sb.append(": ");
            sb.append(i.next());
            if (i.hasNext()) {
                sb.append('\n');
            }
            ++idx;
        }
        return sb.toString();
    }

    short findClassInfo(int start, String s) {
        for (int i = start; i < this.cp.size(); ++i) {
            ClassInfo ci;
            Entry e = this.cp.get(i);
            if (!(e instanceof ClassInfo) || !(ci = (ClassInfo)e).getName().equals(s)) continue;
            return (short)i;
        }
        return -1;
    }

    MethodRefInfo findMethodRefInfo(int start, ClassInfo ci, String name, String desc) {
        for (int i = start; i < this.cp.size(); ++i) {
            ClassInfo __ci;
            MethodRefInfo mi;
            Entry e = this.cp.get(i);
            if (!(e instanceof MethodRefInfo) || !(mi = (MethodRefInfo)e).getMethodName().equals(name) || !mi.getDescriptor().equals(desc) || (__ci = mi.getClassInfo()).getEntryIndex() != ci.getEntryIndex()) continue;
            return mi;
        }
        return null;
    }

    FieldRefInfo findFieldRefInfo(int start, ClassInfo ci, String name, String desc) {
        for (int i = start; i < this.cp.size(); ++i) {
            ClassInfo __ci;
            FieldRefInfo fi;
            Entry e = this.cp.get(i);
            if (!(e instanceof FieldRefInfo) || !(fi = (FieldRefInfo)e).getFieldName().equals(name) || !fi.getDescriptor().equals(desc) || (__ci = fi.getClassInfo()).getEntryIndex() != ci.getEntryIndex()) continue;
            return fi;
        }
        return null;
    }

    NameAndTypeInfo findNameAndTypeInfo(int start, String name, String desc) {
        for (int i = start; i < this.cp.size(); ++i) {
            NameAndTypeInfo ni;
            Entry e = this.cp.get(i);
            if (!(e instanceof NameAndTypeInfo) || !(ni = (NameAndTypeInfo)e).getName().equals(name) || !ni.getDescriptor().equals(desc)) continue;
            return ni;
        }
        return null;
    }

    StringInfo findStringInfo(int start, String s) {
        for (int i = start; i < this.cp.size(); ++i) {
            StringInfo si;
            Entry e = this.cp.get(i);
            if (!(e instanceof StringInfo) || !(si = (StringInfo)e).stringValue().equals(s)) continue;
            return si;
        }
        return null;
    }

    Utf8Info findUtf8Info(int start, String s) {
        for (int i = start; i < this.cp.size(); ++i) {
            Utf8Info u8;
            Entry e = this.cp.get(i);
            if (!(e instanceof Utf8Info) || !(u8 = (Utf8Info)e).stringValue().equals(s)) continue;
            return u8;
        }
        return null;
    }

    void verify() {
        for (Entry e : this.cp) {
            Entry e2;
            ClassInfo ci;
            if (!(e instanceof ClassInfo) || (ci = (ClassInfo)e).getNameIndex() > this.cp.size() || (e2 = this.get(ci.getNameIndex())) instanceof Utf8Info) continue;
            throw new ParseException("Invalid class_info; name_index does not point to Utf8Info; index=" + ci.getNameIndex() + ", " + e2, this);
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.cp.iterator();
    }

    public class InvokeDynamicInfo
    extends Entry {
        private final short bootstrap_method_attr_index;
        private final short name_and_type_index;

        public InvokeDynamicInfo(short bootstrap_method_attr_index, short name_and_type_index) {
            super((byte)18);
            this.bootstrap_method_attr_index = bootstrap_method_attr_index;
            this.name_and_type_index = name_and_type_index;
        }

        public NameAndTypeInfo getNameAndTypeInfo() {
            return (NameAndTypeInfo)ConstantPool.this.cp.get(this.name_and_type_index);
        }

        public short getBootstrapMethodsIndex() {
            return this.bootstrap_method_attr_index;
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.bootstrap_method_attr_index);
            dos.writeShort(this.name_and_type_index);
        }
    }

    public class MethodTypeInfo
    extends Entry {
        private final short descriptor_index;

        public MethodTypeInfo(short descriptor_index) {
            super((byte)16);
            this.descriptor_index = descriptor_index;
        }

        public Utf8Info getDescriptor() {
            return (Utf8Info)ConstantPool.this.cp.get(this.descriptor_index);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.descriptor_index);
        }
    }

    public class MethodHandleInfo
    extends Entry {
        public static final byte REF_getField = 1;
        public static final byte REF_getStatic = 2;
        public static final byte REF_putField = 3;
        public static final byte REF_putStatic = 4;
        public static final byte REF_invokeVirtual = 5;
        public static final byte REF_invokeStatic = 6;
        public static final byte REF_invokeSpecial = 7;
        public static final byte REF_newInvokeSpecial = 8;
        public static final byte REF_invokeInterface = 9;
        private final byte reference_kind;
        private final short reference_index;

        public MethodHandleInfo(byte reference_kind, short reference_index) {
            super((byte)15);
            this.reference_kind = reference_kind;
            this.reference_index = reference_index;
        }

        public byte getKind() {
            return this.reference_kind;
        }

        public Entry getReference() {
            return (Entry)ConstantPool.this.cp.get(this.reference_index);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeByte(this.reference_kind);
            dos.writeShort(this.reference_index);
        }
    }

    public class Utf8Info
    extends Entry {
        private byte[] bytes;

        Utf8Info(byte[] bytes) {
            super((byte)1);
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String stringValue() {
            return new String(this.bytes);
        }

        public String toString() {
            return "utf8_info: " + new String(this.bytes);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.bytes.length);
            for (int i = 0; i < this.bytes.length; ++i) {
                dos.writeByte(this.bytes[i]);
            }
        }
    }

    public class NameAndTypeInfo
    extends Entry {
        private short nameIndex;
        private short descriptorIndex;

        NameAndTypeInfo(short nameIndex, short descriptorIndex) {
            super((byte)12);
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
        }

        short getNameIndex() {
            return this.nameIndex;
        }

        public String getName() {
            return ConstantPool.this.getUtf8(this.nameIndex);
        }

        short getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public String getDescriptor() {
            return ConstantPool.this.getUtf8(this.descriptorIndex);
        }

        public String toString() {
            return "nameandtype_info:\n  " + ConstantPool.this.get(this.nameIndex) + "\n  " + ConstantPool.this.get(this.descriptorIndex);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
        }
    }

    public class DoubleInfo
    extends Entry {
        private int highBytes;
        private int lowBytes;

        DoubleInfo(int highBytes, int lowBytes) {
            super((byte)6);
            this.highBytes = highBytes;
            this.lowBytes = lowBytes;
        }

        DoubleInfo(long bits) {
            super((byte)6);
            this.highBytes = (int)(bits >> 32);
            this.lowBytes = (int)(bits & 0xFFFFL);
        }

        public int getHighBytes() {
            return this.highBytes;
        }

        public int getLowBytes() {
            return this.lowBytes;
        }

        public String toString() {
            return "double_info: " + this.highBytes + " " + this.lowBytes;
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeInt(this.highBytes);
            dos.writeInt(this.lowBytes);
        }

        public double getDoubleValue() {
            long bits = (long)this.highBytes << 32 | (long)this.lowBytes & 0xFFFFL;
            if (bits == 0x7FF0000000000000L) {
                return Double.POSITIVE_INFINITY;
            }
            if (bits == -4503599627370496L) {
                return Double.NEGATIVE_INFINITY;
            }
            if (bits >= 9218868437227405313L && bits <= Long.MAX_VALUE) {
                return Double.NaN;
            }
            if (bits >= -4503599627370495L && bits <= -1L) {
                return Double.NaN;
            }
            int s = bits >> 63 == 0L ? 1 : -1;
            int e = (int)(bits >> 52 & 0x7FFL);
            long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            return (double)((long)s * m) * Math.pow(2.0, e - 1075);
        }
    }

    public class LongInfo
    extends Entry {
        private int highBytes;
        private int lowBytes;

        LongInfo(int highBytes, int lowBytes) {
            super((byte)5);
            this.highBytes = highBytes;
            this.lowBytes = lowBytes;
        }

        LongInfo(long l) {
            super((byte)5);
            this.highBytes = (int)(l >> 32);
            this.lowBytes = (int)(l & 0xFFFFL);
        }

        public int getHighBytes() {
            return this.highBytes;
        }

        public int getLowBytes() {
            return this.lowBytes;
        }

        public String toString() {
            return "long_info: " + this.highBytes + " " + this.lowBytes;
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeInt(this.highBytes);
            dos.writeInt(this.lowBytes);
        }

        public long getLongValue() {
            long h1 = (long)this.highBytes << 32;
            long l1 = (long)this.lowBytes & 0xFFFFFFFFL;
            return h1 | l1;
        }
    }

    public class FloatInfo
    extends Entry {
        private int bits;

        FloatInfo(int bytes) {
            super((byte)4);
            this.bits = bytes;
        }

        public int getBytes() {
            return this.bits;
        }

        public String toString() {
            return "float_info: " + this.bits;
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeInt(this.bits);
        }

        public float getFloatValue() {
            if (this.bits == 2139095040) {
                return Float.POSITIVE_INFINITY;
            }
            if (this.bits == -8388608) {
                return Float.NEGATIVE_INFINITY;
            }
            if (this.bits >= 2139095041 & this.bits <= Integer.MAX_VALUE) {
                return Float.NaN;
            }
            if (this.bits <= -1 & this.bits >= -8388607) {
                return Float.NaN;
            }
            int s = this.bits >> 31 == 0 ? 1 : -1;
            int e = this.bits >> 23 & 0xFF;
            int m = e == 0 ? (this.bits & 0x7FFFFF) << 1 : this.bits & 0x7FFFFF | 0x800000;
            return (float)((double)(s * m) * Math.pow(2.0, e - 150));
        }
    }

    public class IntegerInfo
    extends Entry {
        private int bytes;

        IntegerInfo(int bytes) {
            super((byte)3);
            this.bytes = bytes;
        }

        public int getBytes() {
            return this.bytes;
        }

        public String toString() {
            return "integer_info: " + this.bytes;
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeInt(this.bytes);
        }
    }

    public class StringInfo
    extends Entry {
        private short stringIndex;

        StringInfo(short stringIndex) {
            super((byte)8);
            this.stringIndex = stringIndex;
        }

        short getStringIndex() {
            return this.stringIndex;
        }

        public String stringValue() {
            Utf8Info u8 = (Utf8Info)ConstantPool.this.get(this.stringIndex);
            return u8.stringValue();
        }

        public String toString() {
            return "string_info:\n  " + ConstantPool.this.get(this.stringIndex);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.stringIndex);
        }
    }

    public class InterfaceMethodRefInfo
    extends Entry {
        private short classIndex;
        private short nameAndTypeIndex;

        InterfaceMethodRefInfo(short classIndex, short nameAndTypeIndex) {
            super((byte)11);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        short getClassIndex() {
            return this.classIndex;
        }

        public ClassInfo getClassInfo() {
            return (ClassInfo)ConstantPool.this.get(this.classIndex);
        }

        short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public NameAndTypeInfo getNameAndTypeInfo() {
            return (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
        }

        public String getMethodName() {
            NameAndTypeInfo nti = (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
            return ConstantPool.this.getUtf8(nti.getNameIndex());
        }

        public String getDescriptor() {
            NameAndTypeInfo nti = (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
            return ConstantPool.this.getUtf8(nti.getDescriptorIndex());
        }

        public String toString() {
            return "interfacemethodref_info:\n  " + ConstantPool.this.get(this.classIndex) + "\n  " + ConstantPool.this.get(this.nameAndTypeIndex);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }
    }

    public class MethodRefInfo
    extends Entry {
        private short classIndex;
        private short nameAndTypeIndex;

        MethodRefInfo(short classIndex, short nameAndTypeIndex) {
            super((byte)10);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        short getClassIndex() {
            return this.classIndex;
        }

        public ClassInfo getClassInfo() {
            return (ClassInfo)ConstantPool.this.get(this.classIndex);
        }

        short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public NameAndTypeInfo getNameAndTypeInfo() {
            return (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
        }

        public String getMethodName() {
            NameAndTypeInfo nti = (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
            return ConstantPool.this.getUtf8(nti.getNameIndex());
        }

        public String getDescriptor() {
            NameAndTypeInfo nti = (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
            return ConstantPool.this.getUtf8(nti.getDescriptorIndex());
        }

        public String toString() {
            return "methodref_info:\n  " + ConstantPool.this.get(this.classIndex) + "(" + this.classIndex + ")\n  " + ConstantPool.this.get(this.nameAndTypeIndex);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }
    }

    public class FieldRefInfo
    extends Entry {
        private short classIndex;
        private short nameAndTypeIndex;

        FieldRefInfo(short classIndex, short nameAndTypeIndex) {
            super((byte)9);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        short getClassIndex() {
            return this.classIndex;
        }

        public ClassInfo getClassInfo() {
            return (ClassInfo)ConstantPool.this.get(this.classIndex);
        }

        short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public NameAndTypeInfo getNameAndTypeInfo() {
            return (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
        }

        public String getFieldName() {
            NameAndTypeInfo nti = (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
            return ConstantPool.this.getUtf8(nti.getNameIndex());
        }

        public String getDescriptor() {
            NameAndTypeInfo nti = (NameAndTypeInfo)ConstantPool.this.get(this.nameAndTypeIndex);
            return ConstantPool.this.getUtf8(nti.getDescriptorIndex());
        }

        public String toString() {
            return "fieldref_info:\n  " + ConstantPool.this.get(this.classIndex) + "\n  " + ConstantPool.this.get(this.nameAndTypeIndex);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }
    }

    public class ClassInfo
    extends Entry {
        private short nameIndex;

        ClassInfo(short nameIndex) {
            super((byte)7);
            this.nameIndex = nameIndex;
        }

        short getNameIndex() {
            return this.nameIndex;
        }

        public String getName() {
            return ConstantPool.this.getUtf8(this.nameIndex);
        }

        public String toString() {
            return "Class_info:\n  " + ConstantPool.this.get(this.nameIndex);
        }

        @Override
        public void writeData(DataOutputStream dos) throws IOException {
            dos.writeShort(this.nameIndex);
        }
    }

    public class NullEntry
    extends Entry {
        @Override
        public void writeData(DataOutputStream dos) {
        }
    }

    public abstract class Entry {
        private byte tag;
        private short entryIndex;

        private Entry() {
        }

        public Entry(byte tag) {
            this.entryIndex = (short)(ConstantPool.this.cp.size() + 1);
            this.tag = tag;
        }

        public byte getTag() {
            return this.tag;
        }

        public short getEntryIndex() {
            return this.entryIndex;
        }

        public abstract void writeData(DataOutputStream var1) throws IOException;
    }
}

