/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:26:51 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.FastVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class FastVector_ESTest extends FastVector_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.add((Object) "#vzK!aU23@UIaGc");
      fastVector0.insertElementAfter("#vzK!aU23@UIaGc", fastVector0);
      assertFalse(fastVector0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      Object object0 = fastVector0.clone();
      fastVector0.insertElementAfter(object0, fastVector0);
      assertFalse(object0.equals((Object)fastVector0));
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.add(0, (Object) fastVector0);
      fastVector0.setElementAt(fastVector0, 0);
      assertFalse(fastVector0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.add(0, (Object) null);
      Object object0 = fastVector0.lastElement();
      assertNull(object0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      // Undeclared exception!
      try { 
        fastVector0.setElementAt(fastVector0, (-1566));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.add(0, (Object) null);
      fastVector0.insertElementAfter((Object) null, (Object) null);
      // Undeclared exception!
      try { 
        fastVector0.mysort((Comparator) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.ComparableTimSort", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      FastVector fastVector1 = new FastVector();
      fastVector1.add((Object) fastVector0);
      fastVector0.add((Object) fastVector1);
      // Undeclared exception!
      try { 
        fastVector0.insertElementAfter(fastVector0, fastVector0);
        fail("Expecting exception: StackOverflowError");
      
      } catch(StackOverflowError e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      List list0 = fastVector0.subList(0, 0);
      Comparator<String> comparator0 = (Comparator<String>) mock(Comparator.class, new ViolatedAssumptionAnswer());
      FastVector fastVector1 = fastVector0.mysort(comparator0);
      fastVector0.add((Object) list0);
      fastVector1.add((Object) list0);
      // Undeclared exception!
      try { 
        fastVector1.add((Object) fastVector0);
        fail("Expecting exception: ConcurrentModificationException");
      
      } catch(ConcurrentModificationException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.ArrayList$SubList", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.add(0, (Object) fastVector0);
      Comparator<String> comparator0 = (Comparator<String>) mock(Comparator.class, new ViolatedAssumptionAnswer());
      FastVector fastVector1 = fastVector0.mysort(comparator0);
      fastVector0.addAll((Collection) fastVector1);
      Object object0 = fastVector0.lastElement();
      fastVector0.insertElementAfter(fastVector1, fastVector1);
      // Undeclared exception!
      try { 
        fastVector0.add(object0);
        fail("Expecting exception: StackOverflowError");
      
      } catch(StackOverflowError e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.insertElementAfter(fastVector0, fastVector0);
      // Undeclared exception!
      try { 
        fastVector0.add((Object) fastVector0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - object added a second time
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      // Undeclared exception!
      try { 
        fastVector0.add((Object) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      fastVector0.add((Object) fastVector0);
      fastVector0.insertElementAfter(fastVector0, fastVector0);
      // Undeclared exception!
      try { 
        fastVector0.mysort((Comparator) null);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.util.FastVector cannot be cast to java.lang.Comparable
         //
         verifyException("java.util.ComparableTimSort", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      // Undeclared exception!
      try { 
        fastVector0.setElementAt((Object) null, 0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FastVector fastVector0 = new FastVector();
      // Undeclared exception!
      try { 
        fastVector0.lastElement();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }
}
