/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:41:08 GMT 2018
 */

package uk.ac.sanger.artemis.j2ssh;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import java.awt.HeadlessException;
import java.util.Hashtable;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.j2ssh.FTProgress;
import uk.ac.sanger.artemis.j2ssh.SshFileManager;
import uk.ac.sanger.artemis.j2ssh.SshLogin;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class SshFileManager_ESTest extends SshFileManager_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn("SSH Error").when(sftpClient0).toString();
      SftpClient sftpClient1 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((FileAttributes) null).when(sftpClient1).get(anyString() , any(java.io.OutputStream.class) , any(com.sshtools.j2ssh.FileTransferProgress.class));
      doReturn((String) null).when(sftpClient1).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(false, false).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0, sftpClient1).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      FTProgress fTProgress0 = mock(FTProgress.class, new ViolatedAssumptionAnswer());
      SshFileManager.SshGet sshFileManager_SshGet0 = sshFileManager0.new SshGet("port", fTProgress0);
      sshFileManager_SshGet0.run();
      byte[] byteArray0 = sshFileManager_SshGet0.getByteArray();
      assertArrayEquals(new byte[] {}, byteArray0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn("").when(sftpClient0).pwd();
      doReturn("9Cn").when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(false).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      Hashtable hashtable0 = sshFileManager0.getFileList();
      assertNull(hashtable0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(sftpClient0).when(sshClient0).getActiveSftpClient();
      doReturn(true, false).when(sshClient0).hasActiveSftpClient();
      doReturn((SftpClient) null).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      // Undeclared exception!
      try { 
        sshFileManager0.remoteList("'S$vOA<s");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn((SftpClient) null).when(sshClient0).getActiveSftpClient();
      doReturn(false, true).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      // Undeclared exception!
      try { 
        sshFileManager0.stat("SSH Error");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn("SSH Error").when(sftpClient0).toString();
      SftpClient sftpClient1 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((FileAttributes) null).when(sftpClient1).get(anyString() , any(java.io.OutputStream.class) , any(com.sshtools.j2ssh.FileTransferProgress.class));
      doReturn((String) null).when(sftpClient1).pwd();
      doReturn((String) null, (String) null).when(sftpClient1).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(false, false, false, false).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0, sftpClient1, sftpClient1, (SftpClient) null).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      sshFileManager0.pwd();
      FTProgress fTProgress0 = mock(FTProgress.class, new ViolatedAssumptionAnswer());
      SshFileManager.SshGet sshFileManager_SshGet0 = sshFileManager0.new SshGet("port", fTProgress0);
      sshFileManager_SshGet0.run();
      // Undeclared exception!
      try { 
        sshFileManager0.rename("port", "qlV-UPNoSeh,ihY?bQ`");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SftpClient sftpClient1 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((FileAttributes) null).when(sftpClient1).stat(anyString());
      doReturn((String) null).when(sftpClient1).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn((SftpClient) null).when(sshClient0).getActiveSftpClient();
      doReturn(false, false, true).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0, sftpClient1).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      sshFileManager0.stat("SSH Error");
      // Undeclared exception!
      try { 
        sshFileManager0.mkdir("@m<{&");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn("wB#U}(aP3)yz S$s").when(sftpClient0).pwd();
      doReturn("8S:OW").when(sftpClient0).toString();
      SftpClient sftpClient1 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((FileAttributes) null).when(sftpClient1).stat(anyString());
      doReturn((String) null, (String) null).when(sftpClient1).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn((SftpClient) null).when(sshClient0).getActiveSftpClient();
      doReturn(false, false, false, true).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0, sftpClient1, sftpClient1).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      sshFileManager0.stat("SSH Error");
      sshFileManager0.mkdir("@m<{&");
      // Undeclared exception!
      try { 
        sshFileManager0.delete("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn((SftpClient) null).when(sshClient0).getActiveSftpClient();
      doReturn(true).when(sshClient0).hasActiveSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = null;
      try {
        sshFileManager0 = new SshFileManager(sshLogin0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      SshFileManager sshFileManager0 = null;
      try {
        sshFileManager0 = new SshFileManager(sshLogin0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(sftpClient0).when(sshClient0).getActiveSftpClient();
      doReturn(true).when(sshClient0).hasActiveSftpClient();
      doReturn(true).when(sshClient0).isConnected();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      boolean boolean0 = sshFileManager0.isConnected();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(false).when(sshClient0).hasActiveSftpClient();
      doReturn(false).when(sshClient0).isConnected();
      doReturn(sftpClient0).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      boolean boolean0 = sshFileManager0.isConnected();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(false, false).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0, (SftpClient) null).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      String string0 = "SSH Error";
      // Undeclared exception!
      try { 
        sshFileManager0.stat("SSH Error");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.j2ssh.SshFileManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sftpClient0).pwd();
      doReturn((String) null).when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(sftpClient0).when(sshClient0).getActiveSftpClient();
      doReturn(true).when(sshClient0).hasActiveSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      Hashtable hashtable0 = sshFileManager0.getDirList();
      assertNull(hashtable0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SshFileManager sshFileManager0 = null;
      try {
        sshFileManager0 = new SshFileManager();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SftpClient sftpClient0 = mock(SftpClient.class, new ViolatedAssumptionAnswer());
      doReturn("").when(sftpClient0).pwd();
      doReturn("9Cn").when(sftpClient0).toString();
      SshClient sshClient0 = mock(SshClient.class, new ViolatedAssumptionAnswer());
      doReturn(false).when(sshClient0).hasActiveSftpClient();
      doReturn(sftpClient0).when(sshClient0).openSftpClient();
      SshLogin sshLogin0 = mock(SshLogin.class, new ViolatedAssumptionAnswer());
      doReturn(sshClient0).when(sshLogin0).getSshClient(anyBoolean());
      SshFileManager sshFileManager0 = new SshFileManager(sshLogin0);
      FTProgress fTProgress0 = mock(FTProgress.class, new ViolatedAssumptionAnswer());
      SshFileManager.SshGet sshFileManager_SshGet0 = sshFileManager0.new SshGet("TGf;K&]Vcb|z|x$1", fTProgress0);
      sshFileManager_SshGet0.destroy();
      assertFalse(sshFileManager_SshGet0.isDaemon());
  }
}
