/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.cobertura.dsl.ReportFormat;
import net.sourceforge.cobertura.reporting.NullReport;
import net.sourceforge.cobertura.reporting.Report;
import net.sourceforge.cobertura.reporting.ReportName;

public class CompositeReport
implements Report {
    private Set<Report> reports = new HashSet<Report>();

    public CompositeReport() {
        this.reports.add(new NullReport());
    }

    @Override
    public void export(ReportFormat reportFormat) {
        for (Report report : this.reports) {
            report.export(reportFormat);
        }
    }

    @Override
    public ReportName getName() {
        return ReportName.COMPOSITE_REPORT;
    }

    @Override
    public Report getByName(ReportName name) {
        if (ReportName.COMPOSITE_REPORT.equals((Object)name)) {
            return this;
        }
        for (Report report : this.reports) {
            if (!report.getName().equals((Object)name)) continue;
            return report;
        }
        return this.getByName(ReportName.NULL_REPORT);
    }

    public void addReport(Report report) {
        this.reports.add(report);
    }
}

