/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class HistoryMethodAdapter
extends MethodVisitor {
    private final LinkedList<AbstractInsnNode> backlog = new LinkedList();
    private final int eventsToTrace;

    public HistoryMethodAdapter(MethodVisitor mv, int eventsToTrace) {
        super(262144, mv);
        this.eventsToTrace = eventsToTrace;
    }

    public List<AbstractInsnNode> backlog() {
        return Collections.unmodifiableList(this.backlog);
    }

    private void appendToBacklog(AbstractInsnNode node) {
        if (this.backlog.size() >= this.eventsToTrace) {
            this.backlog.removeFirst();
        }
        this.backlog.addLast(node);
    }

    public void visitFieldInsn(int arg0, String arg1, String arg2, String arg3) {
        super.visitFieldInsn(arg0, arg1, arg2, arg3);
        this.appendToBacklog((AbstractInsnNode)new FieldInsnNode(arg0, arg1, arg2, arg3));
    }

    public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        super.visitFrame(arg0, arg1, arg2, arg3, arg4);
        this.appendToBacklog((AbstractInsnNode)new FrameNode(arg0, arg1, arg2, arg3, arg4));
    }

    public void visitIincInsn(int arg0, int arg1) {
        super.visitIincInsn(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new IincInsnNode(arg0, arg1));
    }

    public void visitInsn(int arg0) {
        super.visitInsn(arg0);
        this.appendToBacklog((AbstractInsnNode)new InsnNode(arg0));
    }

    public void visitIntInsn(int arg0, int arg1) {
        super.visitIntInsn(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new IntInsnNode(arg0, arg1));
    }

    public void visitJumpInsn(int arg0, Label arg1) {
        super.visitJumpInsn(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new JumpInsnNode(arg0, new LabelNode(arg1)));
    }

    public void visitLabel(Label arg0) {
        super.visitLabel(arg0);
        this.appendToBacklog((AbstractInsnNode)new LabelNode(arg0));
    }

    public void visitLdcInsn(Object arg0) {
        super.visitLdcInsn(arg0);
        this.appendToBacklog((AbstractInsnNode)new LdcInsnNode(arg0));
    }

    public void visitLineNumber(int arg0, Label arg1) {
        super.visitLineNumber(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new LineNumberNode(arg0, new LabelNode(arg1)));
    }

    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        super.visitLookupSwitchInsn(arg0, arg1, arg2);
        LabelNode[] nodes = new LabelNode[arg2.length];
        for (int i = 0; i < arg2.length; ++i) {
            nodes[i] = new LabelNode(arg2[i]);
        }
        this.appendToBacklog((AbstractInsnNode)new LookupSwitchInsnNode(new LabelNode(arg0), arg1, nodes));
    }

    public void visitMethodInsn(int arg0, String arg1, String arg2, String arg3) {
        super.visitMethodInsn(arg0, arg1, arg2, arg3);
        this.appendToBacklog((AbstractInsnNode)new MethodInsnNode(arg0, arg1, arg2, arg3));
    }

    public void visitMultiANewArrayInsn(String arg0, int arg1) {
        super.visitMultiANewArrayInsn(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new MultiANewArrayInsnNode(arg0, arg1));
    }

    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        super.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
        LabelNode[] nodes = new LabelNode[arg3.length];
        for (int i = 0; i < arg3.length; ++i) {
            nodes[i] = new LabelNode(arg3[i]);
        }
        this.appendToBacklog((AbstractInsnNode)new TableSwitchInsnNode(arg0, arg1, new LabelNode(arg2), nodes));
    }

    public void visitTypeInsn(int arg0, String arg1) {
        super.visitTypeInsn(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new TypeInsnNode(arg0, arg1));
    }

    public void visitVarInsn(int arg0, int arg1) {
        super.visitVarInsn(arg0, arg1);
        this.appendToBacklog((AbstractInsnNode)new VarInsnNode(arg0, arg1));
    }
}

