/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.view.selectiontoolbar;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.drawable.Icon;
import android.os.Parcelable;
import android.view.MenuItem;

import com.android.internal.util.DataClass;

/**
 * The menu item that is used to show the selection toolbar.
 *
 * @hide
 */
@DataClass(genBuilder = true, genToString = true, genEqualsHashCode = true)
public final class ToolbarMenuItem implements Parcelable {

    /**
     * The priority of menu item is unknown.
     */
    public static final int PRIORITY_UNKNOWN = 0;

    /**
     * The priority of menu item is shown in primary selection toolbar.
     */
    public static final int PRIORITY_PRIMARY = 1;

    /**
     * The priority of menu item is shown in overflow selection toolbar.
     */
    public static final int PRIORITY_OVERFLOW = 2;

    /**
     * The id of the menu item.
     *
     * @see MenuItem#getItemId()
     */
    private final int mItemId;

    /**
     * The title of the menu item.
     *
     * @see MenuItem#getTitle()
     */
    @NonNull
    private final CharSequence mTitle;

    /**
     * The content description of the menu item.
     *
     * @see MenuItem#getContentDescription()
     */
    @Nullable
    private final CharSequence mContentDescription;

    /**
     * The group id of the menu item.
     *
     * @see MenuItem#getGroupId()
     */
    private final int mGroupId;

    /**
     * The icon id of the menu item.
     *
     * @see MenuItem#getIcon()
     */
    @Nullable
    private final Icon mIcon;

    /**
     * The tooltip text of the menu item.
     *
     * @see MenuItem#getTooltipText()
     */
    @Nullable
    private final CharSequence mTooltipText;

    /**
     * The priority of the menu item used to display the order of the menu item.
     */
    private final int mPriority;

    /**
     * Returns the priority from a given {@link MenuItem}.
     */
    public static int getPriorityFromMenuItem(MenuItem menuItem) {
        if (menuItem.requiresActionButton()) {
            return PRIORITY_PRIMARY;
        } else if (menuItem.requiresOverflow()) {
            return PRIORITY_OVERFLOW;
        }
        return PRIORITY_UNKNOWN;
    }




    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/view/selectiontoolbar/ToolbarMenuItem.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @android.annotation.IntDef(prefix = "PRIORITY_", value = {
        PRIORITY_UNKNOWN,
        PRIORITY_PRIMARY,
        PRIORITY_OVERFLOW
    })
    @java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface Priority {}

    @DataClass.Generated.Member
    public static String priorityToString(@Priority int value) {
        switch (value) {
            case PRIORITY_UNKNOWN:
                    return "PRIORITY_UNKNOWN";
            case PRIORITY_PRIMARY:
                    return "PRIORITY_PRIMARY";
            case PRIORITY_OVERFLOW:
                    return "PRIORITY_OVERFLOW";
            default: return Integer.toHexString(value);
        }
    }

    @DataClass.Generated.Member
    /* package-private */ ToolbarMenuItem(
            int itemId,
            @NonNull CharSequence title,
            @Nullable CharSequence contentDescription,
            int groupId,
            @Nullable Icon icon,
            @Nullable CharSequence tooltipText,
            int priority) {
        this.mItemId = itemId;
        this.mTitle = title;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mTitle);
        this.mContentDescription = contentDescription;
        this.mGroupId = groupId;
        this.mIcon = icon;
        this.mTooltipText = tooltipText;
        this.mPriority = priority;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The id of the menu item.
     *
     * @see MenuItem#getItemId()
     */
    @DataClass.Generated.Member
    public int getItemId() {
        return mItemId;
    }

    /**
     * The title of the menu item.
     *
     * @see MenuItem#getTitle()
     */
    @DataClass.Generated.Member
    public @NonNull CharSequence getTitle() {
        return mTitle;
    }

    /**
     * The content description of the menu item.
     *
     * @see MenuItem#getContentDescription()
     */
    @DataClass.Generated.Member
    public @Nullable CharSequence getContentDescription() {
        return mContentDescription;
    }

    /**
     * The group id of the menu item.
     *
     * @see MenuItem#getGroupId()
     */
    @DataClass.Generated.Member
    public int getGroupId() {
        return mGroupId;
    }

    /**
     * The icon id of the menu item.
     *
     * @see MenuItem#getIcon()
     */
    @DataClass.Generated.Member
    public @Nullable Icon getIcon() {
        return mIcon;
    }

    /**
     * The tooltip text of the menu item.
     *
     * @see MenuItem#getTooltipText()
     */
    @DataClass.Generated.Member
    public @Nullable CharSequence getTooltipText() {
        return mTooltipText;
    }

    /**
     * The priority of the menu item used to display the order of the menu item.
     */
    @DataClass.Generated.Member
    public int getPriority() {
        return mPriority;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "ToolbarMenuItem { " +
                "itemId = " + mItemId + ", " +
                "title = " + mTitle + ", " +
                "contentDescription = " + mContentDescription + ", " +
                "groupId = " + mGroupId + ", " +
                "icon = " + mIcon + ", " +
                "tooltipText = " + mTooltipText + ", " +
                "priority = " + mPriority +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(ToolbarMenuItem other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        ToolbarMenuItem that = (ToolbarMenuItem) o;
        //noinspection PointlessBooleanExpression
        return true
                && mItemId == that.mItemId
                && java.util.Objects.equals(mTitle, that.mTitle)
                && java.util.Objects.equals(mContentDescription, that.mContentDescription)
                && mGroupId == that.mGroupId
                && java.util.Objects.equals(mIcon, that.mIcon)
                && java.util.Objects.equals(mTooltipText, that.mTooltipText)
                && mPriority == that.mPriority;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mItemId;
        _hash = 31 * _hash + java.util.Objects.hashCode(mTitle);
        _hash = 31 * _hash + java.util.Objects.hashCode(mContentDescription);
        _hash = 31 * _hash + mGroupId;
        _hash = 31 * _hash + java.util.Objects.hashCode(mIcon);
        _hash = 31 * _hash + java.util.Objects.hashCode(mTooltipText);
        _hash = 31 * _hash + mPriority;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mContentDescription != null) flg |= 0x4;
        if (mIcon != null) flg |= 0x10;
        if (mTooltipText != null) flg |= 0x20;
        dest.writeByte(flg);
        dest.writeInt(mItemId);
        dest.writeCharSequence(mTitle);
        if (mContentDescription != null) dest.writeCharSequence(mContentDescription);
        dest.writeInt(mGroupId);
        if (mIcon != null) dest.writeTypedObject(mIcon, flags);
        if (mTooltipText != null) dest.writeCharSequence(mTooltipText);
        dest.writeInt(mPriority);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ ToolbarMenuItem(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        int itemId = in.readInt();
        CharSequence title = (CharSequence) in.readCharSequence();
        CharSequence contentDescription = (flg & 0x4) == 0 ? null : (CharSequence) in.readCharSequence();
        int groupId = in.readInt();
        Icon icon = (flg & 0x10) == 0 ? null : (Icon) in.readTypedObject(Icon.CREATOR);
        CharSequence tooltipText = (flg & 0x20) == 0 ? null : (CharSequence) in.readCharSequence();
        int priority = in.readInt();

        this.mItemId = itemId;
        this.mTitle = title;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mTitle);
        this.mContentDescription = contentDescription;
        this.mGroupId = groupId;
        this.mIcon = icon;
        this.mTooltipText = tooltipText;
        this.mPriority = priority;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ToolbarMenuItem> CREATOR
            = new Parcelable.Creator<ToolbarMenuItem>() {
        @Override
        public ToolbarMenuItem[] newArray(int size) {
            return new ToolbarMenuItem[size];
        }

        @Override
        public ToolbarMenuItem createFromParcel(@NonNull android.os.Parcel in) {
            return new ToolbarMenuItem(in);
        }
    };

    /**
     * A builder for {@link ToolbarMenuItem}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private int mItemId;
        private @NonNull CharSequence mTitle;
        private @Nullable CharSequence mContentDescription;
        private int mGroupId;
        private @Nullable Icon mIcon;
        private @Nullable CharSequence mTooltipText;
        private int mPriority;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param itemId
         *   The id of the menu item.
         * @param title
         *   The title of the menu item.
         * @param contentDescription
         *   The content description of the menu item.
         * @param groupId
         *   The group id of the menu item.
         * @param icon
         *   The icon id of the menu item.
         * @param tooltipText
         *   The tooltip text of the menu item.
         * @param priority
         *   The priority of the menu item used to display the order of the menu item.
         */
        public Builder(
                int itemId,
                @NonNull CharSequence title,
                @Nullable CharSequence contentDescription,
                int groupId,
                @Nullable Icon icon,
                @Nullable CharSequence tooltipText,
                int priority) {
            mItemId = itemId;
            mTitle = title;
            com.android.internal.util.AnnotationValidations.validate(
                    NonNull.class, null, mTitle);
            mContentDescription = contentDescription;
            mGroupId = groupId;
            mIcon = icon;
            mTooltipText = tooltipText;
            mPriority = priority;
        }

        /**
         * The id of the menu item.
         *
         * @see MenuItem#getItemId()
         */
        @DataClass.Generated.Member
        public @NonNull Builder setItemId(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mItemId = value;
            return this;
        }

        /**
         * The title of the menu item.
         *
         * @see MenuItem#getTitle()
         */
        @DataClass.Generated.Member
        public @NonNull Builder setTitle(@NonNull CharSequence value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mTitle = value;
            return this;
        }

        /**
         * The content description of the menu item.
         *
         * @see MenuItem#getContentDescription()
         */
        @DataClass.Generated.Member
        public @NonNull Builder setContentDescription(@NonNull CharSequence value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mContentDescription = value;
            return this;
        }

        /**
         * The group id of the menu item.
         *
         * @see MenuItem#getGroupId()
         */
        @DataClass.Generated.Member
        public @NonNull Builder setGroupId(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mGroupId = value;
            return this;
        }

        /**
         * The icon id of the menu item.
         *
         * @see MenuItem#getIcon()
         */
        @DataClass.Generated.Member
        public @NonNull Builder setIcon(@NonNull Icon value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10;
            mIcon = value;
            return this;
        }

        /**
         * The tooltip text of the menu item.
         *
         * @see MenuItem#getTooltipText()
         */
        @DataClass.Generated.Member
        public @NonNull Builder setTooltipText(@NonNull CharSequence value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x20;
            mTooltipText = value;
            return this;
        }

        /**
         * The priority of the menu item used to display the order of the menu item.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPriority(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x40;
            mPriority = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull ToolbarMenuItem build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x80; // Mark builder used

            ToolbarMenuItem o = new ToolbarMenuItem(
                    mItemId,
                    mTitle,
                    mContentDescription,
                    mGroupId,
                    mIcon,
                    mTooltipText,
                    mPriority);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x80) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1643200806234L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/view/selectiontoolbar/ToolbarMenuItem.java",
            inputSignatures = "public static final  int PRIORITY_UNKNOWN\npublic static final  int PRIORITY_PRIMARY\npublic static final  int PRIORITY_OVERFLOW\nprivate final  int mItemId\nprivate final @android.annotation.NonNull java.lang.CharSequence mTitle\nprivate final @android.annotation.Nullable java.lang.CharSequence mContentDescription\nprivate final  int mGroupId\nprivate final @android.annotation.Nullable android.graphics.drawable.Icon mIcon\nprivate final @android.annotation.Nullable java.lang.CharSequence mTooltipText\nprivate final  int mPriority\npublic static  int getPriorityFromMenuItem(android.view.MenuItem)\nclass ToolbarMenuItem extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genBuilder=true, genToString=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
