/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#include "date.h"
#include "modify_alarm.h"
#include <main_window.h>
void
single_day_prefs(void)
{
	GtkWidget *prefs = GTK_WIDGET (gtk_builder_get_object (gxml, "single_day_prefs"));
	
	gtk_widget_show(GTK_WIDGET(prefs));
	
}

void
date_selected(void)
{
	GtkWidget *prefs = GTK_WIDGET (gtk_builder_get_object (gxml, "single_day_prefs"));
	GtkWidget *cal = GTK_WIDGET (gtk_builder_get_object (gxml, "calendar1"));
	gchar *current_date = g_key_file_get_string(current_key, untitled_name, "DateTime", NULL);
	gchar **split = g_strsplit(current_date, "T", -1);
	gchar *date_ok;
	
	guint year, month, day;
	gtk_calendar_get_date(GTK_CALENDAR(cal), &year, &month, &day);

	month++;
	
	date_ok = g_strdup_printf("%i-%i-%iT%s", year, month, day, split[1]);
	
	g_key_file_set_string(current_key, untitled_name, "DateTime", date_ok);

	g_free(date_ok);
	g_free(current_date);
	g_strfreev(split);
	
	gtk_widget_hide(prefs);
}
