"rotatefont Help\n",
"============\n",
"rotatefont {[mode][mode options][rotation options][shared options][files]}*\n",
"rotatefont [other options]\n",
"\n",
"This program is based on the 'tx' program. Without the rotation options, this\n",
"program behaves exactly like the tx program. See 'rotatefont -u' for a list of\n",
"rotatefont-specific options, 'tx -u' for a list of all the other options. The\n",
"command 'tx -h' will give the full 'tx' help on the tx options.\n",
"\n",
"rotatefont applies a Postscript transform matrix to the source font files. The\n",
"transform can be specified either directly with the -matrix argument with all\n",
"six matrix values, or indirectly by specifying the -rt option with three values:\n",
"the number of degrees clockwise and the x and y offsets. Note that if the\n",
"rotation info file is used, the per-glyph x and y offsets will override those\n",
"specified in the rotate font matrix arguments.\n",
"\n",
"Note also that the matrix argument list is NOT the same thing as the font\n",
"FontMatrix, which scales the font design em-space to 1 point. See section 4.3.3\n",
"'Matrix Representation and Manipulation' of the 'PostScript Language Reference' for\n",
"details. For any coordinates (x,y), the coordinates after applying the transform are:\n",
"x' = ax + cy + e\n",
"y' = bx + dy + f\n",
"\n",
"In brief, the values act to:\n",
"a: stretch/condense horizontally\n",
"b: skew\n",
"c: oblique\n",
"d: stretch/condense vertically\n",
"e: shift horizontally\n",
"f: shift vertically\n",
"\n",
"For example, the argument:\n",
"   -matrix 2.0 0 0 0.75 100 200\n",
"will:\n",
" - scale up horizontal coordinates by a factor of 2,\n",
" - condense the vertical coordinates by a factor three-quarters,\n",
" - move the entire glyph left by 100\n",
" - move the entire glyph up by 200.\n",
" \n",
"the argument:\n",
"   -matrix 0 -1.0 1.0 0 0 1000\n",
"will:\n",
" - rotate the glyph clockwise by 90 around the origin point (0,0)\n",
" - move it up by 1000\n",
"\n",
"the argument:\n",
"   -matrix 1.0 0 .2 1.0 0 0\n",
"will:\n",
" - oblique the glyph, slanting at a slope of 2 units horizontally for every 10 units of height.\n",
" \n",
"Rotation info file format:\n",
"Lines beginning with '#' are skipped as comment lines.\n",
"Blank lines are skipped.\n",
"The rotation file serves three purposes.\n",
"-When specified, only glyphs name in the rotation file will be copied to the\n",
"output font file.\n",
"-The file specifies both an input and an output glyph name for each glyph, and so\n",
"can be used to rename glyphs.\n",
"-Finally, it supplies the advance width and x and y offsets for each glyph.\n",
"\n",
"Each line has five fields: source font glyph name, output font glyph name,\n",
"advance width, xoffset, y offset.\n",
"\n",
"The glyph name fields must be a decimal CID value when the source font is CID\n",
"keyed, else they must be glyph names.\n",
"\n",
"Example:\n",
"--------------------------------------------\n",
"# example rotation font info file that passes through 2 glyphs\n",
".notdef  .notdef  1000  120  880\n",
"c21  c21rotated  500  120  880\n",
"c22  c22rotated  None  120  880\n",
"--------------------------------------------\n",
"\n",
"Note that the string 'None' may be used instead of an h advance value, in order\n",
"pass through the original glyph value unchanged.\n",
"\n",
