/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>

#include "shared.h"

#define cell_IMPORT
#include "cell.h"

int
LocateCell (struct cell *p, int id)
{
	int     n;
	for (n = 0; p->id >= 0; n++, p++) {
		if (id == p->id) {
			return n;
		}
	}

	fprintf (stderr, "Unable to locate cell %d\n \
Cell zero will contain invalid data\n", id);
	return 0;
}

double
GetCellValueDouble (struct cell *p, int n, double *value)
{
	char    *s;

	s = XmTextFieldGetString (p[LocateCell(p, n)].field);
	*value = atof(s);
	XtFree (s);
	return *value;
}

void
SetCellValueDouble (struct cell *p, int n, double value)
{
	char    s[64];

	sprintf (s, "%.8lg", value);
	XmTextFieldSetString (p[LocateCell(p, n)].field, s);
}

char *
GetCellValueString (struct cell *p, int n, char *value)
{
	char    *s;

	s = XmTextFieldGetString (p[LocateCell(p, n)].field);
	strcpy (value, s);
	XtFree (s);
	return value;
}

void
SetCellValueString (struct cell *p, int n, char *value)
{
	XmTextFieldSetString (p[LocateCell(p, n)].field, value);
}
