/*
 *  acm : an aerial combat simulator for X
 *  Air and wind properties module.
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * Air data properties routines.
 * 
 * @author Riley Rainey
 * @license GNU GPL
 * @version $Date: 2020/01/08 05:58:14 $
 * @file
 */

#ifndef _air_h
#define _air_h

#include "../V/Vlibmath.h"

#ifdef air_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Calculated air properties.
 */
typedef struct {

	/** Density [slug/ft^3]. */
	double rho;

	/** Pressure [lbf/ft^2]. */
	double p;

	/** Temperature [Rankine]. */
	double t;

	/** Speed of sound [ft/s]. */
	double mach1;

} air_Properties;


/**
 * Calculate air properties at the given altitude in standard atmosphere.
 * @param air Store here the air properties.
 * @param h Altitude [ft].
 */
EXTERN void air_update(air_Properties * air, double h);

/**
 * Sets wind direction. Default: no wind.
 * @param wd Direction from which the wind come from [RAD].
 * @param wv Wind velocity [ft/s].
 */
EXTERN void air_set_wind(double wd, double wv);

/**
 * Set maximum gust intensity. Default: no gust.
 * @param gust_max Max gust intensity [ft/s].
 */
EXTERN void air_set_gust(double gust_max);

/**
 * Return wind speed (ft/s) at the given altitude (m).
 * @param h Altitude [m].
 * @return Wind speed vector.
 */
EXTERN VPoint * air_get_wind(double h);

#undef EXTERN
#endif
