!{\src2tex{textfont=tt}}
!!****f* ABINIT/vcjas
!!
!! NAME
!! vcjas
!!
!! FUNCTION
!! Calculate the correlation potential for a homogenous e-gas,
!! with charge density RHO. Uses the PERDEW & ZUNGER calculations
!! (see diffwc).
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  rho=density in real space, at a particular point
!!
!! OUTPUT
!!  function vcjas=correlation potential
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function vcjas(rho)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: vcjas
 real(dp),intent(in) :: rho

!Local variables-------------------------------
!scalars
 real(dp),parameter :: a=0.0311,b=-0.0480,beta1=1.0529,beta2=0.3334,c=0.0020
 real(dp),parameter :: d=-0.0116,gamma=-0.1423
 real(dp) :: rs,stor1,stor2

! *************************************************************************

!first calculate Rs from RHO
 rs=(3.0/(4.0*pi*rho))**third
!need to do different calculations depending on Rs<>1
 if(rs>1.0) then
  stor1=(1.0+1.16666667*beta1*sqrt(rs)+1.3333333*beta2*rs)
  stor2=gamma*(1.0+beta1*sqrt(rs)+beta2*rs)**(-2.0)
  vcjas=stor1*stor2
 else
  stor1=a*log(rs)+(b-third*a)
  stor2=0.6666667*c*rs*log(rs)+0.33333333*(2*d-c)*rs
  vcjas=stor1+stor2
 end if

 end function vcjas
!!***
