!{\src2tex{textfont=tt}}
!!****f* ABINIT/iosig
!! NAME
!! iosig
!!
!! FUNCTION
!! input/output sigma results
!! This file contains 3 routines : write_sigma_results_header,
!!  write_sigma_results, rdgw,calc_wf_qp
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  ep=epsilonm1_parameters
!!  sp=sigma_parameters
!!
!! OUTPUT
!!  (for writing routines, no output)
!!  otherwise, should be described
!!
!! NOTES
!!
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      cgemm
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine write_sigma_results_header(sp,ep)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none
 
!Arguments ------------------------------------
!scalars
 type(epsilonm1_parameters),intent(in) :: ep
 type(sigma_parameters),intent(in) :: sp
 
!Local variables-------------------------------
 character(len=500) :: message
 
! *************************************************************************

 write(message,'(a)')' SIGMA fundamental parameters:'
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 if(sp%gwcalctyp==0) then
  write(message,'(a)')' PLASMON POLE MODEL'
 else if(sp%gwcalctyp==1) then
  write(message,'(a)')' ANALYTIC CONTINUATION'
 else if(sp%gwcalctyp==2) then
  write(message,'(a)')' CONTOUR DEFORMATION'
 else if(mod(sp%gwcalctyp,10)==5) then
  write(message,'(a)')' Hartree-Fock'
 else if(mod(sp%gwcalctyp,10)==6) then
  write(message,'(a)')' Screened Exchange'
 else if(mod(sp%gwcalctyp,10)==7) then
  write(message,'(a)')' COHSEX'
 else if(mod(sp%gwcalctyp,10)==8) then
  write(message,'(a)')' MODEL GW with PLASMON POLE MODEL'
 else if(mod(sp%gwcalctyp,10)==9) then
  write(message,'(a)')' MODEL GW without PLASMON POLE MODEL'
 end if
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 write(message,'(a,i12)')' number of plane-waves for SigmaX         ',sp%npwx
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of plane-waves for SigmaC and W   ',sp%npwc
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of plane-waves for wavefunctions  ',sp%npwwfn
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of bands                          ',sp%nb
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of independent spin polarisations ',sp%nsppol
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of k-points in IBZ                ',sp%nk
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of q-points in IBZ                ',sp%nq
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of symmetry operations            ',sp%nop
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of k-points in BZ                 ',sp%nkbz
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of q-points in BZ                 ',sp%nqbz
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of omega for sigma on real axis   ',sp%nomegasrd
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,f12.2)')' deltae [eV]                              ',sp%deltae*Ha_eV
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
!MG060923 FIXME here we are wrong since sp%nomegasr sp%omegasrmax are the number of
!frequencies and the maximum frequency used in the  evaluation of the spectral function
 write(message,'(a,i12)')' number of omega for sigma on real axis   ',sp%nomegasr
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,f12.2)')' max omega for sigma on real axis  [eV]   ',sp%omegasrmax*Ha_eV
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 write(message,'(2a)')ch10,' EPSILON^-1 parameters (SCR file):'
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 !write(6,*) titem1(2)(1:79)
 write(message,'(a,i12)')' dimension of the eps^-1 matrix           ',ep%npwe
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of plane-waves for wavefunctions  ',ep%npwwfn
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of bands                          ',ep%nb
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of q-points in IBZ                ',ep%nq
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of frequencies                    ',ep%nomega
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of real frequencies               ',ep%nomegaer
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,i12)')' number of imag frequencies               ',ep%nomegaei
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(3a)')ch10,' matrix elements of self-energy operator (all in [eV])',ch10
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 if(sp%gwcalctyp<10) then
  write(message,'(a)')' Perturbative Calculation'
 else if(sp%gwcalctyp<20) then
  write(message,'(a)')' Self-Consistent on Energies only'
 else
  write(message,'(a)')' Self-Consistent on Energies and Wavefunctions'
 end if
 call wrtout(6,message,'COLL') 
 call wrtout(ab_out,message,'COLL')

 return
end subroutine write_sigma_results_header
!!***


!!****m* ABINIT/write_sigma_results
!! NAME
!! write_sigma_results
!!
!! FUNCTION
!! write the final results of the GW calculation
!!
!! INPUTS
!!
!! en_lda(sp%nk,sp%nb,sp%nsppol)= KS energies
!! ikibz= to be described (FIXME)
!! ikcalc= to be described (FIXME)
!! sp=sigma_parameters) datatype
!! sr=sigma results datatype
!!
!! OUTPUT
!!  (for writing routines, no output)
!!  otherwise, should be described
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      cgemm
!!
!! SOURCE
!!

subroutine write_sigma_results(sp,sr,ikcalc,ikibz,en_lda)
 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 type(sigma_parameters), intent(in) :: sp
 type(sigma_results), intent(in) :: sr
 integer, intent(in) :: ikcalc,ikibz
!MG060924 added new dimension to treat the spin
 real(dp),intent(in) :: en_lda(sp%nk,sp%nb,sp%nsppol)

!Local variables-------------------------------
 integer :: ib,io,i,is
 character(len=500) :: message

! *************************************************************************

 do is=1,sp%nsppol

  write(message,'(2a,3f8.3)')ch10,' k = ',sp%xkcalc(:,ikcalc)
  call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

  if(sp%gwcalctyp>=10) then
  !for self-consistent calculations, output much more
   write(message,'(a)')&
&  ' Band     E_lda   <Vxclda>   E(N-1)  <Hhartree>   SigX  SigC[E(N-1)]    Z     dSigC/dE  Sig[E(N)]  DeltaE  E(N)_pert E(N)_diago'
   call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
  else
   write(message,'(a)')&
&  ' Band     E0 <VxcLDA>   SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E'
   call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
  end if

  write(21,'(3f10.6)') sp%xkcalc(:,ikcalc)
  write(21,'(i4)') sp%maxbnd(ikcalc)-sp%minbnd(ikcalc)+1

  write(22,'("# k = ",3f10.6)') sp%xkcalc(:,ikcalc)
  write(22,'("# b = ",2i10)') sp%minbnd(ikcalc), sp%maxbnd(ikcalc)

  write(23,'("# k = ",3f10.6)') sp%xkcalc(:,ikcalc)
  write(23,'("# b = ",2i10)') sp%minbnd(ikcalc), sp%maxbnd(ikcalc)


  do ib=sp%minbnd(ikcalc),sp%maxbnd(ikcalc)

   if(sp%gwcalctyp>=10) then
    !for self-consistent calculations, output much more
    write(message,'(i5,12(2x,f8.3))')         & 
&     ib,                                     &
&     en_lda(ikibz,ib,is)*Ha_eV,              &
!&       sr%e0(ib,ikibz,is)*Ha_eV,              &
&     sr%vxcme(ib,ikibz,is)*Ha_eV,            &
&     sr%e0(ib,ikibz,is)*Ha_eV,               &
&     real(sr%hhartree(ib,ib,ikibz,is))*Ha_eV,&
&     sr%sigxme(ib,ikibz,is)*Ha_eV,           &
&     real(sr%sigcmee0(ib,ikibz,is))*Ha_eV,   &
&     real(sr%ze0(ib,ikibz,is)),              &
&     real(sr%dsigmee0(ib,ikibz,is)),         &
&     real(sr%sigmee(ib,ikibz,is))*Ha_eV,     &
&     real(sr%degw(ib,ikibz,is))*Ha_eV,       &
&     real(sr%egw(ib,ikibz,is))*Ha_eV,        &
&     sr%en_qp_diago(ib,ikibz,is)*Ha_eV
    call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
   else
    !for perturbative calculations, output a few quantities
    write(message,'(i5,9f8.3)')            &
&     ib,                                  &
&     sr%e0(ib,ikibz,is)*Ha_eV,            &
&     sr%vxcme(ib,ikibz,is)*Ha_eV,         &
&     sr%sigxme(ib,ikibz,is)*Ha_eV,        &
&     real(sr%sigcmee0(ib,ikibz,is))*Ha_eV,&
&     real(sr%ze0(ib,ikibz,is)),           &
&     real(sr%dsigmee0(ib,ikibz,is)),      &
&     real(sr%sigmee(ib,ikibz,is))*Ha_eV,  &
&     real(sr%degw(ib,ikibz,is))*Ha_eV,    &
&     real(sr%egw(ib,ikibz,is))*Ha_eV
    call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
   end if

   write(21,'(i6,3f9.4)')             &
&    ib,                              &
&    real(sr%egw(ib,ikibz,is))*Ha_eV, &
&    real(sr%degw(ib,ikibz,is))*Ha_eV,&
&    aimag(sr%egw(ib,ikibz,is))*Ha_eV
  
  end do !ib

  if(sr%e0gap(ikibz,is)**2+sr%egwgap(ikibz,is)**2+sr%degwgap(ikibz,is)**2 > tol10)then
!  If all the gaps are zero, this means that it could not be computed in the calling routine
!  MG060926 write the direct gap for each spin
   write(message,'(2a,f8.3)')ch10,' E^0_gap       ',sr%e0gap(ikibz,is)*Ha_eV
   call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
   write(message,'(a,f8.3)')      ' E^GW_gap      ',sr%egwgap(ikibz,is)*Ha_eV
   call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
   write(message,'(a,f8.3,a)')    ' DeltaE^GW_gap ',sr%degwgap(ikibz,is)*Ha_eV,ch10
   call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
  endif

  do io=1,sr%nomega
   write(22,'(100(e11.5,2x))')&
&    real(sr%omega(io))*Ha_eV,&
&    (real(sr%sigxcme(ib,ikibz,io,is))*Ha_eV,&
&    aimag(sr%sigxcme(ib,ikibz,io,is))*Ha_eV,&
&    1./pi*abs(aimag(sr%sigcme(ib,ikibz,io,is)))&
&    /( (real(sr%omega(io)-sr%hhartree(ib,ib,ikibz,is)-sr%sigxcme(ib,ikibz,io,is)))**2&
&    +(aimag(sr%sigcme(ib,ikibz,io,is)))**2) /Ha_eV,&
&    ib=sp%minbnd(ikcalc),sp%maxbnd(ikcalc))
  end do

  do ib=sp%minbnd(ikcalc),sp%maxbnd(ikcalc)
   write(23,'("# ik, ib",2i5)') ikibz,ib
   do io=1,sr%nomegasrd
    write(23,'(100(e11.5,2x))')                 &
&     real(sr%omegasrd(ib,ikibz,io,is))*Ha_eV,  &
&     real(sr%sigxcmesrd(ib,ikibz,io,is))*Ha_eV,&
&     aimag(sr%sigxcmesrd(ib,ikibz,io,is))*Ha_eV
   end do
  end do

 end do !is

 close(21)
 close(22)
 close(23)

end subroutine write_sigma_results
!!***


!!****m* ABINIT/rdgw
!! NAME
!! rdgw
!!
!! FUNCTION
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      cgemm
!!
!! SOURCE
!!
subroutine rdgw(nk,nb,nbv,ns,kibz,gwenergy)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => rdgw
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer, intent(in) :: nk,nb,ns
!MG060926 added new dimension to take into account the valence band index for each spin
 integer, intent(in) :: nbv(ns)
 real(dp), intent(in) :: kibz(3,nk)
 real(dp), intent(out) :: gwenergy(nk,nb,ns)

!Local variables ------------------------------
 real(dp) :: gwcorr(nk,nb,ns)
 integer nkr,nbr,ik,ikr,ikibz,ibr,ib,is,n
 real(dp) :: k(3),egw,degw,a,b,smrt

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: linfit
#endif
!End of the abilint section

 gwcorr(:,:,:)=0.0
 open(21,file='in.gw')
!MG060914 The format of in.gw should be standardized 
!         added external loop on spin
 read(21,*) nkr
 do is=1,ns
  do ikr=1,nkr
   read(21,*) k
   read(21,*) nbr
   ikibz=0
   do ik=1, nk
    if(all(abs(k(:)-kibz(:,ik))<0.0001)) ikibz=ik
   end do
   do ib=1, nbr
    read(21,*) ibr, egw, degw
    if(ibr<=nb .and. ikibz/=0) gwcorr(ikibz,ibr,is)=degw/Ha_eV
   end do
  end do !ikr
 end do !is
 close(21)

!MG060914 added external loop on spin
!added new dimension in nbv to take into account the valence band index for each spin
!   
 do is=1,ns
  do ik=1,nk
 
   n=nb-nbv(is)
   do ib=nbv(is)+1,nb
    if(gwcorr(ik,ib,is)==0) then
     n=ib-1-nbv(is)
     if(n>1) then
      print *, 'linear extrapolating (conduction) GW corrections beyond the read values'
      smrt=linfit(n,gwenergy(ik,nbv(is)+1:nbv(is)+n,is),gwcorr(ik,nbv(is)+1:nbv(is)+n,is),a,b)
     else
      print *, 'assuming constant (conduction) GW corrections beyond the read values'
      a=0
      b=gwcorr(ik,nbv(is)+n,is)
     end if
     exit !ib
    end if
   end do !ib
   do ib=nbv(is)+n+1,nb
    gwcorr(ik,ib,is)=a * gwenergy(ik,ib,is) + b
   end do

   n=nbv(is)
   do ib=nbv(is),1,-1
    if(gwcorr(ik,ib,is)==0) then
     n=nbv(is)-ib
     if(n>1) then
      print *, 'linear extrapolating (valence) GW corrections beyond the read values'
      smrt=linfit(n,gwenergy(ik,nbv(is)-n+1:nbv(is),is),gwcorr(ik,nbv(is)-n+1:nbv(is),is),a,b)
     else
      print *, 'assuming constant (valence) GW corrections beyond the read values'
      a=0
      b=gwcorr(ik,nbv(is),is)
     end if
     exit !ib
    end if
   end do !ib
   do ib=1,nbv(is)-n
    gwcorr(ik,ib,is)=a * gwenergy(ik,ib,is) + b
   end do
  end do !ik
 end do !is

 print *, ' k  s     GW corrections [eV]'
 do is=1,ns
  do ik=1, nk
   write(*,'(i3,1x,i3,10f7.2/50(10x,10f7.2/))') ik,is,(Ha_eV*gwcorr(ik,ib,is),ib=1,nb)
  end do
 end do 

 gwenergy(:,:,:)=gwenergy(:,:,:)+gwcorr(:,:,:)

!MG060914 should use wrtout
 print *, ' k   s    GW eigenvalues [eV]'
 write(ab_out,*) ' k   s      GW eigenvalues [eV]'
 do is=1,ns
  do ik=1, nk
   write(*,'(i3,7x,10f7.2/50(10x,10f7.2/))') ik, is, (Ha_eV*gwenergy(ik,ib,is),ib=1,nb)
   write(ab_out,'(i3,7x,10f7.2/50(10x,10f7.2/))') ik, is, (Ha_eV*gwenergy(ik,ib,is),ib=1,nb)
  end do
 enddo
 print *
 write(ab_out,*)
 return

end subroutine rdgw
!!***


!!****m* ABINIT/calc_wf_qp
!! NAME
!! calc_wf_qp
!!
!! FUNCTION
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      cgemm
!!
!! SOURCE
!!

subroutine calc_wf_qp(nk,nb,nsize,ns,m_lda_to_qp,wf,min_band_proc,max_band_proc)

use defs_basis

implicit none

 integer,intent(in) :: nk,nb,nsize,min_band_proc,max_band_proc,ns
 complex,intent(inout) :: m_lda_to_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)
 complex,intent(inout) :: wf(nsize,min_band_proc:max_band_proc,nk,ns)
!local
 integer :: ik,is
 complex :: wf_k(nsize,nb)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'CGEMM' :: cgemm
#endif
 do ik=1,nk
  do is=1,ns
   wf_k(:,:)=wf(:,:,ik,is)
   call cgemm('n','n',nsize,nb,nb,(1.,0.),wf_k(:,:),nsize,m_lda_to_qp(:,:,ik,is),nb,(0.,0.),wf(:,:,ik,is),nsize)
  end do
 end do
 end subroutine calc_wf_qp
	    
