!{\src2tex{textfont=tt}}
!!****f* ABINIT/cchi0q0
!! NAME
!! cchi0q0
!!
!! FUNCTION
!! Calculate chi0 in the limit q->0
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  energy(nkibz,nbnds,nsppol)=KS energies
!!  gradvnl =(grad_K + grad_K') Vnl(K,K') in reciprocal lattice units
!!  grottb(npwvec,2,nop)= contains the index of (IR) G where I is the identity or the inversion 
!!  grottbm1(npwvec,2,nop)=  contains the index  (IR)**-1 G 
!!  gwenergy(nkibzm,nbnds,nsppol)=GW energies, for self-consistency purposes
!!  igfft(npwvec,5,5,5)=index of G-G0 planewaves (see cigfft routine)
!!  inclvkb=flag to include (or not) the grad of Vkb
!!  irottb(nr,nop)= contains the index in the FFT array of (R**-1) r, where R is
!!   one of the nop symmetry operations in reciprocal space 
!!  lt_q= little group datatype
!!  kbz(3,nkbz)=k-point coordinates, full Brillouin zone
!!  ktab(nkbz)= table giving for each k-point in the BZ (kBZ), the corresponding 
!!   irreducible point (kIBZ), where kBZ= (IR) kIBZ and I is the inversion or the identity operation
!!  ktabi(nkbz)= for each point in the BZ defines whether inversion  has to be 
!!   considered in the relation kBZ=(IR) kIBZ (1 => only R; -1 => -R)  
!!  ktabo(nkbzmx)= the symmetry operation R that takes kIBZ to each kBZ
!!  nbnds=number of bands
!!  nbv=number of valence bands
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  nkbz=number of k points in full Brillouin zone
!!  nkibz=number of k points in irreducible Brillouin zone
!!  nkibzm=maximum number of k points in irreducible Brillouin zone
!!  nomega=number of frequencies
!!  nop=number of symmetry operations
!!  npwsigx=number of planewaves for sigma exchange (input variable)
!!  npwvec=dimension of igfft
!!  npwwfn=number of planewaves for wavefunctions (input variable)
!!  nr=number of points of FFT grid
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  occ(nkibzm,nbnds,nsppol)=occupation numbers, for each k point in IBZ, and each band
!!  omega(nomega)=frequencies
!!  op(3,3,nop)=symmetry operations in reciprocal space
!!  qq(3)=reciprocal space coordinates of the q wavevector
!!  ucvol=unit cell volume
!!  wtk(nkibz)=weights for k points (input variable)
!!
!! OUTPUT
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix for wavevector qq,
!!   and frequencies defined by omega
!!
!! NOTES
!! The terms "head", "wings" and "body" of chi(G,G'') refer to
!! G=G''=0, either G or G''=0, and neither=0 respectively
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      assemblychi0,assemblychi0q0_sym,dosym,leave_new,matrginv,pclock
!!      rho_tw_g,wrtout,xcast_mpi,xcomm_init,xmaster_init,xme_init,xsum_master
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cchi0q0(qq,nomega,omega,gvec,npwvec,npwsigx,npwwfn,op,nop,kibz,&
& nkibz,nkibzm,nbnds,nbv,nsppol,occ,ktab,ktabr,ktabi,ktabo,kbz,nkbz,irottb,&
& ngfft1,ngfft1a,ngfft2,ngfft3,igfft,nr,energy,gwenergy,etadelta,chi0,b1,b2,b3,ucvol,&
& wtk,grottb,inclvkb,gradvnl,mpi_enreg,&
& grottbm1,lt_q,natom,mpsang,fnl,fnld,&
& min_band_proc,max_band_proc,&
& parallelism_is_on_kpoints,parallelism_is_on_bands,nbnds_per_proc,distributed,nonlocal,wfr,wfg)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_15gw, except_this_one => cchi0q0
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!MG FIXME This variable is not used 
!scalars
 integer,intent(in) :: inclvkb,max_band_proc,min_band_proc,nbnds,nbnds_per_proc
 integer,intent(in) :: ngfft1,ngfft1a,ngfft2,ngfft3,nkbz,nkibz,nkibzm,nomega
 integer,intent(in) :: nop,npwsigx,npwvec,npwwfn,nr,nsppol
 real(dp),intent(in) :: etadelta,ucvol
 logical,intent(in) :: distributed,parallelism_is_on_bands
 logical,intent(in) :: parallelism_is_on_kpoints,nonlocal
 type(MPI_type),intent(inout) :: mpi_enreg
 type(little_group),intent(in) :: lt_q
!arrays
 integer,intent(in) :: grottb(npwvec,2,nop),grottbm1(npwvec,2,nop)
 integer,intent(in) :: gvec(3,npwvec),igfft(npwvec,5,5,5),irottb(nr,nop)
 integer,intent(in) :: ktab(nkibzm),ktabi(nkibzm),ktabo(nkibzm)
 integer,intent(in) :: ktabr(nr,nkibzm),nbv(nsppol)
 real(dp),intent(in) :: b1(3),b2(3),b3(3)
 real(dp),intent(in) :: energy(nkibz,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: gwenergy(nkibz,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: kbz(3,nkibzm),kibz(3,nkibz)
 real(dp),intent(in) :: occ(nkibz,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: op(3,3,nop),qq(3),wtk(nkibz)
 complex,intent(in) :: gradvnl(3,npwwfn,npwwfn,nkibz),omega(nomega)
 complex,intent(in),optional :: wfg(npwwfn,min_band_proc:max_band_proc,nkibz,nsppol)
 complex,intent(in),optional :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
 complex,intent(out) :: chi0(npwsigx,npwsigx,nomega)

!Local variables ------------------------------
!scalars
 integer,parameter :: unitwfg=25,unitwfr=26
 integer :: ib,ibc,ibv,ig,igp,iinv,ik,ikbz,ikibz,io,iop,ir,is,istat
 integer :: jb_proc_rank,max_con,max_val,min_con,min_val,nrb,tim_fourdp
 real(dp) :: f_occ,factocc,rtemp,weight
 complex :: cauxil,ct,ct2,ctemp,rhotmp
!MG the if statements related to these logical variables 
!have been commented in the code
 logical,parameter :: onlyantiresonant=.false.
 logical :: ltemp,noantiresonant=.false.
!arrays
 real(dp) :: opinv(3,3),qcart(3),qrot(3)
 real(dp),allocatable :: energy_k(:),energy_temp(:,:,:),gwenergy_k(:)
 real(dp),allocatable :: gwenergy_temp(:,:,:),oc_k(:),oc_temp(:,:,:)
 complex :: cv(3),rhotwx(3),rhotwxc(3)
 complex,allocatable :: rhotw(:),rhotwg(:),wfg_k(:,:),wfg_temp(:,:,:,:)
 complex,allocatable :: wfng(:,:),wfnrk(:,:),wfr_k(:,:),wfr_temp(:,:,:,:)
 complex,allocatable :: wfr_v(:,:)
!no_abirules
 complex (kind(0.0_dp)):: ediff,egwdiff
 complex (kind(0.0_dp)),allocatable :: den(:)
 character(len=500)::message
 integer::master,spaceComm,ierr,me
!MG this is for the new implementation of vkb
 complex cta1,cta2(3),cta3(3),cta4
 integer :: iat,ilm,ii
!new input variables, should be described
 logical::i_can_read,master_must_cast_data
 integer,intent(in) :: natom,mpsang
 complex,intent(in) :: fnl(npwwfn,mpsang*mpsang,natom,nkibz),fnld(3,npwwfn,mpsang*mpsang,natom,nkibz)
 complex,allocatable :: fnlkslm(:),fnldkslm(:,:)
!END MG 

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 complex :: dotproductqrc
#endif
!End of the abilint section

 write(message,'(4a)')' cchi0q0 : enter',ch10,' calculating chi0(q=(0,0,0),omega,G,G")',ch10
 call wrtout(06,message,'COLL')

 if(mpi_enreg%me==0)then 
  write(*,*)'symmetrization flag = ',lt_q%sym_flag
 end if 

 !These lines added by Shaltaf for parallelization 10/08/05
 !parallization is on k points only, one must include the bands too in the future

 call xcomm_init(mpi_enreg,spaceComm) !Init mpi_comm
 call xme_init(mpi_enreg,me)          !Init me
 call xmaster_init(mpi_enreg,master)  !Init master

 tim_fourdp=1
 nrb=ngfft1*ngfft2*ngfft3
 
 !weight (2 for spin unpolarized sistem, 1 for polarized)
 !f_occ is set outside the loops and is used to normalize the occupation factors to one
 if (nsppol==1) then 
  weight=2.0/nkbz
  f_occ=0.5
 else if (nsppol==2) then 
  weight=1.0/nkbz
  f_occ=1.0
 else 
  write(message,'(2a)')ch10,&
& ' cchi0: BUG wrong value for nsppol '
  call wrtout(6,message,'COLL') 
  call leave_new('COLL')
 end if

 if(.not.(present(wfr)))then
  allocate(wfng(npwwfn,nbnds),stat=istat)
  if(istat/=0) stop 'out of memory'
  allocate(wfnrk(nr,nbnds),stat=istat)
  if(istat/=0) stop 'out of memory'
 end if
 allocate(den(nomega),stat=istat)
 if(istat/=0) stop 'out of memory'
 allocate(rhotwg(npwsigx),stat=istat)
 if(istat/=0) stop 'out of memory'
 allocate(rhotw(nr),stat=istat)
 if(istat/=0) stop 'out of memory'
 if(inclvkb==2) then 
  allocate (fnlkslm(npwwfn),fnldkslm(3,npwwfn))
 end if 

 chi0(:,:,:)=(0.,0.) !zero chi0
!Organize the I/O of proc
 if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then
  i_can_read=.true.
 else
  i_can_read=.false.
 end if

 if(mpi_enreg%nproc>1.and.nonlocal)then
  master_must_cast_data=.true.
 else
  master_must_cast_data=.false.
 end if

!The loop over spin is placed after the loop over k-points to optimize
!the code since we need the traceof the polarizability: $\Chi_{up,up} + \Chi_{down,down}$

 if (lt_q%sym_flag/=0) then 
  write(message,'(a,i6,a)')' calculation status (',sum(lt_q%ibzq(:)),' to be completed):'
 else 
  write(message,'(a,i6,a)')' calculation status (',nkbz,' to be completed):'
 end if 
 call wrtout(06,message,'COLL')

!XG070103 : this section concerning parallelisation will definitively not work when nsppol==2
!Not every proc may have the wavefunction,energies,and occupations  
!that correspond to the block of valence bands
!these data has to be casted from the proc that has them into other proc
 if(present(wfr))then
  if(mpi_enreg%nproc>1.and.parallelism_is_on_bands.and.distributed)then
   allocate(wfr_temp(nr,nbv(1),nkibz,nsppol))
   allocate(wfg_temp(npwwfn,nbv(1),nkibz,nsppol))
   allocate(gwenergy_temp(nkibz,nbv(1),nsppol))
   allocate(energy_temp(nkibz,nbv(1),nsppol))
   allocate(oc_temp(nkibz,nbv(1),nsppol))

   do ibv=1,nbv(1)
    jb_proc_rank=minval(abs(mpi_enreg%proc_distrb(ibv,:,:)))
    if(me==jb_proc_rank)then
     wfr_temp(:,ibv,:,:)=wfr(:,ibv,:,:)
     wfg_temp(:,ibv,:,:)=wfg(:,ibv,:,:)
     gwenergy_temp(:,ibv,:)=gwenergy(:,ibv,:)
     energy_temp(:,ibv,:)=energy(:,ibv,:)
     oc_temp(:,ibv,:)=occ(:,ibv,:)
    end if
    call xcast_mpi(wfr_temp(:,ibv,:,:),jb_proc_rank,spaceComm,ierr)
    call xcast_mpi(wfg_temp(:,ibv,:,:),jb_proc_rank,spaceComm,ierr)
    call xcast_mpi(energy_temp(:,ibv,:),jb_proc_rank,spaceComm,ierr)
    call xcast_mpi(gwenergy_temp(:,ibv,:),jb_proc_rank,spaceComm,ierr)
    call xcast_mpi(oc_temp(:,ibv,:),jb_proc_rank,spaceComm,ierr)
   end do ! ibv
  end if
 end if

 do ikbz=1,nkbz !loop over k-points in BZ
  !These lines added by Shaltaf for parallelization 10/08/05
  if(mpi_enreg%nproc>1 .and.parallelism_is_on_kpoints )then
   if(minval(abs(mpi_enreg%proc_distrb(ikbz,:,:)-mpi_enreg%me))/=0)cycle
  end if

!MG symmetrization 
! this coding is safer since lt_q%ibzq(ik) might be not allocated 
  if (lt_q%sym_flag/=0) then 
   if (lt_q%ibzq(ikbz)/=1) cycle !only k in IBZq   
  end if

  ikibz=ktab(ikbz)
  iop=ktabo(ikbz)
  iinv=(3-ktabi(ikbz))/2
 
  do is=1,nsppol

   write(message,'(a,2i6)')' cchi0q0 : ik,is=',ikbz,is
   call wrtout(06,message,'COLL')

   if(distributed)then
    min_val=1
    max_val=nbv(is)
    min_con=nbv(is)+1
    max_con=nbnds
!  this will lead to a faster algorithm
!  this algorithm might be used in serial case
!  at the moment (for testing+debugging) we only use it in case of band para
   else
    min_val=1
    max_val=nbnds
    min_con=1
    max_con=nbnds
   end if

   if(.not.(present(wfr)))then
    !read wfn(G) and wfn(r) for the associated ibz k-point and spin
    if(i_can_read)then
    read(unitwfg,rec=ikibz+nkibz*(is-1)) ((wfng(ig,ib),ig=1,npwwfn),ib=1,nbnds)
    read(unitwfr,rec=ikibz+nkibz*(is-1)) ((wfnrk(ir,ib),ir=1,nr),ib=1,nbnds)
    end if
    if(master_must_cast_data)then
    call xcast_mpi(wfng,master,spaceComm,ierr)
    call xcast_mpi(wfnrk,master,spaceComm,ierr)
   end if
   end if

   !the wavefunctions for the k-point in the bz are:
   !wfn(G,b,kbz)=wfn(R^-1G,b,kibz) (=wfn*(R^-1G,b,kibz) for inversion)
   !wfn(r,b,kbz)=wfn(R^-1r,b,kibz) (=wfn*(R^-1r,b,kibz) for inversion)
   !the gradient of the Vnl(K,K'') for the k-point in the bz should be:
   !gradvnl(G,G'',kbz)=R gradvnl(R^-1G,R^-1G'',kibz)

   do ibc=min_con,max_con
    if(mpi_enreg%nproc>1.and.parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ibc,:,:)-mpi_enreg%me))/=0)cycle
    end if     
    do ibv=min_val,max_val
     !MG in case of nsppol==2  the correct expression is:
     !   factocc=(ockp-occ(ikibz,ibv,is)) since  occ \in [0,1]

     !MG WARNING here the merge has introduced a BUG
     !in case of nsppol=2 we must multiply the occupation numbers by 1
     !for this reason I have introduce f_occ 
     if(distributed)then
      factocc=f_occ*(oc_temp(ikibz,ibv,is)-occ(ikibz,ibc,is))
     else
      factocc=f_occ*(occ(ikibz,ibc,is)-occ(ikibz,ibv,is))
     end if       

!    we continue the loop only if factocc !=0
     if(abs(factocc)<0.01) cycle

!DEBUG
!    if(noantiresonant .and. factocc<tol8) cycle
!    if(onlyantiresonant .and. factocc>tol8) cycle
!ENDDEBUG

     if(distributed)then
      ediff=energy_temp(ikibz,ibv,is)-energy(ikibz,ibc,is)
     else
      ediff=energy(ikibz,ibc,is)-energy(ikibz,ibv,is)
     end if
     if(distributed)then
      egwdiff=gwenergy_temp(ikibz,ibv,is)-gwenergy(ikibz,ibc,is)
     else
      egwdiff=gwenergy(ikibz,ibc,is)-gwenergy(ikibz,ibv,is)
     end if

!    Add the small imaginary of the time-ordered response function
!    XG070106 : Here, I do not know how to mix Riad and Fabien contributions
     if(distributed)then
      egwdiff= egwdiff + (0.,1.)*etadelta
      den(:)=factocc/(omega(:)+egwdiff)-factocc/(omega(:)-egwdiff)
     else
!     egwdiff= egwdiff - (0.,1.)*egwdiff/abs(egwdiff)*etadelta
!     XG070106 : Could Riad and Fabien check that this is correct ?
      do io=1,nomega
       if(real(omega(io))>0.001) then
        den(io)=factocc/(omega(io)+egwdiff-(0.,1.)*egwdiff/abs(egwdiff)*etadelta)
       else
        den(io)=factocc/(omega(io)+egwdiff)
       end if
      end do
     end if

!    Calculate rho-twiddle(G)
     if(present(wfr))then
      if(distributed)then
       call rho_tw_g(npwsigx,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,&
&       igfft(:,3,3,3),wfr(:,ibc,ikibz,is),iinv,ktabr(:,ikbz),&
&       wfr_temp(:,ibv,ikibz,is),iinv,ktabr(:,ikbz),rhotwg,tim_fourdp)
      else
       call rho_tw_g(npwsigx,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,&
&       igfft(:,3,3,3),wfr(:,ibc,ikibz,is),iinv,ktabr(:,ikbz),&
&       wfr(:,ibv,ikibz,is),iinv,ktabr(:,ikbz),rhotwg,tim_fourdp)
      end if
     else   !if they were read from disk file..
      call rho_tw_g(npwsigx,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,&
&      igfft(:,3,3,3),wfnrk(:,ibc),iinv,ktabr(:,ikbz),&
&      wfnrk(:,ibv),iinv,ktabr(:,ikbz),rhotwg,tim_fourdp)
     end if ! present(wfr)

     !set up rho-twiddle(G=0) using small vector q instead of zero
     !and k.p perturbation theory
     rhotwx(:)=0.0

     !first term<c,k|-iq*grad|v,k>
     do ig=1,npwwfn
      if(present(wfg))then
       if(distributed)then
        ct=conjg(wfg(ig,ibc,ikibz,is))*wfg_temp(ig,ibv,ikibz,is)
       else
        ct=conjg(wfg(ig,ibc,ikibz,is))*wfg(ig,ibv,ikibz,is)
       end if
      else
       ct=conjg(wfng(ig,ibc))*wfng(ig,ibv)
      end if
      rhotwx(:)=rhotwx(:)+gvec(:,ig)*ct
     end do ! ig

!    Second term<c,k|[Vnl,iqr]|v,k>
     if(inclvkb==1) then
      do ig=1,npwwfn
       do igp=1,npwwfn
        if(present(wfg))then
         if(distributed)then
          ct=conjg(wfg(ig,ibc,ikibz,is))*wfg_temp(igp,ibv,ikibz,is)
         else
          ct=conjg(wfg(ig,ibc,ikibz,is))*wfg(igp,ibv,ikibz,is)
         end if
        else
         ct=conjg(wfng(ig,ibc))*wfng(igp,ibv)
        end if
!       Must multiply by ucvol because yet gradvnl contain 1/ucvol
        rhotwx(:)=rhotwx(:)+ct*gradvnl(:,ig,igp,ikibz)
       end do
      end do

     else if (inclvkb==2) then

!     MG new treatment of the gradient of the non local operator 
!     should be possible to speed up by considering only ntypat
!     and only the kb projectors used for each type of atom  
!     note that incldvkb==2 should be the default approach (much much faster!)
!     XG070103 : not yet compatible with parallelism over bands ...
!     parallelism over bands for this option is fixed by Rshaltaf 120207 
      do iat=1,natom 
       do ilm = 1,mpsang*mpsang 
        fnlkslm(:)=fnl(:,ilm,iat,ikibz)
        do ii=1,3
         fnldkslm(ii,:)=fnld(ii,:,ilm,iat,ikibz) 
         cta1=(0.,0.)
         cta2(:)=(0.,0.)
         cta3(:)=(0.,0.)
         cta4=(0.,0.)
         !here we take advantage of the property Y_(l-m)=(-i^m)Y_lm^* 
         do ig = 1,npwwfn
          if(present(wfg))then
              cta1 =    cta1    + wfg(ig,ibc,ikibz,is) * fnlkslm(ig)
              cta3(:) = cta3(:) + wfg(ig,ibc,ikibz,is) * fnldkslm(:,ig)
           if(distributed)then
             cta2(:) = cta2(:) + wfg_temp(ig,ibv,ikibz,is) * fnldkslm(:,ig)
             cta4    = cta4    + wfg_temp(ig,ibv,ikibz,is) * fnlkslm(ig)
          else              
             cta2(:) = cta2(:) + wfg(ig,ibv,ikibz,is) * fnldkslm(:,ig)
             cta4    = cta4    + wfg(ig,ibv,ikibz,is) * fnlkslm(ig)
          end if
          else
          cta1 = cta1 + wfng(ig,ibc)*fnlkslm(ig)
          cta2(:) = cta2(:) + wfng(ig,ibv) * fnldkslm(:,ig)
          cta3(:) = cta3(:) + wfng(ig,ibc) * fnldkslm(:,ig)
          cta4 = cta4 + wfng(ig,ibv)*fnlkslm(ig)
          end if
         end do ! ig
         rhotwx(:)=rhotwx(:) +conjg(cta1)*cta2(:)+conjg(cta3(:))*cta4
        end do ! ii
       end do ! ilm
      end do ! iat
!     END NEW treatment

     end if

     rhotwx(:)=-rhotwx(:)/ediff

     if (lt_q%sym_flag==0) then !no symmetries 
      !rhotwg(1)=R^-1q*rhotwx_ibz
      !rhotwg(1)=-R^-1q*conjg(rhotwx_ibz) for inversion
      opinv(:,:)=op(:,:,iop)
      call matrginv(opinv,3,3)
      call dosym(opinv,iinv,qq,qrot)
      rhotwg(1)=dotproductqrc(qrot,rhotwx,b1,b2,b3)
      if(iinv==2) rhotwg(1)=conjg(rhotwg(1))

      call assemblychi0(npwsigx,nomega,chi0,rhotwg,den)

     else  
!     MG Symmetrization, should merge this subroutine with assemblychi0 
      call assemblychi0q0_sym(qq,npwvec,npwwfn,npwsigx,lt_q%ninv,lt_q%nop,lt_q%op,&
&      lt_q%nkbz,lt_q%wtksym(:,:,ikbz),grottbm1,nomega,chi0,rhotwx,rhotwg,den,b1,b2,b3) 
     end if  
    write(6,*)ibv,ibc
    end do !ibv
   end do !ibc
  end do !is

 end do !ikibz

 call pclock(180)
 !These lines added by Shaltaf for parallelization 10/08/05
 !Rewritten using upper level primitives by MB 20060830
 call xsum_master(chi0,master,spaceComm,ierr)
 
 chi0(:,:,:)=weight*chi0(:,:,:)

  call pclock(180)

 if(allocated(wfr_temp))deallocate(wfr_temp)
 if(allocated(wfg_temp))deallocate(wfg_temp)
 if(allocated(gwenergy_temp))deallocate(gwenergy_temp)
 if(allocated(energy_temp))deallocate(energy_temp)
 if(allocated(oc_temp))deallocate(oc_temp)
 if(allocated(wfng))deallocate(wfng)
 if(allocated(wfnrk))deallocate(wfnrk)
 deallocate(den,rhotwg,rhotw)
 if(inclvkb==2)deallocate(fnlkslm,fnldkslm)

 write(message,'(a)')' cchi0q0 : exit '
 call wrtout(06,message,'COLL')

 end subroutine cchi0q0
!!***
