!{\src2tex{textfont=tt}}
!!****f* ABINIT/assemblychi0q0_sym
!! NAME
!! assemblychi0q0_sym
!!
!! FUNCTION
!! Update the independent particle susceptibility at q==0 for the contribution
!! of one pair of occupied-unoccupied band, for each frequencies
!! taking into account the symmetries of the little group of the external 
!! point q
!!
!! Compute chi0(G,G'',io)=chi0(G,G'',io)+\sum_S (rhotwg(G)*rhotwg*(G''))*den(io)
!! where S is a symmetry in reciprocal space 
!! The subroutine also performs the symmetrization of the matrix elements of the 
!! gradient operator and of the commutator of non local pseudopotential operator 
!! with the position operator 
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  npwwfn=number of planewaves for wavefunctions (input variable)
!!  npwsigx=number of plane waves for sigma exchange or epsilon (input variable)
!!  npwvec=maximum number of G vectors
!!  nomega=number of frequencies
!!  qq(3)=reciprocal space coordinates of the q wavevector
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  rhotwx(3)=matrix elements of the gradient and of the commutator of the non
!!   local operator with the position operator (the second term in included only if inclvkb=1
!!  den(nomega)=denominator of the susceptibility expression
!!  nop=number of symmetry operations
!!  ninv=if 2, inversion is considered; if 1, inversion is not considered
!!  nkbz=number of kpoints in the full BZ
!!  wtksym(2,nop)= equal to 1 if the symmetry (with or without time reversal) for this kpoint must be considered
!!   in the calculation of \chi_o, 0 otherwise  
!!  grottbm1(npwvec,2,nop)= contains the index of (IR) G where I is the identity or the inversion 
!!   operation and G is one of the npwvec vectors in reciprocal space 
!!    
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space at q==0
!!
!! NOTES
!!  Non symmporphic operations are not yet treated
!!
!! PARENTS
!!   
!!
!! CHILDREN
!!   
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine assemblychi0q0_sym(qq,npwvec,npwwfn,npwsigx,ninv,nop,op,&
& nkbz,wtksym,grottbm1,nomega,chi0,rhotwx,rhotwg,den,b1,b2,b3)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_11util
 use interfaces_15gw, except_this_one => assemblychi0q0_sym
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ninv,nkbz,nomega,nop,npwsigx,npwvec,npwwfn
!arrays
 integer,intent(in) :: grottbm1(npwvec,2,nop),wtksym(2,nop)
 real(dp),intent(in) :: b1(3),b2(3),b3(3),op(3,3,nop),qq(3)
 complex,intent(in) :: rhotwg(npwsigx),rhotwx(3)
 complex,target :: chi0(npwsigx,npwsigx,nomega)
!no_abirules
 complex (kind(0.0d0)),intent(in) :: den(nomega)

!Local variables-------------------------------
!scalars
 integer :: i,i2,ig,igp,iinv,io,iop,npwsigx2
 complex :: ct,dd
!arrays
 real(dp) :: opinv(3,3),qrot(3)
 complex,allocatable :: rhotwg_sym(:)

! *************************************************************************

#ifdef VMS
!DEC$ ATTRIBUTES ALIAS:'CGERC' :: cgerc
#endif
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 complex :: dotproductqrc
#endif
!End of the abilint section

 allocate(rhotwg_sym(npwsigx))

 !rhotwg(1)=R^-1q*rhotwx_ibz
 !rhotwg(1)=-R^-1q*conjg(rhotwx_ibz) for inversion
 do iop=1,nop
  do iinv=1,ninv
   if (wtksym(iinv,iop)==1) then 
    !here we should add the phase in case of non symmorphic operations 
    if (iinv==1) then 
     rhotwg_sym(1:npwsigx)=rhotwg(grottbm1(1:npwsigx,iinv,iop))
     opinv(:,:)=op(:,:,iop)
     call matrginv(opinv,3,3)
     call dosym(opinv,iinv,qq,qrot)
     rhotwg_sym(1)=dotproductqrc(qrot,rhotwx,b1,b2,b3)
    else 
     rhotwg_sym(1:npwsigx)=conjg(rhotwg(grottbm1(1:npwsigx,iinv,iop)))
     opinv(:,:)=op(:,:,iop)
     call matrginv(opinv,3,3)
     call dosym(opinv,iinv,qq,qrot)
     rhotwg_sym(1)=conjg(dotproductqrc(qrot,rhotwx,b1,b2,b3))
    end if 
    do io=1,nomega
     !dd is single precision needed for cgerc
     dd=den(io)
     call cgerc(npwsigx,npwsigx,dd,rhotwg_sym,1,rhotwg_sym,1,chi0(:,:,io),npwsigx)
    end do
   end if 
  end do 
 end do 
  
 deallocate(rhotwg_sym)

end subroutine assemblychi0q0_sym
!!***
