!{\src2tex{textfont=tt}}
!!****f* ABINIT/vlocal2
!! NAME
!! vlocal2
!!
!! FUNCTION
!!  (to be completed)
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (JJ)
!!
!! INPUTS
!!  (to be completed)
!!
!! OUTPUT
!!  (to be completed)
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine vlocal2( zval, nrval, a, rofi, drdi, s, vps, nrgauss, &
&                    vlocal,nchloc,chlocal )

 use defs_basis
! This routine generates the local pseudopotential appropriate
! for species with  a large core.
! Written by D. Sanchez-Portal, Aug. 1998

 implicit none

!Arguments ----------------------------
!scalars
 integer,intent(in) :: nrval
 integer,intent(inout) :: nrgauss
 integer,intent(out) :: nchloc
 real(dp),intent(in) :: a,zval
!arrays
 real(dp),intent(in) :: drdi(:),rofi(:),s(:),vps(:)
 real(dp),intent(out) :: chlocal(:),vlocal(:)

!Local variables ----------------------
!scalars
 integer :: ir,ndevfit
 real(dp),parameter :: eps=1.0d-5
 real(dp) :: a2b4,cons,d2g,d2u,dev,dev2,dev3,dm11,dm12,dm13,dm21,dm22,dm23,dm31
 real(dp) :: dm32,dm33,g0,g1,g2,g3,g4,qtot,r,v1,v2,v3,v4,var1,var2,var3,vlc

! *************************************************************************

!     Continuity up to second derivative***
 ndevfit=2
!     Continuity up to third derivative****
! ndevfit=3

 nrgauss = nrgauss + 3        !! For good measure...

 do ir = 1, nrval
   vlocal(ir) = vps(ir) * rofi(ir)
 end do

 ir   = nrgauss
 dev  = ( vlocal(ir+1) - vlocal(ir-1) ) * 0.5d0
 dev2 = ( vlocal(ir+1) + vlocal(ir-1) - 2.0d0 * vlocal(ir) )
 dev3 = ( vlocal(ir+2) - 2.0d0 * vlocal(ir+1)                  &
&         + 2.0d0 * vlocal(ir-1) - vlocal(ir-2) ) * 0.5d0
 dev3 = ( dev3 - 3.0d0 * a * dev2 + 2.0d0 * (a**2) * dev ) / ( drdi(ir)**3 )
 dev2 = ( dev2 - a * dev ) / ( drdi(ir)**2 )
 dev  = dev / drdi(ir)

!     Local potential is Vloc(r)=v3*exp(v1*r^2+v2*r^3)
!     inside Rgauss and equals the
!     all-electron atomic potential outside Rgauss
!     We impose the continuity up to second derivative

 if( ndevfit .eq. 2 ) then
   vlc = vlocal(nrgauss)
   r   = rofi(nrgauss)

   var1 = dev  / vlc - 1.0d0 / r
   var2 = dev2 / vlc - 2.0d0 * var1 / r  - ( var1**2 )

   dm11 = 2.0d0 * r
   dm12 = 3.0d0 * r * r
   dm21 = 2.0d0
   dm22 = 6.0d0 * r

   v1 = ( dm22 * var1 - dm12 * var2 ) /( 6.0d0 * r * r )
   v2 = ( dm11 * var2 - dm21 * var1 ) /( 6.0d0 * r * r )
   v3 = vlc / ( r * exp( ( v1 + v2*r ) * r * r ) )


! elseif(ndevfit.eq.3) then
 else

!     We can also construct a local potential
!     Vloc(r)=v4*exp(v1*r^2+v2*r^3+v3*r^4),
!     this new coefficient allows us to impose the continuity
!     of the potential up  to the third derivative.

   vlc  = vlocal( nrgauss )
   r    = rofi( nrgauss )

   var1 = dev  / vlc - 1.d0 / r
   var2 = dev2 / vlc - 2.0d0 * var1 / r - ( var1**2 )
   var3 = dev3 / vlc - 3.0d0 * var1 * var2 - ( var1**3 ) &
&          - 3.0d0 *( var1**2 + var2 ) / r

   dm11 = 2.0d0 * r
   dm12 = 3.0d0 * r * r
   dm13 = 4.0d0 * r * r * r
   dm21 = 2.0d0
   dm22 = 6.0d0 * r
   dm23 = 12.0d0 * r * r
   dm31 = 0.0d0
   dm32 = 6.0d0
   dm33 = 24.0d0 * r

   v1 = ( ( var1 * dm22 * dm33 + var2 * dm13 * dm32 + var3 * dm12 * dm23 ) &
&      -(var3*dm22*dm13+var1*dm32*dm23+var2*dm12*dm33))/(48.0_dp*r*r*r)
   v2 = ( ( var2 * dm11 * dm33 + var3 * dm21 * dm13 + var1 * dm23 * dm31 ) &
&      -(var2*dm31*dm13+var3*dm23*dm11+var1*dm21*dm33))/(48.0_dp*r*r*r)
   v3 = ( ( var3 * dm11 * dm22 + var2 * dm12 * dm31 + var1 * dm32 * dm21 ) &
&      -(var1*dm22*dm31+var3*dm21*dm12+var2*dm11*dm32))/(48.0_dp*r*r*r)
   v4 = vlc / ( r * exp( ( v1 + v2 * r + v3 * r * r ) * r * r ) )

 end if

 do ir = 1, nrval
   r = rofi(ir)
   if( ir .le. nrgauss ) then
!**   If second derivative fit***
      if( ndevfit .eq. 2 ) then
        vlocal(ir) = v3 * exp( ( v1 + v2*r ) * r * r )
!**   If third derivative fit****
      else if(ndevfit.eq.3) then
        vlocal(ir) = v4 * exp ( ( v1 + v2 * r + v3 * r * r ) * r * r )
!****
      end if
   else
      vlocal(ir) = vps(ir)
   end if
 end do

!     Once we have the local potential we define the 'local-pseudopotential
!     charge' which help us to calculate the electrostatic interation
!     between the ions
!
!     Poisson's eq.:
!
!           1/r* d2(rV)/dr2 = -8*pi*rho
!
 a2b4 = 0.25d0 * a * a
 qtot = 0.d0
 do ir = 1, nrval-1
   g2 = vlocal(ir) * rofi(ir)
!
!        To determine the chlocal cutoff, use the reduced_vlocal cutoff
!
   if( abs ( g2 + 2.0d0 * zval ) .lt. eps ) then
    exit   !exit loop
   end if

   if( ir .gt. nrgauss ) then
      if( ( ir .gt. 2 ) .and. ( ir .lt. (nrval-1) ) ) then
         g0 = vlocal(ir-2) * rofi(ir-2) / s(ir-2)
         g1 = vlocal(ir-1) * rofi(ir-1) / s(ir-1)
         g2 = vlocal(ir)   * rofi(ir)   / s(ir)
         g3 = vlocal(ir+1) * rofi(ir+1) / s(ir+1)
         g4 = vlocal(ir+2) * rofi(ir+2) / s(ir+2)
         d2g = ( 16.d0 * ( g1 + g3 ) - ( g0 + g4 ) -30.d0 * g2 ) / 12.d0
      else
         g1 = vlocal(ir-1) * rofi(ir-1) / s(ir-1)
         g2 = vlocal(ir)   * rofi(ir)   / s(ir)
         g3 = vlocal(ir+1) * rofi(ir+1) / s(ir+1)
         d2g = g1 + g3 - 2.0d0 * g2
      end if
      d2u         = d2g - a2b4 * g2
      r           = rofi(ir)
      cons        = 8.0d0 * pi * r * drdi(ir) * s(ir)
      chlocal(ir) = (-d2u) / cons
      qtot        = qtot + 0.5d0 * d2u * r / s(ir)
   else
!     If second derivative fit
      if( ndevfit .eq. 2 )  then
         r  = rofi(ir)
         g0 = v3 * exp( ( v1 + v2 * r ) * r **2 )
         g1 = ( 2.d0 * v1 + 3.0d0 * v2 * r )
         g2 =   2.d0 * v1 + 6.0d0 * v2 * r
         g3 = ( g2 + g1 * g1 * r * r + 2.0d0 * g1 ) * g0
         cons        = 8.0d0 * pi
         chlocal(ir) = (-g3) / cons
         qtot        = qtot  + 0.5d0 * g3 * r * r * drdi(ir)
!**** If third derivative fit
      else if ( ndevfit .eq. 3 )  then
         r  = rofi(ir)
         g0 = v4 * exp( ( v1 + v2 * r + v3 * r * r ) * r * r )
         g1 = ( 2.0d0 * v1 + 3.0d0 * v2 * r + 4.0d0  * v3 * r * r )
         g2 = ( 2.0d0 * v1 + 6.0d0 * v2 * r + 12.0d0 * v3 * r * r )
         g3 = ( g2 + g1 * g1 * r * r + 2.0d0 * g1 ) * g0

         cons        = 8.0d0 * pi
         chlocal(ir) = -g3 / cons
         qtot        = qtot  + 0.5d0 * g3 * r * r * drdi(ir)
      end if
   end if
 end do
!
!     This sets the cutoff point for chlocal in a rather
!     arbitrary way, as that in which Vlocal "equals" 2Z/r
!
 nchloc = ir

 do ir = 1, nchloc-1
   chlocal(ir) = zval * chlocal(ir) / qtot
 end do
 do ir = nchloc, nrval
   chlocal(ir) = 0.0_dp
 end do

end subroutine vlocal2
! ---
!!***
