!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_occ
!! NAME
!! calc_occ
!! 
!! FUNCTION
!! Deduce occupations of valence states from considerations
!! upon reference energies and valence densities
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!  usdata
!!    %lval(nval)= l angular momentum for each valence state
!!    %nval= Number of valence states
!!    %occ(nval)= Valence states occupancies inherited from USpp
!!    %refkeys(basis_size)= Key for identifying each reference energie
!!    %snl(wav_meshsz,nval)= Radial part of atomic eigenfunction
!!                           for each valence state
!!  un_log= Unit number for log file (comments)
!!
!! OUTPUT
!!  pawarray
!!    %occ_(sph_meshsz,basis_size)= Partial waves occupancies deduced
!!                                  from densities considerations
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine calc_occ(pawarray,pawps,pshead,usdata,un_log)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 integer :: un_log
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead
 type(usdata_type)   :: usdata

!Local variables ---------------------------------------
 integer :: ib,ir,ival
 real(dp) :: amat(2,2),bvec(2),xres(2)
 integer, allocatable :: iref(:,:),ieigref(:),nref(:)

!--------------------------------------------------------

!Question: how many reference energies are atomic eigenenergies ?
 allocate(iref(2,usdata%nval),ieigref(usdata%nval),nref(usdata%nval))
 nref=0;iref=0;ieigref=0
 do ival=1,usdata%nval
  do ib=1,pshead%basis_size
   if (pshead%orbitals(ib)==usdata%lval(ival)) then
    nref(ival)=nref(ival)+1
    if (nref(ival)>2) then
     write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (calc_occ):'
     write(un_log,'(a)')   '    Incorrect number of ref. energies'
     write(un_log,'(a,i2,a)')   'for valence state nr ',ival,' (>2) !'
     stop 'Program stopped before end'
    endif
    iref(nref(ival),ival)=ib
    if (usdata%refkeys(ib)==ival) ieigref(ival)=ib
   endif
  enddo
  if (nref(ival)==0) then
   write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (calc_occ):'
   write(un_log,'(a)')   '    Incorrect number of ref. energies'
   write(un_log,'(a,i2,a)')   'for valence state nr ',ival,' (=0) !'
   stop 'Program stopped before end'
  endif
 enddo

!Deduce partial waves occupancies from density considerations
 pawarray%occ_=zero
 do ival=1,usdata%nval

  if (ieigref(ival)/=0) then
   pawarray%occ_(1:pshead%sph_meshsz,ieigref(ival))=usdata%occ(ival)

  elseif (nref(ival)==2) then
   do ir=2,pshead%sph_meshsz-1
    bvec(1)=usdata%occ(ival)*usdata%snl(ir  ,ival)**2
    bvec(2)=usdata%occ(ival)*usdata%snl(ir+1,ival)**2
    amat(1,1)=pawps%phi(ir  ,iref(1,ival))**2
    amat(2,1)=pawps%phi(ir+1,iref(1,ival))**2
    amat(1,2)=pawps%phi(ir  ,iref(2,ival))**2
    amat(2,2)=pawps%phi(ir+1,iref(2,ival))**2
    xres(1)=(amat(2,2)*bvec(1)-amat(1,2)*bvec(2))&
&          /(amat(2,2)*amat(1,1)-amat(1,2)*amat(2,1))
    xres(2)=(amat(1,1)*bvec(2)-amat(2,1)*bvec(1))&
&          /(amat(2,2)*amat(1,1)-amat(1,2)*amat(2,1))
    if (abs(xres(1)-nint(xres(1)))<tol8) then
     pawarray%occ_(ir,iref(1,ival))=nint(xres(1))
     pawarray%occ_(ir,iref(2,ival))=nint(xres(2))
    else
     pawarray%occ_(ir,iref(1,ival))=xres(1)
     pawarray%occ_(ir,iref(2,ival))=xres(2)
    endif
   enddo
   pawarray%occ_(1,iref(1,ival))=pawarray%occ_(2,iref(1,ival))
   pawarray%occ_(1,iref(2,ival))=pawarray%occ_(2,iref(2,ival))
   pawarray%occ_(pshead%sph_meshsz,iref(1,ival))=pawarray%occ_(pshead%sph_meshsz-1,iref(1,ival))
   pawarray%occ_(pshead%sph_meshsz,iref(2,ival))=pawarray%occ_(pshead%sph_meshsz-1,iref(2,ival))

  else
   write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (calc_occ):'
   write(un_log,'(a)')   '    Incorrect number of ref. energies'
   write(un_log,'(a,i2,a)')   'for valence state nr ',ival,' (=0) !'
   stop 'Program stopped before end'
  endif

 enddo

 deallocate(iref,ieigref,nref)

 end subroutine
!!***
