/* BEGIN_HEADER                                              Java TreeView
*
* $Author: alokito $
* $RCSfile: KnnModelLoader.java,v $
* $Revision: 1.13 $
* $Date: 2008-06-11 01:58:58 $
* $Name:  $
*
* Copyright (C) 2001-2014 Alok Saldanha, All Rights Reserved. Modifications Copyright (C) Lawrence Berkeley Lab.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*
* END_HEADER
*/

package edu.stanford.genetics.treeview.model;

import javax.swing.*;

import edu.stanford.genetics.treeview.*;

/**
 * @author aloksaldanha
 *
 */
public class KnnModelLoader extends TVModelLoader2 {
	
	/**
	 * @param model
	 */
	public KnnModelLoader(KnnModel model) {
		super(model);
		loadProgress.setPhases(new String [] {"Starting",
				"Loading CDT", "Parsing CDT", 
				"Parsing KGG", "Parsing KAG", 
				"Loading Document Config", "Finished"});
	}
	

	private KnnModel getKnnModel() {
		// localize the cast
		return (KnnModel) targetModel;
	}

	
	/**
	 * This run() completely overrides the run() of TVModelLoader2.
	 * 
	 * @see edu.stanford.genetics.treeview.model.TVModelLoader2#run()
	 */
	protected void run() {
		try{
			KnnModel model = getKnnModel();
			FileSet fileSet = targetModel.getFileSet();
			setPhase(0);
			model.gidFound(false);
			model.aidFound(false);
			
			setPhase(1);
			println("loading " + fileSet.getCdt() + " ... ");
			try {
				parser.setResource(fileSet.getCdt());
				parser.setProgressTrackable(this);
				RectData tempTable = parser.loadIntoTable();
				setPhase(2);
				parseCDT(tempTable);
			} catch (LoadException e) {
				throw e;
			} catch (Exception e) {
				// this should never happen!
				LogBuffer.println("TVModelLoader2.run() : while parsing cdt got error " + e.getMessage());
				LogBuffer.println("TVModel instance " + targetModel.getType());
				e.printStackTrace();
				throw new LoadException("Error Parsing CDT: " + e, LoadException.CDTPARSE);
			}

			String kggfilename = fileSet.getKgg();
			if (kggfilename != "") {
				println ("parsing kgg");
				try {
					parser.setResource(fileSet.getKgg());
					parser.setProgressTrackable(this);
					setPhase(3);
					RectData tempTable = parser.loadIntoTable();
					model.setGClusters(tempTable, LoadException.KGGPARSE);
				} catch (Exception e) {
					e.printStackTrace();
					println("ignoring gene k-means clusters.");
					setHadProblem(true);
				}
			}
			
			String kagfilename = fileSet.getKag();
			if (kagfilename != "") {
				println ("parsing kag");
				try {
					parser.setResource(fileSet.getKag());
					parser.setProgressTrackable(this);
					setPhase(4);
					RectData tempTable = parser.loadIntoTable();
					model.setAClusters(tempTable, LoadException.KAGPARSE);
				} catch (Exception e) {
					println("error parsing KAG: " + e.getMessage());
					e.printStackTrace();
					println("ignoring array k-means clusters.");
					setHadProblem(true);
				}
			}

			setPhase(5);
			try {
				println("parsing jtv config file");
				XmlConfig documentConfig = new XmlConfig(targetModel.getFileSet().getJtv(),
				"DocumentConfig");
				targetModel.setDocumentConfig(documentConfig);
			} catch (Exception e) {
				targetModel.setDocumentConfig(null);
				println("Got exception " + e);
				setHadProblem(true);
			}

			setPhase(6);
			if (getException() == null) {
				/*	
				 if (!fileLoader.getCompleted()) {
				 throw new LoadException("Parse not Completed", LoadException.INTPARSE);
				 }
				 //System.out.println("f had no exceptoin set");
				  */
			} else {
				throw getException();
			}
			//	ActionEvent(this, 0, "none",0);
		} catch (java.lang.OutOfMemoryError ex) {
			JPanel temp = new JPanel();
			temp. add(new JLabel("Out of memory, allocate more RAM"));
			temp. add(new JLabel("see Chapter 3 of Help->Documentation... for Out of Memory"));
			JOptionPane.showMessageDialog(parent,  temp);
		} catch (LoadException e) {
			setException(e);
			println("error parsing File: " + e.getMessage());
			println("parse cannot succeed. please fix.");
			setHadProblem(true);
		}
		setFinished(true);
		
	}
	
}
