#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Zniw Adventure
# send your bug reports to contact@dotslashplay.it
###

script_version=20230322.3

GAME_ID='zniw-adventure'
GAME_NAME='Zniw Adventure'

ARCHIVE_BASE_0='zniw_adventure_1_3_4_1l_gog_60121.sh'
ARCHIVE_BASE_0_MD5='37fb48f55d4e36d6692a8e13b7f07623'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='2300000'
ARCHIVE_BASE_0_VERSION='1.3.4.1l-gog60121'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/zniw_adventure'

CONTENT_PATH_DEFAULT='data/noarch/game/data'
CONTENT_GAME_AGS32_FILES='
ags32'
CONTENT_GAME_AGS64_FILES='
ags64'
CONTENT_GAME_COMMON_FILES='
acsetup.cfg
CTGAME.???
*.cdf
*.cvf
*.ogv
*.tra
*.vox'
CONTENT_DOC_COMMON_FILES='
licenses'
CONTENT_DOC0_COMMON_PATH='data/noarch/game'
CONTENT_DOC0_COMMON_FILES='
manualEn.pdf
manualPl.pdf
refCardLinEnglish.pdf
refCardLinPolish.pdf'
CONTENT_DOC1_COMMON_PATH='data/noarch/game/Walkthrough'
CONTENT_DOC1_COMMON_FILES='
SpoilerFreeWalkthrough.pdf'

APP_MAIN_ICON='../../support/icon.png'

APP_MAIN_TYPE_SCUMMVM='scummvm'
APP_MAIN_SCUMMID='ags:zniwadventure'

APP_MAIN_EXE_AGS32='ags32'
APP_MAIN_EXE_AGS64='ags64'

PACKAGES_LIST='PKG_SCUMMVM PKG_AGS32 PKG_AGS64 PKG_COMMON'

PKG_COMMON_ID="${GAME_ID}-common"
PKG_COMMON_DESCRIPTION='common data files'

PKG_SCUMMVM_ID="${GAME_ID}-scummvm"
PKG_SCUMMVM_PROVIDE="$GAME_ID"
PKG_SCUMMVM_DEPS="$PKG_COMMON_ID scummvm"

PKG_AGS32_ID="${GAME_ID}-ags32"
PKG_AGS64_ID="${GAME_ID}-ags64"
PKG_AGS_PROVIDE="$GAME_ID"
PKG_AGS32_PROVIDE="$PKG_AGS_PROVIDE"
PKG_AGS64_PROVIDE="$PKG_AGS_PROVIDE"
PKG_AGS32_ARCH='32'
PKG_AGS64_ARCH='64'
PKG_AGS_DEPS="$PKG_COMMON_ID"
PKG_AGS32_DEPS="$PKG_AGS_DEPS"
PKG_AGS64_DEPS="$PKG_AGS_DEPS"
PKG_AGS_DEPENDENCIES_LIBRARIES='
liballeg.so.4.4
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libogg.so.0
libpthread.so.0
libstdc++.so.6
libtheora.so.0
libvorbisfile.so.3
libvorbis.so.0
libX11.so.6'
PKG_AGS32_DEPENDENCIES_LIBRARIES="$PKG_AGS_DEPENDENCIES_LIBRARIES"
PKG_AGS64_DEPENDENCIES_LIBRARIES="$PKG_AGS_DEPENDENCIES_LIBRARIES"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_COMMON'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_SCUMMVM' 'PKG_AGS32' 'PKG_AGS64'; do
	launchers_write
done

# Build packages

write_metadata
build_pkg

# Print instructions

case "${LANG%_*}" in
	('fr')
		lang_string='version %s :'
		lang_en='anglaise'
		lang_fr='française'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_en='English'
		lang_fr='French'
	;;
esac
printf '\n'
printf 'ScummVM:\n'
print_instructions 'PKG_COMMON' 'PKG_SCUMMVM'
printf 'Adventure Game Studio:\n'
print_instructions 'PKG_COMMON' 'PKG_AGS32' 'PKG_AGS64'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
