#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Silver Case (demo)
# send your bug reports to contact@dotslashplay.it
###

script_version=20230625.1

GAME_ID='the-silver-case-demo'
GAME_NAME='The Silver Case (demo)'

ARCHIVE_BASE_GOG_0='setup_the_silver_case_demo_2.0.0.1.exe'
ARCHIVE_BASE_GOG_0_MD5='3c133cb2031160370917f120055c63b4'
ARCHIVE_BASE_GOG_0_TYPE='innosetup'
ARCHIVE_BASE_GOG_0_SIZE='960000'
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog2.0.0.1'

## This installer is no longer available from Playism,
## as they turned their store into yet another Steam keys reseller.
ARCHIVE_BASE_PLAYISM_0='TheSilverCase_DEMO_Playism0930.zip'
ARCHIVE_BASE_PLAYISM_0_MD5='a1bbd59ead01c4e1dc50c38b3a65c5ea'
ARCHIVE_BASE_PLAYISM_0_SIZE='950000'
ARCHIVE_BASE_PLAYISM_0_VERSION='1.0-playism0930'

UNITY3D_NAME='thesilvercase_trial'

CONTENT_PATH_DEFAULT_GOG='app'
CONTENT_PATH_DEFAULT_PLAYISM='thesilvercase_demo_0930'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/mono
${UNITY3D_NAME}_data/plugins"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	case "$(context_archive)" in
		('ARCHIVE_BASE_PLAYISM_'*)
			tolower .
		;;
	esac
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
