#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Machinarium
# send your bug reports to contact@dotslashplay.it
###

script_version=20230119.1

GAME_ID='machinarium'
GAME_NAME='Machinarium'

# Archives

## GOG native Linux build,
## that is still sold but no longer officially supported.

ARCHIVE_BASE_GOG_0='gog_machinarium_2.0.0.2.sh'
ARCHIVE_BASE_GOG_0_MD5='4a66896935fbf29f4816e615748bb679'
ARCHIVE_BASE_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_0_SIZE='370000'
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog2.0.0.2'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/machinarium_collectors_edition'

## Humble Bundle native Linux build,
## that is no longer available for sale.

ARCHIVE_BASE_HUMBLE_0='machinarium_20121106-ubuntu_i386.deb'
ARCHIVE_BASE_HUMBLE_0_MD5='4f0ab314a75aad77a9c6dd92110f8a48'
ARCHIVE_BASE_HUMBLE_0_SIZE='360000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble1'


CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='opt/machinarium'
CONTENT_GAME_BIN_FILES='
Machinarium'
CONTENT_GAME_DATA_FILES='
00
01
10
11'

APP_MAIN_EXE='Machinarium'
APP_MAIN_ICONS_LIST_GOG='APP_MAIN_ICON_GOG'
APP_MAIN_ICON_GOG='../support/icon.png'
APP_MAIN_ICONS_LIST_HUMBLE='APP_MAIN_ICON_HUMBLE_16 APP_MAIN_ICON_HUMBLE_32 APP_MAIN_ICON_HUMBLE_64'
APP_MAIN_ICON_HUMBLE_16='../../usr/share/icons/hicolor/16x16/apps/machinarium.png'
APP_MAIN_ICON_HUMBLE_32='../../usr/share/icons/hicolor/32x32/apps/machinarium.png'
APP_MAIN_ICON_HUMBLE_64='../../usr/share/icons/hicolor/64x64/apps/machinarium.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libglib-2.0.so.0
libgmodule-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libnspr4.so
libnss3.so
libpango-1.0.so.0
libpangocairo-1.0.so.0
libplc4.so
libplds4.so
libpthread.so.0
libsmime3.so
libssl3.so
libstdc++.so.6
libX11.so.6
libXext.so.6
libXrender.so.1
libXt.so.6'

# Load common functions

target_version='2.19'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
APP_MAIN_ICONS_LIST=$(get_context_specific_value 'archive' 'APP_MAIN_ICONS_LIST')
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
