#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kero Blaster
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20221203.1

# Set game-specific variables

GAME_ID='kero-blaster'
GAME_NAME='Kero Blaster'

# Archives

## The following archive used to be sold from Playism store,
## before it closed down in favour of Steam.

ARCHIVE_BASE_0='KeroBlaster_EN_v1501a.zip'
ARCHIVE_BASE_0_MD5='c6ba58d37b5344d08c7d9a94506266b0'
ARCHIVE_BASE_0_SIZE='20000'
ARCHIVE_BASE_0_VERSION='1.501-playism1501a'


CONTENT_PATH_DEFAULT='KeroBlasterEn'
ARCHIVE_DOC_DATA_FILES='ReadmeEn.txt'
ARCHIVE_GAME_BIN_FILES='KeroBlaster.exe'
ARCHIVE_GAME_DATA_FILES='rsc_k'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='KeroBlaster.exe'
APP_MAIN_ICON='KeroBlaster.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"
PKG_BIN_DEPS_ARCH='lib32-mpg123 lib32-alsa-lib'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
